/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys;

import java.io.IOException;
import java.io.PrintStream;
import java.net.SocketException;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.jlan.netbios.server.NetBIOSNameServer;
import org.alfresco.jlan.server.NetworkServer;
import org.alfresco.jlan.server.SessionListener;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.smb.server.CIFSConfigSection;
import org.alfresco.jlan.smb.server.SMBServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class CIFSServerBean
extends AbstractLifecycleBean {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.smb.server");
    private ServerConfiguration m_filesysConfig;
    private CIFSConfigSection m_cifsConfig;
    private List<NetworkServer> serverList = new LinkedList<NetworkServer>();
    private List<SessionListener> sessionListeners = new LinkedList<SessionListener>();

    public CIFSServerBean(ServerConfiguration serverConfig) {
        this.m_filesysConfig = serverConfig;
    }

    public void setSessionListeners(List<SessionListener> sessionListeners) {
        this.sessionListeners = sessionListeners;
    }

    public final ServerConfiguration getConfiguration() {
        return this.m_filesysConfig;
    }

    public boolean isStarted() {
        return !this.serverList.isEmpty() && this.m_filesysConfig.isServerRunning("CIFS");
    }

    public final void startServer() throws SocketException, IOException {
        try {
            this.m_cifsConfig = (CIFSConfigSection)this.m_filesysConfig.getConfigSection("CIFS");
            if (this.m_cifsConfig != null) {
                if (this.m_cifsConfig.hasNetBIOSSMB()) {
                    this.serverList.add((NetworkServer)new NetBIOSNameServer(this.m_filesysConfig));
                }
                SMBServer smbServer = new SMBServer(this.m_filesysConfig);
                this.serverList.add((NetworkServer)smbServer);
                for (SessionListener sessionListener : this.sessionListeners) {
                    smbServer.addSessionListener(sessionListener);
                }
                for (NetworkServer server : this.serverList) {
                    this.m_filesysConfig.addServer(server);
                }
            }
            for (NetworkServer server : this.serverList) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Starting server " + server.getProtocolName() + " ..."));
                }
                String serverName = server.getConfiguration().getServerName();
                server.startServer();
            }
        }
        catch (Throwable e) {
            for (NetworkServer server : this.serverList) {
                this.getConfiguration().removeServer(server.getProtocolName());
            }
            this.serverList.clear();
            throw new AlfrescoRuntimeException("Failed to start CIFS Server", e);
        }
    }

    public final void stopServer() {
        if (this.m_filesysConfig == null) {
            return;
        }
        for (NetworkServer server : this.serverList) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Shutting server " + server.getProtocolName() + " ..."));
            }
            server.shutdownServer(false);
            this.getConfiguration().removeServer(server.getProtocolName());
        }
        this.serverList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        PrintStream out = System.out;
        out.println("CIFS Server Test");
        out.println("----------------");
        try {
            ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("alfresco/application-context.xml");
            CIFSServerBean server = (CIFSServerBean)((Object)ctx.getBean("cifsServer"));
            if (server == null) {
                throw new AlfrescoRuntimeException("Server bean 'cifsServer' not defined");
            }
            NetworkServer srv = server.getConfiguration().findServer("FTP");
            if (srv != null) {
                srv.shutdownServer(true);
            }
            if ((srv = server.getConfiguration().findServer("NFS")) != null) {
                srv.shutdownServer(true);
            }
            if (server.getConfiguration().hasConfigSection("CIFS")) {
                out.println("Enter 'x' to shutdown ...");
                boolean shutdown = false;
                while (!shutdown) {
                    int ch = System.in.read();
                    if (ch == 120 || ch == 88) {
                        shutdown = true;
                    }
                    CIFSServerBean cIFSServerBean = server;
                    synchronized (cIFSServerBean) {
                        ((Object)((Object)server)).wait(20L);
                    }
                }
                server.stopServer();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(1);
    }

    protected void onBootstrap(ApplicationEvent event) {
        try {
            this.startServer();
        }
        catch (SocketException e) {
            throw new AlfrescoRuntimeException("Failed to start CIFS server", (Throwable)e);
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Failed to start CIFS server", (Throwable)e);
        }
    }

    protected void onShutdown(ApplicationEvent event) {
        this.stopServer();
        this.m_filesysConfig = null;
    }
}

