/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys;

import java.io.IOException;
import java.io.PrintStream;
import java.net.SocketException;
import java.util.Vector;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.NfsServerNodeMonitor;
import org.alfresco.jlan.oncrpc.mount.MountServer;
import org.alfresco.jlan.oncrpc.nfs.NFSConfigSection;
import org.alfresco.jlan.oncrpc.nfs.NFSServer;
import org.alfresco.jlan.oncrpc.portmap.PortMapperServer;
import org.alfresco.jlan.server.NetworkServer;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class NFSServerBean
extends AbstractLifecycleBean {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.nfs.server");
    private ServerConfiguration m_filesysConfig;
    private NFSConfigSection m_nfsConfig;
    private NfsServerNodeMonitor nodeMonitor;
    private Vector<NetworkServer> m_serverList = new Vector();

    public NFSServerBean(ServerConfiguration serverConfig) {
        this.m_filesysConfig = serverConfig;
    }

    public final ServerConfiguration getConfiguration() {
        return this.m_filesysConfig;
    }

    public void setNodeMonitor(NfsServerNodeMonitor nodeMonitor) {
        this.nodeMonitor = nodeMonitor;
    }

    public boolean isStarted() {
        return !this.m_serverList.isEmpty() && this.m_filesysConfig.isServerRunning("NFS");
    }

    public final void startServer() throws SocketException, IOException {
        try {
            this.m_nfsConfig = (NFSConfigSection)this.m_filesysConfig.getConfigSection("NFS");
            if (this.m_nfsConfig != null) {
                if (this.m_nfsConfig.hasNFSPortMapper()) {
                    this.m_serverList.add((NetworkServer)new PortMapperServer(this.m_filesysConfig));
                }
                this.m_serverList.add((NetworkServer)new MountServer(this.m_filesysConfig));
                NFSServer nfsServer = new NFSServer(this.m_filesysConfig);
                this.m_serverList.add((NetworkServer)nfsServer);
                if (null != this.nodeMonitor) {
                    this.nodeMonitor.setNfsServer(nfsServer);
                }
                for (NetworkServer server : this.m_serverList) {
                    this.m_filesysConfig.addServer(server);
                }
            }
            for (NetworkServer server : this.m_serverList) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Starting server " + server.getProtocolName() + " ..."));
                }
                server.startServer();
            }
        }
        catch (Throwable e) {
            for (NetworkServer server : this.m_serverList) {
                this.getConfiguration().removeServer(server.getProtocolName());
            }
            this.m_serverList.clear();
            throw new AlfrescoRuntimeException("Failed to start NFS Server", e);
        }
    }

    public final void stopServer() {
        if (null != this.nodeMonitor) {
            this.nodeMonitor.setEnabled(false);
        }
        if (this.m_filesysConfig == null) {
            return;
        }
        for (int i = this.m_serverList.size() - 1; i >= 0; --i) {
            NetworkServer server = this.m_serverList.get(i);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Shutting server " + server.getProtocolName() + " ..."));
            }
            server.shutdownServer(false);
            this.getConfiguration().removeServer(server.getProtocolName());
        }
        this.m_serverList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        PrintStream out = System.out;
        out.println("NFS Server Test");
        out.println("----------------");
        try {
            ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("alfresco/application-context.xml");
            NFSServerBean server = (NFSServerBean)((Object)ctx.getBean("nfsServer"));
            if (server == null) {
                throw new AlfrescoRuntimeException("Server bean 'nfsServer' not defined");
            }
            NetworkServer srv = server.getConfiguration().findServer("FTP");
            if (srv != null) {
                srv.shutdownServer(true);
            }
            if ((srv = server.getConfiguration().findServer("SMB")) != null) {
                srv.shutdownServer(true);
            }
            if (server.getConfiguration().hasConfigSection("NFS")) {
                out.println("Enter 'x' to shutdown ...");
                boolean shutdown = false;
                while (!shutdown) {
                    int ch = System.in.read();
                    if (ch == 120 || ch == 88) {
                        shutdown = true;
                    }
                    NFSServerBean nFSServerBean = server;
                    synchronized (nFSServerBean) {
                        ((Object)((Object)server)).wait(20L);
                    }
                }
                server.stopServer();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(1);
    }

    protected void onBootstrap(ApplicationEvent event) {
        try {
            this.startServer();
        }
        catch (SocketException e) {
            throw new AlfrescoRuntimeException("Failed to start NFS server", (Throwable)e);
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Failed to start NFS server", (Throwable)e);
        }
    }

    protected void onShutdown(ApplicationEvent event) {
        this.stopServer();
        this.m_filesysConfig = null;
    }
}

