/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.avm;

import org.alfresco.jlan.server.filesys.FileAttribute;
import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.SearchContext;
import org.alfresco.jlan.server.filesys.pseudo.PseudoFile;
import org.alfresco.jlan.server.filesys.pseudo.PseudoFileList;
import org.alfresco.jlan.util.WildCard;

public class PseudoFileListSearchContext
extends SearchContext {
    private PseudoFileList m_fileList;
    private int m_fileIdx;
    private int m_attrib;
    private WildCard m_filter;
    private boolean m_readOnly;

    public PseudoFileListSearchContext(PseudoFileList fileList, int attrib, WildCard filter, boolean readOnly) {
        this.m_attrib = attrib;
        this.m_filter = filter;
        this.m_fileList = fileList;
        this.m_readOnly = readOnly;
    }

    public boolean hasMoreFiles() {
        return this.m_fileIdx < this.m_fileList.numberOfFiles();
    }

    public boolean nextFileInfo(FileInfo info) {
        if (this.m_fileIdx >= this.m_fileList.numberOfFiles()) {
            return false;
        }
        boolean foundMatch = false;
        PseudoFile curFile = null;
        while (!foundMatch && this.m_fileIdx < this.m_fileList.numberOfFiles()) {
            curFile = this.m_fileList.getFileAt(this.m_fileIdx++);
            if (this.m_filter != null) {
                if (!this.m_filter.matchesPattern(curFile.getFileName())) continue;
                if (FileAttribute.hasAttribute((int)this.m_attrib, (int)16) && curFile.isDirectory()) {
                    foundMatch = true;
                } else if (curFile.isFile()) {
                    foundMatch = true;
                }
                if (foundMatch || ++this.m_fileIdx >= this.m_fileList.numberOfFiles()) continue;
                curFile = this.m_fileList.getFileAt(this.m_fileIdx);
                continue;
            }
            foundMatch = true;
        }
        if (foundMatch) {
            info.setFileName(curFile.getFileName());
            FileInfo pfInfo = curFile.getFileInfo();
            if (curFile.isFile()) {
                info.setFileSize(pfInfo.getSize());
                info.setAllocationSize(pfInfo.getAllocationSize());
            } else {
                info.setFileSize(0L);
            }
            info.setAccessDateTime(pfInfo.getAccessDateTime());
            info.setCreationDateTime(pfInfo.getCreationDateTime());
            info.setModifyDateTime(pfInfo.getModifyDateTime());
            int attr = pfInfo.getFileAttributes();
            if (!pfInfo.isHidden() && curFile.getFileName().startsWith(".") || curFile.getFileName().equalsIgnoreCase("Desktop.ini") || curFile.getFileName().equalsIgnoreCase("Thumbs.db")) {
                attr += 2;
            }
            if (this.m_readOnly && !pfInfo.isReadOnly()) {
                ++attr;
            }
            info.setFileAttributes(attr);
            info.setFileId(pfInfo.getFileId());
        }
        return foundMatch;
    }

    public String nextFileName() {
        while (this.m_fileIdx < this.m_fileList.numberOfFiles()) {
            String fname;
            if (!this.m_filter.matchesPattern(fname = this.m_fileList.getFileAt(this.m_fileIdx++).getFileName())) continue;
            return fname;
        }
        return null;
    }

    public int numberOfEntries() {
        return this.m_fileList.numberOfFiles();
    }

    public int getResumeId() {
        return this.m_fileIdx;
    }

    public boolean restartAt(int resumeId) {
        int resId = resumeId - 1;
        if (resId < 0 || resId >= this.m_fileList.numberOfFiles()) {
            return false;
        }
        this.m_fileIdx = resId;
        return true;
    }

    public boolean restartAt(FileInfo info) {
        int curFileIdx = this.m_fileIdx;
        if (this.m_fileIdx >= this.m_fileList.numberOfFiles()) {
            this.m_fileIdx = this.m_fileList.numberOfFiles() - 1;
        }
        while (this.m_fileIdx > 0) {
            if (this.m_fileList.getFileAt(this.m_fileIdx).getFileName().equals(info.getFileName())) {
                return true;
            }
            --this.m_fileIdx;
        }
        this.m_fileIdx = curFileIdx;
        return false;
    }
}

