/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo.desk;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.alfresco.filesys.alfresco.AlfrescoContext;
import org.alfresco.filesys.alfresco.DesktopAction;
import org.alfresco.filesys.alfresco.DesktopActionException;
import org.alfresco.filesys.alfresco.DesktopParams;
import org.alfresco.filesys.alfresco.DesktopResponse;
import org.alfresco.jlan.server.filesys.DiskSharedDevice;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.scripts.ScriptException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ResourceFinder;
import org.springframework.core.io.Resource;
import org.springframework.extensions.config.ConfigElement;

public class JavaScriptDesktopAction
extends DesktopAction {
    private String m_scriptName;
    private Resource m_scriptResource;
    private Long m_lastModified;
    private String m_script;

    public JavaScriptDesktopAction() {
        super(0, 0);
    }

    @Override
    public String getConfirmationString() {
        return "Run Javascript action";
    }

    @Override
    public void standardInitialize(ConfigElement global, ConfigElement config, DiskSharedDevice fileSys) throws DesktopActionException {
        super.standardInitialize(global, config, fileSys);
        ConfigElement elem = config.getChild("script");
        if (elem == null || elem.getValue().length() <= 0) {
            throw new DesktopActionException("Script name not specified");
        }
        this.setScriptName(elem.getValue());
        elem = config.getChild("attributes");
        if (elem != null) {
            if (elem.getValue().length() == 0) {
                throw new DesktopActionException("Empty desktop action attributes");
            }
            this.setAttributeList(elem.getValue());
        }
        if ((elem = config.getChild("preprocess")) != null) {
            this.setPreprocess(elem.getValue());
        }
    }

    @Override
    public void initializeAction(ServiceRegistry serviceRegistry, AlfrescoContext filesysContext) throws DesktopActionException {
        super.initializeAction(serviceRegistry, filesysContext);
        if (this.m_scriptName == null || this.m_scriptName.length() == 0) {
            throw new DesktopActionException("Script name not specified");
        }
        this.m_scriptResource = new ResourceFinder().getResource(this.m_scriptName);
        if (!this.m_scriptResource.exists()) {
            throw new DesktopActionException("Failed to find script on classpath, " + this.getScriptName());
        }
        try {
            this.m_lastModified = this.m_scriptResource.lastModified();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.loadScript(this.m_scriptResource);
        }
        catch (IOException ex) {
            throw new DesktopActionException("Failed to load script, " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DesktopResponse runAction(DesktopParams params) throws DesktopActionException {
        JavaScriptDesktopAction javaScriptDesktopAction = this;
        synchronized (javaScriptDesktopAction) {
            try {
                if (this.m_lastModified != null && this.m_scriptResource.lastModified() != this.m_lastModified.longValue()) {
                    this.m_lastModified = this.m_scriptResource.lastModified();
                    this.loadScript(this.m_scriptResource);
                }
            }
            catch (IOException ex) {
                logger.warn((Object)("Failed to reload script file, " + this.m_scriptResource.getDescription()), (Throwable)ex);
            }
        }
        final ScriptService scriptService = this.getServiceRegistry().getScriptService();
        if (scriptService != null) {
            final HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("deskParams", params);
            model.put("out", System.out);
            if (this.hasWebappURL()) {
                model.put("webURL", this.getWebappURL());
            }
            TransactionService transactionService = this.getServiceRegistry().getTransactionService();
            RetryingTransactionHelper tx = transactionService.getRetryingTransactionHelper();
            RetryingTransactionHelper.RetryingTransactionCallback<DesktopResponse> runScriptCB = new RetryingTransactionHelper.RetryingTransactionCallback<DesktopResponse>(){

                @Override
                public DesktopResponse execute() throws Throwable {
                    DesktopResponse response = new DesktopResponse(0);
                    try {
                        Object result = scriptService.executeScriptString(JavaScriptDesktopAction.this.getScript(), model);
                        if (result != null) {
                            if (result instanceof DesktopResponse) {
                                response = (DesktopResponse)((Object)result);
                            } else if (result instanceof Double) {
                                Double jsSts = (Double)result;
                                response.setStatus(jsSts.intValue(), "");
                            } else if (result instanceof String) {
                                String responseMsg = (String)result;
                                StringTokenizer token = new StringTokenizer(responseMsg, ",");
                                String stsToken = token.nextToken();
                                String msgToken = token.nextToken();
                                int sts = -1;
                                try {
                                    sts = Integer.parseInt(stsToken);
                                }
                                catch (NumberFormatException ex) {
                                    response.setStatus(1, "Bad response from script");
                                }
                                response.setStatus(sts, msgToken != null ? msgToken : "");
                            }
                        }
                        return response;
                    }
                    catch (ScriptException ex) {
                        return new DesktopResponse(1, ex.getMessage());
                    }
                }
            };
            return tx.doInTransaction(runScriptCB, false, false);
        }
        return new DesktopResponse(1, "Script service not available");
    }

    public final String getScriptName() {
        return this.m_scriptName;
    }

    public final String getScript() {
        return this.m_script;
    }

    public final void setScriptName(String name) {
        this.m_scriptName = name;
    }

    public void setAttributeList(String attributes) throws DesktopActionException {
        if (attributes == null || attributes.length() == 0) {
            return;
        }
        int attr = 0;
        StringTokenizer tokens = new StringTokenizer(attributes, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equalsIgnoreCase("targetFiles")) {
                attr |= 1;
                continue;
            }
            if (token.equalsIgnoreCase("targetFolders")) {
                attr |= 2;
                continue;
            }
            if (token.equalsIgnoreCase("clientFiles")) {
                attr |= 4;
                continue;
            }
            if (token.equalsIgnoreCase("clientFolders")) {
                attr |= 8;
                continue;
            }
            if (token.equalsIgnoreCase("alfrescoFiles")) {
                attr |= 0x10;
                continue;
            }
            if (token.equalsIgnoreCase("alfrescoFolders")) {
                attr |= 0x20;
                continue;
            }
            if (token.equalsIgnoreCase("multiplePaths")) {
                attr |= 0x40;
                continue;
            }
            if (token.equalsIgnoreCase("allowNoParams")) {
                attr |= 0x80;
                continue;
            }
            if (token.equalsIgnoreCase("anyFiles")) {
                attr |= 0x15;
                continue;
            }
            if (token.equalsIgnoreCase("anyFolders")) {
                attr |= 0x2A;
                continue;
            }
            if (token.equalsIgnoreCase("anyFilesFolders")) {
                attr |= 0x3F;
                continue;
            }
            throw new DesktopActionException("Unknown attribute, " + token);
        }
        this.setAttributes(attr);
    }

    public void setPreprocess(String preProcessActions) throws DesktopActionException {
        if (preProcessActions == null || preProcessActions.length() == 0) {
            return;
        }
        int pre = 0;
        StringTokenizer tokens = new StringTokenizer(preProcessActions, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equalsIgnoreCase("copyToTarget")) {
                pre |= 1;
                continue;
            }
            if (token.equalsIgnoreCase("confirm")) {
                pre |= 2;
                continue;
            }
            if (token.equalsIgnoreCase("localToWorkingCopy")) {
                pre |= 4;
                continue;
            }
            throw new DesktopActionException("Unknown pre-processing flag, " + token);
        }
        this.setPreProcessActions(pre);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadScript(Resource scriptResource) throws IOException {
        BufferedReader scriptIn = new BufferedReader(new InputStreamReader(scriptResource.getInputStream()));
        StringBuilder scriptStr = new StringBuilder(1024);
        try {
            String inRec = scriptIn.readLine();
            while (inRec != null) {
                scriptStr.append(inRec);
                scriptStr.append("\n");
                inRec = scriptIn.readLine();
            }
        }
        finally {
            scriptIn.close();
        }
        this.m_script = scriptStr.toString();
    }
}

