/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo.rules;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.filesys.repo.rules.Command;
import org.alfresco.filesys.repo.rules.Operation;
import org.alfresco.filesys.repo.rules.ScenarioInstance;
import org.alfresco.filesys.repo.rules.commands.CompoundCommand;
import org.alfresco.filesys.repo.rules.commands.CopyContentCommand;
import org.alfresco.filesys.repo.rules.commands.DeleteFileCommand;
import org.alfresco.filesys.repo.rules.commands.RenameFileCommand;
import org.alfresco.filesys.repo.rules.operations.CreateFileOperation;
import org.alfresco.filesys.repo.rules.operations.DeleteFileOperation;
import org.alfresco.filesys.repo.rules.operations.RenameFileOperation;
import org.alfresco.jlan.server.filesys.FileName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScenarioCreateDeleteRenameShuffleInstance
implements ScenarioInstance {
    private static Log logger = LogFactory.getLog(ScenarioCreateDeleteRenameShuffleInstance.class);
    InternalState internalState = InternalState.NONE;
    private Date startTime = new Date();
    private String createName;
    private ScenarioInstance.Ranking ranking;
    private boolean checkFilename = true;
    private long timeout = 60000L;
    private boolean isComplete;
    private Map<String, String> deletes = new HashMap<String, String>();

    @Override
    public Command evaluate(Operation operation) {
        DeleteFileOperation d;
        Date now = new Date();
        if (now.getTime() > this.startTime.getTime() + this.getTimeout() && logger.isDebugEnabled()) {
            logger.debug((Object)("Instance timed out createName:" + this.createName));
            this.isComplete = true;
            return null;
        }
        if (this.createName != null && operation instanceof DeleteFileOperation && (d = (DeleteFileOperation)operation).getName().equals(this.createName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Anti-pattern : Shuffle file deleted createName:" + this.createName));
            }
            this.isComplete = true;
            return null;
        }
        switch (this.internalState) {
            case NONE: {
                if (operation instanceof CreateFileOperation) {
                    CreateFileOperation c = (CreateFileOperation)operation;
                    this.createName = c.getName();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("entering ACTIVE state: " + this.createName));
                    }
                    this.internalState = InternalState.ACTIVE;
                    return null;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"State error, expected a CREATE");
                }
                this.isComplete = true;
                break;
            }
            case ACTIVE: {
                RenameFileOperation m;
                String targetFile;
                if (operation instanceof DeleteFileOperation) {
                    d = (DeleteFileOperation)operation;
                    String deleteName = d.getName();
                    if (this.checkFilename) {
                        int i = deleteName.lastIndexOf(46);
                        if (i > 0 && i < this.createName.length() && deleteName.substring(0, i).equalsIgnoreCase(this.createName.substring(0, i))) {
                            logger.debug((Object)"check filenames - does match");
                        } else {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("check filename patterns do not match - Ignore" + this.createName + deleteName));
                            }
                            return null;
                        }
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("got a delete : replace with rename createName:" + this.createName + "deleteName:" + deleteName));
                    }
                    String tempName = ".shuffle" + d.getName();
                    this.deletes.put(d.getName(), tempName);
                    String[] paths = FileName.splitPath((String)d.getPath());
                    String currentFolder = paths[0];
                    RenameFileCommand r1 = new RenameFileCommand(d.getName(), tempName, d.getRootNodeRef(), d.getPath(), currentFolder + "\\" + tempName);
                    return r1;
                }
                if (!(operation instanceof RenameFileOperation) || !this.deletes.containsKey(targetFile = (m = (RenameFileOperation)operation).getTo())) break;
                String tempName = this.deletes.get(targetFile);
                String[] paths = FileName.splitPath((String)m.getToPath());
                String currentFolder = paths[0];
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("scenario fires:" + this.createName));
                }
                ArrayList<Command> commands = new ArrayList<Command>();
                RenameFileCommand r1 = new RenameFileCommand(tempName, targetFile, m.getRootNodeRef(), currentFolder + "\\" + tempName, m.getToPath());
                CopyContentCommand copyContent = new CopyContentCommand(m.getFrom(), targetFile, m.getRootNodeRef(), m.getFromPath(), m.getToPath());
                DeleteFileCommand d1 = new DeleteFileCommand(m.getFrom(), m.getRootNodeRef(), m.getFromPath());
                commands.add(r1);
                commands.add(copyContent);
                commands.add(d1);
                logger.debug((Object)"Scenario complete");
                this.isComplete = true;
                return new CompoundCommand(commands);
            }
        }
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    @Override
    public ScenarioInstance.Ranking getRanking() {
        return this.ranking;
    }

    public void setRanking(ScenarioInstance.Ranking ranking) {
        this.ranking = ranking;
    }

    public String toString() {
        return "ScenarioShuffleInstance: createName:" + this.createName;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    static enum InternalState {
        NONE,
        ACTIVE;

    }
}

