/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.dictionary;

import java.util.Collection;
import javax.jcr.AccessDeniedException;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.alfresco.service.namespace.NamespaceService;

public class NamespaceRegistryImpl
implements NamespaceRegistry {
    private boolean allowRegistration;
    private NamespaceService namespaceService;

    public NamespaceRegistryImpl(boolean allowRegistraton, NamespaceService namespaceService) {
        this.allowRegistration = allowRegistraton;
        this.namespaceService = namespaceService;
    }

    public NamespaceService getNamespaceService() {
        return this.namespaceService;
    }

    public void registerNamespace(String prefix, String uri) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        try {
            if (!this.allowRegistration) {
                throw new UnsupportedRepositoryOperationException();
            }
            this.namespaceService.registerNamespace(prefix, uri);
        }
        catch (org.alfresco.service.namespace.NamespaceException e) {
            throw new NamespaceException((Throwable)e);
        }
    }

    public void unregisterNamespace(String prefix) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        try {
            if (!this.allowRegistration) {
                throw new UnsupportedRepositoryOperationException();
            }
            this.namespaceService.unregisterNamespace(prefix);
        }
        catch (org.alfresco.service.namespace.NamespaceException e) {
            throw new NamespaceException((Throwable)e);
        }
    }

    public String[] getPrefixes() throws RepositoryException {
        Collection prefixes = this.namespaceService.getPrefixes();
        return prefixes.toArray(new String[prefixes.size()]);
    }

    public String[] getURIs() throws RepositoryException {
        Collection uris = this.namespaceService.getURIs();
        return uris.toArray(new String[uris.size()]);
    }

    public String getURI(String prefix) throws NamespaceException, RepositoryException {
        String uri = this.namespaceService.getNamespaceURI(prefix);
        if (uri == null) {
            throw new NamespaceException("Prefix " + prefix + " is unknown.");
        }
        return uri;
    }

    public String getPrefix(String uri) throws NamespaceException, RepositoryException {
        Collection prefixes = this.namespaceService.getPrefixes(uri);
        if (prefixes.size() == 0) {
            throw new NamespaceException("URI " + uri + " is unknown.");
        }
        return (String)prefixes.iterator().next();
    }
}

