/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.item;

import java.io.InputStream;
import java.io.Serializable;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.version.Version;
import javax.jcr.version.VersionIterator;
import org.alfresco.jcr.api.JCRNodeRef;
import org.alfresco.jcr.test.BaseJCRTest;
import org.alfresco.model.ContentModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;

public class ItemTest
extends BaseJCRTest {
    protected Session session;
    private static final String QUICK_TXT = "The quick brown fox jumps over the lazy dog";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_ALFCOM_1655() throws RepositoryException {
        Node cNode;
        Node bNode;
        Node aNode;
        Node rootNode;
        SimpleCredentials user = new SimpleCredentials(this.getAdminUserName(), "admin".toCharArray());
        this.session = this.repository.login((Credentials)user, this.getWorkspace());
        try {
            rootNode = this.session.getRootNode();
            ItemTest.assertNotNull((Object)rootNode);
            aNode = rootNode.addNode("A1", "my:a");
            ItemTest.assertNotNull((Object)aNode);
            bNode = aNode.addNode("B1", "my:b");
            ItemTest.assertNotNull((Object)bNode);
            aNode = rootNode.addNode("A2", "cm:folder");
            ItemTest.assertNotNull((Object)aNode);
            bNode = aNode.addNode("B2", "cm:folder");
            ItemTest.assertNotNull((Object)bNode);
            cNode = rootNode.addNode("C1", "my:c");
            ItemTest.assertNotNull((Object)cNode);
            aNode = cNode.addNode("A3", "my:a");
            ItemTest.assertNotNull((Object)aNode);
            bNode = cNode.addNode("B3", "my:b");
            ItemTest.assertNotNull((Object)bNode);
            this.session.save();
        }
        finally {
            if (this.session != null) {
                this.session.logout();
            }
        }
        this.session = this.repository.login((Credentials)user, this.getWorkspace());
        try {
            rootNode = this.session.getRootNode();
            ItemTest.assertNotNull((Object)rootNode);
            aNode = rootNode.getNode("A1");
            ItemTest.assertNotNull((Object)aNode);
            bNode = aNode.getNode("B1");
            ItemTest.assertNotNull((Object)bNode);
            aNode = rootNode.getNode("A2");
            ItemTest.assertNotNull((Object)aNode);
            bNode = aNode.getNode("B2");
            ItemTest.assertNotNull((Object)bNode);
            cNode = rootNode.getNode("C1");
            ItemTest.assertNotNull((Object)cNode);
            aNode = cNode.getNode("A3");
            ItemTest.assertNotNull((Object)aNode);
            bNode = cNode.getNode("B3");
            ItemTest.assertNotNull((Object)bNode);
        }
        finally {
            if (this.session != null) {
                this.session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_ALFCOM_1507() throws RepositoryException {
        SimpleCredentials user = new SimpleCredentials(this.getAdminUserName(), "admin".toCharArray());
        this.session = this.repository.login((Credentials)user, "SpacesStore");
        try {
            Node rootNode = this.session.getRootNode();
            Node companyHome = rootNode.getNode("app:company_home");
            String name = "JCR sample (" + System.currentTimeMillis() + ")";
            Node content = companyHome.addNode("cm:" + name, "cm:content");
            content.setProperty("cm:name", name);
            content.addMixin("cm:titled");
            content.setProperty("cm:title", name);
            content.setProperty("cm:description", name);
            content.setProperty("cm:content", QUICK_TXT);
            ServiceRegistry registry = (ServiceRegistry)applicationContext.getBean("ServiceRegistry");
            ItemTest.setMimetype(registry, content, "cm:content", "text/plain");
            content.addMixin("mix:versionable");
            NodeRef nodeRef = JCRNodeRef.getNodeRef(content);
            VersionService versionService = registry.getVersionService();
            NodeService nodeService = registry.getNodeService();
            for (int i = 0; i <= 19; ++i) {
                content.checkout();
                content.setProperty("cm:title", "v" + i);
                content.checkin();
                javax.jcr.version.VersionHistory vh = content.getVersionHistory();
                VersionIterator vi = vh.getAllVersions();
                ItemTest.assertEquals((long)(i + 1), (long)vi.getSize());
                Version v = content.getBaseVersion();
                ItemTest.assertEquals((String)"", (String)("0." + (i + 1)), (String)v.getName());
                VersionHistory versionHistory = versionService.getVersionHistory(nodeRef);
                long startTime = System.currentTimeMillis();
                org.alfresco.service.cmr.version.Version version = versionService.getCurrentVersion(nodeRef);
                long beforeDuration = System.currentTimeMillis() - startTime;
                ItemTest.assertEquals((String)("0." + (i + 1)), (String)version.getVersionLabel());
                startTime = System.currentTimeMillis();
                if (versionHistory != null) {
                    String versionLabel = (String)((Object)nodeService.getProperty(nodeRef, ContentModel.PROP_VERSION_LABEL));
                    version = versionHistory.getVersion(versionLabel);
                }
                long afterDuration = System.currentTimeMillis() - startTime;
                ItemTest.assertEquals((String)("0." + (i + 1)), (String)version.getVersionLabel());
                System.out.println("getBaseVersion - get current version (BEFORE: " + beforeDuration + "ms, AFTER: " + afterDuration + "ms) ");
            }
            this.session.save();
        }
        finally {
            if (this.session != null) {
                this.session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_JAWS_191() throws Throwable {
        Node content;
        Node companyHome;
        Node rootNode;
        SimpleCredentials user = new SimpleCredentials(this.getAdminUserName(), "admin".toCharArray());
        this.session = this.repository.login((Credentials)user, "SpacesStore");
        String runid = "" + System.currentTimeMillis();
        String pathname = "cm:JCR-" + runid + ".jpg";
        String name = "JCR Sample (" + runid + ")";
        try {
            rootNode = this.session.getRootNode();
            companyHome = rootNode.getNode("app:company_home");
            content = companyHome.addNode(pathname, "cm:content");
            content.setProperty("cm:name", name);
            content.addMixin("cm:titled");
            content.setProperty("cm:title", name);
            content.setProperty("cm:description", name);
            InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/alfresco/jcr/test/testQuick.jpg");
            ItemTest.assertNotNull((Object)is);
            content.setProperty("cm:content", is);
            this.session.save();
            content = companyHome.getNode(pathname);
            ServiceRegistry registry = (ServiceRegistry)applicationContext.getBean("ServiceRegistry");
            ContentData contentData = ItemTest.getContentData(registry, content);
            ItemTest.assertEquals((String)"image/jpeg", (String)contentData.getMimetype());
            ItemTest.assertEquals((String)"UTF-8", (String)contentData.getEncoding());
        }
        finally {
            if (this.session != null) {
                this.session.logout();
            }
        }
        this.session = this.repository.login((Credentials)user, "SpacesStore");
        runid = "" + System.currentTimeMillis();
        pathname = "cm:JCR-" + runid + ".txt";
        name = "JCR Sample (" + runid + ")";
        try {
            rootNode = this.session.getRootNode();
            companyHome = rootNode.getNode("app:company_home");
            content = companyHome.addNode(pathname, "cm:content");
            content.setProperty("cm:name", name);
            content.addMixin("cm:titled");
            content.setProperty("cm:title", name);
            content.setProperty("cm:description", name);
            content.setProperty("cm:content", "\u00e4\u00f6\u00e5");
            this.session.save();
            content = companyHome.getNode(pathname);
            ServiceRegistry registry = (ServiceRegistry)applicationContext.getBean("ServiceRegistry");
            ContentData contentData = ItemTest.getContentData(registry, content);
            ItemTest.assertEquals((String)"text/plain", (String)contentData.getMimetype());
            ItemTest.assertEquals((String)"UTF-8", (String)contentData.getEncoding());
        }
        finally {
            if (this.session != null) {
                this.session.logout();
            }
        }
    }

    private static void setMimetype(ServiceRegistry registry, Node node, String propertyName, String mimeType) throws RepositoryException {
        NodeRef nodeRef = JCRNodeRef.getNodeRef(node);
        NodeService nodeService = registry.getNodeService();
        ContentData content = (ContentData)nodeService.getProperty(nodeRef, ContentModel.PROP_CONTENT);
        content = ContentData.setMimetype((ContentData)content, (String)mimeType);
        nodeService.setProperty(nodeRef, ContentModel.PROP_CONTENT, (Serializable)content);
    }

    private static ContentData getContentData(ServiceRegistry registry, Node node) throws RepositoryException {
        NodeRef nodeRef = JCRNodeRef.getNodeRef(node);
        NodeService nodeService = registry.getNodeService();
        return (ContentData)nodeService.getProperty(nodeRef, ContentModel.PROP_CONTENT);
    }
}

