/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.coci.CheckOutCheckInServiceException;
import org.alfresco.service.cmr.model.FileExistsException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisVersioningException;

public class AlfrescoCmisExceptionInterceptor
implements MethodInterceptor {
    public Object invoke(MethodInvocation mi) throws Throwable {
        try {
            return mi.proceed();
        }
        catch (AuthenticationException e) {
            throw new CmisPermissionDeniedException(e.getMessage(), (Throwable)e);
        }
        catch (CheckOutCheckInServiceException e) {
            throw new CmisVersioningException("Check out failed: " + e.getMessage(), (Throwable)((Object)e));
        }
        catch (FileExistsException fee) {
            throw new CmisContentAlreadyExistsException("An object with this name already exists!", (Throwable)fee);
        }
        catch (IntegrityException ie) {
            throw new CmisConstraintException("Constraint violation: " + ie.getMessage(), (Throwable)((Object)ie));
        }
        catch (AccessDeniedException ade) {
            throw new CmisPermissionDeniedException("Permission denied!", (Throwable)((Object)ade));
        }
        catch (Exception e) {
            if (e instanceof CmisBaseException) {
                throw (CmisBaseException)e;
            }
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }
}

