/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.search;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.alfresco.opencmis.dictionary.CMISDictionaryService;
import org.alfresco.opencmis.dictionary.CMISNodeInfo;
import org.alfresco.opencmis.search.CMISQueryOptions;
import org.alfresco.opencmis.search.CMISResultSetMetaData;
import org.alfresco.opencmis.search.CMISResultSetRow;
import org.alfresco.opencmis.search.CMISResultSetRowIterator;
import org.alfresco.repo.search.impl.querymodel.Query;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.ResultSetSPI;
import org.alfresco.util.Pair;

public class CMISResultSet
implements ResultSetSPI<CMISResultSetRow, CMISResultSetMetaData>,
Serializable {
    private static final long serialVersionUID = 2014688399588268994L;
    private Map<String, ResultSet> wrapped;
    private Map<NodeRef, CMISNodeInfo> nodeInfos;
    private LimitBy limitBy;
    CMISQueryOptions options;
    NodeService nodeService;
    Query query;
    CMISDictionaryService cmisDictionaryService;
    DictionaryService alfrescoDictionaryService;

    public CMISResultSet(Map<String, ResultSet> wrapped, CMISQueryOptions options, LimitBy limitBy, NodeService nodeService, Query query, CMISDictionaryService cmisDictionaryService, DictionaryService alfrescoDictionaryService) {
        this.wrapped = wrapped;
        this.options = options;
        this.limitBy = limitBy;
        this.nodeService = nodeService;
        this.query = query;
        this.cmisDictionaryService = cmisDictionaryService;
        this.alfrescoDictionaryService = alfrescoDictionaryService;
        this.nodeInfos = new HashMap<NodeRef, CMISNodeInfo>();
    }

    public void close() {
        HashSet<ResultSet> closed = new HashSet<ResultSet>();
        for (ResultSet resultSet : this.wrapped.values()) {
            if (closed.contains(resultSet)) continue;
            resultSet.close();
            closed.add(resultSet);
        }
    }

    public CMISResultSetMetaData getMetaData() {
        return new CMISResultSetMetaData(this.options, this.query, this.limitBy, this.cmisDictionaryService, this.alfrescoDictionaryService);
    }

    public CMISResultSetRow getRow(int i) {
        return new CMISResultSetRow(this, i, this.getScores(i), this.nodeService, this.getNodeRefs(i), this.nodeInfos, this.query, this.cmisDictionaryService);
    }

    public boolean hasMore() {
        for (ResultSet resultSet : this.wrapped.values()) {
            if (!resultSet.hasMore()) continue;
            return true;
        }
        return false;
    }

    public int getLength() {
        Iterator<ResultSet> i$ = this.wrapped.values().iterator();
        if (i$.hasNext()) {
            ResultSet resultSet = i$.next();
            return resultSet.length();
        }
        throw new IllegalStateException();
    }

    public int getStart() {
        return this.options.getSkipCount();
    }

    public Iterator<CMISResultSetRow> iterator() {
        return new CMISResultSetRowIterator(this);
    }

    private Map<String, NodeRef> getNodeRefs(int i) {
        HashMap<String, NodeRef> refs = new HashMap<String, NodeRef>();
        for (String selector : this.wrapped.keySet()) {
            ResultSet rs = this.wrapped.get(selector);
            refs.put(selector, rs.getNodeRef(i));
        }
        return refs;
    }

    private Map<String, Float> getScores(int i) {
        HashMap<String, Float> scores = new HashMap<String, Float>();
        for (String selector : this.wrapped.keySet()) {
            ResultSet rs = this.wrapped.get(selector);
            scores.put(selector, Float.valueOf(rs.getScore(i)));
        }
        return scores;
    }

    public ChildAssociationRef getChildAssocRef(int n) {
        NodeRef nodeRef = this.getNodeRef(n);
        return this.nodeService.getPrimaryParent(nodeRef);
    }

    public List<ChildAssociationRef> getChildAssocRefs() {
        ArrayList<ChildAssociationRef> cars = new ArrayList<ChildAssociationRef>(this.length());
        Iterator<CMISResultSetRow> i$ = this.iterator();
        while (i$.hasNext()) {
            ResultSetRow row = i$.next();
            cars.add(row.getChildAssocRef());
        }
        return cars;
    }

    public NodeRef getNodeRef(int n) {
        Map<String, NodeRef> refs = this.getNodeRefs(n);
        if (refs.size() == 1) {
            return refs.values().iterator().next();
        }
        if (this.allNodeRefsEqual(refs)) {
            return refs.values().iterator().next();
        }
        throw new IllegalStateException("Ambiguous selector");
    }

    private boolean allNodeRefsEqual(Map<String, NodeRef> selected) {
        NodeRef last = null;
        for (NodeRef current : selected.values()) {
            if (last == null) {
                last = current;
                continue;
            }
            if (last.equals((Object)current)) continue;
            return false;
        }
        return true;
    }

    public List<NodeRef> getNodeRefs() {
        ArrayList<NodeRef> nodeRefs = new ArrayList<NodeRef>(this.length());
        Iterator<CMISResultSetRow> i$ = this.iterator();
        while (i$.hasNext()) {
            ResultSetRow row = i$.next();
            nodeRefs.add(row.getNodeRef());
        }
        return nodeRefs;
    }

    public CMISResultSetMetaData getResultSetMetaData() {
        return this.getMetaData();
    }

    public float getScore(int n) {
        Map<String, Float> scores = this.getScores(n);
        if (scores.size() == 1) {
            return scores.values().iterator().next().floatValue();
        }
        if (this.allScoresEqual(scores)) {
            return scores.values().iterator().next().floatValue();
        }
        throw new IllegalStateException("Ambiguous selector");
    }

    private boolean allScoresEqual(Map<String, Float> scores) {
        Float last = null;
        for (Float current : scores.values()) {
            if (last == null) {
                last = current;
                continue;
            }
            if (last.equals(current)) continue;
            return false;
        }
        return true;
    }

    public int length() {
        return this.getLength();
    }

    public boolean setBulkFetch(boolean bulkFetch) {
        return false;
    }

    public boolean getBulkFetch() {
        return false;
    }

    public int setBulkFetchSize(int bulkFetchSize) {
        return 0;
    }

    public int getBulkFetchSize() {
        return 0;
    }

    public List<Pair<String, Integer>> getFieldFacet(String field) {
        return Collections.emptyList();
    }
}

