/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.action.ParameterizedItemDefinition;
import org.alfresco.service.cmr.rule.RuleServiceException;
import org.springframework.extensions.surf.util.I18NUtil;

public abstract class ParameterizedItemDefinitionImpl
implements ParameterizedItemDefinition,
Serializable {
    private String name;
    private String titleKey;
    private String descriptionKey;
    private boolean adhocPropertiesAllowed = false;
    private List<ParameterDefinition> parameterDefinitions = new ArrayList<ParameterDefinition>();
    private Map<String, ParameterDefinition> paramDefinitionsByName;
    private static final String ERR_NAME_DUPLICATION = "The names given to parameter definitions must be unique within the scope of the rule item definition.";

    public ParameterizedItemDefinitionImpl(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setTitleKey(String title) {
        this.titleKey = title;
    }

    @Override
    public String getTitle() {
        return I18NUtil.getMessage((String)this.titleKey);
    }

    public void setDescriptionKey(String descriptionKey) {
        this.descriptionKey = descriptionKey;
    }

    @Override
    public String getDescription() {
        return I18NUtil.getMessage((String)this.descriptionKey);
    }

    @Override
    public boolean getAdhocPropertiesAllowed() {
        return this.adhocPropertiesAllowed;
    }

    public void setAdhocPropertiesAllowed(boolean adhocPropertiesAllowed) {
        this.adhocPropertiesAllowed = adhocPropertiesAllowed;
    }

    public void setParameterDefinitions(List<ParameterDefinition> parameterDefinitions) {
        if (this.hasDuplicateNames(parameterDefinitions)) {
            throw new RuleServiceException(ERR_NAME_DUPLICATION);
        }
        this.parameterDefinitions = parameterDefinitions;
        this.paramDefinitionsByName = new HashMap<String, ParameterDefinition>(this.parameterDefinitions.size());
        for (ParameterDefinition definition : this.parameterDefinitions) {
            this.paramDefinitionsByName.put(definition.getName(), definition);
        }
    }

    private boolean hasDuplicateNames(List<ParameterDefinition> parameterDefinitions) {
        boolean result = false;
        if (parameterDefinitions != null) {
            HashSet<String> temp = new HashSet<String>(parameterDefinitions.size());
            for (ParameterDefinition definition : parameterDefinitions) {
                temp.add(definition.getName());
            }
            result = parameterDefinitions.size() != temp.size();
        }
        return result;
    }

    @Override
    public boolean hasParameterDefinitions() {
        return !this.parameterDefinitions.isEmpty();
    }

    @Override
    public List<ParameterDefinition> getParameterDefinitions() {
        return this.parameterDefinitions;
    }

    @Override
    public ParameterDefinition getParameterDefintion(String name) {
        ParameterDefinition result = null;
        if (this.paramDefinitionsByName != null) {
            result = this.paramDefinitionsByName.get(name);
        }
        return result;
    }
}

