/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.metadata.MetadataExtracterRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentMetadataExtracter
extends ActionExecuterAbstractBase {
    private static Log logger = LogFactory.getLog(ContentMetadataExtracter.class);
    public static final String EXECUTOR_NAME = "extract-metadata";
    private NodeService nodeService;
    private ContentService contentService;
    private DictionaryService dictionaryService;
    private MetadataExtracterRegistry metadataExtracterRegistry;
    private boolean carryAspectProperties = true;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    @Override
    public void setDictionaryService(DictionaryService dictService) {
        this.dictionaryService = dictService;
    }

    public void setMetadataExtracterRegistry(MetadataExtracterRegistry metadataExtracterRegistry) {
        this.metadataExtracterRegistry = metadataExtracterRegistry;
    }

    public void setCarryAspectProperties(boolean carryAspectProperties) {
        this.carryAspectProperties = carryAspectProperties;
    }

    @Override
    public void executeImpl(Action ruleAction, NodeRef actionedUponNodeRef) {
        if (!this.nodeService.exists(actionedUponNodeRef)) {
            return;
        }
        ContentReader reader = this.contentService.getReader(actionedUponNodeRef, ContentModel.PROP_CONTENT);
        if (reader == null || reader.getMimetype() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"no content or mimetype - do nothing");
            }
            return;
        }
        String mimetype = reader.getMimetype();
        MetadataExtracter extracter = this.metadataExtracterRegistry.getExtracter(mimetype);
        if (extracter == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("no extracter for mimetype:" + mimetype));
            }
            return;
        }
        Map nodeProperties = this.nodeService.getProperties(actionedUponNodeRef);
        Map<QName, Serializable> modifiedProperties = null;
        try {
            modifiedProperties = extracter.extract(reader, nodeProperties);
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Raw metadata extraction failed: \n   Extracter: " + this + "\n" + "   Node:      " + actionedUponNodeRef + "\n" + "   Content:   " + reader), e);
            } else {
                logger.warn((Object)("Raw metadata extraction failed (turn on DEBUG for full error): \n   Extracter: " + this + "\n" + "   Node:      " + actionedUponNodeRef + "\n" + "   Content:   " + reader + "\n" + "   Failure:   " + e.getMessage()));
            }
            modifiedProperties = new HashMap<QName, Serializable>(0);
        }
        if (modifiedProperties.size() == 0) {
            return;
        }
        HashSet<QName> requiredAspectQNames = new HashSet<QName>(3);
        HashSet aspectPropertyQNames = new HashSet(17);
        for (QName propertyQName : modifiedProperties.keySet()) {
            ClassDefinition propertyContainerDef;
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyQName);
            if (propertyDef == null || !(propertyContainerDef = propertyDef.getContainerClass()).isAspect()) continue;
            QName aspectQName = propertyContainerDef.getName();
            requiredAspectQNames.add(aspectQName);
            Set aspectProperties = propertyContainerDef.getProperties().keySet();
            aspectPropertyQNames.addAll(aspectProperties);
        }
        if (!this.carryAspectProperties) {
            for (QName aspectPropertyQName : aspectPropertyQNames) {
                if (!modifiedProperties.containsKey(aspectPropertyQName)) {
                    nodeProperties.remove(aspectPropertyQName);
                    continue;
                }
                if (modifiedProperties.get(aspectPropertyQName) != null) continue;
                nodeProperties.remove(aspectPropertyQName);
            }
        }
        this.nodeService.setProperties(actionedUponNodeRef, nodeProperties);
        for (QName requiredAspectQName : requiredAspectQNames) {
            if (this.nodeService.hasAspect(actionedUponNodeRef, requiredAspectQName)) continue;
            this.nodeService.addAspect(actionedUponNodeRef, requiredAspectQName, null);
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> arg0) {
    }
}

