/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.executer.ContentMetadataExtracter;
import org.alfresco.repo.content.metadata.AbstractMappingMetadataExtracter;
import org.alfresco.repo.content.metadata.MetadataExtracterRegistry;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;

public class ContentMetadataExtracterTest
extends BaseSpringTest {
    protected static final String QUICK_TITLE = "The quick brown fox jumps over the lazy dog";
    protected static final String QUICK_DESCRIPTION = "Gym class featuring a brown fox and lazy dog";
    protected static final String QUICK_CREATOR = "Nevin Nollop";
    private NodeService nodeService;
    private ContentService contentService;
    private StoreRef testStoreRef;
    private NodeRef rootNodeRef;
    private NodeRef nodeRef;
    private ContentMetadataExtracter executer;
    private static final String ID = GUID.generate();
    private static final QName PROP_UNKNOWN_1 = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"unkown1");
    private static final QName PROP_UNKNOWN_2 = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"unkown2");

    protected void onSetUpInTransaction() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        authenticationComponent.setSystemUserAsCurrentUser();
        this.testStoreRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.testStoreRef);
        this.nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"), ContentModel.TYPE_CONTENT).getChildRef();
        ContentWriter cw = this.contentService.getWriter(this.nodeRef, ContentModel.PROP_CONTENT, true);
        cw.setMimetype("application/pdf");
        cw.putContent(AbstractContentTransformerTest.loadQuickTestFile("pdf"));
        this.executer = (ContentMetadataExtracter)this.applicationContext.getBean("extract-metadata");
    }

    public void testFromBlanks() {
        Map props = this.nodeService.getProperties(this.nodeRef);
        props.remove(ContentModel.PROP_AUTHOR);
        props.put(ContentModel.PROP_TITLE, "");
        props.put(ContentModel.PROP_DESCRIPTION, null);
        this.nodeService.setProperties(this.nodeRef, props);
        ActionImpl action = new ActionImpl(null, ID, "set-property-value", null);
        this.executer.execute(action, this.nodeRef);
        ContentMetadataExtracterTest.assertEquals((Object)QUICK_TITLE, (Object)this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_TITLE));
        ContentMetadataExtracterTest.assertEquals((Object)QUICK_DESCRIPTION, (Object)this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_DESCRIPTION));
        ContentMetadataExtracterTest.assertEquals((Object)QUICK_CREATOR, (Object)this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_AUTHOR));
    }

    public void testUnknownProperties() {
        MetadataExtracterRegistry registry = (MetadataExtracterRegistry)this.applicationContext.getBean("metadataExtracterRegistry");
        TestUnknownMetadataExtracter extracterUnknown = new TestUnknownMetadataExtracter();
        extracterUnknown.setRegistry(registry);
        extracterUnknown.register();
        ContentWriter cw = this.contentService.getWriter(this.nodeRef, ContentModel.PROP_CONTENT, true);
        cw.setMimetype("application/octet-stream");
        cw.putContent("Content for " + this.getName());
        ActionImpl action = new ActionImpl(null, ID, "set-property-value", null);
        this.executer.execute(action, this.nodeRef);
        Serializable prop1 = this.nodeService.getProperty(this.nodeRef, PROP_UNKNOWN_1);
        Serializable prop2 = this.nodeService.getProperty(this.nodeRef, PROP_UNKNOWN_2);
        ContentMetadataExtracterTest.assertNotNull((String)"Unknown property is null", (Object)prop1);
        ContentMetadataExtracterTest.assertNotNull((String)"Unknown property is null", (Object)prop2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNullExtractedValues_ALF1823() {
        MetadataExtracterRegistry registry = (MetadataExtracterRegistry)this.applicationContext.getBean("metadataExtracterRegistry");
        TestNullPropMetadataExtracter extractor = new TestNullPropMetadataExtracter();
        extractor.setRegistry(registry);
        extractor.register();
        this.nodeService.setProperty(this.nodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"TITLE"));
        this.nodeService.setProperty(this.nodeRef, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"DESCRIPTION"));
        ContentWriter cw = this.contentService.getWriter(this.nodeRef, ContentModel.PROP_CONTENT, true);
        cw.setMimetype("application/octet-stream");
        cw.putContent("Content for " + this.getName());
        ActionImpl action = new ActionImpl(null, ID, "set-property-value", null);
        this.executer.execute(action, this.nodeRef);
        Serializable title = this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_TITLE);
        Serializable descr = this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_DESCRIPTION);
        ContentMetadataExtracterTest.assertNotNull((String)"cm:title property is null", (Object)title);
        ContentMetadataExtracterTest.assertNotNull((String)"cm:description property is null", (Object)descr);
        try {
            this.executer.setCarryAspectProperties(false);
            this.executer.execute(action, this.nodeRef);
            title = this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_TITLE);
            descr = this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_DESCRIPTION);
            ContentMetadataExtracterTest.assertNull((String)"cm:title property is not null", (Object)title);
            ContentMetadataExtracterTest.assertNull((String)"cm:description property is not null", (Object)descr);
        }
        finally {
            this.executer.setCarryAspectProperties(true);
        }
    }

    public void testFromPartial() {
        String myCreator = "Null-op";
        String myTitle = "The hot dog is eaten by the city fox";
        Map props = this.nodeService.getProperties(this.nodeRef);
        props.put(ContentModel.PROP_AUTHOR, myCreator);
        props.put(ContentModel.PROP_TITLE, myTitle);
        props.remove(ContentModel.PROP_DESCRIPTION);
        this.nodeService.setProperties(this.nodeRef, props);
        ActionImpl action = new ActionImpl(null, ID, "set-property-value", null);
        this.executer.execute(action, this.nodeRef);
        ContentMetadataExtracterTest.assertEquals((Object)myTitle, (Object)this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_TITLE));
        ContentMetadataExtracterTest.assertEquals((Object)myCreator, (Object)this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_AUTHOR));
        ContentMetadataExtracterTest.assertEquals((Object)QUICK_DESCRIPTION, (Object)this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_DESCRIPTION));
    }

    private static class TestNullPropMetadataExtracter
    extends AbstractMappingMetadataExtracter {
        public TestNullPropMetadataExtracter() {
            Properties mappingProperties = new Properties();
            mappingProperties.put("title", ContentModel.PROP_TITLE.toString());
            mappingProperties.put("description", ContentModel.PROP_DESCRIPTION.toString());
            this.setMappingProperties(mappingProperties);
        }

        @Override
        protected Map<String, Set<QName>> getDefaultMapping() {
            return new HashMap<String, Set<QName>>(0);
        }

        @Override
        public boolean isSupported(String sourceMimetype) {
            return sourceMimetype.equals("application/octet-stream");
        }

        @Override
        public Map<String, Serializable> extractRaw(ContentReader reader) throws Throwable {
            Map<String, Serializable> rawMap = this.newRawMap();
            this.putRawValue("title", null, rawMap);
            this.putRawValue("description", (Serializable)((Object)""), rawMap);
            return rawMap;
        }
    }

    private static class TestUnknownMetadataExtracter
    extends AbstractMappingMetadataExtracter {
        public TestUnknownMetadataExtracter() {
            Properties mappingProperties = new Properties();
            mappingProperties.put("unknown1", PROP_UNKNOWN_1.toString());
            mappingProperties.put("unknown2", PROP_UNKNOWN_2.toString());
            this.setMappingProperties(mappingProperties);
        }

        @Override
        protected Map<String, Set<QName>> getDefaultMapping() {
            return new HashMap<String, Set<QName>>(0);
        }

        @Override
        public boolean isSupported(String sourceMimetype) {
            return sourceMimetype.equals("application/octet-stream");
        }

        @Override
        public Map<String, Serializable> extractRaw(ContentReader reader) throws Throwable {
            Map<String, Serializable> rawMap = this.newRawMap();
            rawMap.put("unknown1", new Integer(1));
            rawMap.put("unknown2", (Serializable)((Object)"TWO"));
            return rawMap;
        }
    }
}

