/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.CrossRepositoryCopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CopyToWebProjectActionExecuter
extends ActionExecuterAbstractBase {
    public static final String ERR_OVERWRITE = "Unable to overwrite copy because more than one have been found.";
    public static final String NAME = "copy-to-web-project";
    public static final String PARAM_DESTINATION_FOLDER = "destination-folder";
    public static final String PARAM_OVERWRITE_COPY = "overwrite-copy";
    private static final Log logger = LogFactory.getLog(CopyToWebProjectActionExecuter.class);
    private CrossRepositoryCopyService crCopyService;
    private NodeService nodeService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setCrossRepositoryCopyService(CrossRepositoryCopyService crCopyService) {
        this.crCopyService = crCopyService;
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_DESTINATION_FOLDER, DataTypeDefinition.NODE_REF, true, this.getParamDisplayLabel(PARAM_DESTINATION_FOLDER)));
    }

    @Override
    public void executeImpl(Action ruleAction, NodeRef actionedUponNodeRef) {
        if (this.nodeService.exists(actionedUponNodeRef)) {
            NodeRef destinationParent = (NodeRef)ruleAction.getParameterValue(PARAM_DESTINATION_FOLDER);
            String name = (String)((Object)this.nodeService.getProperty(actionedUponNodeRef, ContentModel.PROP_NAME));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Copying " + actionedUponNodeRef.toString() + "(" + name + ") to " + destinationParent.toString()));
            }
            this.crCopyService.copy(actionedUponNodeRef, destinationParent, name);
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)("Not copying " + actionedUponNodeRef.toString() + " as it no longer exists!"));
        }
    }
}

