/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.importer.ACPImportPackageHandler;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class ImporterActionExecuter
extends ActionExecuterAbstractBase {
    public static final String NAME = "import";
    public static final String PARAM_ENCODING = "encoding";
    public static final String PARAM_DESTINATION_FOLDER = "destination";
    private static final int BUFFER_SIZE = 16384;
    private static final String TEMP_FILE_PREFIX = "alf";
    private static final String TEMP_FILE_SUFFIX_ACP = ".acp";
    private static final String TEMP_FILE_SUFFIX_ZIP = ".zip";
    private ImporterService importerService;
    private NodeService nodeService;
    private ContentService contentService;
    private FileFolderService fileFolderService;

    public void setImporterService(ImporterService importerService) {
        this.importerService = importerService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeImpl(Action ruleAction, NodeRef actionedUponNodeRef) {
        ContentReader reader;
        if (this.nodeService.exists(actionedUponNodeRef) && (reader = this.contentService.getReader(actionedUponNodeRef, ContentModel.PROP_CONTENT)) != null) {
            NodeRef importDest = (NodeRef)ruleAction.getParameterValue(PARAM_DESTINATION_FOLDER);
            if ("application/acp".equals(reader.getMimetype())) {
                File zipFile = null;
                try {
                    zipFile = TempFileProvider.createTempFile((String)TEMP_FILE_PREFIX, (String)TEMP_FILE_SUFFIX_ACP);
                    reader.getContent(zipFile);
                    ACPImportPackageHandler importHandler = new ACPImportPackageHandler(zipFile, (String)((Object)ruleAction.getParameterValue(PARAM_ENCODING)));
                    this.importerService.importView(importHandler, new Location(importDest), null, null);
                }
                finally {
                    if (zipFile != null) {
                        zipFile.delete();
                    }
                }
            }
            if ("application/zip".equals(reader.getMimetype())) {
                ZipFile zipFile = null;
                File tempFile = null;
                try {
                    tempFile = TempFileProvider.createTempFile((String)TEMP_FILE_PREFIX, (String)TEMP_FILE_SUFFIX_ACP);
                    reader.getContent(tempFile);
                    zipFile = new ZipFile(tempFile, "UTF-8", true);
                    File alfTempDir = TempFileProvider.getLongLifeTempDir((String)NAME);
                    File tempDir = new File(alfTempDir.getPath() + File.separatorChar + actionedUponNodeRef.getId());
                    try {
                        ImporterActionExecuter.extractFile(zipFile, tempDir.getPath());
                        this.importDirectory(tempDir.getPath(), importDest);
                    }
                    finally {
                        ImporterActionExecuter.deleteDir(tempDir);
                    }
                }
                catch (IOException ioErr) {
                    throw new AlfrescoRuntimeException("Failed to import ZIP file.", (Throwable)ioErr);
                }
                finally {
                    if (tempFile != null) {
                        tempFile.delete();
                    }
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException e) {
                            throw new AlfrescoRuntimeException("Failed to close zip package.", (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    private void importDirectory(String dir, NodeRef root) {
        File topdir = new File(dir);
        for (File file : topdir.listFiles()) {
            try {
                if (file.isFile()) {
                    String fileName = file.getName();
                    FileInfo fileInfo = this.fileFolderService.create(root, fileName, ContentModel.TYPE_CONTENT);
                    NodeRef fileRef = fileInfo.getNodeRef();
                    HashMap<QName, String> titledProps = new HashMap<QName, String>(1, 1.0f);
                    titledProps.put(ContentModel.PROP_TITLE, fileName);
                    this.nodeService.addAspect(fileRef, ContentModel.ASPECT_TITLED, titledProps);
                    BufferedInputStream contentStream = new BufferedInputStream(new FileInputStream(file), 16384);
                    ContentWriter writer = this.contentService.getWriter(fileRef, ContentModel.PROP_CONTENT, true);
                    writer.guessMimetype(fileName);
                    writer.putContent((InputStream)contentStream);
                    continue;
                }
                FileInfo folderInfo = this.fileFolderService.create(root, file.getName(), ContentModel.TYPE_FOLDER);
                NodeRef folderRef = folderInfo.getNodeRef();
                this.nodeService.addAspect(folderRef, ApplicationModel.ASPECT_UIFACETS, null);
                this.importDirectory(file.getPath(), folderRef);
            }
            catch (FileNotFoundException e) {
                throw new AlfrescoRuntimeException("Failed to process ZIP file.", (Throwable)e);
            }
            catch (FileExistsException e) {
                throw new AlfrescoRuntimeException("Failed to process ZIP file.", (Throwable)e);
            }
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_DESTINATION_FOLDER, DataTypeDefinition.NODE_REF, true, this.getParamDisplayLabel(PARAM_DESTINATION_FOLDER)));
        paramList.add(new ParameterDefinitionImpl(PARAM_ENCODING, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_ENCODING)));
    }

    public static void extractFile(ZipFile archive, String extractDir) {
        byte[] buffer = new byte[16384];
        extractDir = extractDir + File.separator;
        try {
            Enumeration e = archive.getEntries();
            while (e.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)e.nextElement();
                if (!entry.isDirectory()) {
                    int count;
                    File parentFile;
                    String fileName = entry.getName();
                    fileName = fileName.replace('/', File.separatorChar);
                    String destFileName = extractDir + fileName;
                    File destFile = new File(destFileName);
                    String parent = destFile.getParent();
                    if (parent != null && !(parentFile = new File(parent)).exists()) {
                        parentFile.mkdirs();
                    }
                    BufferedInputStream in = new BufferedInputStream(archive.getInputStream(entry), 16384);
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destFileName), 16384);
                    while ((count = ((InputStream)in).read(buffer)) != -1) {
                        ((OutputStream)out).write(buffer, 0, count);
                    }
                    ((InputStream)in).close();
                    ((OutputStream)out).close();
                    continue;
                }
                File newdir = new File(extractDir + entry.getName());
                newdir.mkdirs();
            }
        }
        catch (ZipException e) {
            throw new AlfrescoRuntimeException("Failed to process ZIP file.", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new AlfrescoRuntimeException("Failed to process ZIP file.", (Throwable)e);
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Failed to process ZIP file.", (Throwable)e);
        }
    }

    public static void deleteDir(File dir) {
        if (dir != null) {
            File elenco = new File(dir.getPath());
            File[] files = elenco.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isFile()) {
                        file.delete();
                        continue;
                    }
                    ImporterActionExecuter.deleteDir(file);
                }
            }
            dir.delete();
        }
    }
}

