/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.action.executer.TestModeable;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.template.DateCompareMethod;
import org.alfresco.repo.template.HasAspectMethod;
import org.alfresco.repo.template.I18NMessageMethod;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.TemplateService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.UrlUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.routines.EmailValidator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.mail.MailException;
import org.springframework.mail.MailPreparationException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;

public class MailActionExecuter
extends ActionExecuterAbstractBase
implements InitializingBean,
TestModeable {
    private static Log logger = LogFactory.getLog(MailActionExecuter.class);
    public static final String NAME = "mail";
    public static final String PARAM_TO = "to";
    public static final String PARAM_TO_MANY = "to_many";
    public static final String PARAM_SUBJECT = "subject";
    public static final String PARAM_TEXT = "text";
    public static final String PARAM_HTML = "html";
    public static final String PARAM_FROM = "from";
    public static final String PARAM_TEMPLATE = "template";
    public static final String PARAM_TEMPLATE_MODEL = "template_model";
    public static final String PARAM_IGNORE_SEND_FAILURE = "ignore_send_failure";
    public static final String PARAM_SEND_AFTER_COMMIT = "send_after_commit";
    private static final String FROM_ADDRESS = "alfresco@alfresco.org";
    private JavaMailSender javaMailSender;
    private TemplateService templateService;
    private PersonService personService;
    private AuthenticationService authService;
    private NodeService nodeService;
    private AuthorityService authorityService;
    private ServiceRegistry serviceRegistry;
    private SysAdminParams sysAdminParams;
    private String headerEncoding = null;
    private String fromDefaultAddress = null;
    private boolean fromEnabled = true;
    private boolean sendTestMessage = false;
    private String testMessageTo = null;
    private String testMessageSubject = "Test message";
    private String testMessageText = "This is a test message.";
    private boolean testMode = false;
    private MimeMessage lastTestMessage;

    public void setMailService(JavaMailSender javaMailSender) {
        this.javaMailSender = javaMailSender;
    }

    public void setTemplateService(TemplateService templateService) {
        this.templateService = templateService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setAuthenticationService(AuthenticationService authService) {
        this.authService = authService;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setHeaderEncoding(String headerEncoding) {
        this.headerEncoding = headerEncoding;
    }

    public void setFromAddress(String fromAddress) {
        this.fromDefaultAddress = fromAddress;
    }

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }

    public void setTestMessageTo(String testMessageTo) {
        this.testMessageTo = testMessageTo;
    }

    public void setTestMessageSubject(String testMessageSubject) {
        this.testMessageSubject = testMessageSubject;
    }

    public void setTestMessageText(String testMessageText) {
        this.testMessageText = testMessageText;
    }

    public void setSendTestMessage(boolean sendTestMessage) {
        this.sendTestMessage = sendTestMessage;
    }

    @Override
    public void init() {
        super.init();
        if (this.sendTestMessage) {
            HashMap<String, Serializable> params = new HashMap<String, Serializable>();
            params.put(PARAM_TO, (Serializable)((Object)this.testMessageTo));
            params.put(PARAM_SUBJECT, (Serializable)((Object)this.testMessageSubject));
            params.put(PARAM_TEXT, (Serializable)((Object)this.testMessageText));
            Action ruleAction = this.serviceRegistry.getActionService().createAction(NAME, params);
            this.executeImpl(ruleAction, null);
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.fromDefaultAddress == null || this.fromDefaultAddress.length() == 0) {
            this.fromDefaultAddress = FROM_ADDRESS;
        }
    }

    @Override
    protected void executeImpl(final Action ruleAction, final NodeRef actionedUponNodeRef) {
        if (this.sendAfterCommit(ruleAction)) {
            AlfrescoTransactionSupport.bindListener(new TransactionListenerAdapter(){

                @Override
                public void afterCommit() {
                    RetryingTransactionHelper helper = MailActionExecuter.this.serviceRegistry.getRetryingTransactionHelper();
                    helper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        @Override
                        public Void execute() throws Throwable {
                            if (MailActionExecuter.this.validNodeRefIfPresent(actionedUponNodeRef)) {
                                MailActionExecuter.this.prepareAndSendEmail(ruleAction, actionedUponNodeRef);
                            }
                            return null;
                        }
                    }, false, true);
                }
            });
        } else if (this.validNodeRefIfPresent(actionedUponNodeRef)) {
            this.prepareAndSendEmail(ruleAction, actionedUponNodeRef);
        }
    }

    private boolean validNodeRefIfPresent(NodeRef actionedUponNodeRef) {
        if (actionedUponNodeRef == null) {
            return true;
        }
        return this.nodeService.exists(actionedUponNodeRef);
    }

    private boolean sendAfterCommit(Action action) {
        Boolean sendAfterCommit = (Boolean)action.getParameterValue(PARAM_SEND_AFTER_COMMIT);
        return sendAfterCommit == null ? false : sendAfterCommit;
    }

    private void prepareAndSendEmail(final Action ruleAction, final NodeRef actionedUponNodeRef) {
        block7: {
            MimeMessagePreparator mailPreparer = new MimeMessagePreparator(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void prepare(MimeMessage mimeMessage) throws MessagingException {
                    String to;
                    if (logger.isDebugEnabled()) {
                        logger.debug(ruleAction.getParameterValues());
                    }
                    MimeMessageHelper message = new MimeMessageHelper(mimeMessage);
                    if (MailActionExecuter.this.headerEncoding != null && MailActionExecuter.this.headerEncoding.length() != 0) {
                        mimeMessage.setHeader("Content-Transfer-Encoding", MailActionExecuter.this.headerEncoding);
                    }
                    if ((to = (String)((Object)ruleAction.getParameterValue(MailActionExecuter.PARAM_TO))) != null && to.length() != 0) {
                        message.setTo(to);
                    } else {
                        Serializable authoritiesValue = ruleAction.getParameterValue(MailActionExecuter.PARAM_TO_MANY);
                        ArrayList<String> authorities = null;
                        if (authoritiesValue != null) {
                            if (authoritiesValue instanceof String) {
                                authorities = new ArrayList<String>(1);
                                authorities.add((String)((Object)authoritiesValue));
                            } else {
                                authorities = (List)((Object)authoritiesValue);
                            }
                        }
                        if (authorities == null || authorities.size() == 0) throw new MailPreparationException("No recipient has been specified for the mail action");
                        ArrayList<String> recipients = new ArrayList<String>(authorities.size());
                        for (String authority : authorities) {
                            AuthorityType authType = AuthorityType.getAuthorityType((String)authority);
                            if (authType.equals((Object)AuthorityType.USER)) {
                                if (!MailActionExecuter.this.personService.personExists(authority)) continue;
                                NodeRef person = MailActionExecuter.this.personService.getPerson(authority);
                                String address = (String)((Object)MailActionExecuter.this.nodeService.getProperty(person, ContentModel.PROP_EMAIL));
                                if (address == null || address.length() == 0 || !MailActionExecuter.this.validateAddress(address)) continue;
                                recipients.add(address);
                                continue;
                            }
                            if (!authType.equals((Object)AuthorityType.GROUP) && !authType.equals((Object)AuthorityType.EVERYONE)) continue;
                            Set<String> users = authType.equals((Object)AuthorityType.GROUP) ? MailActionExecuter.this.authorityService.getContainedAuthorities(AuthorityType.USER, authority, false) : MailActionExecuter.this.authorityService.getAllAuthorities(AuthorityType.USER);
                            for (String userAuth : users) {
                                if (!MailActionExecuter.this.personService.personExists(userAuth)) continue;
                                NodeRef person = MailActionExecuter.this.personService.getPerson(userAuth);
                                String address = (String)((Object)MailActionExecuter.this.nodeService.getProperty(person, ContentModel.PROP_EMAIL));
                                if (address == null || address.length() == 0) continue;
                                recipients.add(address);
                            }
                        }
                        if (recipients.size() <= 0) throw new MailPreparationException("All recipients for the mail action were invalid");
                        message.setTo(recipients.toArray(new String[recipients.size()]));
                    }
                    NodeRef fromPerson = null;
                    if (!MailActionExecuter.this.authService.isCurrentUserTheSystemUser()) {
                        fromPerson = MailActionExecuter.this.personService.getPerson(MailActionExecuter.this.authService.getCurrentUserName());
                    }
                    if (MailActionExecuter.this.isFromEnabled()) {
                        String from = (String)((Object)ruleAction.getParameterValue(MailActionExecuter.PARAM_FROM));
                        if (from != null && from.length() > 0) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("from specified as a parameter, from:" + from));
                            }
                            message.setFrom(from);
                        } else {
                            String fromActualUser = null;
                            if (fromPerson != null) {
                                fromActualUser = (String)((Object)MailActionExecuter.this.nodeService.getProperty(fromPerson, ContentModel.PROP_EMAIL));
                            }
                            if (fromActualUser != null && fromActualUser.length() != 0) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("looked up email address for :" + fromPerson + " email from " + fromActualUser));
                                }
                                message.setFrom(fromActualUser);
                            } else {
                                message.setFrom(MailActionExecuter.this.fromDefaultAddress);
                            }
                        }
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("from not enabled - sending from default address:" + MailActionExecuter.this.fromDefaultAddress));
                        }
                        message.setFrom(MailActionExecuter.this.fromDefaultAddress);
                    }
                    message.setSubject((String)((Object)ruleAction.getParameterValue(MailActionExecuter.PARAM_SUBJECT)));
                    String text = null;
                    NodeRef templateRef = (NodeRef)ruleAction.getParameterValue(MailActionExecuter.PARAM_TEMPLATE);
                    if (templateRef != null) {
                        Map suppliedModel = null;
                        if (ruleAction.getParameterValue(MailActionExecuter.PARAM_TEMPLATE_MODEL) != null) {
                            Serializable m = ruleAction.getParameterValue(MailActionExecuter.PARAM_TEMPLATE_MODEL);
                            if (m instanceof Map) {
                                suppliedModel = (Map)((Object)m);
                            } else {
                                logger.warn((Object)("Skipping unsupported email template model parameters of type " + m.getClass().getName() + " : " + m.toString()));
                            }
                        }
                        Map model = MailActionExecuter.this.createEmailTemplateModel(actionedUponNodeRef, suppliedModel, fromPerson);
                        text = MailActionExecuter.this.templateService.processTemplate("freemarker", templateRef.toString(), model);
                    }
                    boolean isHTML = false;
                    if (text == null) {
                        text = (String)((Object)ruleAction.getParameterValue(MailActionExecuter.PARAM_TEXT));
                    }
                    if (text != null) {
                        String htmlPrefix = "<html";
                        if (text.length() >= htmlPrefix.length() && text.substring(0, htmlPrefix.length()).equalsIgnoreCase(htmlPrefix)) {
                            isHTML = true;
                        }
                    } else {
                        text = (String)((Object)ruleAction.getParameterValue(MailActionExecuter.PARAM_HTML));
                        if (text != null) {
                            isHTML = true;
                        }
                    }
                    if (text == null) return;
                    message.setText(text, isHTML);
                }
            };
            try {
                if (!this.testMode) {
                    this.javaMailSender.send(mailPreparer);
                } else {
                    try {
                        MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
                        mailPreparer.prepare(mimeMessage);
                        this.lastTestMessage = mimeMessage;
                    }
                    catch (Exception e) {
                        System.err.println(e);
                    }
                }
            }
            catch (MailException e) {
                Serializable obj;
                String to = (String)((Object)ruleAction.getParameterValue(PARAM_TO));
                if (to == null && (obj = ruleAction.getParameterValue(PARAM_TO_MANY)) != null) {
                    to = obj.toString();
                }
                logger.error((Object)("Failed to send email to " + to), (Throwable)e);
                Boolean ignoreError = (Boolean)ruleAction.getParameterValue(PARAM_IGNORE_SEND_FAILURE);
                if (ignoreError != null && ignoreError.booleanValue()) break block7;
                throw new AlfrescoRuntimeException("Failed to send email to:" + to, (Throwable)e);
            }
        }
    }

    private boolean validateAddress(String address) {
        boolean result = false;
        EmailValidator emailValidator = EmailValidator.getInstance((boolean)true);
        if (emailValidator.isValid(address)) {
            result = true;
        } else {
            logger.error((Object)("Failed to send email to '" + address + "' as the address is incorrectly formatted"));
        }
        return result;
    }

    private Map<String, Object> createEmailTemplateModel(NodeRef ref, Map<String, Object> suppliedModel, NodeRef fromPerson) {
        HashMap<String, Object> model = new HashMap<String, Object>(8, 1.0f);
        if (fromPerson != null) {
            model.put("person", new TemplateNode(fromPerson, this.serviceRegistry, null));
        }
        if (ref != null) {
            model.put("document", new TemplateNode(ref, this.serviceRegistry, null));
            NodeRef parent = this.serviceRegistry.getNodeService().getPrimaryParent(ref).getParentRef();
            model.put("space", new TemplateNode(parent, this.serviceRegistry, null));
        }
        model.put("date", new Date());
        model.put("hasAspect", new HasAspectMethod());
        model.put("message", new I18NMessageMethod());
        model.put("dateCompare", new DateCompareMethod());
        model.put("url", new URLHelper(this.sysAdminParams));
        model.put("shareUrl", UrlUtil.getShareUrl(this.serviceRegistry.getSysAdminParams()));
        if (suppliedModel != null && suppliedModel.size() > 0) {
            for (String key : suppliedModel.keySet()) {
                if (model.containsKey(key)) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Not allowing overwriting of built in model parameter " + key));
                    continue;
                }
                model.put(key, suppliedModel.get(key));
            }
        }
        return model;
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_TO, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_TO)));
        paramList.add(new ParameterDefinitionImpl(PARAM_TO_MANY, DataTypeDefinition.ANY, false, this.getParamDisplayLabel(PARAM_TO_MANY), true));
        paramList.add(new ParameterDefinitionImpl(PARAM_SUBJECT, DataTypeDefinition.TEXT, true, this.getParamDisplayLabel(PARAM_SUBJECT)));
        paramList.add(new ParameterDefinitionImpl(PARAM_TEXT, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_TEXT)));
        paramList.add(new ParameterDefinitionImpl(PARAM_FROM, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_FROM)));
        paramList.add(new ParameterDefinitionImpl(PARAM_TEMPLATE, DataTypeDefinition.NODE_REF, false, this.getParamDisplayLabel(PARAM_TEMPLATE), false, "ac-email-templates"));
        paramList.add(new ParameterDefinitionImpl(PARAM_TEMPLATE_MODEL, DataTypeDefinition.ANY, false, this.getParamDisplayLabel(PARAM_TEMPLATE_MODEL), true));
        paramList.add(new ParameterDefinitionImpl(PARAM_IGNORE_SEND_FAILURE, DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel(PARAM_IGNORE_SEND_FAILURE)));
    }

    @Override
    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    @Override
    public boolean isTestMode() {
        return this.testMode;
    }

    public MimeMessage retrieveLastTestMessage() {
        return this.lastTestMessage;
    }

    public void clearLastTestMessage() {
        this.lastTestMessage = null;
    }

    public void setFromEnabled(boolean fromEnabled) {
        this.fromEnabled = fromEnabled;
    }

    public boolean isFromEnabled() {
        return this.fromEnabled;
    }

    public static class URLHelper {
        private final SysAdminParams sysAdminParams;

        public URLHelper(SysAdminParams sysAdminParams) {
            this.sysAdminParams = sysAdminParams;
        }

        public String getContext() {
            return "/" + this.sysAdminParams.getAlfrescoContext();
        }

        public String getServerPath() {
            return this.sysAdminParams.getAlfrescoProtocol() + "://" + this.sysAdminParams.getAlfrescoHost() + ":" + this.sysAdminParams.getAlfrescoPort();
        }
    }
}

