/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.Serializable;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NoTransformerException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.service.cmr.rule.RuleServiceException;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransformActionExecuter
extends ActionExecuterAbstractBase {
    public static final String ERR_OVERWRITE = "Unable to overwrite copy because more than one have been found.";
    private static final String CONTENT_READER_NOT_FOUND_MESSAGE = "Can not find Content Reader for document. Operation can't be performed";
    private static final String TRANSFORMING_ERROR_MESSAGE = "Some error occurred during document transforming. Error message: ";
    private static final String TRANSFORMER_NOT_EXISTS_MESSAGE_PATTERN = "Transformer for '%s' source mime type and '%s' target mime type was not found. Operation can't be performed";
    private static Log logger = LogFactory.getLog(TransformActionExecuter.class);
    public static final String NAME = "transform";
    public static final String PARAM_MIME_TYPE = "mime-type";
    public static final String PARAM_DESTINATION_FOLDER = "destination-folder";
    public static final String PARAM_ASSOC_TYPE_QNAME = "assoc-type";
    public static final String PARAM_ASSOC_QNAME = "assoc-name";
    public static final String PARAM_OVERWRITE_COPY = "overwrite-copy";
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private CheckOutCheckInService checkOutCheckInService;
    private ContentService contentService;
    private CopyService copyService;
    private MimetypeService mimetypeService;

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setCheckOutCheckInService(CheckOutCheckInService checkOutCheckInService) {
        this.checkOutCheckInService = checkOutCheckInService;
    }

    @Override
    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setCopyService(CopyService copyService) {
        this.copyService = copyService;
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_MIME_TYPE, DataTypeDefinition.TEXT, true, this.getParamDisplayLabel(PARAM_MIME_TYPE), false, "ac-mimetypes"));
        paramList.add(new ParameterDefinitionImpl(PARAM_DESTINATION_FOLDER, DataTypeDefinition.NODE_REF, true, this.getParamDisplayLabel(PARAM_DESTINATION_FOLDER)));
        paramList.add(new ParameterDefinitionImpl(PARAM_ASSOC_TYPE_QNAME, DataTypeDefinition.QNAME, false, this.getParamDisplayLabel(PARAM_ASSOC_TYPE_QNAME)));
        paramList.add(new ParameterDefinitionImpl(PARAM_ASSOC_QNAME, DataTypeDefinition.QNAME, false, this.getParamDisplayLabel(PARAM_ASSOC_QNAME)));
        paramList.add(new ParameterDefinitionImpl(PARAM_OVERWRITE_COPY, DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel(PARAM_OVERWRITE_COPY)));
    }

    @Override
    protected void executeImpl(Action ruleAction, NodeRef actionedUponNodeRef) {
        if (!this.nodeService.exists(actionedUponNodeRef)) {
            return;
        }
        QName typeQName = this.nodeService.getType(actionedUponNodeRef);
        if (!this.dictionaryService.isSubClass(typeQName, ContentModel.TYPE_CONTENT)) {
            return;
        }
        String mimeType = (String)((Object)ruleAction.getParameterValue(PARAM_MIME_TYPE));
        ContentReader contentReader = this.contentService.getReader(actionedUponNodeRef, ContentModel.PROP_CONTENT);
        if (null == contentReader || !contentReader.exists()) {
            throw new RuleServiceException(CONTENT_READER_NOT_FOUND_MESSAGE);
        }
        TransformationOptions options = new TransformationOptions();
        options.setSourceNodeRef(actionedUponNodeRef);
        if (null == this.contentService.getTransformer(contentReader.getContentUrl(), contentReader.getMimetype(), contentReader.getSize(), mimeType, options)) {
            throw new RuleServiceException(String.format(TRANSFORMER_NOT_EXISTS_MESSAGE_PATTERN, contentReader.getMimetype(), mimeType));
        }
        NodeRef destinationParent = (NodeRef)ruleAction.getParameterValue(PARAM_DESTINATION_FOLDER);
        QName destinationAssocTypeQName = (QName)ruleAction.getParameterValue(PARAM_ASSOC_TYPE_QNAME);
        QName destinationAssocQName = (QName)ruleAction.getParameterValue(PARAM_ASSOC_QNAME);
        if (destinationAssocTypeQName == null) {
            destinationAssocTypeQName = ContentModel.ASSOC_CONTAINS;
        }
        if (destinationAssocQName == null) {
            destinationAssocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"copy");
        }
        boolean overwrite = true;
        Boolean overwriteValue = (Boolean)ruleAction.getParameterValue(PARAM_OVERWRITE_COPY);
        if (overwriteValue != null) {
            overwrite = overwriteValue;
        }
        String originalName = (String)((Object)this.nodeService.getProperty(actionedUponNodeRef, ContentModel.PROP_NAME));
        String newName = TransformActionExecuter.transformName(this.mimetypeService, originalName, mimeType, true);
        NodeRef copyNodeRef = null;
        if (overwrite) {
            PagingResults<CopyService.CopyInfo> copies = this.copyService.getCopies(actionedUponNodeRef, destinationParent, new PagingRequest(1000));
            for (CopyService.CopyInfo copyInfo : copies.getPage()) {
                NodeRef copy = copyInfo.getNodeRef();
                String copyName = copyInfo.getName();
                if (this.checkOutCheckInService.isWorkingCopy(copy) || !newName.equals(copyName)) continue;
                if (copyNodeRef == null) {
                    copyNodeRef = copy;
                    continue;
                }
                throw new RuleServiceException(ERR_OVERWRITE);
            }
        }
        boolean newCopy = false;
        if (copyNodeRef == null) {
            copyNodeRef = this.copyService.copy(actionedUponNodeRef, destinationParent, destinationAssocTypeQName, destinationAssocQName, false);
            newCopy = true;
        }
        if (newCopy) {
            this.nodeService.setProperty(copyNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)newName));
            String originalTitle = (String)((Object)this.nodeService.getProperty(actionedUponNodeRef, ContentModel.PROP_TITLE));
            if (originalTitle != null) {
                this.nodeService.setProperty(copyNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)originalTitle));
            }
        }
        if (contentReader != null) {
            ContentWriter contentWriter = this.contentService.getWriter(copyNodeRef, ContentModel.PROP_CONTENT, true);
            contentWriter.setMimetype(mimeType);
            contentWriter.setEncoding(contentReader.getEncoding());
            try {
                this.doTransform(ruleAction, actionedUponNodeRef, contentReader, copyNodeRef, contentWriter);
            }
            catch (NoTransformerException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("No transformer found to execute rule: \n   reader: " + contentReader + "\n" + "   writer: " + contentWriter + "\n" + "   action: " + this));
                }
                throw new RuleServiceException(TRANSFORMING_ERROR_MESSAGE + e.getMessage());
            }
        }
    }

    protected void doTransform(Action ruleAction, NodeRef sourceNodeRef, ContentReader contentReader, NodeRef destinationNodeRef, ContentWriter contentWriter) {
        TransformationOptions options = new TransformationOptions(sourceNodeRef, ContentModel.PROP_NAME, destinationNodeRef, ContentModel.PROP_NAME);
        this.contentService.transform(contentReader, contentWriter, options);
    }

    public static String transformName(MimetypeService mimetypeService, String original, String newMimetype, boolean alwaysAdd) {
        int dotIndex = original.lastIndexOf(46);
        StringBuilder sb = new StringBuilder(original.length());
        if (dotIndex > -1) {
            String nameBeforeDot = original.substring(0, dotIndex);
            String originalExtension = original.substring(dotIndex + 1, original.length());
            boolean originalExtensionIsReasonable = TransformActionExecuter.isExtensionReasonable(originalExtension);
            String newExtension = mimetypeService.getExtension(newMimetype);
            if (originalExtensionIsReasonable) {
                sb.append(nameBeforeDot);
                sb.append('.').append(newExtension);
            } else {
                sb.append(original);
                if (alwaysAdd) {
                    if (sb.charAt(sb.length() - 1) != '.') {
                        sb.append('.');
                    }
                    sb.append(newExtension);
                }
            }
        } else {
            sb.append(original);
            if (alwaysAdd) {
                String newExtension = mimetypeService.getExtension(newMimetype);
                sb.append('.').append(newExtension);
            }
        }
        return sb.toString();
    }

    private static boolean isExtensionReasonable(String potentialExtensionString) {
        return potentialExtensionString.length() > 0 && potentialExtensionString.indexOf(32) == -1;
    }
}

