/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.util.HashMap;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.executer.TransitionSimpleWorkflowActionExecuter;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.GUID;

public class TransitionSimpleWorkflowActionExecuterTest
extends BaseAlfrescoSpringTest {
    private FileFolderService fileFolderService;
    private NodeRef sourceFolder;
    private NodeRef destinationFolder;
    private NodeRef node;
    private TransitionSimpleWorkflowActionExecuter acceptExecuter;
    private TransitionSimpleWorkflowActionExecuter rejectExecuter;
    private static final String ID = GUID.generate();

    @Override
    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.fileFolderService = (FileFolderService)this.applicationContext.getBean("fileFolderService");
        NodeRef container = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"), ContentModel.TYPE_CONTENT).getChildRef();
        this.sourceFolder = this.fileFolderService.create(container, "my source folder", ContentModel.TYPE_FOLDER).getNodeRef();
        this.destinationFolder = this.fileFolderService.create(container, "my destination folder", ContentModel.TYPE_FOLDER).getNodeRef();
        this.node = this.fileFolderService.create(this.sourceFolder, "my node.txt", ContentModel.TYPE_CONTENT).getNodeRef();
        this.acceptExecuter = (TransitionSimpleWorkflowActionExecuter)this.applicationContext.getBean("accept-simpleworkflow");
        this.rejectExecuter = (TransitionSimpleWorkflowActionExecuter)this.applicationContext.getBean("reject-simpleworkflow");
        HashMap<QName, Object> propertyValues = new HashMap<QName, Object>();
        propertyValues.put(ApplicationModel.PROP_APPROVE_STEP, "Approve");
        propertyValues.put(ApplicationModel.PROP_APPROVE_FOLDER, this.destinationFolder);
        propertyValues.put(ApplicationModel.PROP_APPROVE_MOVE, Boolean.TRUE);
        propertyValues.put(ApplicationModel.PROP_REJECT_STEP, "Reject");
        propertyValues.put(ApplicationModel.PROP_REJECT_FOLDER, this.destinationFolder);
        propertyValues.put(ApplicationModel.PROP_REJECT_MOVE, Boolean.FALSE);
        this.nodeService.addAspect(this.node, ApplicationModel.ASPECT_SIMPLE_WORKFLOW, propertyValues);
    }

    public void testExecutionApprove() {
        TransitionSimpleWorkflowActionExecuterTest.assertTrue((boolean)this.nodeService.hasAspect(this.node, ApplicationModel.ASPECT_SIMPLE_WORKFLOW));
        NodeRef pParent = this.nodeService.getPrimaryParent(this.node).getParentRef();
        TransitionSimpleWorkflowActionExecuterTest.assertEquals((Object)this.sourceFolder, (Object)pParent);
        ActionImpl action = new ActionImpl(null, ID, "accept-simpleworkflow", null);
        this.acceptExecuter.execute(action, this.node);
        TransitionSimpleWorkflowActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(this.node, ApplicationModel.ASPECT_SIMPLE_WORKFLOW));
        pParent = this.nodeService.getPrimaryParent(this.node).getParentRef();
        TransitionSimpleWorkflowActionExecuterTest.assertEquals((Object)this.destinationFolder, (Object)pParent);
    }

    public void testExecutionReject() {
        TransitionSimpleWorkflowActionExecuterTest.assertTrue((boolean)this.nodeService.hasAspect(this.node, ApplicationModel.ASPECT_SIMPLE_WORKFLOW));
        NodeRef pParent = this.nodeService.getPrimaryParent(this.node).getParentRef();
        TransitionSimpleWorkflowActionExecuterTest.assertEquals((Object)this.sourceFolder, (Object)pParent);
        TransitionSimpleWorkflowActionExecuterTest.assertEquals((int)0, (int)this.nodeService.getChildAssocs(this.destinationFolder).size());
        ActionImpl action = new ActionImpl(null, ID, "reject-simpleworkflow", null);
        this.rejectExecuter.execute(action, this.node);
        TransitionSimpleWorkflowActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(this.node, ApplicationModel.ASPECT_SIMPLE_WORKFLOW));
        pParent = this.nodeService.getPrimaryParent(this.node).getParentRef();
        TransitionSimpleWorkflowActionExecuterTest.assertEquals((Object)this.sourceFolder, (Object)pParent);
        TransitionSimpleWorkflowActionExecuterTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(this.destinationFolder).size());
    }
}

