/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.scheduled;

import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.action.scheduled.TemplateActionModelFactory;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.Duration;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.springframework.extensions.surf.util.ISO8601DateFormat;

public class FreeMarkerWithLuceneExtensionsModelFactory
implements TemplateActionModelFactory {
    private ServiceRegistry serviceRegistry;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public Map<String, Object> getModel() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("date", new Date());
        Date today = cal.getTime();
        model.put("today", today);
        model.put("yesterday", Duration.add((Date)today, (Duration)new Duration("-P1D")));
        model.put("tomorrow", Duration.add((Date)today, (Duration)new Duration("P1D")));
        model.put("luceneDateRange", new LuceneDateRangeFunction());
        model.put("selectSingleNode", new QueryForSingleNodeFunction());
        return model;
    }

    @Override
    public Map<String, Object> getModel(NodeRef nodeRef) {
        Map<String, Object> model = this.getModel();
        TemplateNode companyRootNode = new TemplateNode(nodeRef, this.serviceRegistry, null);
        model.put("node", companyRootNode);
        return model;
    }

    @Override
    public String getTemplateEngine() {
        return "freemarker";
    }

    private static class LuceneDateRangeFunction
    implements TemplateMethodModelEx {
        private LuceneDateRangeFunction() {
        }

        public Object exec(List args) throws TemplateModelException {
            if (args.size() == 2) {
                Object arg0 = args.get(0);
                Object arg1 = args.get(1);
                Date startDate = null;
                Date endDate = null;
                if (arg0 instanceof TemplateDateModel) {
                    startDate = ((TemplateDateModel)arg0).getAsDate();
                } else if (arg0 instanceof TemplateScalarModel) {
                    String startDateString = ((TemplateScalarModel)arg0).getAsString();
                    startDate = ISO8601DateFormat.parse((String)startDateString);
                } else {
                    throw new TemplateModelException("Invalid date entry");
                }
                if (arg1 instanceof TemplateDateModel) {
                    endDate = ((TemplateDateModel)arg0).getAsDate();
                } else if (arg1 instanceof TemplateScalarModel) {
                    String valueString = ((TemplateScalarModel)arg1).getAsString();
                    try {
                        Duration duration = new Duration(valueString);
                        endDate = Duration.add((Date)startDate, (Duration)duration);
                    }
                    catch (Exception e) {
                        endDate = ISO8601DateFormat.parse((String)valueString);
                    }
                } else {
                    throw new TemplateModelException("Invalid date entry");
                }
                if (startDate.compareTo(endDate) > 0) {
                    Date temp = startDate;
                    startDate = endDate;
                    endDate = temp;
                }
                StringBuilder builder = new StringBuilder();
                builder.append("[");
                builder.append((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)startDate));
                builder.append(" TO ");
                builder.append((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)endDate));
                builder.append("]");
                return builder.toString();
            }
            throw new TemplateModelException("Invalid date entry");
        }
    }

    private class QueryForSingleNodeFunction
    implements TemplateMethodModelEx {
        private QueryForSingleNodeFunction() {
        }

        public Object exec(List args) throws TemplateModelException {
            if (args.size() == 3) {
                Object arg0 = args.get(0);
                Object arg1 = args.get(1);
                Object arg2 = args.get(2);
                if (!(arg0 instanceof TemplateScalarModel)) {
                    throw new TemplateModelException("Invalid store string");
                }
                StoreRef storeRef = new StoreRef(((TemplateScalarModel)arg0).getAsString());
                if (!(arg1 instanceof TemplateScalarModel)) {
                    throw new TemplateModelException("Invalid language string");
                }
                String language = ((TemplateScalarModel)arg1).getAsString();
                if (!(arg2 instanceof TemplateScalarModel)) {
                    throw new TemplateModelException("Invalid query string");
                }
                String query = ((TemplateScalarModel)arg2).getAsString();
                SearchParameters sp = new SearchParameters();
                sp.addStore(storeRef);
                sp.setLanguage(language);
                sp.setQuery(query);
                ResultSet results = null;
                try {
                    results = FreeMarkerWithLuceneExtensionsModelFactory.this.serviceRegistry.getSearchService().query(sp);
                    if (results.length() == 0) {
                        throw new TemplateModelException("No nodes selected");
                    }
                    if (results.length() == 1) {
                        String string = results.getNodeRef(0).toString();
                        return string;
                    }
                    throw new TemplateModelException("More than one node selected");
                }
                finally {
                    if (results != null) {
                        results.close();
                    }
                }
            }
            throw new TemplateModelException("Incorrect arguments");
        }
    }
}

