/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.scheduled;

import java.util.Date;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.scheduled.SchedulableAction;
import org.alfresco.service.cmr.action.scheduled.ScheduledPersistedAction;
import org.alfresco.service.cmr.repository.NodeRef;
import org.quartz.DateIntervalTrigger;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class ScheduledPersistedActionImpl
implements ScheduledPersistedAction {
    private NodeRef persistedAtNodeRef;
    private Action action;
    private Date lastExecutedAt;
    private Date scheduleStart;
    private Date scheduleEnd;
    private Integer intervalCount;
    private SchedulableAction.IntervalPeriod intervalPeriod;

    protected ScheduledPersistedActionImpl(Action action) {
        this.action = action;
    }

    protected NodeRef getPersistedAtNodeRef() {
        return this.persistedAtNodeRef;
    }

    protected void setPersistedAtNodeRef(NodeRef nodeRef) {
        this.persistedAtNodeRef = nodeRef;
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    @Override
    public NodeRef getActionNodeRef() {
        return this.action == null ? null : this.action.getNodeRef();
    }

    @Override
    public Date getScheduleLastExecutedAt() {
        return this.lastExecutedAt;
    }

    public void setScheduleLastExecutedAt(Date executedAt) {
        this.lastExecutedAt = executedAt;
    }

    @Override
    public Date getScheduleStart() {
        return this.scheduleStart;
    }

    @Override
    public void setScheduleStart(Date startDate) {
        this.scheduleStart = startDate;
    }

    protected Date getScheduleEnd() {
        return this.scheduleEnd;
    }

    protected void setScheduleEnd(Date endDate) {
        this.scheduleEnd = endDate;
    }

    @Override
    public Integer getScheduleIntervalCount() {
        return this.intervalCount;
    }

    @Override
    public void setScheduleIntervalCount(Integer count) {
        this.intervalCount = count;
    }

    @Override
    public SchedulableAction.IntervalPeriod getScheduleIntervalPeriod() {
        return this.intervalPeriod;
    }

    @Override
    public void setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod period) {
        this.intervalPeriod = period;
    }

    @Override
    public String getScheduleInterval() {
        if (this.intervalCount == null || this.intervalPeriod == null) {
            return null;
        }
        return this.intervalCount.toString() + this.intervalPeriod.name();
    }

    public Trigger asTrigger() {
        if (this.persistedAtNodeRef == null) {
            throw new IllegalStateException("Must be persisted first");
        }
        String triggerName = this.persistedAtNodeRef.toString();
        if (this.getScheduleInterval() == null && this.scheduleStart == null) {
            return null;
        }
        if (this.scheduleEnd != null && this.scheduleEnd.getTime() < System.currentTimeMillis()) {
            return null;
        }
        Date startAt = this.scheduleStart;
        Date endAt = this.scheduleEnd;
        if (startAt == null) {
            startAt = new Date();
        } else if (startAt.getTime() < System.currentTimeMillis()) {
            if (this.lastExecutedAt == null) {
                startAt = this.scheduleStart;
            } else if (this.lastExecutedAt.getTime() < startAt.getTime()) {
                startAt = this.scheduleStart;
            } else {
                if (this.getScheduleInterval() == null) {
                    return null;
                }
                DateIntervalTrigger testT = this.buildDateIntervalTrigger("TEST", this.scheduleStart, null);
                Date nextFireFromNow = testT.getFireTimeAfter(new Date());
                Date nextFireFromLast = testT.getFireTimeAfter(this.lastExecutedAt);
                startAt = nextFireFromLast.getTime() < nextFireFromNow.getTime() ? this.scheduleStart : nextFireFromNow;
            }
        }
        if (this.getScheduleInterval() == null) {
            SimpleTrigger trigger = new SimpleTrigger(triggerName, null, startAt);
            trigger.setMisfireInstruction(1);
            return trigger;
        }
        return this.buildDateIntervalTrigger(triggerName, startAt, endAt);
    }

    private DateIntervalTrigger buildDateIntervalTrigger(String triggerName, Date startAt, Date endAt) {
        DateIntervalTrigger.IntervalUnit quartzInterval = DateIntervalTrigger.IntervalUnit.valueOf((String)this.intervalPeriod.toString().toUpperCase());
        DateIntervalTrigger trigger = new DateIntervalTrigger(triggerName, null, startAt, endAt, quartzInterval, this.intervalCount.intValue());
        trigger.setMisfireInstruction(1);
        return trigger;
    }
}

