/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.post.lookup;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.activities.ActivityPostDAO;
import org.alfresco.repo.domain.activities.ActivityPostEntity;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.Pair;
import org.alfresco.util.PathUtil;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.VmShutdownListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.quartz.JobExecutionException;

public class PostLookup {
    private static Log logger = LogFactory.getLog(PostLookup.class);
    private static VmShutdownListener vmShutdownListener = new VmShutdownListener(PostLookup.class.getName());
    private ActivityPostDAO postDAO;
    private NodeService nodeService;
    private PermissionService permissionService;
    private TransactionService transactionService;
    private PersonService personService;
    private TenantService tenantService;
    private SiteService siteService;
    private volatile boolean busy;
    public static final String JSON_NODEREF_LOOKUP = "nodeRefL";
    public static final String JSON_NODEREF = "nodeRef";
    public static final String JSON_NODEREF_PARENT = "parentNodeRef";
    public static final String JSON_FIRSTNAME = "firstName";
    public static final String JSON_LASTNAME = "lastName";
    public static final String JSON_NAME = "name";
    public static final String JSON_TYPEQNAME = "typeQName";
    public static final String JSON_PARENT_NODEREF = "parentNodeRef";
    public static final String JSON_DISPLAY_PATH = "displayPath";
    public static final String JSON_TENANT_DOMAIN = "tenantDomain";
    public static final String JSON_TITLE = "title";
    public static final String JSON_PAGE = "page";
    private static Map<String, String> rollupTypes = new HashMap<String, String>(3);
    private int rollupCount = 5;

    public void setPostDAO(ActivityPostDAO postDAO) {
        this.postDAO = postDAO;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setRollupCount(int rollupCount) {
        this.rollupCount = rollupCount;
    }

    private void checkProperties() {
        PropertyCheck.mandatory((Object)this, (String)"postDAO", (Object)this.postDAO);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"permissionService", (Object)this.permissionService);
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"personService", (Object)this.personService);
        PropertyCheck.mandatory((Object)this, (String)"tenantService", (Object)this.tenantService);
        rollupTypes.put("org.alfresco.documentlibrary.file-added", "org.alfresco.documentlibrary.files-added");
        rollupTypes.put("org.alfresco.documentlibrary.file-updated", "org.alfresco.documentlibrary.files-updated");
        rollupTypes.put("org.alfresco.documentlibrary.file-deleted", "org.alfresco.documentlibrary.files-deleted");
        rollupTypes.put("org.alfresco.documentlibrary.folder-added", "org.alfresco.documentlibrary.folders-added");
        rollupTypes.put("org.alfresco.documentlibrary.folder-deleted", "org.alfresco.documentlibrary.folders-deleted");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws JobExecutionException {
        this.checkProperties();
        if (this.busy) {
            logger.warn((Object)"Still busy ...");
            return;
        }
        this.busy = true;
        try {
            ActivityPostEntity params = new ActivityPostEntity();
            params.setStatus(ActivityPostEntity.STATUS.PENDING.toString());
            final List<ActivityPostEntity> activityPosts = this.postDAO.selectPosts(params);
            if (activityPosts.size() > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Update: " + activityPosts.size() + " activity post" + (activityPosts.size() == 1 ? "s" : "")));
                }
                this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                    @Override
                    public Object execute() throws Throwable {
                        PostLookup.this.lookupPosts(activityPosts);
                        return null;
                    }
                }, true);
                List<ActivityPostEntity> activityPostsToUpdate = this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<List<ActivityPostEntity>>(){

                    @Override
                    public List<ActivityPostEntity> execute() throws Throwable {
                        return PostLookup.this.rollupPosts(activityPosts);
                    }
                }, false);
                this.updatePosts(activityPostsToUpdate);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Exception during select of posts", (Throwable)e);
            throw new JobExecutionException((Throwable)e);
        }
        catch (Throwable e) {
            if (vmShutdownListener.isVmShuttingDown()) {
            } else {
                logger.error((Object)"Exception during update of posts", e);
            }
        }
        finally {
            this.busy = false;
        }
    }

    private List<ActivityPostEntity> lookupPosts(List<ActivityPostEntity> activityPosts) {
        for (final ActivityPostEntity activityPost : activityPosts) {
            final String postUserId = activityPost.getUserId();
            try {
                String tenantDomain = "";
                final JSONObject jo = new JSONObject(new JSONTokener(activityPost.getActivityData()));
                if (!jo.isNull(JSON_TENANT_DOMAIN)) {
                    tenantDomain = jo.getString(JSON_TENANT_DOMAIN);
                }
                activityPost.setTenantDomain(tenantDomain);
                TenantUtil.runAsSystemTenant(new TenantUtil.TenantRunAsWork<Void>(){

                    @Override
                    public Void doWork() throws Exception {
                        JSONObject joLookup = null;
                        if (!jo.isNull(PostLookup.JSON_NODEREF_LOOKUP)) {
                            String nodeRefStr = jo.getString(PostLookup.JSON_NODEREF_LOOKUP);
                            NodeRef nodeRef = new NodeRef(nodeRefStr);
                            joLookup = PostLookup.this.lookupNode(nodeRef, postUserId, jo);
                        } else {
                            String nodeRefStr;
                            String siteId;
                            NodeRef parentNodeRef;
                            Pair firstLastName;
                            if ((jo.isNull(PostLookup.JSON_FIRSTNAME) || jo.isNull(PostLookup.JSON_LASTNAME)) && (firstLastName = PostLookup.this.lookupPerson(postUserId)) != null) {
                                jo.put(PostLookup.JSON_FIRSTNAME, firstLastName.getFirst());
                                jo.put(PostLookup.JSON_LASTNAME, firstLastName.getSecond());
                                joLookup = jo;
                            }
                            if ((parentNodeRef = activityPost.getParentNodeRef()) == null) {
                                String parentNodeRefStr = null;
                                if (jo.isNull("parentNodeRef")) {
                                    if (!jo.isNull(PostLookup.JSON_NODEREF) && (parentNodeRef = PostLookup.this.lookupParentNodeRef(new NodeRef(jo.getString(PostLookup.JSON_NODEREF)))) != null) {
                                        parentNodeRefStr = parentNodeRef.toString();
                                        jo.put("parentNodeRef", (Object)parentNodeRefStr);
                                    }
                                } else {
                                    parentNodeRefStr = jo.getString("parentNodeRef");
                                }
                                if (parentNodeRefStr != null) {
                                    activityPost.setParentNodeRef(new NodeRef(parentNodeRefStr));
                                }
                            }
                            if ((siteId = activityPost.getSiteNetwork()) == null && (nodeRefStr = jo.getString(PostLookup.JSON_NODEREF)) != null) {
                                siteId = PostLookup.this.lookupSite(new NodeRef(nodeRefStr));
                                activityPost.setSiteNetwork(siteId);
                            }
                        }
                        if (joLookup != null) {
                            activityPost.setActivityData(joLookup.toString());
                        }
                        if (activityPost.getActivityData() != null && activityPost.getActivityData().length() > 1024) {
                            throw new IllegalArgumentException("Invalid activity data - exceeds 1024 chars: " + activityPost.getActivityData());
                        }
                        if (activityPost.getSiteNetwork() != null && activityPost.getSiteNetwork().length() > 255) {
                            throw new IllegalArgumentException("Invalid siteId - exceeds 255 chars: " + activityPost.getSiteNetwork());
                        }
                        activityPost.setLastModified(new Date());
                        return null;
                    }
                }, tenantDomain);
            }
            catch (Exception e) {
                logger.error((Object)("Skipping activity post " + activityPost.getId() + ": " + e));
                activityPost.setStatus(ActivityPostEntity.STATUS.ERROR.toString());
            }
        }
        return activityPosts;
    }

    private List<ActivityPostEntity> rollupPosts(List<ActivityPostEntity> activityPosts) throws SQLException {
        HashMap<UserRollupActivity, ArrayList<ActivityPostEntity>> rollupPosts = new HashMap<UserRollupActivity, ArrayList<ActivityPostEntity>>();
        ArrayList<ActivityPostEntity> result = new ArrayList<ActivityPostEntity>(activityPosts.size());
        for (ActivityPostEntity activityPostEntity : activityPosts) {
            if (rollupTypes.containsKey(activityPostEntity.getActivityType()) && activityPostEntity.getParentNodeRef() != null) {
                UserRollupActivity key = new UserRollupActivity(activityPostEntity.getUserId(), activityPostEntity.getActivityType(), activityPostEntity.getParentNodeRef());
                ArrayList<ActivityPostEntity> posts = (ArrayList<ActivityPostEntity>)rollupPosts.get(key);
                if (posts == null) {
                    posts = new ArrayList<ActivityPostEntity>();
                    rollupPosts.put(key, posts);
                }
                posts.add(activityPostEntity);
                continue;
            }
            result.add(activityPostEntity);
        }
        for (final Map.Entry entry : rollupPosts.entrySet()) {
            final int count = ((List)entry.getValue()).size();
            if (count >= this.rollupCount) {
                final ActivityPostEntity oldPost = (ActivityPostEntity)((List)entry.getValue()).get(0);
                final String tenantDomain = oldPost.getTenantDomain();
                TenantUtil.runAsSystemTenant(new TenantUtil.TenantRunAsWork<Void>(){

                    @Override
                    public Void doWork() throws Exception {
                        String postUserId = oldPost.getUserId();
                        ActivityPostEntity newPost = new ActivityPostEntity();
                        newPost.setActivityType((String)rollupTypes.get(oldPost.getActivityType()));
                        newPost.setPostDate(oldPost.getPostDate());
                        newPost.setUserId(postUserId);
                        newPost.setSiteNetwork(oldPost.getSiteNetwork());
                        newPost.setAppTool(oldPost.getAppTool());
                        newPost.setLastModified(oldPost.getLastModified());
                        newPost.setTenantDomain(tenantDomain);
                        newPost.setJobTaskNode(1);
                        try {
                            String displayPath;
                            Path path;
                            JSONObject jo = new JSONObject();
                            jo.put("parentNodeRef", (Object)oldPost.getParentNodeRef().toString());
                            jo.put(PostLookup.JSON_TENANT_DOMAIN, (Object)tenantDomain);
                            jo.put(PostLookup.JSON_TITLE, (Object)("" + count));
                            Pair firstLastName = PostLookup.this.lookupPerson(postUserId);
                            if (firstLastName != null) {
                                jo.put(PostLookup.JSON_FIRSTNAME, firstLastName.getFirst());
                                jo.put(PostLookup.JSON_LASTNAME, firstLastName.getSecond());
                            }
                            if ((path = PostLookup.this.nodeService.getPath(oldPost.getParentNodeRef())) != null && (displayPath = PathUtil.getDisplayPath(path, true)) != null) {
                                String prefix = "/company_home/sites/" + PostLookup.this.tenantService.getBaseName(oldPost.getSiteNetwork()) + "/documentLibrary";
                                int idx = displayPath.indexOf(prefix);
                                if (idx == 0) {
                                    displayPath = displayPath.substring(prefix.length());
                                }
                                jo.put(PostLookup.JSON_PAGE, (Object)("documentlibrary?path=" + displayPath));
                            }
                            newPost.setActivityData(jo.toString());
                            newPost.setStatus(ActivityPostEntity.STATUS.POSTED.toString());
                        }
                        catch (JSONException e) {
                            logger.warn((Object)("Unable to create activity data: " + (Object)((Object)e)));
                            newPost.setStatus(ActivityPostEntity.STATUS.ERROR.toString());
                        }
                        for (ActivityPostEntity post : (List)entry.getValue()) {
                            post.setStatus(ActivityPostEntity.STATUS.PROCESSED.toString());
                        }
                        ((List)entry.getValue()).add(newPost);
                        return null;
                    }
                }, tenantDomain);
            }
            result.addAll((Collection)entry.getValue());
        }
        return result;
    }

    private void updatePosts(List<ActivityPostEntity> activityPosts) throws SQLException {
        for (final ActivityPostEntity activityPost : activityPosts) {
            String tenantDomain = activityPost.getTenantDomain();
            TenantUtil.runAsSystemTenant(new TenantUtil.TenantRunAsWork<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object doWork() throws Exception {
                    try {
                        PostLookup.this.postDAO.startTransaction();
                        ActivityPostEntity.STATUS status = ActivityPostEntity.STATUS.valueOf(activityPost.getStatus());
                        switch (status) {
                            case ERROR: 
                            case PROCESSED: {
                                PostLookup.this.postDAO.updatePostStatus(activityPost.getId(), status);
                                break;
                            }
                            case POSTED: {
                                if (activityPost.getId() != null) break;
                                PostLookup.this.postDAO.insertPost(activityPost);
                                break;
                            }
                            case PENDING: {
                                PostLookup.this.postDAO.updatePost(activityPost.getId(), activityPost.getSiteNetwork(), activityPost.getActivityData(), ActivityPostEntity.STATUS.POSTED);
                                activityPost.setStatus(ActivityPostEntity.STATUS.POSTED.toString());
                                break;
                            }
                            default: {
                                throw new Exception("Unexpected status: " + (Object)((Object)status));
                            }
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Updated: " + activityPost));
                        }
                        PostLookup.this.postDAO.commitTransaction();
                    }
                    catch (SQLException e) {
                        logger.error((Object)"Exception during update of post", (Throwable)e);
                        throw new JobExecutionException((Throwable)e);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Skipping activity post " + activityPost.getId() + ": " + e));
                        PostLookup.this.postDAO.updatePostStatus(activityPost.getId(), ActivityPostEntity.STATUS.ERROR);
                        PostLookup.this.postDAO.commitTransaction();
                    }
                    finally {
                        PostLookup.this.postDAO.endTransaction();
                    }
                    return null;
                }
            }, tenantDomain);
        }
    }

    private Pair<String, String> lookupPerson(String postUserId) throws JSONException {
        Pair result = null;
        if (this.personService.personExists(postUserId)) {
            NodeRef personRef = this.personService.getPerson(postUserId);
            String firstName = (String)((Object)this.nodeService.getProperty(personRef, ContentModel.PROP_FIRSTNAME));
            String lastName = (String)((Object)this.nodeService.getProperty(personRef, ContentModel.PROP_LASTNAME));
            result = new Pair((Object)firstName, (Object)lastName);
        }
        return result;
    }

    private NodeRef lookupParentNodeRef(NodeRef nodeRef) throws JSONException {
        return this.nodeService.getPrimaryParent(nodeRef).getParentRef();
    }

    private String lookupSite(NodeRef nodeRef) throws JSONException {
        SiteInfo siteInfo = this.siteService.getSite(nodeRef);
        return siteInfo != null ? siteInfo.getShortName() : null;
    }

    private JSONObject lookupNode(NodeRef nodeRef, String postUserId, JSONObject jo) throws JSONException {
        String name = "";
        if (!jo.isNull(JSON_NAME)) {
            name = jo.getString(JSON_NAME);
        }
        NodeRef parentNodeRef = null;
        if (!jo.isNull("parentNodeRef")) {
            parentNodeRef = new NodeRef(jo.getString("parentNodeRef"));
        }
        String typeQName = "";
        if (!jo.isNull(JSON_TYPEQNAME)) {
            typeQName = jo.getString(JSON_TYPEQNAME);
        }
        String displayPath = "";
        Path path = null;
        String firstName = "";
        String lastName = "";
        if (this.personService.personExists(postUserId)) {
            NodeRef personRef = this.personService.getPerson(postUserId);
            firstName = (String)((Object)this.nodeService.getProperty(personRef, ContentModel.PROP_FIRSTNAME));
            lastName = (String)((Object)this.nodeService.getProperty(personRef, ContentModel.PROP_LASTNAME));
        }
        if (nodeRef != null && this.nodeService.exists(nodeRef)) {
            if (name.length() == 0) {
                name = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
            }
            if (typeQName.length() == 0) {
                typeQName = this.nodeService.getType(nodeRef).toPrefixString();
            }
            if (parentNodeRef == null) {
                parentNodeRef = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
            }
        }
        if (parentNodeRef != null && this.nodeService.exists(parentNodeRef)) {
            path = this.nodeService.getPath(parentNodeRef);
        }
        if (path != null) {
            displayPath = path.toDisplayPath(this.nodeService, this.permissionService);
            displayPath = displayPath + "/" + name;
        }
        jo.put(JSON_NAME, (Object)name);
        jo.put(JSON_NODEREF, (Object)nodeRef.toString());
        jo.put(JSON_TYPEQNAME, (Object)typeQName);
        jo.put("parentNodeRef", (Object)(parentNodeRef != null ? parentNodeRef.toString() : null));
        jo.put(JSON_DISPLAY_PATH, (Object)displayPath);
        jo.put(JSON_FIRSTNAME, (Object)firstName);
        jo.put(JSON_LASTNAME, (Object)lastName);
        return jo;
    }

    private class UserRollupActivity {
        private String userId;
        private String activityType;
        private NodeRef parentNodeRef;

        public UserRollupActivity(String userId, String activityType, NodeRef parentNodeRef) {
            this.userId = userId;
            this.activityType = activityType;
            this.parentNodeRef = parentNodeRef;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
            result = 31 * result + (this.activityType == null ? 0 : this.activityType.hashCode());
            result = 31 * result + (this.parentNodeRef == null ? 0 : this.parentNodeRef.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof UserRollupActivity)) {
                return false;
            }
            UserRollupActivity that = (UserRollupActivity)obj;
            return this.userId.equals(that.userId) && this.activityType.equals(that.activityType) && this.parentNodeRef.equals((Object)that.parentNodeRef);
        }
    }
}

