/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.admin.IndexConfigurationChecker;
import org.alfresco.repo.node.index.FullIndexRecoveryComponent;
import org.alfresco.repo.search.AVMSnapShotTriggeredIndexingMethodInterceptor;
import org.alfresco.repo.search.IndexMode;
import org.alfresco.service.cmr.repository.InvalidStoreRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class IndexConfigurationCheckerImpl
implements IndexConfigurationChecker {
    private static Log logger = LogFactory.getLog(IndexConfigurationCheckerImpl.class);
    private static final String ERR_DUPLICATE_ROOT_NODE = "system.config_check.err.indexes.duplicate_root_node";
    private FullIndexRecoveryComponent.RecoveryMode indexRecoveryMode;
    private NodeService nodeService;
    private SearchService searchService;
    private AVMSnapShotTriggeredIndexingMethodInterceptor avmSnapShotTriggeredIndexingMethodInterceptor;

    public void setIndexRecoveryMode(FullIndexRecoveryComponent.RecoveryMode indexRecoveryMode) {
        this.indexRecoveryMode = indexRecoveryMode;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setAvmSnapShotTriggeredIndexingMethodInterceptor(AVMSnapShotTriggeredIndexingMethodInterceptor avmSnapShotTriggeredIndexingMethodInterceptor) {
        this.avmSnapShotTriggeredIndexingMethodInterceptor = avmSnapShotTriggeredIndexingMethodInterceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StoreRef> checkIndexConfiguration() {
        List storeRefs = this.nodeService.getStores();
        ArrayList<StoreRef> missingIndexStoreRefs = new ArrayList<StoreRef>(0);
        for (StoreRef storeRef : storeRefs) {
            NodeRef rootNodeRef = null;
            try {
                rootNodeRef = this.nodeService.getRootNode(storeRef);
            }
            catch (InvalidStoreRefException e) {
                continue;
            }
            if (this.indexRecoveryMode == FullIndexRecoveryComponent.RecoveryMode.FULL) continue;
            if (storeRef.getProtocol().equals("avm")) {
                if (this.avmSnapShotTriggeredIndexingMethodInterceptor.isIndexingEnabled()) {
                    IndexMode storeIndexMode = this.avmSnapShotTriggeredIndexingMethodInterceptor.getIndexMode(storeRef.getIdentifier());
                    if (storeIndexMode.equals((Object)IndexMode.UNINDEXED)) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Skipping index check for store: " + storeRef + " (unindexed AVM store)"));
                        continue;
                    }
                } else {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Skipping index check for store: " + storeRef + " (AVM indexing is disabled)"));
                    continue;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Checking index for store: " + storeRef));
            }
            SearchParameters sp = new SearchParameters();
            sp.addStore(storeRef);
            sp.setLanguage("lucene");
            sp.setQuery("ISROOT:T");
            ResultSet results = null;
            int size = 0;
            try {
                results = this.searchService.query(sp);
                size = results.length();
            }
            finally {
                try {
                    results.close();
                }
                catch (Throwable e) {}
            }
            if (size == 0) {
                missingIndexStoreRefs.add(storeRef);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Index missing for store: \n   store: " + storeRef));
                continue;
            }
            if (size <= 1) continue;
            String msg = I18NUtil.getMessage((String)ERR_DUPLICATE_ROOT_NODE, (Object[])new Object[]{storeRef});
            throw new AlfrescoRuntimeException(msg);
        }
        return missingIndexStoreRefs;
    }
}

