/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.alfresco.email.server.AliasableAspect;
import org.alfresco.email.server.EmailServerModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.batch.BatchProcessWorkProvider;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.service.cmr.attributes.AttributeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AliasableAspectPatch
extends AbstractPatch {
    private static final String MSG_SUCCESS = "patch.emailAliasableAspect.result";
    private AttributeService attributeService;
    private NodeDAO nodeDAO;
    private PatchDAO patchDAO;
    private QNameDAO qnameDAO;
    private BehaviourFilter behaviourFilter;
    private final int batchThreads = 3;
    private final int batchSize = 40;
    private final long count = 120L;
    private static Log logger = LogFactory.getLog(AliasableAspectPatch.class);

    @Override
    protected String applyInternal() throws Exception {
        BatchProcessWorkProvider<NodeRef> workProvider = new BatchProcessWorkProvider<NodeRef>(){
            final List<NodeRef> result = new ArrayList<NodeRef>();
            Long aspectQNameId = 0L;
            long maxNodeId = AliasableAspectPatch.this.getPatchDAO().getMaxAdmNodeID();
            long minSearchNodeId = 1L;
            long maxSearchNodeId = 120L;
            Pair<Long, QName> val = AliasableAspectPatch.this.getQnameDAO().getQName(EmailServerModel.ASPECT_ALIASABLE);

            @Override
            public int getTotalEstimatedWorkSize() {
                return this.result.size();
            }

            @Override
            public Collection<NodeRef> getNextWork() {
                if (this.val != null) {
                    Long aspectQNameId = (Long)this.val.getFirst();
                    this.result.clear();
                    while (this.result.isEmpty() && this.minSearchNodeId < this.maxNodeId) {
                        List<Long> nodeids = AliasableAspectPatch.this.getPatchDAO().getNodesByAspectQNameId(aspectQNameId, this.minSearchNodeId, this.maxSearchNodeId);
                        for (Long nodeid : nodeids) {
                            NodeRef.Status status = AliasableAspectPatch.this.getNodeDAO().getNodeIdStatus(nodeid);
                            if (status.isDeleted()) continue;
                            this.result.add(status.getNodeRef());
                        }
                        this.minSearchNodeId += 120L;
                        this.maxSearchNodeId += 120L;
                    }
                }
                return this.result;
            }
        };
        BatchProcessor<NodeRef> batchProcessor = new BatchProcessor<NodeRef>("AliasableAspectPatch", this.transactionService.getRetryingTransactionHelper(), workProvider, 3, 40, this.applicationEventPublisher, logger, 1000);
        BatchProcessor.BatchProcessWorker<NodeRef> worker = new BatchProcessor.BatchProcessWorker<NodeRef>(){

            @Override
            public void afterProcess() throws Throwable {
            }

            @Override
            public void beforeProcess() throws Throwable {
            }

            @Override
            public String getIdentifier(NodeRef entry) {
                return entry.toString();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void process(NodeRef entry) throws Throwable {
                String alias = (String)((Object)AliasableAspectPatch.this.nodeService.getProperty(entry, EmailServerModel.PROP_ALIAS));
                if (alias != null) {
                    NodeRef existing = (NodeRef)AliasableAspectPatch.this.getAttributeService().getAttribute(new Serializable[]{"AliasableAspect", "Alias", AliasableAspect.normaliseAlias(alias)});
                    if (existing != null) {
                        if (!existing.equals((Object)entry)) {
                            if (logger.isWarnEnabled()) {
                                logger.warn((Object)("Email alias is not unique, alias:" + alias + " nodeRef:" + entry));
                            }
                            try {
                                AliasableAspectPatch.this.behaviourFilter.disableBehaviour(EmailServerModel.ASPECT_ALIASABLE);
                                AliasableAspectPatch.this.nodeService.removeAspect(entry, EmailServerModel.ASPECT_ALIASABLE);
                            }
                            finally {
                                AliasableAspectPatch.this.behaviourFilter.enableBehaviour(EmailServerModel.ASPECT_ALIASABLE);
                            }
                        }
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("creating email alias attribute for " + alias));
                        }
                        AliasableAspectPatch.this.getAttributeService().createAttribute((Serializable)entry, new Serializable[]{"AliasableAspect", "Alias", AliasableAspect.normaliseAlias(alias)});
                    }
                }
            }
        };
        batchProcessor.process(worker, true);
        return MSG_SUCCESS;
    }

    public void setAttributeService(AttributeService attributeService) {
        this.attributeService = attributeService;
    }

    public AttributeService getAttributeService() {
        return this.attributeService;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public NodeDAO getNodeDAO() {
        return this.nodeDAO;
    }

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    public PatchDAO getPatchDAO() {
        return this.patchDAO;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public QNameDAO getQnameDAO() {
        return this.qnameDAO;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public BehaviourFilter getBehaviourFilter() {
        return this.behaviourFilter;
    }
}

