/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.List;
import java.util.Set;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.site.SiteServiceImpl;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.surf.util.I18NUtil;

public class SitePermissionRefactorPatch
extends AbstractPatch {
    private static final String STATUS_MSG = "patch.sitePermissionRefactorPatch.result";
    private SiteService siteService;
    private PermissionService permissionService;
    private AuthorityService authorityService;

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    @Override
    protected String applyInternal() throws Exception {
        if (AuthenticationUtil.isRunAsUserTheSystemUser() || !AuthenticationUtil.isMtEnabled()) {
            List<SiteInfo> sites = this.siteService.listSites(null, null);
            for (SiteInfo siteInfo : sites) {
                String siteGroup = this.authorityService.createAuthority(AuthorityType.GROUP, ((SiteServiceImpl)this.siteService).getSiteGroup(siteInfo.getShortName(), false));
                QName siteType = this.nodeService.getType(siteInfo.getNodeRef());
                Set permissions = this.permissionService.getSettablePermissions(siteType);
                for (String permission : permissions) {
                    String permissionGroup = this.authorityService.createAuthority(AuthorityType.GROUP, ((SiteServiceImpl)this.siteService).getSiteRoleGroup(siteInfo.getShortName(), permission, false));
                    this.authorityService.addAuthority(siteGroup, permissionGroup);
                    this.permissionService.setPermission(siteInfo.getNodeRef(), permissionGroup, permission, true);
                }
                Set currentPermissions = this.permissionService.getAllSetPermissions(siteInfo.getNodeRef());
                for (AccessPermission permission : currentPermissions) {
                    if (permission.getAuthorityType() != AuthorityType.USER) continue;
                    String group = ((SiteServiceImpl)this.siteService).getSiteRoleGroup(siteInfo.getShortName(), permission.getPermission(), true);
                    this.authorityService.addAuthority(group, permission.getAuthority());
                    this.permissionService.deletePermission(siteInfo.getNodeRef(), permission.getAuthority(), permission.getPermission());
                }
            }
        }
        return I18NUtil.getMessage((String)STATUS_MSG);
    }
}

