/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.util.List;
import java.util.SortedMap;
import javax.transaction.UserTransaction;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.avm.AVMServiceTestBase;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avmsync.AVMDifference;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;

public class AVMServiceConcurrentTest
extends AVMServiceTestBase {
    @Override
    public void testSetup() throws Exception {
        super.testSetup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_CreateDelete() throws Exception {
        int threads = 4;
        int loops = 10;
        int snapshotsPerLoop = 4;
        AVMServiceConcurrentTest.assertEquals((int)1, (int)fService.getStoreVersions("main").size());
        fService.createDirectory("main:/", "test");
        int startVersion = fService.createSnapshot("main", null, null).get("main");
        AVMServiceConcurrentTest.assertEquals((int)2, (int)fService.getStoreVersions("main").size());
        AVMServiceConcurrentTest.assertEquals((int)0, (int)fService.getDirectoryListing(-1, "main:/test").size());
        UserTransaction testTX = fTransactionService.getUserTransaction();
        testTX.begin();
        StoreRef storeRef = AVMNodeConverter.ToStoreRef("main");
        SearchService searchService = fIndexerAndSearcher.getSearcher(AVMNodeConverter.ToStoreRef("main"), true);
        ResultSet results = searchService.query(storeRef, "lucene", "PATH:\"/test/*\"");
        AVMServiceConcurrentTest.assertEquals((int)0, (int)results.length());
        results.close();
        testTX.commit();
        Thread runner = null;
        for (int i = 0; i < threads; ++i) {
            runner = new Nester("Concurrent-" + i, runner, false, snapshotsPerLoop, Nester.Mode.CREATE, loops);
        }
        if (runner != null) {
            runner.start();
            try {
                runner.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Snapshot count: " + fService.getStoreVersions("main").size());
        SortedMap<String, AVMNodeDescriptor> listing = fService.getDirectoryListing(-1, "main:/test");
        AVMServiceConcurrentTest.assertEquals((int)loops, (int)listing.size());
        for (AVMNodeDescriptor node : listing.values()) {
            System.out.println("Listed: " + node.getPath() + " " + node.getVersionID());
        }
        List<AVMDifference> diffs = fSyncService.compare(startVersion, "main:/", -1, "main:/", null);
        AVMServiceConcurrentTest.assertEquals((int)loops, (int)diffs.size());
        for (AVMDifference diff : diffs) {
            AVMNodeDescriptor desc = fService.lookup(diff.getDestinationVersion(), diff.getDestinationPath(), true);
            AVMServiceConcurrentTest.assertFalse((boolean)desc.isDeleted());
        }
        testTX = fTransactionService.getUserTransaction();
        testTX.begin();
        try {
            searchService = fIndexerAndSearcher.getSearcher(AVMNodeConverter.ToStoreRef("main"), true);
            results = searchService.query(storeRef, "lucene", "PATH:\"/test/*\"");
            for (ResultSetRow row : results) {
                System.out.println("Found: " + row.getNodeRef());
            }
            AVMServiceConcurrentTest.assertEquals((int)loops, (int)results.length());
            results.close();
        }
        finally {
            try {
                testTX.commit();
            }
            catch (Exception e) {}
        }
        runner = null;
        for (int i = 0; i < threads; ++i) {
            runner = new Nester("Concurrent-" + i, runner, false, snapshotsPerLoop, Nester.Mode.DELETE, loops);
        }
        if (runner != null) {
            runner.start();
            try {
                runner.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        AVMServiceConcurrentTest.assertEquals((int)0, (int)fService.getDirectoryListing(-1, "main:/test").size());
        System.out.println("Snapshot count: " + fService.getStoreVersions("main").size());
        testTX = fTransactionService.getUserTransaction();
        testTX.begin();
        searchService = fIndexerAndSearcher.getSearcher(AVMNodeConverter.ToStoreRef("main"), true);
        results = searchService.query(storeRef, "lucene", "PATH:\"/test/*\"");
        for (ResultSetRow row : results) {
            System.out.println("Found: " + row.getNodeRef());
        }
        AVMServiceConcurrentTest.assertEquals((int)0, (int)results.length());
        results.close();
        testTX.commit();
    }

    public synchronized void test_ALF_14979() throws Exception {
        String name = "test" + System.currentTimeMillis();
        fService.createDirectory("main:/", name);
        int peerCount = 1000;
        for (int i = 0; i < peerCount; ++i) {
            fService.createDirectory("main:/", name + "-" + i);
        }
        StoreRef storeRef = AVMNodeConverter.ToStoreRef("main");
        NodeService fNodeService = (NodeService)fContext.getBean("NodeService");
        NodeRef rootNodeRef = fNodeService.getRootNode(storeRef);
        SearchService fSearchService = (SearchService)fContext.getBean("SearchService");
        NamespaceService fNamespaceService = (NamespaceService)fContext.getBean("NamespaceService");
        long before = System.nanoTime();
        List nodeRefs = fSearchService.selectNodes(rootNodeRef, "/cm:" + name, null, (NamespacePrefixResolver)fNamespaceService, false);
        AVMServiceConcurrentTest.assertEquals((String)"Expected to find a result", (int)1, (int)nodeRefs.size());
        long after = System.nanoTime();
        System.out.println("Took " + (double)(after - before) / 1000000.0 + "ms to find entry out of " + peerCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_ALF_786() throws Exception {
        int threads = 4;
        int loops = 10;
        int snapshotsPerLoop = 4;
        fService.createDirectory("main:/", "test");
        int startVersion = fService.createSnapshot("main", null, null).get("main");
        AVMServiceConcurrentTest.assertEquals((int)0, (int)fService.getDirectoryListing(-1, "main:/test").size());
        UserTransaction testTX = fTransactionService.getUserTransaction();
        testTX.begin();
        StoreRef storeRef = AVMNodeConverter.ToStoreRef("main");
        SearchService searchService = fIndexerAndSearcher.getSearcher(AVMNodeConverter.ToStoreRef("main"), true);
        ResultSet results = searchService.query(storeRef, "lucene", "PATH:\"/test/*\"");
        AVMServiceConcurrentTest.assertEquals((int)0, (int)results.length());
        results.close();
        testTX.commit();
        Thread runner = null;
        for (int i = 0; i < threads; ++i) {
            runner = new Nester("Concurrent-" + i, runner, false, snapshotsPerLoop, Nester.Mode.CREATE, loops);
        }
        if (runner != null) {
            runner.start();
            try {
                runner.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        SortedMap<String, AVMNodeDescriptor> listing = fService.getDirectoryListing(-1, "main:/test");
        AVMServiceConcurrentTest.assertEquals((int)loops, (int)listing.size());
        for (AVMNodeDescriptor node : listing.values()) {
            System.out.println("Listed: " + node.getPath() + " " + node.getVersionID());
        }
        List<AVMDifference> diffs = fSyncService.compare(startVersion, "main:/", -1, "main:/", null);
        AVMServiceConcurrentTest.assertEquals((int)loops, (int)diffs.size());
        for (AVMDifference diff : diffs) {
            AVMNodeDescriptor desc = fService.lookup(diff.getDestinationVersion(), diff.getDestinationPath(), true);
            AVMServiceConcurrentTest.assertFalse((boolean)desc.isDeleted());
        }
        testTX = fTransactionService.getUserTransaction();
        testTX.begin();
        try {
            searchService = fIndexerAndSearcher.getSearcher(AVMNodeConverter.ToStoreRef("main"), true);
            results = searchService.query(storeRef, "lucene", "PATH:\"/test/*\"");
            for (ResultSetRow row : results) {
                System.out.println("Found: " + row.getNodeRef());
            }
            AVMServiceConcurrentTest.assertEquals((int)loops, (int)results.length());
            results.close();
        }
        finally {
            try {
                testTX.commit();
            }
            catch (Exception e) {}
        }
        runner = null;
        for (int i = 0; i < threads; ++i) {
            runner = new Nester("Concurrent-" + i, runner, false, snapshotsPerLoop, Nester.Mode.UPDATE, loops);
        }
        if (runner != null) {
            runner.start();
            try {
                runner.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        testTX = fTransactionService.getUserTransaction();
        testTX.begin();
        searchService = fIndexerAndSearcher.getSearcher(AVMNodeConverter.ToStoreRef("main"), true);
        results = searchService.query(storeRef, "lucene", "PATH:\"/test/*\"");
        for (ResultSetRow row : results) {
            System.out.println("Found: " + row.getNodeRef());
        }
        AVMServiceConcurrentTest.assertEquals((int)loops, (int)results.length());
        results.close();
        testTX.commit();
        runner = null;
        for (int i = 0; i < threads; ++i) {
            runner = new Nester("Concurrent-" + i, runner, false, snapshotsPerLoop, Nester.Mode.DELETE, loops);
        }
        if (runner != null) {
            runner.start();
            try {
                runner.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        AVMServiceConcurrentTest.assertEquals((int)0, (int)fService.getDirectoryListing(-1, "main:/test").size());
        testTX = fTransactionService.getUserTransaction();
        testTX.begin();
        searchService = fIndexerAndSearcher.getSearcher(AVMNodeConverter.ToStoreRef("main"), true);
        results = searchService.query(storeRef, "lucene", "PATH:\"/test/*\"");
        for (ResultSetRow row : results) {
            System.out.println("Found: " + row.getNodeRef());
        }
        AVMServiceConcurrentTest.assertEquals((int)0, (int)results.length());
        results.close();
        testTX.commit();
        runner = null;
        for (int i = 0; i < threads; ++i) {
            runner = new Nester("Concurrent-" + i, runner, false, snapshotsPerLoop, Nester.Mode.CREATE, loops);
        }
        if (runner != null) {
            runner.start();
            try {
                runner.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        testTX = fTransactionService.getUserTransaction();
        testTX.begin();
        searchService = fIndexerAndSearcher.getSearcher(AVMNodeConverter.ToStoreRef("main"), true);
        results = searchService.query(storeRef, "lucene", "PATH:\"/test/*\"");
        for (ResultSetRow row : results) {
            System.out.println("Found: " + row.getNodeRef());
        }
        AVMServiceConcurrentTest.assertEquals((int)loops, (int)results.length());
        results.close();
        testTX.commit();
        runner = null;
        for (int i = 0; i < threads; ++i) {
            runner = new Nester("Concurrent-" + i, runner, false, snapshotsPerLoop, Nester.Mode.MOVE, loops);
        }
        if (runner != null) {
            runner.start();
            try {
                runner.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        testTX = fTransactionService.getUserTransaction();
        testTX.begin();
        searchService = fIndexerAndSearcher.getSearcher(AVMNodeConverter.ToStoreRef("main"), true);
        results = searchService.query(storeRef, "lucene", "PATH:\"/test/*\"");
        for (ResultSetRow row : results) {
            System.out.println("Found: " + row.getNodeRef());
        }
        AVMServiceConcurrentTest.assertEquals((int)loops, (int)results.length());
        results.close();
        testTX.commit();
    }

    public void xtest_ALF_786_PLUS() throws Exception {
        UserTransaction testTX = fTransactionService.getUserTransaction();
        testTX.begin();
        fService.createDirectory("main:/", "test");
        int startVersion = fService.createSnapshot("main", null, null).get("main");
        testTX.commit();
        testTX = fTransactionService.getUserTransaction();
        testTX.begin();
        StoreRef storeRef = AVMNodeConverter.ToStoreRef("main");
        SearchService searchService = fIndexerAndSearcher.getSearcher(AVMNodeConverter.ToStoreRef("main"), true);
        ResultSet results = searchService.query(storeRef, "lucene", "PATH:\"/test/*\"");
        AVMServiceConcurrentTest.assertEquals((int)0, (int)results.length());
        results.close();
        testTX.commit();
        Thread runner = null;
        for (int i = 0; i < 10; ++i) {
            runner = new Nester("Concurrent-" + i, runner, true, 10, Nester.Mode.CREATE, 10);
        }
        if (runner != null) {
            runner.start();
            try {
                runner.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        testTX = fTransactionService.getUserTransaction();
        testTX.begin();
        testTX.commit();
        testTX = fTransactionService.getUserTransaction();
        testTX.begin();
        SortedMap<String, AVMNodeDescriptor> listing = fService.getDirectoryListing(-1, "main:/test");
        AVMServiceConcurrentTest.assertEquals((int)100, (int)listing.size());
        for (AVMNodeDescriptor node : listing.values()) {
            System.out.println("Listed: " + node.getPath() + " " + node.getVersionID());
        }
        List<AVMDifference> diffs = fSyncService.compare(startVersion, "main:/", -1, "main:/", null);
        AVMServiceConcurrentTest.assertEquals((int)100, (int)diffs.size());
        for (AVMDifference diff : diffs) {
            AVMNodeDescriptor desc = fService.lookup(diff.getDestinationVersion(), diff.getDestinationPath(), true);
            AVMServiceConcurrentTest.assertFalse((boolean)desc.isDeleted());
        }
        searchService = fIndexerAndSearcher.getSearcher(AVMNodeConverter.ToStoreRef("main"), true);
        results = searchService.query(storeRef, "lucene", "PATH:\"/test/*\"");
        for (ResultSetRow row : results) {
            System.out.println("Found: " + row.getNodeRef());
        }
        AVMServiceConcurrentTest.assertEquals((int)100, (int)results.length());
        results.close();
        testTX.commit();
    }

    static class Nester
    extends Thread {
        Thread waiter;
        int i;
        boolean multiThread;
        int snapshotCount;
        Mode mode;
        int loopCount;

        Nester(String name, Thread waiter, boolean multiThread, int snapshotCount, Mode mode, int loopCount) {
            super(name);
            this.setDaemon(true);
            this.waiter = waiter;
            this.multiThread = multiThread;
            this.snapshotCount = snapshotCount;
            this.mode = mode;
            this.loopCount = loopCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AVMServiceTestBase.fAuthenticationComponent.setSystemUserAsCurrentUser();
            if (this.waiter != null) {
                this.waiter.start();
            }
            try {
                this.i = 0;
                while (this.i < this.loopCount) {
                    RetryingTransactionHelper.RetryingTransactionCallback<Void> create = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        @Override
                        public Void execute() throws Throwable {
                            System.out.println("Create file: main:/test/" + Nester.this.getName() + "-" + Nester.this.i);
                            AVMServiceTestBase.fService.createFile("main:/test", Nester.this.getName() + "-" + Nester.this.i).close();
                            return null;
                        }
                    };
                    RetryingTransactionHelper.RetryingTransactionCallback<Void> update = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        @Override
                        public Void execute() throws Throwable {
                            System.out.println("Update file mime type: main:/test/" + Nester.this.getName() + "-" + Nester.this.i);
                            AVMServiceTestBase.fService.setMimeType("main:/test/" + Nester.this.getName() + "-" + Nester.this.i, "text/plain");
                            return null;
                        }
                    };
                    RetryingTransactionHelper.RetryingTransactionCallback<Void> delete = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        @Override
                        public Void execute() throws Throwable {
                            System.out.println("Remove file: main:/test/" + Nester.this.getName() + "-" + Nester.this.i);
                            AVMServiceTestBase.fService.removeNode("main:/test/" + Nester.this.getName() + "-" + Nester.this.i);
                            return null;
                        }
                    };
                    RetryingTransactionHelper.RetryingTransactionCallback<Void> move = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        @Override
                        public Void execute() throws Throwable {
                            System.out.println("Rename file: main:/test/" + Nester.this.getName() + "-" + Nester.this.i);
                            AVMServiceTestBase.fService.rename("main:/test/", Nester.this.getName() + "-" + Nester.this.i, "main:/test/", "MOVED-" + Nester.this.getName() + "-" + Nester.this.i);
                            return null;
                        }
                    };
                    if (this.multiThread || this.waiter == null) {
                        switch (this.mode) {
                            case CREATE: {
                                AVMServiceTestBase.fRetryingTransactionHelper.doInTransaction(create);
                                break;
                            }
                            case UPDATE: {
                                AVMServiceTestBase.fRetryingTransactionHelper.doInTransaction(update);
                                break;
                            }
                            case DELETE: {
                                AVMServiceTestBase.fRetryingTransactionHelper.doInTransaction(delete);
                                break;
                            }
                            case MOVE: {
                                AVMServiceTestBase.fRetryingTransactionHelper.doInTransaction(move);
                                break;
                            }
                        }
                    }
                    RetryingTransactionHelper.RetryingTransactionCallback<Void> snap = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        @Override
                        public Void execute() throws Throwable {
                            AVMServiceTestBase.fService.createSnapshot("main", null, null);
                            return null;
                        }
                    };
                    for (int s = 0; s < this.snapshotCount; ++s) {
                        AVMServiceTestBase.fRetryingTransactionHelper.doInTransaction(snap);
                    }
                    ++this.i;
                }
            }
            catch (Exception e) {
                System.out.println("End " + this.getName() + " with error " + e.getMessage());
                e.printStackTrace();
            }
            finally {
                AVMServiceTestBase.fAuthenticationComponent.clearCurrentSecurityContext();
            }
            if (this.waiter != null) {
                try {
                    this.waiter.join();
                    System.out.println("Waited for " + this.waiter.getName() + " by " + this.getName());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        static enum Mode {
            CREATE,
            UPDATE,
            DELETE,
            MOVE;

        }
    }
}

