/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.alfresco.repo.avm.AVMDAOs;
import org.alfresco.repo.avm.AVMNode;
import org.alfresco.repo.avm.AVMRepository;
import org.alfresco.repo.avm.AVMStore;
import org.alfresco.repo.avm.BasicAttributes;
import org.alfresco.repo.avm.ChildEntry;
import org.alfresco.repo.avm.ChildEntryImpl;
import org.alfresco.repo.avm.ChildKey;
import org.alfresco.repo.avm.DeletedNodeImpl;
import org.alfresco.repo.avm.DirectoryNode;
import org.alfresco.repo.avm.DirectoryNodeImpl;
import org.alfresco.repo.avm.LayeredDirectoryNode;
import org.alfresco.repo.avm.LayeredDirectoryNodeImpl;
import org.alfresco.repo.avm.Lookup;
import org.alfresco.repo.avm.PlainDirectoryNode;
import org.alfresco.repo.security.permissions.ACLCopyMode;
import org.alfresco.service.cmr.avm.AVMBadArgumentException;
import org.alfresco.service.cmr.avm.AVMExistsException;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMNotFoundException;
import org.alfresco.util.Pair;

public class PlainDirectoryNodeImpl
extends DirectoryNodeImpl
implements PlainDirectoryNode {
    static final long serialVersionUID = 9423813734583003L;

    public PlainDirectoryNodeImpl(AVMStore store) {
        super(store);
        this.setVersionID(1);
    }

    public PlainDirectoryNodeImpl() {
    }

    public PlainDirectoryNodeImpl(PlainDirectoryNode other, AVMStore store, Long parentAcl, ACLCopyMode mode) {
        super(store);
        this.setVersionID(other.getVersionID() + 1);
        this.copyACLs(other, parentAcl, mode);
        this.copyCreationAndOwnerBasicAttributes(other);
        AVMDAOs.Instance().fAVMNodeDAO.save(this);
        for (ChildEntry child : AVMDAOs.Instance().fChildEntryDAO.getByParent(other, null)) {
            ChildKey key = new ChildKey(this, child.getKey().getName());
            ChildEntryImpl newChild = new ChildEntryImpl(key, child.getChild());
            AVMDAOs.Instance().fChildEntryDAO.save(newChild);
        }
        this.copyProperties(other);
        this.copyAspects(other);
    }

    @Override
    public Map<String, AVMNode> getListing(Lookup lPath, boolean includeDeleted) {
        return this.getListing(lPath, null, includeDeleted);
    }

    @Override
    public Map<String, AVMNode> getListing(Lookup lPath, String childNamePattern, boolean includeDeleted) {
        HashMap<String, AVMNode> result = new HashMap<String, AVMNode>();
        List<ChildEntry> children = AVMDAOs.Instance().fChildEntryDAO.getByParent(this, childNamePattern);
        for (ChildEntry child : children) {
            if ((child.getChild().getType() == 3 || child.getChild().getType() == 2) && !AVMRepository.GetInstance().can(lPath.getAVMStore(), child.getChild(), "ReadChildren", lPath.getDirectlyContained()) || !includeDeleted && child.getChild().getType() == 4) continue;
            result.put(child.getKey().getName(), child.getChild());
        }
        return result;
    }

    @Override
    public Map<String, AVMNode> getListingDirect(Lookup lPath, boolean includeDeleted) {
        return this.getListing(lPath, includeDeleted);
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getListingDirect(AVMNodeDescriptor dir, boolean includeDeleted) {
        return this.getListing(dir, includeDeleted);
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getListing(AVMNodeDescriptor dir, boolean includeDeleted) {
        return this.getListing(dir, null, includeDeleted);
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getListing(AVMNodeDescriptor dir, String childNamePattern, boolean includeDeleted) {
        if (dir.getPath() == null) {
            throw new AVMBadArgumentException("Path is null.");
        }
        TreeMap<String, AVMNodeDescriptor> result = new TreeMap<String, AVMNodeDescriptor>(String.CASE_INSENSITIVE_ORDER);
        List<ChildEntry> children = AVMDAOs.Instance().fChildEntryDAO.getByParent(this, childNamePattern);
        for (ChildEntry child : children) {
            if ((child.getChild().getType() == 3 || child.getChild().getType() == 2) && !AVMRepository.GetInstance().can(null, child.getChild(), "ReadChildren", false) || !includeDeleted && child.getChild().getType() == 4) continue;
            result.put(child.getKey().getName(), child.getChild().getDescriptor(dir.getPath(), child.getKey().getName(), dir.getIndirection(), dir.getIndirectionVersion()));
        }
        return result;
    }

    @Override
    public List<String> getDeletedNames() {
        return new ArrayList<String>();
    }

    @Override
    public Pair<ChildEntry, Boolean> lookupChildEntry(Lookup lPath, String name, boolean includeDeleted) {
        ChildKey key = new ChildKey(this, name);
        ChildEntry entry = AVMDAOs.Instance().fChildEntryDAO.get(key);
        if (entry == null) {
            return null;
        }
        if (!includeDeleted && entry.getChild().getType() == 4) {
            return null;
        }
        Pair result = new Pair((Object)entry, (Object)true);
        return result;
    }

    @Override
    public AVMNodeDescriptor lookupChild(AVMNodeDescriptor mine, String name, boolean includeDeleted) {
        if (mine.getPath() == null) {
            throw new AVMBadArgumentException("Path is null.");
        }
        ChildKey key = new ChildKey(this, name);
        ChildEntry entry = AVMDAOs.Instance().fChildEntryDAO.get(key);
        if (entry == null || !includeDeleted && entry.getChild().getType() == 4) {
            return null;
        }
        AVMNodeDescriptor desc = entry.getChild().getDescriptor(mine.getPath(), name, null, -1);
        return desc;
    }

    @Override
    public void removeChild(Lookup lPath, String name) {
        ChildKey key;
        ChildEntry entry;
        if (DEBUG) {
            this.checkReadOnly();
        }
        if ((entry = AVMDAOs.Instance().fChildEntryDAO.get(key = new ChildKey(this, name))) != null) {
            AVMNode child = entry.getChild();
            if (child.getType() == 4) {
                return;
            }
            AVMDAOs.Instance().fChildEntryDAO.delete(entry);
            if (child.getStoreNew() == null || child.getAncestor() != null) {
                DeletedNodeImpl ghost = new DeletedNodeImpl(lPath.getAVMStore(), child.getAcl());
                AVMDAOs.Instance().fAVMNodeDAO.save(ghost);
                ghost.setAncestor(child);
                ghost.setDeletedType(child.getType());
                ghost.copyCreationAndOwnerBasicAttributes(child);
                ghost.copyAspects(child);
                ghost.copyProperties(child);
                AVMDAOs.Instance().fAVMNodeDAO.update(ghost);
                this.putChild(name, ghost);
            }
        }
    }

    @Override
    public void putChild(String name, AVMNode node) {
        ChildKey key;
        ChildEntry existing;
        if (DEBUG) {
            this.checkReadOnly();
        }
        if ((existing = AVMDAOs.Instance().fChildEntryDAO.get(key = new ChildKey(this, name))) != null) {
            AVMDAOs.Instance().fChildEntryDAO.delete(existing);
        }
        ChildEntryImpl entry = new ChildEntryImpl(key, node);
        AVMDAOs.Instance().fChildEntryDAO.save(entry);
    }

    @Override
    public AVMNode copy(Lookup lPath) {
        DirectoryNodeImpl newMe = null;
        DirectoryNode dir = lPath.getCurrentNodeDirectory();
        Long parentAclId = null;
        if (dir != null && dir.getAcl() != null) {
            parentAclId = dir.getAcl().getId();
        }
        if (lPath.isLayered()) {
            newMe = new LayeredDirectoryNodeImpl(this, lPath.getAVMStore(), lPath, lPath.isInThisLayer(), parentAclId, ACLCopyMode.COPY);
            ((LayeredDirectoryNodeImpl)newMe).setLayerID(lPath.getTopLayer().getLayerID());
            AVMDAOs.Instance().fAVMNodeDAO.update(newMe);
        } else {
            newMe = new PlainDirectoryNodeImpl(this, lPath.getAVMStore(), parentAclId, ACLCopyMode.COW);
        }
        newMe.setAncestor(this);
        return newMe;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public String toString(Lookup lPath) {
        return "[PD:" + this.getId() + "]";
    }

    @Override
    public void turnPrimary(Lookup lPath) {
        assert (false) : "Should never happen.";
    }

    @Override
    public void retarget(Lookup lPath, String target) {
        assert (false) : "Should never happen.";
    }

    @Override
    public AVMNodeDescriptor getDescriptor(Lookup lPath, String name) {
        BasicAttributes attrs = this.getBasicAttributes();
        String path = lPath.getRepresentedPath();
        path = path.endsWith("/") ? path + name : path + "/" + name;
        return new AVMNodeDescriptor(path, name, 2, attrs.getCreator(), attrs.getOwner(), attrs.getLastModifier(), attrs.getCreateDate(), attrs.getModDate(), attrs.getAccessDate(), this.getId(), this.getGuid(), this.getVersionID(), null, -1, false, -1L, false, -1L, -1);
    }

    @Override
    public AVMNodeDescriptor getDescriptor(Lookup lPath) {
        BasicAttributes attrs = this.getBasicAttributes();
        String path = lPath.getRepresentedPath();
        return new AVMNodeDescriptor(path, path.substring(path.lastIndexOf("/") + 1), 2, attrs.getCreator(), attrs.getOwner(), attrs.getLastModifier(), attrs.getCreateDate(), attrs.getModDate(), attrs.getAccessDate(), this.getId(), this.getGuid(), this.getVersionID(), null, -1, false, -1L, false, -1L, -1);
    }

    @Override
    public AVMNodeDescriptor getDescriptor(String parentPath, String name, String parentIndirection, int parentIndirectionVersion) {
        BasicAttributes attrs = this.getBasicAttributes();
        String path = parentPath.endsWith("/") ? parentPath + name : parentPath + "/" + name;
        return new AVMNodeDescriptor(path, name, 2, attrs.getCreator(), attrs.getOwner(), attrs.getLastModifier(), attrs.getCreateDate(), attrs.getModDate(), attrs.getAccessDate(), this.getId(), this.getGuid(), this.getVersionID(), null, -1, false, -1L, false, -1L, -1);
    }

    @Override
    public void link(Lookup lPath, String name, AVMNodeDescriptor toLink) {
        AVMNode node;
        if (DEBUG) {
            this.checkReadOnly();
        }
        if ((node = AVMDAOs.Instance().fAVMNodeDAO.getByID(toLink.getId())) == null) {
            throw new AVMNotFoundException("Node not found: " + toLink.getId());
        }
        if (node.getType() == 3 && !((LayeredDirectoryNode)node).getPrimaryIndirection()) {
            throw new AVMBadArgumentException("Non primary layered directories cannot be linked.");
        }
        ChildKey key = new ChildKey(this, name);
        ChildEntry child = AVMDAOs.Instance().fChildEntryDAO.get(key);
        if (child != null) {
            if (child.getChild().getType() != 4) {
                throw new AVMExistsException(name + " exists.");
            }
            AVMDAOs.Instance().fChildEntryDAO.delete(child);
        }
        ChildEntryImpl newChild = new ChildEntryImpl(key, node);
        AVMDAOs.Instance().fChildEntryDAO.save(newChild);
    }
}

