/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.avm.AVMDAOs;
import org.alfresco.repo.avm.AVMNode;
import org.alfresco.repo.avm.AVMStore;
import org.alfresco.repo.avm.BasicAttributes;
import org.alfresco.repo.avm.DirectoryNode;
import org.alfresco.repo.avm.FileNodeImpl;
import org.alfresco.repo.avm.Lookup;
import org.alfresco.repo.avm.PlainFileNode;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.domain.permissions.Acl;
import org.alfresco.repo.security.permissions.ACLCopyMode;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.namespace.QName;

public class PlainFileNodeImpl
extends FileNodeImpl
implements PlainFileNode {
    static final long serialVersionUID = 8720376837929735294L;
    private static final String PREFIX_CONTENT_DATA_ID = "id:";
    private static final String SUFFIX_CONTENT_DATA_NULL = "null";
    private String contentURL;
    private String mimeType;
    private String encoding;
    private long length;

    public PlainFileNodeImpl() {
    }

    public PlainFileNodeImpl(AVMStore store) {
        super(store);
        this.setVersionID(1);
    }

    public PlainFileNodeImpl(PlainFileNode other, AVMStore store, Long parentAcl, ACLCopyMode mode) {
        super(store);
        this.setContentData(other.getContentData(null));
        this.setVersionID(other.getVersionID() + 1);
        this.copyACLs(other, parentAcl, mode);
        this.copyCreationAndOwnerBasicAttributes(other);
        AVMDAOs.Instance().fAVMNodeDAO.save(this);
        this.copyProperties(other);
        this.copyAspects(other);
    }

    public PlainFileNodeImpl(AVMStore store, BasicAttributes attrs, ContentData content, Map<QName, PropertyValue> props, Set<QName> aspects, Acl acl, int versionID, Acl parentAcl, ACLCopyMode mode) {
        super(store);
        this.setContentData(content);
        this.setBasicAttributes(attrs);
        this.setVersionID(versionID + 1);
        this.copyACLs(acl, parentAcl, mode);
        AVMDAOs.Instance().fAVMNodeDAO.save(this);
        this.addProperties(props);
        this.setAspects(new HashSet<QName>(aspects));
    }

    @Override
    public AVMNode copy(Lookup lPath) {
        DirectoryNode dir = lPath.getCurrentNodeDirectory();
        Long parentAclId = null;
        if (dir != null && dir.getAcl() != null) {
            parentAclId = dir.getAcl().getId();
        }
        PlainFileNodeImpl newMe = new PlainFileNodeImpl(this, lPath.getAVMStore(), parentAclId, ACLCopyMode.COW);
        newMe.setAncestor(this);
        return newMe;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String toString(Lookup lPath) {
        return "[PF:" + this.getId() + "]";
    }

    @Override
    public AVMNodeDescriptor getDescriptor(Lookup lPath, String name) {
        BasicAttributes attrs = this.getBasicAttributes();
        String path = lPath.getRepresentedPath();
        path = path.endsWith("/") ? path + name : path + "/" + name;
        ContentData contentData = this.getContentData();
        return new AVMNodeDescriptor(path, name, 0, attrs.getCreator(), attrs.getOwner(), attrs.getLastModifier(), attrs.getCreateDate(), attrs.getModDate(), attrs.getAccessDate(), this.getId(), this.getGuid(), this.getVersionID(), null, -1, false, -1L, false, contentData == null ? 0L : contentData.getSize(), -1);
    }

    @Override
    public AVMNodeDescriptor getDescriptor(Lookup lPath) {
        BasicAttributes attrs = this.getBasicAttributes();
        String path = lPath.getRepresentedPath();
        ContentData contentData = this.getContentData();
        return new AVMNodeDescriptor(path, path.substring(path.lastIndexOf("/") + 1), 0, attrs.getCreator(), attrs.getOwner(), attrs.getLastModifier(), attrs.getCreateDate(), attrs.getModDate(), attrs.getAccessDate(), this.getId(), this.getGuid(), this.getVersionID(), null, -1, false, -1L, false, contentData == null ? 0L : contentData.getSize(), -1);
    }

    @Override
    public AVMNodeDescriptor getDescriptor(String parentPath, String name, String parentIndirection, int parentIndirectionVersion) {
        BasicAttributes attrs = this.getBasicAttributes();
        String path = parentPath.endsWith("/") ? parentPath + name : parentPath + "/" + name;
        ContentData contentData = this.getContentData();
        return new AVMNodeDescriptor(path, name, 0, attrs.getCreator(), attrs.getOwner(), attrs.getLastModifier(), attrs.getCreateDate(), attrs.getModDate(), attrs.getAccessDate(), this.getId(), this.getGuid(), this.getVersionID(), null, -1, false, -1L, false, contentData == null ? 0L : contentData.getSize(), -1);
    }

    @Override
    public String getContentURL() {
        return this.contentURL;
    }

    public void setContentURL(String contentURL) {
        this.contentURL = contentURL;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    @Override
    public void setContentData(ContentData contentData) {
        if (this.isLegacyContentData()) {
            this.contentURL = "id:null";
            this.encoding = null;
            this.length = 0L;
            this.mimeType = null;
        }
        Long oldContentDataId = this.getContentDataId();
        Long newContentDataId = null;
        if (oldContentDataId == null) {
            if (contentData != null) {
                newContentDataId = (Long)AVMDAOs.Instance().contentDataDAO.createContentData(contentData).getFirst();
            }
        } else if (contentData != null) {
            AVMDAOs.Instance().contentDataDAO.updateContentData(oldContentDataId, contentData);
            newContentDataId = oldContentDataId;
        } else {
            AVMDAOs.Instance().contentDataDAO.deleteContentData(oldContentDataId);
            newContentDataId = null;
        }
        this.contentURL = newContentDataId == null ? "id:null" : PREFIX_CONTENT_DATA_ID + newContentDataId;
    }

    @Override
    public ContentData getContentData(Lookup lPath) {
        return this.getContentData();
    }

    @Override
    public ContentData getContentData() {
        if (this.contentURL != null && this.contentURL.startsWith(PREFIX_CONTENT_DATA_ID)) {
            Long contentDataId = this.getContentDataId();
            try {
                if (contentDataId == null) {
                    return new ContentData(null, null, 0L, null);
                }
                return (ContentData)AVMDAOs.Instance().contentDataDAO.getContentData(contentDataId).getSecond();
            }
            catch (Throwable e) {
                throw new AlfrescoRuntimeException("AVM File node " + this.getId() + " has invalid ContentData id reference " + contentDataId, e);
            }
        }
        return new ContentData(this.contentURL, this.mimeType, this.length, this.encoding);
    }

    @Override
    public boolean isLegacyContentData() {
        return this.contentURL == null || !this.contentURL.startsWith(PREFIX_CONTENT_DATA_ID);
    }

    @Override
    public Long getContentDataId() {
        String idStr = this.contentURL.substring(3);
        if (idStr.equals(SUFFIX_CONTENT_DATA_NULL)) {
            return null;
        }
        try {
            return Long.parseLong(idStr);
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("AVM File node " + this.getId() + " has malformed ContentData id reference " + idStr, e);
        }
    }
}

