/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm.ibatis;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.avm.AVMDAOs;
import org.alfresco.repo.avm.AVMNode;
import org.alfresco.repo.avm.AVMNodeDAO;
import org.alfresco.repo.avm.AVMNodeImpl;
import org.alfresco.repo.avm.AVMStore;
import org.alfresco.repo.avm.BasicAttributesImpl;
import org.alfresco.repo.avm.DeletedNode;
import org.alfresco.repo.avm.DeletedNodeImpl;
import org.alfresco.repo.avm.DirectoryNode;
import org.alfresco.repo.avm.Layered;
import org.alfresco.repo.avm.LayeredDirectoryNode;
import org.alfresco.repo.avm.LayeredDirectoryNodeImpl;
import org.alfresco.repo.avm.LayeredFileNode;
import org.alfresco.repo.avm.LayeredFileNodeImpl;
import org.alfresco.repo.avm.PlainDirectoryNode;
import org.alfresco.repo.avm.PlainDirectoryNodeImpl;
import org.alfresco.repo.avm.PlainFileNode;
import org.alfresco.repo.avm.PlainFileNodeImpl;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.domain.avm.AVMHistoryLinkEntity;
import org.alfresco.repo.domain.avm.AVMMergeLinkEntity;
import org.alfresco.repo.domain.avm.AVMNodeEntity;
import org.alfresco.repo.domain.avm.AVMVersionRootEntity;
import org.alfresco.repo.domain.permissions.Acl;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class AVMNodeDAOIbatis
implements AVMNodeDAO {
    private static Log logger = LogFactory.getLog(AVMNodeDAO.class);

    AVMNodeDAOIbatis() {
    }

    @Override
    public void save(AVMNode node) {
        AVMNodeEntity nodeEntity = AVMDAOs.Instance().newAVMNodeDAO.createNode(this.convertNodeToNodeEntity(node));
        ((AVMNodeImpl)node).setId(nodeEntity.getId());
    }

    @Override
    public void delete(AVMNode node) {
        AVMDAOs.Instance().newAVMNodeDAO.deleteNode(node.getId());
    }

    @Override
    public void createAspect(long nodeId, QName aspectQName) {
        AVMDAOs.Instance().newAVMNodeDAO.createAspect(nodeId, aspectQName);
    }

    @Override
    public void deleteAspect(long nodeId, QName aspectQName) {
        AVMDAOs.Instance().newAVMNodeDAO.deleteAspect(nodeId, aspectQName);
    }

    @Override
    public void deleteAspects(long nodeId) {
        AVMDAOs.Instance().newAVMNodeDAO.deleteAspects(nodeId);
    }

    @Override
    public Set<QName> getAspects(long nodeId) {
        return AVMDAOs.Instance().newAVMNodeDAO.getAspects(nodeId);
    }

    @Override
    public void createOrUpdateProperty(long nodeId, QName qname, PropertyValue value) {
        AVMDAOs.Instance().newAVMNodeDAO.createOrUpdateNodeProperty(nodeId, qname, value);
    }

    @Override
    public void deleteProperty(long nodeId, QName propQName) {
        AVMDAOs.Instance().newAVMNodeDAO.deleteNodeProperty(nodeId, propQName);
    }

    @Override
    public void deleteProperties(long nodeId) {
        AVMDAOs.Instance().newAVMNodeDAO.deleteNodeProperties(nodeId);
    }

    @Override
    public Map<QName, PropertyValue> getProperties(long nodeId) {
        return AVMDAOs.Instance().newAVMNodeDAO.getNodeProperties(nodeId);
    }

    @Override
    public AVMNode getByID(long id) {
        return this.convertNodeEntityToNode(AVMDAOs.Instance().newAVMNodeDAO.getNode(id));
    }

    AVMNode getRootNodeByID(AVMStore store, long rootNodeId) {
        AVMNodeEntity rootNodeEntity = null;
        try {
            rootNodeEntity = AVMDAOs.Instance().newAVMNodeDAO.getNode(rootNodeId);
        }
        catch (RuntimeException re) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Root node (" + rootNodeId + ") not found for store: " + store));
            }
            throw re;
        }
        AVMNode rootNode = null;
        if (rootNodeEntity.getStoreNewId() != null) {
            rootNode = this.convertNodeEntityToNode(rootNodeEntity, false);
            rootNode.setStoreNew(store);
        } else {
            rootNode = this.convertNodeEntityToNode(rootNodeEntity);
        }
        return rootNode;
    }

    @Override
    public void update(AVMNode node) {
        AVMNodeEntity nodeEntity = this.convertNodeToNodeEntity(node);
        AVMDAOs.Instance().newAVMNodeDAO.updateNode(nodeEntity);
        ((AVMNodeImpl)node).setVers(nodeEntity.getVers());
    }

    @Override
    public void updateModTimeAndGuid(AVMNode node) {
        AVMNodeEntity nodeEntity = this.convertNodeToNodeEntity(node);
        AVMDAOs.Instance().newAVMNodeDAO.updateNodeModTimeAndGuid(nodeEntity);
        ((AVMNodeImpl)node).setVers(nodeEntity.getVers());
    }

    @Override
    public DirectoryNode getAVMStoreRoot(AVMStore store, int version) {
        AVMVersionRootEntity vrEntity = AVMDAOs.Instance().newAVMVersionRootDAO.getByVersionID(store.getId(), version);
        if (vrEntity == null) {
            return null;
        }
        return (DirectoryNode)this.getByID(vrEntity.getRootNodeId());
    }

    @Override
    public AVMNode getAncestor(AVMNode descendent) {
        AVMHistoryLinkEntity hlEntity = AVMDAOs.Instance().newAVMNodeLinksDAO.getHistoryLinkByDescendent(descendent.getId());
        if (hlEntity == null) {
            return null;
        }
        return AVMDAOs.Instance().fAVMNodeDAO.getByID(hlEntity.getAncestorNodeId());
    }

    @Override
    public AVMNode getMergedFrom(AVMNode mTo) {
        AVMMergeLinkEntity mlEntity = AVMDAOs.Instance().newAVMNodeLinksDAO.getMergeLinkByTo(mTo.getId());
        if (mlEntity == null) {
            return null;
        }
        return AVMDAOs.Instance().fAVMNodeDAO.getByID(mlEntity.getMergeFromNodeId());
    }

    @Override
    public List<AVMNode> getOrphans(int batchSize) {
        List<AVMNodeEntity> nodeEntities = AVMDAOs.Instance().newAVMNodeDAO.getNodeOrphans(batchSize);
        if (nodeEntities == null) {
            return new ArrayList<AVMNode>(0);
        }
        ArrayList<AVMNode> nodes = new ArrayList<AVMNode>(nodeEntities.size());
        for (AVMNodeEntity nodeEntity : nodeEntities) {
            nodes.add(this.convertNodeEntityToNode(nodeEntity));
        }
        return nodes;
    }

    @Override
    public List<AVMNode> getNewInStore(AVMStore store) {
        List<AVMNodeEntity> nodeEntities = AVMDAOs.Instance().newAVMNodeDAO.getNodesNewInStore(store.getId());
        if (nodeEntities == null) {
            return new ArrayList<AVMNode>(0);
        }
        ArrayList<AVMNode> nodes = new ArrayList<AVMNode>(nodeEntities.size());
        for (AVMNodeEntity nodeEntity : nodeEntities) {
            nodes.add(this.convertNodeEntityToNode(nodeEntity));
        }
        return nodes;
    }

    @Override
    public void clear() {
        AVMDAOs.Instance().newAVMNodeDAO.clearNodeEntityCache();
    }

    @Override
    public void clearNewInStore(AVMStore store) {
        AVMDAOs.Instance().newAVMNodeDAO.updateNodesClearNewInStore(store.getId());
    }

    @Override
    public List<Long> getNewLayeredInStoreIDs(AVMStore store) {
        return AVMDAOs.Instance().newAVMNodeDAO.getLayeredNodesNewInStoreIDs(store.getId());
    }

    @Override
    public List<Layered> getNewLayeredInStore(AVMStore store) {
        List<AVMNodeEntity> nodeEntities = AVMDAOs.Instance().newAVMNodeDAO.getLayeredNodesNewInStore(store.getId());
        if (nodeEntities == null) {
            return new ArrayList<Layered>(0);
        }
        ArrayList<Layered> nodes = new ArrayList<Layered>(nodeEntities.size());
        for (AVMNodeEntity nodeEntity : nodeEntities) {
            nodes.add((Layered)this.convertNodeEntityToNode(nodeEntity));
        }
        return nodes;
    }

    private AVMNodeEntity convertNodeToNodeEntity(AVMNode node) {
        AVMNodeEntity nodeEntity = new AVMNodeEntity();
        nodeEntity.setId(node.getId());
        nodeEntity.setAccessDate(node.getBasicAttributes().getAccessDate());
        nodeEntity.setOwner(node.getBasicAttributes().getOwner());
        nodeEntity.setCreator(node.getBasicAttributes().getCreator());
        nodeEntity.setCreatedDate(node.getBasicAttributes().getCreateDate());
        nodeEntity.setModifier(node.getBasicAttributes().getLastModifier());
        nodeEntity.setModifiedDate(node.getBasicAttributes().getModDate());
        nodeEntity.setType(node.getType());
        nodeEntity.setVersion(new Long(node.getVersionID()));
        nodeEntity.setVers(((AVMNodeImpl)node).getVers());
        nodeEntity.setAclId(node.getAcl() == null ? null : node.getAcl().getId());
        nodeEntity.setGuid(node.getGuid());
        nodeEntity.setStoreNewId(node.getStoreNew() == null ? null : Long.valueOf(node.getStoreNew().getId()));
        nodeEntity.setRoot(node.getIsRoot());
        if (node instanceof PlainFileNode) {
            PlainFileNode pfNode = (PlainFileNode)node;
            nodeEntity.setEncoding(pfNode.getEncoding());
            nodeEntity.setLength(pfNode.getLength());
            nodeEntity.setMimetype(pfNode.getMimeType());
            nodeEntity.setContentUrl(pfNode.getContentURL());
        } else if (node instanceof LayeredFileNode) {
            LayeredFileNode lfNode = (LayeredFileNode)node;
            nodeEntity.setIndirection(lfNode.getIndirection());
            nodeEntity.setIndirectionVersion(lfNode.getIndirectionVersion());
        } else if (!(node instanceof PlainDirectoryNode)) {
            if (node instanceof LayeredDirectoryNode) {
                LayeredDirectoryNode ldNode = (LayeredDirectoryNode)node;
                nodeEntity.setIndirection(ldNode.getIndirection());
                nodeEntity.setIndirectionVersion(ldNode.getIndirectionVersion());
                nodeEntity.setLayerId(ldNode.getLayerID());
                nodeEntity.setPrimaryIndirection(ldNode.getPrimaryIndirection());
                nodeEntity.setOpacity(ldNode.getOpacity());
            } else if (node instanceof DeletedNode) {
                DeletedNode dNode = (DeletedNode)node;
                nodeEntity.setDeletedType(dNode.getDeletedType());
            }
        }
        return nodeEntity;
    }

    private AVMNode convertNodeEntityToNode(AVMNodeEntity nodeEntity) {
        return this.convertNodeEntityToNode(nodeEntity, true);
    }

    private AVMNode convertNodeEntityToNode(AVMNodeEntity nodeEntity, boolean withStore) {
        if (nodeEntity == null) {
            return null;
        }
        AVMNodeImpl node = null;
        if (nodeEntity.getType() == 0) {
            node = new PlainFileNodeImpl();
            PlainFileNodeImpl pfNode = node;
            pfNode.setMimeType(nodeEntity.getMimetype());
            pfNode.setEncoding(nodeEntity.getEncoding());
            pfNode.setLength(nodeEntity.getLength());
            pfNode.setContentURL(nodeEntity.getContentUrl());
        } else if (nodeEntity.getType() == 2) {
            node = new PlainDirectoryNodeImpl();
        } else if (nodeEntity.getType() == 1) {
            node = new LayeredFileNodeImpl();
            ((LayeredFileNodeImpl)node).setIndirection(nodeEntity.getIndirection());
            ((LayeredFileNodeImpl)node).setIndirectionVersion(nodeEntity.getIndirectionVersion());
        } else if (nodeEntity.getType() == 3) {
            node = new LayeredDirectoryNodeImpl();
            ((LayeredDirectoryNodeImpl)node).setIndirection(nodeEntity.getIndirection());
            ((LayeredDirectoryNodeImpl)node).setIndirectionVersion(nodeEntity.getIndirectionVersion());
            ((LayeredDirectoryNodeImpl)node).setPrimaryIndirection(nodeEntity.isPrimaryIndirection());
            ((LayeredDirectoryNodeImpl)node).setLayerID(nodeEntity.getLayerId());
            ((LayeredDirectoryNodeImpl)node).setOpacity(nodeEntity.getOpacity());
        } else if (nodeEntity.getType() == 4) {
            node = new DeletedNodeImpl();
            ((DeletedNodeImpl)node).setDeletedType(nodeEntity.getDeletedType());
        } else {
            throw new AlfrescoRuntimeException("Unexpected node type: " + nodeEntity.getType());
        }
        node.setId(nodeEntity.getId());
        node.setIsRoot(nodeEntity.isRoot());
        node.setGuid(nodeEntity.getGuid());
        node.setVersionID(nodeEntity.getVersion().intValue());
        node.setVers(nodeEntity.getVers());
        BasicAttributesImpl ba = new BasicAttributesImpl();
        ba.setAccessDate(nodeEntity.getAccessDate());
        ba.setModDate(nodeEntity.getModifiedDate());
        ba.setCreateDate(nodeEntity.getCreatedDate());
        ba.setLastModifier(nodeEntity.getModifier());
        ba.setCreator(nodeEntity.getCreator());
        ba.setOwner(nodeEntity.getOwner());
        node.setBasicAttributes(ba);
        AVMStore store = null;
        if (withStore && nodeEntity.getStoreNewId() != null) {
            store = AVMDAOs.Instance().fAVMStoreDAO.getByID(nodeEntity.getStoreNewId());
        }
        node.setStoreNew(store);
        Acl acl = null;
        if (nodeEntity.getAclId() != null) {
            acl = AVMDAOs.Instance().fAclDAO.getAcl(nodeEntity.getAclId());
        }
        node.setAcl(acl);
        return node;
    }
}

