/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm.locking;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.domain.avm.AVMLockDAO;
import org.alfresco.service.cmr.attributes.AttributeService;
import org.alfresco.service.cmr.attributes.DuplicateAttributeException;
import org.alfresco.service.cmr.avm.AVMBadArgumentException;
import org.alfresco.service.cmr.avm.locking.AVMLockingException;
import org.alfresco.service.cmr.avm.locking.AVMLockingService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AVMLockingServiceImpl
implements AVMLockingService {
    public static final String KEY_AVM_LOCKS = ".avm_locks";
    public static final String KEY_LOCK_OWNER = "lock-owner";
    private static final String ROLE_CONTENT_MANAGER = "ContentManager";
    private static final Log logger = LogFactory.getLog(AVMLockingServiceImpl.class);
    private String webProjectStore;
    private SearchService searchService;
    private AttributeService attributeService;
    private AuthorityService authorityService;
    private PersonService personService;
    private NodeService nodeService;
    private AVMLockDAO avmLockDAO;

    public void setWebProjectStore(String webProjectStore) {
        this.webProjectStore = webProjectStore;
    }

    public void setAttributeService(AttributeService attributeService) {
        this.attributeService = attributeService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setAvmLockDAO(AVMLockDAO avmLockDAO) {
        this.avmLockDAO = avmLockDAO;
    }

    private HashMap<String, String> createLockAttributes(String lockOwner, Map<String, String> lockData) {
        HashMap<String, String> lockAttributes = new HashMap<String, String>(lockData);
        lockAttributes.put(KEY_LOCK_OWNER, lockOwner);
        return lockAttributes;
    }

    @Override
    public void lock(String avmStore, String path, String lockOwner, Map<String, String> lockData) {
        ParameterCheck.mandatoryString((String)"avmStore", (String)avmStore);
        ParameterCheck.mandatoryString((String)"path", (String)path);
        ParameterCheck.mandatoryString((String)"lockOwner", (String)lockOwner);
        path = AVMLockingServiceImpl.normalizePath(path);
        if (!this.authorityService.authorityExists(lockOwner) && !this.personService.personExists(lockOwner)) {
            throw new AVMBadArgumentException("Not an Authority: " + lockOwner);
        }
        AVMLockingService.LockState lockState = this.getLockState(avmStore, path, lockOwner);
        switch (lockState) {
            case LOCK_NOT_OWNER: {
                throw new AVMLockingException("avmlockservice.locked", path, lockOwner);
            }
            case NO_LOCK: {
                try {
                    HashMap<String, String> lockAttributes = this.createLockAttributes(lockOwner, lockData);
                    this.attributeService.createAttribute(lockAttributes, new Serializable[]{KEY_AVM_LOCKS, avmStore, path});
                    break;
                }
                catch (DuplicateAttributeException e) {
                    String currentLockOwner = this.getLockOwner(avmStore, path);
                    throw new AVMLockingException((Throwable)((Object)e), "avmlockservice.locked", path, currentLockOwner);
                }
            }
        }
    }

    @Override
    public boolean modifyLock(String avmStore, String path, String lockOwner, String newAvmStore, String newPath, Map<String, String> lockData) {
        ParameterCheck.mandatoryString((String)"avmStore", (String)avmStore);
        ParameterCheck.mandatoryString((String)"path", (String)path);
        ParameterCheck.mandatoryString((String)"lockOwner", (String)lockOwner);
        ParameterCheck.mandatoryString((String)"newAvmStore", (String)newAvmStore);
        ParameterCheck.mandatoryString((String)"newPath", (String)newPath);
        path = AVMLockingServiceImpl.normalizePath(path);
        newPath = AVMLockingServiceImpl.normalizePath(newPath);
        AVMLockingService.LockState currentLockState = this.getLockState(avmStore, path, lockOwner);
        switch (currentLockState) {
            case LOCK_NOT_OWNER: 
            case LOCK_OWNER: {
                this.attributeService.removeAttribute(new Serializable[]{KEY_AVM_LOCKS, avmStore, path});
                HashMap<String, String> lockAttributes = this.createLockAttributes(lockOwner, lockData);
                this.attributeService.setAttribute(lockAttributes, new Serializable[]{KEY_AVM_LOCKS, newAvmStore, newPath});
                return true;
            }
            case NO_LOCK: {
                return false;
            }
        }
        throw new IllegalStateException("Unexpected enum constant");
    }

    @Override
    public String getLockOwner(String avmStore, String path) {
        ParameterCheck.mandatoryString((String)"path", (String)path);
        path = AVMLockingServiceImpl.normalizePath(path);
        Map<String, String> lockAttributes = this.getLockData(avmStore, path);
        if (lockAttributes == null) {
            return null;
        }
        if (!lockAttributes.containsKey(KEY_LOCK_OWNER)) {
            logger.warn((Object)("AVM lock does not have a lock owner: " + avmStore + "-" + path));
            return null;
        }
        return lockAttributes.get(KEY_LOCK_OWNER);
    }

    @Override
    public Map<String, String> getLockData(String avmStore, String path) {
        ParameterCheck.mandatoryString((String)"avmStore", (String)avmStore);
        ParameterCheck.mandatoryString((String)"path", (String)path);
        path = AVMLockingServiceImpl.normalizePath(path);
        Map lockAttributes = (Map)((Object)this.attributeService.getAttribute(new Serializable[]{KEY_AVM_LOCKS, avmStore, path}));
        return lockAttributes;
    }

    @Override
    public AVMLockingService.LockState getLockState(String avmStore, String path, String lockOwner) {
        ParameterCheck.mandatoryString((String)"avmStore", (String)avmStore);
        ParameterCheck.mandatoryString((String)"lockOwner", (String)lockOwner);
        path = AVMLockingServiceImpl.normalizePath(path);
        String currentLockOwner = this.getLockOwner(avmStore, path);
        if (currentLockOwner == null) {
            return AVMLockingService.LockState.NO_LOCK;
        }
        if (currentLockOwner.equals(lockOwner)) {
            return AVMLockingService.LockState.LOCK_OWNER;
        }
        return AVMLockingService.LockState.LOCK_NOT_OWNER;
    }

    @Override
    public void removeLock(String avmStore, String path) {
        ParameterCheck.mandatoryString((String)"avmStore", (String)avmStore);
        ParameterCheck.mandatoryString((String)"path", (String)path);
        path = AVMLockingServiceImpl.normalizePath(path);
        this.attributeService.removeAttribute(new Serializable[]{KEY_AVM_LOCKS, avmStore, path});
    }

    @Override
    public void removeLocks(String avmStore) {
        ParameterCheck.mandatoryString((String)"avmStore", (String)avmStore);
        this.attributeService.removeAttributes(new Serializable[]{KEY_AVM_LOCKS, avmStore});
    }

    @Override
    public void removeLocks(String avmStore, String dirPath, Map<String, String> lockDataToMatch) {
        String dirPathStart;
        ParameterCheck.mandatoryString((String)"avmStore", (String)avmStore);
        ParameterCheck.mandatory((String)"lockDataToMatch", lockDataToMatch);
        if (dirPath == null) {
            dirPathStart = null;
        } else {
            if (!(dirPath = AVMLockingServiceImpl.normalizePath(dirPath)).endsWith("/")) {
                dirPath = dirPath + '/';
            }
            dirPathStart = dirPath;
        }
        this.avmLockDAO.removeLocks(avmStore, dirPathStart, lockDataToMatch);
    }

    @Override
    public void removeLocks(String avmStore, Map<String, String> lockDataToMatch) {
        this.removeLocks(avmStore, null, lockDataToMatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAccess(String webProject, String avmPath, String lockOwner) {
        if (this.personService.getPerson(lockOwner) == null && !this.authorityService.authorityExists(lockOwner)) {
            return false;
        }
        if (this.authorityService.isAdminAuthority(lockOwner)) {
            return true;
        }
        StoreRef storeRef = new StoreRef(this.webProjectStore);
        ResultSet results = this.searchService.query(storeRef, "lucene", "@wca\\:avmstore:\"" + webProject + '\"');
        try {
            if (results.getNodeRefs().size() == 1) {
                boolean bl = this.hasAccess(webProject, (NodeRef)results.getNodeRefs().get(0), avmPath, lockOwner);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            results.close();
        }
    }

    @Override
    public boolean hasAccess(NodeRef webProjectRef, String avmPath, String lockOwner) {
        if (this.personService.getPerson(lockOwner) == null && !this.authorityService.authorityExists(lockOwner)) {
            return false;
        }
        if (this.authorityService.isAdminAuthority(lockOwner)) {
            return true;
        }
        String webProject = (String)((Object)this.nodeService.getProperty(webProjectRef, WCMAppModel.PROP_AVMSTORE));
        return this.hasAccess(webProject, webProjectRef, avmPath, lockOwner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasAccess(String webProject, NodeRef webProjectRef, String avmPath, String lockOwner) {
        String path;
        Map<String, String> lockData;
        String[] storePath = avmPath.split(":");
        if (storePath.length != 2) {
            throw new AVMBadArgumentException("Malformed AVM Path : " + avmPath);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Testing lock access on path: " + avmPath + " for user: " + lockOwner + " in webproject: " + webProject));
        }
        if ((lockData = this.getLockData(webProject, path = AVMLockingServiceImpl.normalizePath(storePath[1]))) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)" GRANTED: No lock found.");
            }
            return true;
        }
        String currentLockOwner = lockData.get(KEY_LOCK_OWNER);
        String currentLockStore = lockData.get("avm-store-name");
        if (storePath[0].contains("--workflow")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)" GRANTED: Workflow store path.");
            }
            return true;
        }
        if (currentLockStore == null || !currentLockStore.equals(storePath[0])) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(" DENIED: Store on path and lock (" + currentLockStore + ") do not match."));
            }
            return false;
        }
        StringBuilder query = new StringBuilder(128);
        query.append("+PARENT:\"").append(webProjectRef).append("\" ");
        query.append("+TYPE:\"").append(WCMAppModel.TYPE_WEBUSER).append("\" ");
        query.append("+@").append("wca").append("\\:username:\"");
        query.append(lockOwner);
        query.append("\"");
        ResultSet resultSet = null;
        List nodes = null;
        try {
            resultSet = this.searchService.query(new StoreRef(this.webProjectStore), "lucene", query.toString());
            nodes = resultSet.getNodeRefs();
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        if (nodes.size() == 1) {
            String userrole = (String)((Object)this.nodeService.getProperty((NodeRef)nodes.get(0), WCMAppModel.PROP_WEBUSERROLE));
            if (ROLE_CONTENT_MANAGER.equals(userrole)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"GRANTED: Store match and user is ContentManager role in webproject.");
                }
                return true;
            }
        } else if (nodes.size() == 0) {
            logger.warn((Object)("hasAccess: user role not found for " + lockOwner));
        } else {
            logger.warn((Object)("hasAccess: more than one user role found for " + lockOwner));
        }
        if (AuthorityType.getAuthorityType((String)currentLockOwner) == AuthorityType.EVERYONE) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)" GRANTED: Authority EVERYONE matched lock owner.");
            }
            return true;
        }
        if (this.checkAgainstAuthority(lockOwner, currentLockOwner)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)" GRANTED: User matched as lock owner.");
            }
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" DENIED: User did not match as lock owner.");
        }
        return false;
    }

    private boolean checkAgainstAuthority(String user, String authority) {
        if (user.equalsIgnoreCase(authority)) {
            return true;
        }
        return this.authorityService.getAuthoritiesForUser(user).contains(authority);
    }

    public static String normalizePath(String path) {
        path = path.toLowerCase();
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path.replaceAll("/+", "/");
    }
}

