/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bulkimport;

import java.io.File;
import java.io.IOException;
import org.alfresco.util.GUID;
import org.apache.commons.io.FileUtils;

public class CreateTestData {
    private void createFile(File sourceFile, File targetFolder) throws IOException {
        File f = new File(targetFolder, GUID.generate() + ".bin");
        FileUtils.copyFile((File)sourceFile, (File)f);
    }

    private void createDirectory(File sourceFolder, File targetFolder) throws IOException {
        String s = sourceFolder.getName();
        if (s != null && !s.equals("")) {
            File d = new File(targetFolder, s);
            if (d.exists() || d.mkdir()) {
                this.createTestData(sourceFolder, d);
            } else {
                System.err.println("Unable to create directory " + d.getAbsolutePath());
            }
        }
    }

    public void createTestData(File sourceFolder, File targetFolder) throws IOException {
        File[] files;
        for (File file : files = sourceFolder.listFiles()) {
            if (file.getName().startsWith(".")) continue;
            if (file.isDirectory()) {
                this.createDirectory(file, targetFolder);
                continue;
            }
            this.createFile(file, targetFolder);
        }
    }

    public void execute(String sourceFolderPath, String targetFolderPath) throws IOException {
        File targetFolder = new File(targetFolderPath);
        File sourceFolder = new File(sourceFolderPath);
        if (!sourceFolder.isDirectory()) {
            throw new IllegalArgumentException("source is not a folder");
        }
        if (!targetFolder.isDirectory()) {
            throw new IllegalArgumentException("target is not a folder");
        }
        this.createDirectory(sourceFolder, targetFolder);
    }

    public static void main(String[] args) {
        try {
            new CreateTestData().execute(args[0], args[1]);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

