/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bulkimport.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.bulkimport.ContentDataFactory;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.encoding.ContentCharsetFinder;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class FilesystemContentDataFactory
implements ContentDataFactory,
InitializingBean {
    private static final Log logger = LogFactory.getLog(FilesystemContentDataFactory.class);
    private static final String PROTOCOL_DELIMITER = "://";
    private static final String OS_FILE_SEPARATOR = System.getProperty("file.separator");
    private MimetypeService mimetypeService;
    private String defaultEncoding;
    private String storeProtocol;

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public void setStoreProtocol(String storeProtocol) {
        this.storeProtocol = storeProtocol;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"mimetypeService", (Object)this.mimetypeService);
        PropertyCheck.mandatory((Object)this, (String)"defaultEncoding", (Object)this.defaultEncoding);
        PropertyCheck.mandatory((Object)this, (String)"storeProtocol", (Object)this.storeProtocol);
    }

    @Override
    public ContentData createContentData(ContentStore store, File contentFile) {
        if (!this.contentIsInStore(contentFile, store)) {
            throw new IllegalArgumentException("Can't create content URL : file '" + contentFile.getAbsolutePath() + "' is not located within the store's tree ! The store's root is :'" + store.getRootLocation());
        }
        String relativeFilePath = contentFile.getAbsolutePath().replace(store.getRootLocation() + OS_FILE_SEPARATOR, "");
        String mimetype = this.mimetypeService.guessMimetype(contentFile.getName());
        String encoding = this.defaultEncoding;
        if (!contentFile.isDirectory()) {
            encoding = this.guessEncoding(contentFile, mimetype);
        }
        ContentData contentData = new ContentData(this.storeProtocol + PROTOCOL_DELIMITER + relativeFilePath, mimetype, contentFile.length(), encoding);
        HashMap<QName, String> contentProps = new HashMap<QName, String>();
        contentProps.put(ContentModel.PROP_NAME, contentFile.getName());
        contentProps.put(ContentModel.PROP_CONTENT, (String)contentData);
        return contentData;
    }

    private boolean contentIsInStore(File contentFile, ContentStore store) {
        return contentFile.getAbsolutePath().startsWith(store.getRootLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String guessEncoding(File file, String mimetype) {
        String encoding = this.defaultEncoding;
        if (file.isDirectory()) {
            return this.defaultEncoding;
        }
        InputStream is = null;
        ContentCharsetFinder charsetFinder = this.mimetypeService.getContentCharsetFinder();
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            encoding = charsetFinder.getCharset(is, mimetype).name();
        }
        catch (Throwable e) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Failed to guess character encoding of file: '" + file.getName() + "'. Falling back to configured default encoding (" + this.defaultEncoding + ")"));
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable e) {}
            }
        }
        return encoding;
    }
}

