/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.coci;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.copy.DefaultCopyBehaviourCallback;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;

public class WorkingCopyAspect
implements CopyServicePolicies.OnCopyNodePolicy {
    private PolicyComponent policyComponent;
    private NodeService nodeService;
    private LockService lockService;
    private CheckOutCheckInService checkOutCheckInService;
    private BehaviourFilter policyBehaviourFilter;
    private WorkingCopyAspectCopyBehaviourCallback workingCopyAspectCopyBehaviourCallback = new WorkingCopyAspectCopyBehaviourCallback();

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public void setCheckOutCheckInService(CheckOutCheckInService checkOutCheckInService) {
        this.checkOutCheckInService = checkOutCheckInService;
    }

    public void setPolicyBehaviourFilter(BehaviourFilter policyBehaviourFilter) {
        this.policyBehaviourFilter = policyBehaviourFilter;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(CopyServicePolicies.OnCopyNodePolicy.QNAME, ContentModel.TYPE_CMOBJECT, (Behaviour)new JavaBehaviour(this, "getCopyCallback"));
        this.policyComponent.bindClassBehaviour(CopyServicePolicies.OnCopyNodePolicy.QNAME, ContentModel.ASPECT_WORKING_COPY, (Behaviour)new JavaBehaviour(this, "getCopyCallback"));
        this.policyComponent.bindClassBehaviour(CopyServicePolicies.OnCopyNodePolicy.QNAME, ContentModel.ASPECT_CHECKED_OUT, (Behaviour)new JavaBehaviour(this, "getCopyCallback"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, ContentModel.ASPECT_WORKING_COPY, (Behaviour)new JavaBehaviour(this, "beforeDeleteWorkingCopy"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeDeleteWorkingCopy(NodeRef nodeRef) {
        NodeRef checkedOutNodeRef = this.checkOutCheckInService.getCheckedOut(nodeRef);
        if (checkedOutNodeRef != null) {
            this.policyBehaviourFilter.disableBehaviour(checkedOutNodeRef, ContentModel.ASPECT_AUDITABLE);
            try {
                this.lockService.unlock(checkedOutNodeRef);
                this.nodeService.removeAspect(checkedOutNodeRef, ContentModel.ASPECT_CHECKED_OUT);
            }
            finally {
                this.policyBehaviourFilter.enableBehaviour(checkedOutNodeRef, ContentModel.ASPECT_AUDITABLE);
            }
        }
    }

    @Override
    public CopyBehaviourCallback getCopyCallback(QName classRef, CopyDetails copyDetails) {
        return this.workingCopyAspectCopyBehaviourCallback;
    }

    private class WorkingCopyAspectCopyBehaviourCallback
    extends DefaultCopyBehaviourCallback {
        private WorkingCopyAspectCopyBehaviourCallback() {
        }

        @Override
        public boolean getMustCopy(QName classQName, CopyDetails copyDetails) {
            return !classQName.equals((Object)ContentModel.ASPECT_WORKING_COPY);
        }

        @Override
        public Map<QName, Serializable> getCopyProperties(QName classQName, CopyDetails copyDetails, Map<QName, Serializable> properties) {
            if (classQName.equals((Object)ContentModel.ASPECT_WORKING_COPY)) {
                return Collections.emptyMap();
            }
            if (copyDetails.getSourceNodeAspectQNames().contains(ContentModel.ASPECT_WORKING_COPY)) {
                NodeRef checkedOutFrom;
                String newName = null;
                if (copyDetails.isTargetNodeIsNew() && (checkedOutFrom = WorkingCopyAspect.this.checkOutCheckInService.getCheckedOut(copyDetails.getSourceNodeRef())) != null) {
                    String oldName = (String)((Object)WorkingCopyAspect.this.nodeService.getProperty(checkedOutFrom, ContentModel.PROP_NAME));
                    int extIndex = oldName.lastIndexOf(46);
                    String string = newName = extIndex == -1 ? oldName + "_" + GUID.generate() : oldName.substring(0, extIndex) + "_" + GUID.generate() + oldName.substring(extIndex);
                }
                if (newName == null) {
                    properties.remove(ContentModel.PROP_NAME);
                } else {
                    properties.put(ContentModel.PROP_NAME, (Serializable)((Object)newName));
                }
                return properties;
            }
            return properties;
        }
    }
}

