/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.poi.poifs.common.POIFSConstants;
import org.apache.poi.util.IOUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.parser.microsoft.ooxml.OOXMLParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TikaOfficeDetectParser
implements Parser {
    private Parser ole2Parser = new OfficeParser();
    private Parser ooxmlParser = new OOXMLParser();

    public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
        HashSet<MediaType> types = new HashSet<MediaType>();
        types.addAll(this.ole2Parser.getSupportedTypes(parseContext));
        types.addAll(this.ooxmlParser.getSupportedTypes(parseContext));
        return types;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext parseContext) throws IOException, SAXException, TikaException {
        PushbackInputStream inp = new PushbackInputStream(stream, 4);
        byte[] initial4 = new byte[4];
        IOUtils.readFully((InputStream)inp, (byte[])initial4);
        inp.unread(initial4);
        if (initial4[0] == POIFSConstants.OOXML_FILE_HEADER[0] && initial4[1] == POIFSConstants.OOXML_FILE_HEADER[1] && initial4[2] == POIFSConstants.OOXML_FILE_HEADER[2] && initial4[3] == POIFSConstants.OOXML_FILE_HEADER[3]) {
            this.ooxmlParser.parse((InputStream)inp, handler, metadata, parseContext);
        } else {
            this.ole2Parser.parse((InputStream)inp, handler, metadata, parseContext);
        }
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, handler, metadata, new ParseContext());
    }
}

