/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.metadata.MP3MetadataExtracter;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.metadata.TikaAudioMetadataExtracterTest;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;

public class MP3MetadataExtracterTest
extends TikaAudioMetadataExtracterTest {
    private MP3MetadataExtracter extracter;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.extracter = (MP3MetadataExtracter)this.ctx.getBean("extracter.MP3");
        this.extracter.register();
    }

    @Override
    protected MetadataExtracter getExtracter() {
        return this.extracter;
    }

    @Override
    public void testSupports() throws Exception {
        for (String mimetype : MP3MetadataExtracter.SUPPORTED_MIMETYPES) {
            boolean supports = this.extracter.isSupported(mimetype);
            MP3MetadataExtracterTest.assertTrue((String)("Mimetype should be supported: " + mimetype), (boolean)supports);
        }
    }

    public void testMP3Extraction() throws Exception {
        this.testExtractFromMimetype("audio/mpeg");
    }

    @Override
    public void testOggExtraction() throws Exception {
    }

    @Override
    public void testFlacExtraction() throws Exception {
    }

    @Override
    public void testMP4AudioExtraction() throws Exception {
    }

    @Override
    protected void testCommonMetadata(String mimetype, Map<QName, Serializable> properties) {
        MP3MetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_TITLE + " not found for mimetype " + mimetype), (String)"The quick brown fox jumps over the lazy dog", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_TITLE))));
        MP3MetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_AUTHOR + " not found for mimetype " + mimetype), (String)"Hauskaz", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_AUTHOR))));
        MP3MetadataExtracterTest.assertContains("Property " + ContentModel.PROP_DESCRIPTION + " didn't contain " + "The quick brown fox jumps over the lazy dog" + " for mimetype " + mimetype, "The quick brown fox jumps over the lazy dog", (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_DESCRIPTION)));
    }

    @Override
    public void testFileSpecificMetadata(String mimetype, Map<QName, Serializable> properties) {
        super.testFileSpecificMetadata(mimetype, properties);
    }
}

