/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Properties;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.alfresco.repo.content.transform.AbstractContentTransformer2;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.txt.Icu4jEncodingDetector;

public class EMLTransformer
extends AbstractContentTransformer2 {
    @Override
    public boolean isTransformableMimetype(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return "message/rfc822".equals(sourceMimetype) && "text/plain".equals(targetMimetype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void transformInternal(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
        TikaInputStream tikaInputStream = null;
        try {
            tikaInputStream = TikaInputStream.get((InputStream)reader.getContentInputStream());
            Icu4jEncodingDetector encodingDetector = new Icu4jEncodingDetector();
            Charset charset = encodingDetector.detect((InputStream)tikaInputStream, new Metadata());
            MimeMessage mimeMessage = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()), (InputStream)tikaInputStream);
            if (charset != null) {
                mimeMessage.setHeader("Content-Type", "text/plain; charset=" + charset.name());
                mimeMessage.setHeader("Content-Transfer-Encoding", "quoted-printable");
            }
            StringBuilder sb = new StringBuilder();
            Object content = mimeMessage.getContent();
            if (content instanceof Multipart) {
                sb.append((CharSequence)this.processMultiPart((Multipart)content));
            } else {
                sb.append(content.toString());
            }
            writer.putContent(sb.toString());
        }
        finally {
            if (tikaInputStream != null) {
                try {
                    tikaInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private StringBuilder processMultiPart(Multipart multipart) throws MessagingException, IOException {
        StringBuilder sb = new StringBuilder();
        int n = multipart.getCount();
        for (int i = 0; i < n; ++i) {
            BodyPart part = multipart.getBodyPart(i);
            if (part.getContent() instanceof Multipart) {
                sb.append((CharSequence)this.processMultiPart((Multipart)part.getContent()));
                continue;
            }
            if (!part.getContentType().contains("text")) continue;
            sb.append(part.getContent().toString()).append("\n");
        }
        return sb;
    }
}

