/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.EMLTransformer;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.util.TempFileProvider;

public class EMLTransformerTest
extends AbstractContentTransformerTest {
    private static final String QUICK_EML_CONTENT = "Gym class featuring a brown fox and lazy dog";
    private static final String QUICK_EML_CONTENT_SPANISH_UNICODE = "El r\u00e1pido zorro marr\u00f3n salta sobre el perro perezoso";
    private EMLTransformer transformer;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.transformer = new EMLTransformer();
        this.transformer.setMimetypeService(this.mimetypeService);
        this.transformer.setTransformerDebug(this.transformerDebug);
    }

    @Override
    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return this.transformer;
    }

    public void testIsTransformable() throws Exception {
        EMLTransformerTest.assertFalse((boolean)this.transformer.isTransformable("text/plain", -1L, "message/rfc822", new TransformationOptions()));
        EMLTransformerTest.assertTrue((boolean)this.transformer.isTransformable("message/rfc822", -1L, "text/plain", new TransformationOptions()));
    }

    public void testRFC822ToText() throws Exception {
        File emlSourceFile = EMLTransformerTest.loadQuickTestFile("eml");
        File txtTargetFile = TempFileProvider.createTempFile((String)"test", (String)".txt");
        FileContentReader reader = new FileContentReader(emlSourceFile);
        reader.setMimetype("message/rfc822");
        FileContentWriter writer = new FileContentWriter(txtTargetFile);
        writer.setMimetype("text/plain");
        this.transformer.transform(reader, writer);
        FileContentReader reader2 = new FileContentReader(txtTargetFile);
        reader2.setMimetype("text/plain");
        EMLTransformerTest.assertTrue((boolean)reader2.getContentString().contains(QUICK_EML_CONTENT));
    }

    public void testNonAsciiRFC822ToText() throws Exception {
        File emlSourceFile = EMLTransformerTest.loadQuickTestFile("spanish.eml");
        File txtTargetFile = TempFileProvider.createTempFile((String)"test2", (String)".txt");
        FileContentReader reader = new FileContentReader(emlSourceFile);
        reader.setMimetype("message/rfc822");
        FileContentWriter writer = new FileContentWriter(txtTargetFile);
        writer.setMimetype("text/plain");
        this.transformer.transform(reader, writer);
        FileContentReader reader2 = new FileContentReader(txtTargetFile);
        reader2.setMimetype("text/plain");
        EMLTransformerTest.assertTrue((boolean)reader2.getContentString().contains(new String(QUICK_EML_CONTENT_SPANISH_UNICODE.getBytes("UTF-8"))));
    }
}

