/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import java.net.URLConnection;
import org.alfresco.repo.content.transform.AbstractContentTransformer2;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlparser.Parser;
import org.htmlparser.beans.StringBean;
import org.htmlparser.util.ParserException;

public class HtmlParserContentTransformer
extends AbstractContentTransformer2 {
    private static final Log logger = LogFactory.getLog(HtmlParserContentTransformer.class);

    @Override
    public boolean isTransformableMimetype(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return "text/html".equals(sourceMimetype) && "text/plain".equals(targetMimetype);
    }

    @Override
    public void transformInternal(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
        File htmlFile = TempFileProvider.createTempFile((String)"HtmlParserContentTransformer_", (String)".html");
        reader.getContent(htmlFile);
        String encoding = reader.getEncoding();
        EncodingAwareStringBean extractor = new EncodingAwareStringBean();
        extractor.setCollapse(false);
        extractor.setLinks(false);
        extractor.setReplaceNonBreakingSpaces(false);
        extractor.setURL(htmlFile, encoding);
        String text = extractor.getStrings();
        writer.putContent(text);
        htmlFile.delete();
    }

    class EncodingAwareStringBean
    extends StringBean {
        private static final long serialVersionUID = -9033414360428669553L;

        EncodingAwareStringBean() {
        }

        public void setURL(File file, String encoding) {
            String previousURL = this.getURL();
            String newURL = file.getAbsolutePath();
            if (previousURL == null || !newURL.equals(previousURL)) {
                try {
                    URLConnection conn = this.getConnection();
                    if (null == this.mParser) {
                        this.mParser = new Parser(newURL);
                    } else {
                        this.mParser.setURL(newURL);
                    }
                    if (encoding != null) {
                        this.mParser.setEncoding(encoding);
                    }
                    this.mPropertySupport.firePropertyChange("URL", previousURL, this.getURL());
                    this.mPropertySupport.firePropertyChange("connection", conn, this.mParser.getConnection());
                    this.setStrings();
                }
                catch (ParserException pe) {
                    this.updateStrings(pe.toString());
                }
            }
        }
    }
}

