/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.ByteArrayInputStream;
import java.io.File;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.HtmlParserContentTransformer;
import org.alfresco.service.cmr.repository.TransformationOptions;

public class HtmlParserContentTransformerTest
extends AbstractContentTransformerTest {
    private HtmlParserContentTransformer transformer;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.transformer = new HtmlParserContentTransformer();
        this.transformer.setMimetypeService(this.mimetypeService);
        this.transformer.setTransformerDebug(this.transformerDebug);
    }

    @Override
    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return this.transformer;
    }

    @Override
    public void testSetUp() throws Exception {
        HtmlParserContentTransformerTest.assertNotNull((Object)this.transformer);
    }

    public void checkIsTransformable() throws Exception {
        boolean reliability = this.transformer.isTransformable("text/html", -1L, "text/plain", new TransformationOptions());
        HtmlParserContentTransformerTest.assertTrue((boolean)reliability);
        reliability = this.transformer.isTransformable("text/plain", -1L, "text/html", new TransformationOptions());
        HtmlParserContentTransformerTest.assertFalse((boolean)reliability);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEncodingHandling() throws Exception {
        String TITLE = "Testing!";
        String TEXT_P1 = "This is some text in English";
        String TEXT_P2 = "This is more text in English";
        String TEXT_P3 = "C'est en Fran\u00e7ais et Espa\u00f1ol";
        String partA = "<html><head><title>Testing!</title>";
        String partB = "</head>\n<body><p>This is some text in English</p>\n<p>This is more text in English</p>\n<p>C'est en Fran\u00e7ais et Espa\u00f1ol</p>\n";
        String partC = "</body></html>";
        File tmpS = null;
        File tmpD = null;
        try {
            tmpS = File.createTempFile("test", ".html");
            FileContentWriter content = new FileContentWriter(tmpS);
            content.setEncoding("ISO-8859-1");
            content.setMimetype("text/html");
            content.putContent(partA + partB + partC);
            tmpD = File.createTempFile("test", ".txt");
            FileContentWriter dest = new FileContentWriter(tmpD);
            dest.setMimetype("text/plain");
            this.transformer.transform(content.getReader(), dest);
            HtmlParserContentTransformerTest.assertEquals((String)"Testing!\nThis is some text in English\nThis is more text in English\nC'est en Fran\u00e7ais et Espa\u00f1ol\n", (String)dest.getReader().getContentString());
            tmpS.delete();
            tmpD.delete();
            tmpS = File.createTempFile("test", ".html");
            content = new FileContentWriter(tmpS);
            content.setEncoding("UTF-8");
            content.setMimetype("text/html");
            content.putContent(partA + partB + partC);
            tmpD = File.createTempFile("test", ".txt");
            dest = new FileContentWriter(tmpD);
            dest.setMimetype("text/plain");
            this.transformer.transform(content.getReader(), dest);
            HtmlParserContentTransformerTest.assertEquals((String)"Testing!\nThis is some text in English\nThis is more text in English\nC'est en Fran\u00e7ais et Espa\u00f1ol\n", (String)dest.getReader().getContentString());
            tmpS.delete();
            tmpD.delete();
            tmpS = File.createTempFile("test", ".html");
            content = new FileContentWriter(tmpS);
            content.setEncoding("UTF-16");
            content.setMimetype("text/html");
            content.putContent(partA + partB + partC);
            tmpD = File.createTempFile("test", ".txt");
            dest = new FileContentWriter(tmpD);
            dest.setMimetype("text/plain");
            this.transformer.transform(content.getReader(), dest);
            HtmlParserContentTransformerTest.assertEquals((String)"Testing!\nThis is some text in English\nThis is more text in English\nC'est en Fran\u00e7ais et Espa\u00f1ol\n", (String)dest.getReader().getContentString());
            tmpS.delete();
            tmpD.delete();
            tmpS = File.createTempFile("test", ".html");
            content = new FileContentWriter(tmpS);
            content.setMimetype("text/html");
            String str = partA + "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\">" + partB + partC;
            content.putContent(new ByteArrayInputStream(str.getBytes("ISO-8859-1")));
            tmpD = File.createTempFile("test", ".txt");
            dest = new FileContentWriter(tmpD);
            dest.setMimetype("text/plain");
            this.transformer.transform(content.getReader(), dest);
            HtmlParserContentTransformerTest.assertEquals((String)"Testing!\nThis is some text in English\nThis is more text in English\nC'est en Fran\u00e7ais et Espa\u00f1ol\n", (String)dest.getReader().getContentString());
            tmpS.delete();
            tmpD.delete();
            tmpS = File.createTempFile("test", ".html");
            content = new FileContentWriter(tmpS);
            content.setMimetype("text/html");
            str = partA + "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">" + partB + partC;
            content.putContent(new ByteArrayInputStream(str.getBytes("UTF-8")));
            tmpD = File.createTempFile("test", ".txt");
            dest = new FileContentWriter(tmpD);
            dest.setMimetype("text/plain");
            this.transformer.transform(content.getReader(), dest);
            HtmlParserContentTransformerTest.assertEquals((String)"Testing!\nThis is some text in English\nThis is more text in English\nC'est en Fran\u00e7ais et Espa\u00f1ol\n", (String)dest.getReader().getContentString());
            tmpS.delete();
            tmpD.delete();
        }
        finally {
            if (tmpS != null && tmpS.exists()) {
                tmpS.delete();
            }
            if (tmpD != null && tmpD.exists()) {
                tmpD.delete();
            }
        }
    }
}

