/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import java.net.URL;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformerWorker;
import org.alfresco.repo.content.transform.ProxyContentTransformer;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.util.TempFileProvider;

public class OpenOfficeContentTransformerTest
extends AbstractContentTransformerTest {
    private static String MIMETYPE_RUBBISH = "text/rubbish";
    private ContentTransformerWorker worker;
    private ProxyContentTransformer transformer;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.worker = (ContentTransformerWorker)this.ctx.getBean("transformer.worker.OpenOffice");
        this.transformer = new ProxyContentTransformer();
        this.transformer.setMimetypeService(this.mimetypeService);
        this.transformer.setTransformerDebug(this.transformerDebug);
        this.transformer.setWorker(this.worker);
    }

    @Override
    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return this.transformer;
    }

    @Override
    public void testSetUp() throws Exception {
        super.testSetUp();
        OpenOfficeContentTransformerTest.assertNotNull((Object)this.mimetypeService);
    }

    public void testReliability() throws Exception {
        if (!this.worker.isAvailable()) {
            return;
        }
        boolean reliability = this.transformer.isTransformable(MIMETYPE_RUBBISH, -1L, "text/plain", new TransformationOptions());
        OpenOfficeContentTransformerTest.assertEquals((String)"Mimetype should not be supported", (boolean)false, (boolean)reliability);
        reliability = this.transformer.isTransformable("text/plain", -1L, MIMETYPE_RUBBISH, new TransformationOptions());
        OpenOfficeContentTransformerTest.assertEquals((String)"Mimetype should not be supported", (boolean)false, (boolean)reliability);
        reliability = this.transformer.isTransformable("text/plain", -1L, "application/xhtml+xml", new TransformationOptions());
        OpenOfficeContentTransformerTest.assertEquals((String)"Mimetype should not be supported", (boolean)false, (boolean)reliability);
        reliability = this.transformer.isTransformable("text/plain", -1L, "application/msword", new TransformationOptions());
        OpenOfficeContentTransformerTest.assertEquals((String)"Mimetype should be supported", (boolean)true, (boolean)reliability);
        reliability = this.transformer.isTransformable("application/msword", -1L, "text/plain", new TransformationOptions());
        OpenOfficeContentTransformerTest.assertEquals((String)"Mimetype should be supported", (boolean)true, (boolean)reliability);
    }

    public void testHtmlToPdf() throws Exception {
        if (!this.worker.isAvailable()) {
            return;
        }
        File htmlSourceFile = OpenOfficeContentTransformerTest.loadQuickTestFile("html");
        File pdfTargetFile = TempFileProvider.createTempFile((String)(this.getName() + "-target-"), (String)".pdf");
        FileContentReader reader = new FileContentReader(htmlSourceFile);
        reader.setMimetype("text/html");
        FileContentWriter writer = new FileContentWriter(pdfTargetFile);
        writer.setMimetype("application/pdf");
        this.transformer.transform(reader, writer);
    }

    public void testEmptyHtmlToEmptyPdf() throws Exception {
        if (!this.worker.isAvailable()) {
            return;
        }
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("misc/empty.html");
        OpenOfficeContentTransformerTest.assertNotNull((String)"URL was unexpectedly null", (Object)url);
        File htmlSourceFile = new File(url.getFile());
        OpenOfficeContentTransformerTest.assertTrue((String)"Test file does not exist.", (boolean)htmlSourceFile.exists());
        File pdfTargetFile = TempFileProvider.createTempFile((String)(this.getName() + "-target-"), (String)".pdf");
        FileContentReader reader = new FileContentReader(htmlSourceFile);
        reader.setMimetype("text/html");
        FileContentWriter writer = new FileContentWriter(pdfTargetFile);
        writer.setMimetype("application/pdf");
        this.transformer.transform(reader, writer);
    }

    @Override
    protected boolean isTransformationExcluded(String sourceExtension, String targetExtension) {
        return sourceExtension.equals("doc") && targetExtension.equals("docx") || sourceExtension.equals("doc") && targetExtension.equals("html") || sourceExtension.equals("doc") && targetExtension.equals("odt") || sourceExtension.equals("doc") && targetExtension.equals("rtf") || sourceExtension.equals("doc") && targetExtension.equals("sxw") || sourceExtension.equals("doc") && targetExtension.equals("txt") || sourceExtension.equals("docx") && targetExtension.equals("sxw") || sourceExtension.equals("html") && targetExtension.equals("docx") || sourceExtension.equals("odp") && targetExtension.equals("pptx") || sourceExtension.equals("ods") && targetExtension.equals("html") || sourceExtension.equals("ods") && targetExtension.equals("sxc") || sourceExtension.equals("ods") && targetExtension.equals("xlsx") || sourceExtension.equals("ods") && targetExtension.equals("xls") || sourceExtension.equals("odt") && targetExtension.equals("docx") || sourceExtension.equals("odt") && targetExtension.equals("txt") || sourceExtension.equals("ppt") && targetExtension.equals("html") || sourceExtension.equals("ppt") && targetExtension.equals("pptx") || sourceExtension.equals("sxc") && targetExtension.equals("xlsx") || sourceExtension.equals("sxi") && targetExtension.equals("odp") || sourceExtension.equals("sxi") && targetExtension.equals("pptx") || sourceExtension.equals("sxw") && targetExtension.equals("docx") || sourceExtension.equals("txt") && targetExtension.equals("docx") || sourceExtension.equals("txt") && targetExtension.equals("html") || sourceExtension.equals("txt") && targetExtension.equals("odt") || sourceExtension.equals("txt") && targetExtension.equals("pdf") || sourceExtension.equals("txt") && targetExtension.equals("rtf") || sourceExtension.equals("txt") && targetExtension.equals("sxw") || sourceExtension.equals("wpd") && targetExtension.equals("docx") || sourceExtension.equals("xls") && targetExtension.equals("ods") || sourceExtension.equals("xls") && targetExtension.equals("pdf") || sourceExtension.equals("xls") && targetExtension.equals("sxc") || sourceExtension.equals("xls") && targetExtension.equals("xlsx") || sourceExtension.equals("txt") && targetExtension.equals("doc") || sourceExtension.equals("pptx") && targetExtension.equals("html");
    }
}

