/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.PoiOOXMLContentTransformer;
import org.alfresco.service.cmr.repository.TransformationOptions;

public class PoiOOXMLContentTransformerTest
extends AbstractContentTransformerTest {
    private PoiOOXMLContentTransformer transformer;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.transformer = new PoiOOXMLContentTransformer();
        this.transformer.setMimetypeService(this.mimetypeService);
        this.transformer.setTransformerDebug(this.transformerDebug);
    }

    @Override
    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return this.transformer;
    }

    public void testIsTransformable() throws Exception {
        PoiOOXMLContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("text/plain", -1L, "application/vnd.openxmlformats-officedocument.wordprocessingml.document", new TransformationOptions()));
        PoiOOXMLContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.openxmlformats-officedocument.wordprocessingml.document", -1L, "text/plain", new TransformationOptions()));
        PoiOOXMLContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.openxmlformats-officedocument.wordprocessingml.document", -1L, "text/html", new TransformationOptions()));
        PoiOOXMLContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.openxmlformats-officedocument.wordprocessingml.document", -1L, "text/xml", new TransformationOptions()));
        PoiOOXMLContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("text/plain", -1L, "application/vnd.openxmlformats-officedocument.presentationml.presentation", new TransformationOptions()));
        PoiOOXMLContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.openxmlformats-officedocument.presentationml.presentation", -1L, "text/plain", new TransformationOptions()));
        PoiOOXMLContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.openxmlformats-officedocument.presentationml.presentation", -1L, "text/html", new TransformationOptions()));
        PoiOOXMLContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.openxmlformats-officedocument.presentationml.presentation", -1L, "text/xml", new TransformationOptions()));
        PoiOOXMLContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("text/plain", -1L, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", new TransformationOptions()));
        PoiOOXMLContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", -1L, "text/plain", new TransformationOptions()));
        PoiOOXMLContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", -1L, "text/html", new TransformationOptions()));
        PoiOOXMLContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", -1L, "text/xml", new TransformationOptions()));
    }
}

