/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform.magick;

import java.io.File;
import java.util.HashMap;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.transform.magick.AbstractImageMagickContentTransformerWorker;
import org.alfresco.repo.content.transform.magick.ImageCropOptions;
import org.alfresco.repo.content.transform.magick.ImageResizeOptions;
import org.alfresco.repo.content.transform.magick.ImageTransformationOptions;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.util.exec.RuntimeExec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImageMagickContentTransformerWorker
extends AbstractImageMagickContentTransformerWorker {
    private static final String KEY_OPTIONS = "options";
    private static final String VAR_SOURCE = "source";
    private static final String VAR_TARGET = "target";
    private static final Log logger = LogFactory.getLog(ImageMagickContentTransformerWorker.class);
    private RuntimeExec executer;
    private RuntimeExec checkCommand;
    private String versionString;

    public void setExecuter(RuntimeExec executer) {
        this.executer = executer;
    }

    public void setCheckCommand(RuntimeExec checkCommand) {
        this.checkCommand = checkCommand;
    }

    @Override
    public String getVersionString() {
        return this.versionString;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.executer == null) {
            throw new AlfrescoRuntimeException("System runtime executer not set");
        }
        super.afterPropertiesSet();
        if (this.isAvailable()) {
            try {
                RuntimeExec.ExecutionResult result = this.checkCommand.execute();
                this.versionString = result.getStdOut().trim();
            }
            catch (Throwable e) {
                this.setAvailable(false);
                logger.error((Object)(this.getClass().getSimpleName() + " not available: " + (e.getMessage() != null ? e.getMessage() : "")));
                logger.debug((Object)e);
            }
        }
    }

    @Override
    protected void transformInternal(File sourceFile, File targetFile, TransformationOptions options) throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>(5);
        if (options instanceof ImageTransformationOptions) {
            ImageTransformationOptions imageOptions = (ImageTransformationOptions)options;
            ImageCropOptions cropOptions = imageOptions.getCropOptions();
            ImageResizeOptions resizeOptions = imageOptions.getResizeOptions();
            String commandOptions = imageOptions.getCommandOptions();
            if (commandOptions == null) {
                commandOptions = "";
            }
            if (imageOptions.isAutoOrient()) {
                commandOptions = commandOptions + " -auto-orient";
            }
            if (cropOptions != null) {
                commandOptions = commandOptions + " " + this.getImageCropCommandOptions(cropOptions);
            }
            if (resizeOptions != null) {
                commandOptions = commandOptions + " " + this.getImageResizeCommandOptions(resizeOptions);
            }
            properties.put(KEY_OPTIONS, commandOptions);
        }
        properties.put(VAR_SOURCE, sourceFile.getAbsolutePath() + (options.getPageLimit() == 1 ? "[0]" : ""));
        properties.put(VAR_TARGET, targetFile.getAbsolutePath());
        long timeoutMs = options.getTimeoutMs();
        RuntimeExec.ExecutionResult result = this.executer.execute(properties, timeoutMs);
        if (result.getExitValue() != 0 && result.getStdErr() != null && result.getStdErr().length() > 0) {
            throw new ContentIOException("Failed to perform ImageMagick transformation: \n" + result);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ImageMagic executed successfully: \n" + this.executer));
        }
    }

    private String getImageCropCommandOptions(ImageCropOptions cropOptions) {
        int height;
        StringBuilder builder = new StringBuilder(32);
        String gravity = cropOptions.getGravity();
        if (gravity != null) {
            builder.append("-gravity ");
            builder.append(gravity);
            builder.append(" ");
        }
        builder.append("-crop ");
        int width = cropOptions.getWidth();
        if (width > -1) {
            builder.append(width);
        }
        if ((height = cropOptions.getHeight()) > -1) {
            builder.append("x");
            builder.append(height);
        }
        if (cropOptions.isPercentageCrop()) {
            builder.append("%");
        }
        this.appendOffset(builder, cropOptions.getXOffset());
        this.appendOffset(builder, cropOptions.getYOffset());
        builder.append(" +repage");
        return builder.toString();
    }

    private void appendOffset(StringBuilder builder, int xOffset) {
        if (xOffset >= 0) {
            builder.append("+");
        }
        builder.append(xOffset);
    }

    private String getImageResizeCommandOptions(ImageResizeOptions imageResizeOptions) {
        StringBuilder builder = new StringBuilder(32);
        if (imageResizeOptions.isResizeToThumbnail()) {
            builder.append("-thumbnail ");
        } else {
            builder.append("-resize ");
        }
        if (imageResizeOptions.getWidth() > -1) {
            builder.append(imageResizeOptions.getWidth());
        }
        if (imageResizeOptions.getHeight() > -1) {
            builder.append("x");
            builder.append(imageResizeOptions.getHeight());
        }
        if (imageResizeOptions.isPercentResize()) {
            builder.append("%");
        }
        if (!imageResizeOptions.getAllowEnlargement()) {
            builder.append(">");
        }
        if (!imageResizeOptions.isMaintainAspectRatio()) {
            builder.append("!");
        }
        return builder.toString();
    }
}

