/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.copy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.query.CannedQuery;
import org.alfresco.query.CannedQueryFactory;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.action.ActionServiceImpl;
import org.alfresco.repo.copy.CompoundCopyBehaviourCallback;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.copy.DefaultCopyBehaviourCallback;
import org.alfresco.repo.copy.DoNothingCopyBehaviourCallback;
import org.alfresco.repo.copy.query.AbstractCopyCannedQueryFactory;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ChildAssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.CopyServiceException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PublicServiceAccessService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.registry.NamedObjectRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.surf.util.ParameterCheck;

public class CopyServiceImpl
implements CopyService {
    private static Log logger = LogFactory.getLog(ActionServiceImpl.class);
    private static final String QUERY_FACTORY_GET_COPIES = "getCopiesCannedQueryFactory";
    private static final String COPY_OF_LABEL = "copy_service.copy_of_label";
    private NodeService nodeService;
    private NodeService internalNodeService;
    private NamedObjectRegistry<CannedQueryFactory<CopyService.CopyInfo>> cannedQueryRegistry;
    private DictionaryService dictionaryService;
    private PolicyComponent policyComponent;
    private RuleService ruleService;
    private PermissionService permissionService;
    private PublicServiceAccessService publicServiceAccessService;
    private ClassPolicyDelegate<CopyServicePolicies.OnCopyNodePolicy> onCopyNodeDelegate;
    private ClassPolicyDelegate<CopyServicePolicies.OnCopyCompletePolicy> onCopyCompleteDelegate;
    private ClassPolicyDelegate<CopyServicePolicies.BeforeCopyPolicy> beforeCopyDelegate;
    private static final String KEY_POST_COPY_ASSOCS = "CopyServiceImpl.postCopyAssocs";

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setInternalNodeService(NodeService internalNodeService) {
        this.internalNodeService = internalNodeService;
    }

    public void setCannedQueryRegistry(NamedObjectRegistry<CannedQueryFactory<CopyService.CopyInfo>> cannedQueryRegistry) {
        this.cannedQueryRegistry = cannedQueryRegistry;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setPublicServiceAccessService(PublicServiceAccessService publicServiceAccessService) {
        this.publicServiceAccessService = publicServiceAccessService;
    }

    public void init() {
        this.onCopyNodeDelegate = this.policyComponent.registerClassPolicy(CopyServicePolicies.OnCopyNodePolicy.class);
        this.onCopyCompleteDelegate = this.policyComponent.registerClassPolicy(CopyServicePolicies.OnCopyCompletePolicy.class);
        this.beforeCopyDelegate = this.policyComponent.registerClassPolicy(CopyServicePolicies.BeforeCopyPolicy.class);
        this.policyComponent.bindAssociationBehaviour(NodeServicePolicies.BeforeDeleteAssociationPolicy.QNAME, ContentModel.ASPECT_COPIEDFROM, ContentModel.ASSOC_ORIGINAL, new JavaBehaviour(this, "beforeDeleteOriginalAssociation"));
        this.policyComponent.bindClassBehaviour(CopyServicePolicies.OnCopyNodePolicy.QNAME, ContentModel.ASPECT_COPIEDFROM, (Behaviour)new JavaBehaviour(this, "getCallbackForCopiedFromAspect"));
        this.policyComponent.bindClassBehaviour(CopyServicePolicies.OnCopyNodePolicy.QNAME, ContentModel.TYPE_FOLDER, (Behaviour)new JavaBehaviour(this, "getCallbackForFolderType"));
        this.policyComponent.bindClassBehaviour(CopyServicePolicies.OnCopyNodePolicy.QNAME, ContentModel.ASPECT_OWNABLE, (Behaviour)new JavaBehaviour(this, "getCallbackForOwnableAspect"));
    }

    @Override
    public NodeRef copy(NodeRef sourceNodeRef, NodeRef targetParentRef, QName assocTypeQName, QName assocQName, boolean copyChildren) {
        ParameterCheck.mandatory((String)"sourceNodeRef", (Object)sourceNodeRef);
        ParameterCheck.mandatory((String)"targetParentRef", (Object)targetParentRef);
        ParameterCheck.mandatory((String)"assocTypeQName", (Object)assocTypeQName);
        ParameterCheck.mandatory((String)"assocQName", (Object)assocQName);
        if (!sourceNodeRef.getStoreRef().equals((Object)targetParentRef.getStoreRef())) {
            throw new UnsupportedOperationException("Copying nodes across stores is not currently supported.");
        }
        TransactionalResourceHelper.getList(KEY_POST_COPY_ASSOCS).clear();
        HashMap<NodeRef, NodeRef> copiesByOriginals = new HashMap<NodeRef, NodeRef>(17);
        HashSet<NodeRef> copies = new HashSet<NodeRef>(17);
        NodeRef copiedNodeRef = this.copyImpl(sourceNodeRef, targetParentRef, assocTypeQName, assocQName, copyChildren, true, copiesByOriginals, copies);
        if (copiedNodeRef == null) {
            CopyDetails copyDetails = this.getCopyDetails(sourceNodeRef, targetParentRef, null, assocTypeQName, assocQName);
            throw new CopyServiceException("A bound policy denied copy: \n   " + copyDetails);
        }
        this.copyPendingAssociations(copiesByOriginals);
        for (Map.Entry entry : copiesByOriginals.entrySet()) {
            NodeRef mappedSourceNodeRef = (NodeRef)entry.getKey();
            NodeRef mappedTargetNodeRef = (NodeRef)entry.getValue();
            this.invokeCopyComplete(mappedSourceNodeRef, mappedTargetNodeRef, true, copiesByOriginals);
        }
        return copiedNodeRef;
    }

    @Override
    public NodeRef copyAndRename(NodeRef sourceNodeRef, NodeRef destinationParent, QName assocTypeQName, QName assocQName, boolean copyChildren) {
        String sourceName;
        NodeRef result = null;
        String newName = sourceName = (String)((Object)this.internalNodeService.getProperty(sourceNodeRef, ContentModel.PROP_NAME));
        while (this.internalNodeService.getChildByName(destinationParent, assocTypeQName, newName) != null) {
            newName = I18NUtil.getMessage((String)COPY_OF_LABEL, (Object[])new Object[]{newName});
        }
        if (assocQName == null) {
            assocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)newName));
        }
        result = this.copy(sourceNodeRef, destinationParent, assocTypeQName, assocQName, copyChildren);
        this.internalNodeService.setProperty(result, ContentModel.PROP_NAME, (Serializable)((Object)newName));
        return result;
    }

    @Override
    public NodeRef copy(NodeRef sourceNodeRef, NodeRef targetParentNodeRef, QName assocTypeQName, QName assocQName) {
        return this.copy(sourceNodeRef, targetParentNodeRef, assocTypeQName, assocQName, false);
    }

    @Override
    public void copy(NodeRef sourceNodeRef, NodeRef targetNodeRef) {
        QName targetNodeTypeQName;
        QName sourceNodeTypeQName = this.nodeService.getType(sourceNodeRef);
        if (!sourceNodeTypeQName.equals((Object)(targetNodeTypeQName = this.nodeService.getType(targetNodeRef)))) {
            throw new CopyServiceException("The source and destination node must be the same type.");
        }
        ChildAssociationRef destinationPrimaryAssocRef = this.nodeService.getPrimaryParent(targetNodeRef);
        NodeRef destinationParentNodeRef = destinationPrimaryAssocRef.getParentRef();
        QName assocTypeQName = destinationPrimaryAssocRef.getTypeQName();
        QName assocQName = destinationPrimaryAssocRef.getQName();
        CopyDetails copyDetails = this.getCopyDetails(sourceNodeRef, destinationParentNodeRef, targetNodeRef, assocTypeQName, assocQName);
        Map<QName, CopyBehaviourCallback> callbacks = this.getCallbacks(copyDetails);
        this.invokeBeforeCopy(sourceNodeRef, targetNodeRef);
        TransactionalResourceHelper.getList(KEY_POST_COPY_ASSOCS).clear();
        this.copyProperties(copyDetails, targetNodeRef, sourceNodeTypeQName, callbacks);
        this.copyAspects(copyDetails, targetNodeRef, Collections.<QName>emptySet(), callbacks);
        this.copyResidualProperties(copyDetails, targetNodeRef);
        HashMap<NodeRef, NodeRef> copiedNodeRefs = new HashMap<NodeRef, NodeRef>(1);
        copiedNodeRefs.put(sourceNodeRef, targetNodeRef);
        HashSet<NodeRef> copies = new HashSet<NodeRef>(5);
        this.copyChildren(copyDetails, targetNodeRef, false, true, copiedNodeRefs, copies, callbacks);
        this.copyPendingAssociations(copiedNodeRefs);
        this.invokeCopyComplete(sourceNodeRef, targetNodeRef, false, copiedNodeRefs);
    }

    @Override
    public NodeRef getOriginal(NodeRef nodeRef) {
        List assocs = this.internalNodeService.getTargetAssocs(nodeRef, (QNamePattern)ContentModel.ASSOC_ORIGINAL);
        if (assocs.size() > 1) {
            logger.warn((Object)("Multiple cm:orignal associations from node: " + nodeRef));
        }
        if (assocs.size() == 0) {
            return null;
        }
        return ((AssociationRef)assocs.get(0)).getTargetRef();
    }

    @Override
    public List<NodeRef> getCopies(NodeRef nodeRef) {
        PagingRequest pagingRequest = new PagingRequest(1000);
        PagingResults<CopyService.CopyInfo> page = this.getCopies(nodeRef, pagingRequest);
        if (page.hasMoreItems()) {
            logger.warn((Object)"Trimmed page size for deprecated getCopies() call.");
        }
        List pageResults = page.getPage();
        ArrayList<NodeRef> results = new ArrayList<NodeRef>(pageResults.size());
        for (CopyService.CopyInfo copyInfo : pageResults) {
            results.add(copyInfo.getNodeRef());
        }
        return results;
    }

    @Override
    public PagingResults<CopyService.CopyInfo> getCopies(NodeRef originalNodeRef, PagingRequest pagingRequest) {
        CannedQueryFactory queryFactory = (CannedQueryFactory)this.cannedQueryRegistry.getNamedObject(QUERY_FACTORY_GET_COPIES);
        CannedQueryParameters params = new CannedQueryParameters((Object)new AbstractCopyCannedQueryFactory.CopyCannedQueryDetail(originalNodeRef), null, pagingRequest);
        CannedQuery query = queryFactory.getCannedQuery(params);
        return query.execute();
    }

    @Override
    public PagingResults<CopyService.CopyInfo> getCopies(NodeRef originalNodeRef, NodeRef copyParentNodeRef, PagingRequest pagingRequest) {
        CannedQueryFactory queryFactory = (CannedQueryFactory)this.cannedQueryRegistry.getNamedObject(QUERY_FACTORY_GET_COPIES);
        CannedQueryParameters params = new CannedQueryParameters((Object)new AbstractCopyCannedQueryFactory.CopyCannedQueryDetail(originalNodeRef, copyParentNodeRef), null, pagingRequest);
        CannedQuery query = queryFactory.getCannedQuery(params);
        return query.execute();
    }

    private NodeRef copyImpl(NodeRef sourceNodeRef, NodeRef targetParentRef, QName assocTypeQName, QName assocQName, boolean copyChildren, boolean dropName, Map<NodeRef, NodeRef> copiesByOriginals, Set<NodeRef> copies) {
        QName sourceNodeTypeQName;
        CopyDetails copyDetails = this.getCopyDetails(sourceNodeRef, targetParentRef, null, assocTypeQName, assocQName);
        Map<QName, CopyBehaviourCallback> callbacks = this.getCallbacks(copyDetails);
        CopyBehaviourCallback callback = callbacks.get(sourceNodeTypeQName = copyDetails.getSourceNodeTypeQName());
        if (callback == null) {
            throw new IllegalStateException("Source node type has no callback: " + sourceNodeTypeQName);
        }
        if (!callback.getMustCopy(sourceNodeTypeQName, copyDetails)) {
            return null;
        }
        NodeRef copiedNodeRef = this.recursiveCopy(copyDetails, copyChildren, dropName, copiesByOriginals, copies, callbacks);
        return copiedNodeRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeRef recursiveCopy(CopyDetails copyDetails, boolean copyChildren, boolean dropName, Map<NodeRef, NodeRef> copiesByOriginal, Set<NodeRef> copies, Map<QName, CopyBehaviourCallback> callbacks) {
        NodeRef sourceNodeRef = copyDetails.getSourceNodeRef();
        Set<QName> sourceNodeAspectQNames = copyDetails.getSourceNodeAspectQNames();
        NodeRef targetParentNodeRef = copyDetails.getTargetParentNodeRef();
        QName assocTypeQName = copyDetails.getAssocTypeQName();
        QName assocQName = copyDetails.getAssocQName();
        if (copies.contains(sourceNodeRef)) {
            throw new IllegalStateException("Nested copy prevention has failed: \n   " + copyDetails + "\n" + "   Copies by original: " + copiesByOriginal);
        }
        if (copiesByOriginal.containsKey(sourceNodeRef)) {
            throw new IllegalStateException("Multiple child assocs between same two nodes detected: \n   " + copyDetails + "\n" + "   Copies by original: " + copiesByOriginal);
        }
        QName sourceNodeTypeQName = copyDetails.getSourceNodeTypeQName();
        CopyBehaviourCallback sourceTypeBehaviour = callbacks.get(sourceNodeTypeQName);
        if (sourceTypeBehaviour == null) {
            throw new IllegalStateException("Source node type has no callback: " + sourceNodeTypeQName);
        }
        if (!sourceTypeBehaviour.getMustCopy(sourceNodeTypeQName, copyDetails)) {
            return null;
        }
        Map<QName, Serializable> targetNodeProperties = this.buildCopyProperties(copyDetails, Collections.singleton(sourceNodeTypeQName), callbacks);
        Set<QName> defaultAspectQNames = this.getDefaultAspects(sourceNodeTypeQName);
        Map<QName, Serializable> defaultAspectsProperties = this.buildCopyProperties(copyDetails, defaultAspectQNames, callbacks);
        targetNodeProperties.putAll(defaultAspectsProperties);
        AssociationDefinition assocDef = this.dictionaryService.getAssociation(assocTypeQName);
        if (!assocDef.isChild()) {
            throw new AlfrescoRuntimeException("Association is not a child association: " + assocTypeQName);
        }
        ChildAssociationDefinition childAssocDef = (ChildAssociationDefinition)assocDef;
        if (dropName && !childAssocDef.getDuplicateChildNamesAllowed()) {
            targetNodeProperties.remove(ContentModel.PROP_NAME);
        }
        String targetNodeUuid = copyDetails.getTargetNodeRef().getId();
        targetNodeProperties.put(ContentModel.PROP_NODE_UUID, (Serializable)((Object)targetNodeUuid));
        ChildAssociationRef targetChildAssocRef = this.nodeService.createNode(targetParentNodeRef, assocTypeQName, assocQName, sourceNodeTypeQName, targetNodeProperties);
        NodeRef copyTarget = targetChildAssocRef.getChildRef();
        copiesByOriginal.put(sourceNodeRef, copyTarget);
        copies.add(copyTarget);
        this.invokeBeforeCopy(sourceNodeRef, copyTarget);
        HashSet<QName> remainingAspectQNames = new HashSet<QName>(sourceNodeAspectQNames);
        remainingAspectQNames.removeAll(defaultAspectQNames);
        this.ruleService.disableRules(copyTarget);
        try {
            for (QName remainingAspectQName : remainingAspectQNames) {
                this.copyProperties(copyDetails, copyTarget, remainingAspectQName, callbacks);
            }
            this.copyResidualProperties(copyDetails, copyTarget);
            List originalAssocs = this.internalNodeService.getTargetAssocs(copyTarget, (QNamePattern)ContentModel.ASSOC_ORIGINAL);
            for (AssociationRef originalAssoc : originalAssocs) {
                this.internalNodeService.removeAssociation(originalAssoc.getSourceRef(), originalAssoc.getTargetRef(), ContentModel.ASSOC_ORIGINAL);
            }
            QName sourceTypeQName = this.internalNodeService.getType(sourceNodeRef);
            if (this.dictionaryService.isSubClass(sourceTypeQName, ContentModel.TYPE_CMOBJECT) && !sourceNodeAspectQNames.contains(ContentModel.ASPECT_PENDING_DELETE)) {
                this.internalNodeService.createAssociation(copyTarget, sourceNodeRef, ContentModel.ASSOC_ORIGINAL);
            } else {
                this.internalNodeService.removeAspect(copyTarget, ContentModel.ASPECT_COPIEDFROM);
            }
            this.copyPermissions(sourceNodeRef, copyTarget);
            this.copyChildren(copyDetails, copyTarget, true, copyChildren, copiesByOriginal, copies, callbacks);
        }
        finally {
            this.ruleService.enableRules(copyTarget);
        }
        return copyTarget;
    }

    private Set<QName> getDefaultAspects(QName sourceNodeTypeQName) {
        TypeDefinition sourceNodeTypeDef = this.dictionaryService.getType(sourceNodeTypeQName);
        if (sourceNodeTypeDef == null) {
            return Collections.emptySet();
        }
        HashSet<QName> defaultAspectQNames = new HashSet<QName>(7);
        for (AspectDefinition aspectDef : sourceNodeTypeDef.getDefaultAspects()) {
            defaultAspectQNames.add(aspectDef.getName());
        }
        return defaultAspectQNames;
    }

    private Map<QName, Serializable> buildCopyProperties(CopyDetails copyDetails, Set<QName> classQNames, Map<QName, CopyBehaviourCallback> callbacks) {
        Map<QName, Serializable> sourceNodeProperties = copyDetails.getSourceNodeProperties();
        HashMap<QName, Serializable> copyProperties = new HashMap<QName, Serializable>(sourceNodeProperties.size(), 1.0f);
        HashMap<QName, Serializable> scratchProperties = new HashMap<QName, Serializable>(11);
        for (QName classQName : classQNames) {
            ClassDefinition classDef;
            CopyBehaviourCallback callback = callbacks.get(classQName);
            if (callback == null) {
                throw new IllegalStateException("Source node class has no callback: " + classQName);
            }
            if (!callback.getMustCopy(classQName, copyDetails) || (classDef = this.dictionaryService.getClass(classQName)) == null) continue;
            Map propertyDefs = classDef.getProperties();
            scratchProperties.clear();
            for (QName propertyQName : propertyDefs.keySet()) {
                if (!sourceNodeProperties.containsKey(propertyQName)) continue;
                Serializable value = sourceNodeProperties.get(propertyQName);
                scratchProperties.put(propertyQName, value);
            }
            Map<QName, Serializable> propsToCopy = callback.getCopyProperties(classQName, copyDetails, scratchProperties);
            copyProperties.putAll(propsToCopy);
        }
        return copyProperties;
    }

    private void invokeBeforeCopy(NodeRef sourceNodeRef, NodeRef targetNodeRef) {
        QName targetClassRef = this.internalNodeService.getType(targetNodeRef);
        this.invokeBeforeCopy(targetClassRef, sourceNodeRef, targetNodeRef);
        Set targetAspects = this.nodeService.getAspects(targetNodeRef);
        for (QName targetAspect : targetAspects) {
            this.invokeBeforeCopy(targetAspect, sourceNodeRef, targetNodeRef);
        }
    }

    private void invokeBeforeCopy(QName typeQName, NodeRef sourceNodeRef, NodeRef targetNodeRef) {
        Collection<CopyServicePolicies.BeforeCopyPolicy> policies = this.beforeCopyDelegate.getList(typeQName);
        for (CopyServicePolicies.BeforeCopyPolicy policy : policies) {
            policy.beforeCopy(typeQName, sourceNodeRef, targetNodeRef);
        }
    }

    private void invokeCopyComplete(NodeRef sourceNodeRef, NodeRef targetNodeRef, boolean copyToNewNode, Map<NodeRef, NodeRef> copiedNodeRefs) {
        QName sourceClassRef = this.internalNodeService.getType(sourceNodeRef);
        this.invokeCopyComplete(sourceClassRef, sourceNodeRef, targetNodeRef, copyToNewNode, copiedNodeRefs);
        Set sourceAspects = this.nodeService.getAspects(sourceNodeRef);
        for (QName sourceAspect : sourceAspects) {
            this.invokeCopyComplete(sourceAspect, sourceNodeRef, targetNodeRef, copyToNewNode, copiedNodeRefs);
        }
    }

    private void invokeCopyComplete(QName typeQName, NodeRef sourceNodeRef, NodeRef targetNodeRef, boolean copyToNewNode, Map<NodeRef, NodeRef> copiedNodeRefs) {
        Collection<CopyServicePolicies.OnCopyCompletePolicy> policies = this.onCopyCompleteDelegate.getList(typeQName);
        for (CopyServicePolicies.OnCopyCompletePolicy policy : policies) {
            policy.onCopyComplete(typeQName, sourceNodeRef, targetNodeRef, copyToNewNode, copiedNodeRefs);
        }
    }

    private void copyPendingAssociations(Map<NodeRef, NodeRef> copiedNodeRefs) {
        List<Pair> postCopyAssocs = TransactionalResourceHelper.getList(KEY_POST_COPY_ASSOCS);
        block5: for (Pair pair : postCopyAssocs) {
            AssociationRef assocRef = (AssociationRef)pair.getFirst();
            CopyBehaviourCallback.AssocCopyTargetAction action = (CopyBehaviourCallback.AssocCopyTargetAction)pair.getSecond();
            NodeRef newSourceForAssoc = copiedNodeRefs.get(assocRef.getSourceRef());
            if (newSourceForAssoc == null) {
                throw new IllegalStateException("Post-copy association has a source that was NOT copied.");
            }
            NodeRef oldTargetForAssoc = assocRef.getTargetRef();
            NodeRef newTargetForAssoc = copiedNodeRefs.get(oldTargetForAssoc);
            QName assocTypeQName = assocRef.getTypeQName();
            switch (action) {
                case USE_ORIGINAL_TARGET: {
                    this.internalNodeService.createAssociation(newSourceForAssoc, oldTargetForAssoc, assocTypeQName);
                    continue block5;
                }
                case USE_COPIED_TARGET: {
                    if (newTargetForAssoc == null) continue block5;
                    this.internalNodeService.createAssociation(newSourceForAssoc, newTargetForAssoc, assocTypeQName);
                    continue block5;
                }
                case USE_COPIED_OTHERWISE_ORIGINAL_TARGET: {
                    if (newTargetForAssoc == null) {
                        this.internalNodeService.createAssociation(newSourceForAssoc, oldTargetForAssoc, assocTypeQName);
                        continue block5;
                    }
                    this.internalNodeService.createAssociation(newSourceForAssoc, newTargetForAssoc, assocTypeQName);
                    continue block5;
                }
            }
            throw new IllegalStateException("Unknown association action: " + action);
        }
    }

    private void copyPermissions(NodeRef sourceNodeRef, NodeRef destinationNodeRef) {
        if (this.publicServiceAccessService.hasAccess("PermissionService", "getAllSetPermissions", sourceNodeRef) == AccessStatus.ALLOWED && this.publicServiceAccessService.hasAccess("PermissionService", "getInheritParentPermissions", sourceNodeRef) == AccessStatus.ALLOWED) {
            Set permissions = this.permissionService.getAllSetPermissions(sourceNodeRef);
            boolean includeInherited = this.permissionService.getInheritParentPermissions(sourceNodeRef);
            if (this.publicServiceAccessService.hasAccess("PermissionService", "setPermission", destinationNodeRef, "dummyAuth", "dummyPermission", true) == AccessStatus.ALLOWED && this.publicServiceAccessService.hasAccess("PermissionService", "setInheritParentPermissions", destinationNodeRef, includeInherited) == AccessStatus.ALLOWED) {
                for (AccessPermission permission : permissions) {
                    if (!permission.isSetDirectly()) continue;
                    this.permissionService.setPermission(destinationNodeRef, permission.getAuthority(), permission.getPermission(), permission.getAccessStatus().equals((Object)AccessStatus.ALLOWED));
                }
                this.permissionService.setInheritParentPermissions(destinationNodeRef, includeInherited);
            }
        }
    }

    private CopyDetails getCopyDetails(NodeRef sourceNodeRef, NodeRef targetParentNodeRef, NodeRef targetNodeRef, QName assocTypeQName, QName assocQName) {
        QName sourceNodeTypeQName = this.nodeService.getType(sourceNodeRef);
        Map sourceNodeProperties = this.internalNodeService.getProperties(sourceNodeRef);
        Set sourceNodeAspectQNames = this.internalNodeService.getAspects(sourceNodeRef);
        boolean targetNodeIsNew = false;
        if (targetNodeRef == null) {
            targetNodeRef = new NodeRef(targetParentNodeRef.getStoreRef(), GUID.generate());
            targetNodeIsNew = true;
        }
        CopyDetails copyDetails = new CopyDetails(sourceNodeRef, sourceNodeTypeQName, sourceNodeAspectQNames, sourceNodeProperties, targetParentNodeRef, targetNodeRef, targetNodeIsNew, assocTypeQName, assocQName);
        return copyDetails;
    }

    private Map<QName, CopyBehaviourCallback> getCallbacks(CopyDetails copyDetails) {
        QName sourceNodeTypeQName = copyDetails.getSourceNodeTypeQName();
        HashMap<QName, CopyBehaviourCallback> callbacks = new HashMap<QName, CopyBehaviourCallback>(11);
        CopyBehaviourCallback callback = this.getCallback(sourceNodeTypeQName, copyDetails);
        callbacks.put(sourceNodeTypeQName, callback);
        for (QName sourceNodeAspectQName : copyDetails.getSourceNodeAspectQNames()) {
            callback = this.getCallback(sourceNodeAspectQName, copyDetails);
            callbacks.put(sourceNodeAspectQName, callback);
        }
        return callbacks;
    }

    private CopyBehaviourCallback getCallback(QName sourceClassQName, CopyDetails copyDetails) {
        Collection<CopyServicePolicies.OnCopyNodePolicy> policies = this.onCopyNodeDelegate.getList(sourceClassQName);
        ClassDefinition sourceClassDef = this.dictionaryService.getClass(sourceClassQName);
        CopyBehaviourCallback callback = null;
        if (sourceClassDef == null) {
            callback = DoNothingCopyBehaviourCallback.getInstance();
        }
        if (policies.isEmpty()) {
            callback = DefaultCopyBehaviourCallback.getInstance();
        } else if (policies.size() == 1) {
            callback = policies.iterator().next().getCopyCallback(sourceClassQName, copyDetails);
        } else {
            CompoundCopyBehaviourCallback compoundCallback = new CompoundCopyBehaviourCallback(sourceClassQName);
            for (CopyServicePolicies.OnCopyNodePolicy policy : policies) {
                CopyBehaviourCallback nestedCallback = policy.getCopyCallback(sourceClassQName, copyDetails);
                compoundCallback.addBehaviour(nestedCallback);
            }
            callback = compoundCallback;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Fetched copy callback: \n   Class:                      " + sourceClassQName + "\n" + "   Details:                    " + copyDetails + "\n" + "   Callback: " + callback));
        }
        return callback;
    }

    private void copyProperties(CopyDetails copyDetails, NodeRef targetNodeRef, QName classQName, Map<QName, CopyBehaviourCallback> callbacks) {
        ClassDefinition targetClassDef = this.dictionaryService.getClass(classQName);
        if (targetClassDef == null) {
            return;
        }
        CopyBehaviourCallback callback = callbacks.get(classQName);
        if (callback == null) {
            throw new IllegalStateException("Source node class has no callback: " + classQName);
        }
        if (!callback.getMustCopy(classQName, copyDetails)) {
            return;
        }
        Map<QName, Serializable> classProperties = this.buildCopyProperties(copyDetails, Collections.singleton(classQName), callbacks);
        if (targetClassDef.isAspect()) {
            this.internalNodeService.addAspect(targetNodeRef, classQName, classProperties);
        } else {
            this.internalNodeService.addProperties(targetNodeRef, classProperties);
        }
    }

    private void copyResidualProperties(CopyDetails copyDetails, NodeRef targetNodeRef) {
        HashMap<QName, Serializable> residualProperties = new HashMap<QName, Serializable>();
        residualProperties.putAll(copyDetails.getSourceNodeProperties());
        QName sourceNodeTypeQName = copyDetails.getSourceNodeTypeQName();
        HashSet<QName> knownClassQNames = new HashSet<QName>(13);
        knownClassQNames.addAll(this.getDefaultAspects(sourceNodeTypeQName));
        knownClassQNames.addAll(copyDetails.getSourceNodeAspectQNames());
        knownClassQNames.add(sourceNodeTypeQName);
        block0: for (QName knownClassQName : knownClassQNames) {
            ClassDefinition classDef = this.dictionaryService.getClass(knownClassQName);
            if (classDef == null) continue;
            for (QName definedPropQName : classDef.getProperties().keySet()) {
                residualProperties.remove(definedPropQName);
                if (residualProperties.size() != 0) continue;
                continue block0;
            }
        }
        if (residualProperties.size() > 0) {
            this.internalNodeService.addProperties(targetNodeRef, residualProperties);
        }
    }

    private void copyAspects(CopyDetails copyDetails, NodeRef targetNodeRef, Set<QName> aspectsToIgnore, Map<QName, CopyBehaviourCallback> callbacks) {
        Set<QName> sourceAspectQNames = copyDetails.getSourceNodeAspectQNames();
        for (QName aspectQName : sourceAspectQNames) {
            if (aspectsToIgnore.contains(aspectQName)) continue;
            CopyBehaviourCallback callback = callbacks.get(aspectQName);
            if (callback == null) {
                throw new IllegalStateException("Source aspect class has no callback: " + aspectQName);
            }
            if (!callback.getMustCopy(aspectQName, copyDetails)) continue;
            this.copyProperties(copyDetails, targetNodeRef, aspectQName, callbacks);
        }
    }

    private void copyChildren(CopyDetails copyDetails, NodeRef copyTarget, boolean copyTargetIsNew, boolean copyChildren, Map<NodeRef, NodeRef> copiesByOriginals, Set<NodeRef> copies, Map<QName, CopyBehaviourCallback> callbacks) {
        QName sourceNodeTypeQName = copyDetails.getSourceNodeTypeQName();
        Set<QName> sourceNodeAspectQNames = copyDetails.getSourceNodeAspectQNames();
        this.copyChildren(copyDetails, sourceNodeTypeQName, copyTarget, copyTargetIsNew, copyChildren, copiesByOriginals, copies, callbacks);
        for (QName aspectQName : sourceNodeAspectQNames) {
            AspectDefinition aspectDef = this.dictionaryService.getAspect(aspectQName);
            if (aspectDef == null) continue;
            this.copyChildren(copyDetails, aspectQName, copyTarget, copyTargetIsNew, copyChildren, copiesByOriginals, copies, callbacks);
        }
    }

    private void copyChildren(CopyDetails copyDetails, QName classQName, NodeRef copyTarget, boolean copyTargetIsNew, boolean copyChildren, Map<NodeRef, NodeRef> copiesByOriginals, Set<NodeRef> copies, Map<QName, CopyBehaviourCallback> callbacks) {
        NodeRef sourceNodeRef = copyDetails.getSourceNodeRef();
        ClassDefinition classDef = this.dictionaryService.getClass(classQName);
        if (classDef == null) {
            return;
        }
        CopyBehaviourCallback callback = callbacks.get(classQName);
        if (callback == null) {
            throw new IllegalStateException("Source node class has no callback: " + classQName);
        }
        List postCopyAssocs = TransactionalResourceHelper.getList(KEY_POST_COPY_ASSOCS);
        for (Map.Entry entry : classDef.getAssociations().entrySet()) {
            QName assocTypeQName = (QName)entry.getKey();
            AssociationDefinition assocDef = (AssociationDefinition)entry.getValue();
            if (assocDef.isChild()) continue;
            boolean haveRemovedFromCopyTarget = false;
            List assocRefs = this.nodeService.getTargetAssocs(sourceNodeRef, (QNamePattern)assocTypeQName);
            block18: for (AssociationRef assocRef : assocRefs) {
                CopyBehaviourCallback.CopyAssociationDetails assocCopyDetails = new CopyBehaviourCallback.CopyAssociationDetails(assocRef, copyTarget, copyTargetIsNew);
                Pair<CopyBehaviourCallback.AssocCopySourceAction, CopyBehaviourCallback.AssocCopyTargetAction> assocCopyAction = callback.getAssociationCopyAction(classQName, copyDetails, assocCopyDetails);
                switch ((CopyBehaviourCallback.AssocCopySourceAction)assocCopyAction.getFirst()) {
                    case IGNORE: {
                        continue block18;
                    }
                    case COPY_REMOVE_EXISTING: {
                        if (!copyTargetIsNew && !haveRemovedFromCopyTarget) {
                            haveRemovedFromCopyTarget = true;
                            for (AssociationRef assocToRemoveRef : this.internalNodeService.getTargetAssocs(copyTarget, (QNamePattern)assocTypeQName)) {
                                this.internalNodeService.removeAssociation(assocToRemoveRef.getSourceRef(), assocToRemoveRef.getTargetRef(), assocTypeQName);
                            }
                        }
                    }
                    case COPY: {
                        switch ((CopyBehaviourCallback.AssocCopyTargetAction)assocCopyAction.getSecond()) {
                            case USE_ORIGINAL_TARGET: 
                            case USE_COPIED_TARGET: 
                            case USE_COPIED_OTHERWISE_ORIGINAL_TARGET: {
                                postCopyAssocs.add(new Pair((Object)assocRef, assocCopyAction.getSecond()));
                                continue block18;
                            }
                        }
                        throw new IllegalStateException("Unknown association target copy action: " + assocCopyAction);
                    }
                }
                throw new IllegalStateException("Unknown association source copy action: " + assocCopyAction);
            }
        }
        for (Map.Entry childEntry : classDef.getChildAssociations().entrySet()) {
            QName childAssocTypeQName = (QName)childEntry.getKey();
            ChildAssociationDefinition childAssocDef = (ChildAssociationDefinition)childEntry.getValue();
            if (!childAssocDef.isChild()) continue;
            List childAssocRefs = this.nodeService.getChildAssocs(sourceNodeRef, (QNamePattern)childAssocTypeQName, RegexQNamePattern.MATCH_ALL);
            block21: for (ChildAssociationRef childAssocRef : childAssocRefs) {
                NodeRef childNodeRef = childAssocRef.getChildRef();
                QName assocQName = childAssocRef.getQName();
                CopyBehaviourCallback.CopyChildAssociationDetails childAssocCopyDetails = new CopyBehaviourCallback.CopyChildAssociationDetails(childAssocRef, copyTarget, copyTargetIsNew, copyChildren);
                if (copies.contains(childNodeRef)) continue;
                CopyBehaviourCallback.ChildAssocCopyAction childAssocCopyAction = callback.getChildAssociationCopyAction(classQName, copyDetails, childAssocCopyDetails);
                switch (childAssocCopyAction) {
                    case IGNORE: {
                        continue block21;
                    }
                    case COPY_ASSOC: {
                        this.nodeService.addChild(copyTarget, childNodeRef, childAssocTypeQName, assocQName);
                        continue block21;
                    }
                    case COPY_CHILD: {
                        if (copiesByOriginals.containsKey(childNodeRef)) {
                            this.nodeService.addChild(copyTarget, childNodeRef, childAssocTypeQName, assocQName);
                            continue block21;
                        }
                        CopyBehaviourCallback.ChildAssocRecurseAction childAssocRecurseAction = callback.getChildAssociationRecurseAction(classQName, copyDetails, childAssocCopyDetails);
                        switch (childAssocRecurseAction) {
                            case RESPECT_RECURSE_FLAG: {
                                break;
                            }
                            case FORCE_RECURSE: {
                                copyChildren = true;
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unrecognized enum");
                            }
                        }
                        this.copyImpl(childNodeRef, copyTarget, childAssocTypeQName, assocQName, copyChildren, false, copiesByOriginals, copies);
                        continue block21;
                    }
                }
                throw new IllegalStateException("Unrecognized enum");
            }
        }
    }

    public void beforeDeleteOriginalAssociation(AssociationRef nodeAssocRef) {
        NodeRef sourceNodeRef = nodeAssocRef.getSourceRef();
        this.internalNodeService.removeAspect(sourceNodeRef, ContentModel.ASPECT_COPIEDFROM);
    }

    public CopyBehaviourCallback getCallbackForCopiedFromAspect(QName classRef, CopyDetails copyDetails) {
        return DoNothingCopyBehaviourCallback.getInstance();
    }

    public CopyBehaviourCallback getCallbackForFolderType(QName classRef, CopyDetails copyDetails) {
        return FolderTypeCopyBehaviourCallback.INSTANCE;
    }

    public CopyBehaviourCallback getCallbackForOwnableAspect(QName classRef, CopyDetails copyDetails) {
        return DoNothingCopyBehaviourCallback.getInstance();
    }

    private static class FolderTypeCopyBehaviourCallback
    extends DefaultCopyBehaviourCallback {
        private static final CopyBehaviourCallback INSTANCE = new FolderTypeCopyBehaviourCallback();

        private FolderTypeCopyBehaviourCallback() {
        }

        @Override
        public CopyBehaviourCallback.ChildAssocCopyAction getChildAssociationCopyAction(QName classQName, CopyDetails copyDetails, CopyBehaviourCallback.CopyChildAssociationDetails childAssocCopyDetails) {
            ChildAssociationRef childAssocRef = childAssocCopyDetails.getChildAssocRef();
            boolean copyChildren = childAssocCopyDetails.isCopyChildren();
            if (childAssocRef.getTypeQName().equals((Object)ContentModel.ASSOC_CONTAINS)) {
                if (!copyChildren) {
                    return CopyBehaviourCallback.ChildAssocCopyAction.IGNORE;
                }
                if (childAssocRef.isPrimary()) {
                    return CopyBehaviourCallback.ChildAssocCopyAction.COPY_CHILD;
                }
                return CopyBehaviourCallback.ChildAssocCopyAction.COPY_ASSOC;
            }
            throw new IllegalStateException("Behaviour should have been invoked: \n   Aspect: " + this.getClass().getName() + "\n" + "   Assoc:  " + childAssocRef + "\n" + "   " + copyDetails);
        }
    }
}

