/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.deploy;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.alfresco.deployment.DeploymentReceiverService;
import org.alfresco.deployment.DeploymentReceiverTransport;
import org.alfresco.deployment.DeploymentToken;
import org.alfresco.deployment.DeploymentTransportOutputFilter;
import org.alfresco.deployment.FileDescriptor;
import org.alfresco.deployment.FileType;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.action.ActionServiceRemote;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.avm.AVMNodeService;
import org.alfresco.repo.avm.util.SimplePath;
import org.alfresco.repo.deploy.DeploymentReceiverServiceClient;
import org.alfresco.repo.deploy.DeploymentReceiverTransportAdapter;
import org.alfresco.repo.deploy.DeploymentWork;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.remote.AVMRemoteImpl;
import org.alfresco.repo.remote.AVMSyncServiceRemote;
import org.alfresco.repo.remote.ClientTicketHolder;
import org.alfresco.repo.remote.ClientTicketHolderThread;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ActionServiceTransport;
import org.alfresco.service.cmr.avm.AVMException;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.avm.deploy.DeploymentCallback;
import org.alfresco.service.cmr.avm.deploy.DeploymentEvent;
import org.alfresco.service.cmr.avm.deploy.DeploymentService;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.service.cmr.remote.AVMRemote;
import org.alfresco.service.cmr.remote.AVMRemoteTransport;
import org.alfresco.service.cmr.remote.AVMSyncServiceTransport;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.NameMatcher;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.remoting.rmi.RmiProxyFactoryBean;

public class DeploymentServiceImpl
implements DeploymentService {
    private static Log fgLogger = LogFactory.getLog(DeploymentServiceImpl.class);
    private NodeService nodeService;
    private NamespacePrefixResolver namespacePrefixResolver;
    private SearchService searchService;
    private AVMService fAVMService;
    private AVMNodeService fAVMNodeService;
    TransactionService trxService;
    private JobLockService jobLockService;
    private ClientTicketHolder fTicketHolder;
    private int numberOfSendingThreads = 4;
    private long targetLockTimeToLive = 3600000L;
    private long targetLockRefreshTime = 10000L;
    private long targetLockRetryWait = 1000L;
    private int targetLockRetryCount = 10001;
    private int OUTPUT_BUFFER_SIZE;
    private int outputBufferSize = this.OUTPUT_BUFFER_SIZE = 20000;
    private ComparatorFileDescriptorCaseSensitive FILE_DESCRIPTOR_CASE_SENSITIVE = new ComparatorFileDescriptorCaseSensitive();
    private ComparatorAVMNodeDescriptorCaseSensitive AVM_DESCRIPTOR_CASE_SENSITIVE = new ComparatorAVMNodeDescriptorCaseSensitive();
    private Map<String, DeploymentReceiverTransportAdapter> deploymentReceiverTransportAdapters;

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"jobLockService", (Object)this.jobLockService);
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.trxService);
        PropertyCheck.mandatory((Object)this, (String)"avmService", (Object)this.fAVMService);
        PropertyCheck.mandatory((Object)this, (String)"avmNodeService", (Object)this.fAVMNodeService);
    }

    public DeploymentServiceImpl() {
        this.fTicketHolder = new ClientTicketHolderThread();
    }

    public void setAvmService(AVMService service) {
        this.fAVMService = service;
    }

    public void setTransactionService(TransactionService trxService) {
        this.trxService = trxService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void deployDifference(int version, String srcPath, String hostName, int port, String userName, String password, String dstPath, NameMatcher matcher, boolean createDst, boolean dontDelete, boolean dontDo, List<DeploymentCallback> callbacks) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void deployDirectoryPush(int version, AVMNodeDescriptor src, AVMNodeDescriptor dst, AVMRemote remote, NameMatcher matcher, boolean dontDelete, boolean dontDo, List<DeploymentCallback> callbacks) {
        AVMNodeDescriptor srcNode;
        String name;
        if (src.getGuid().equals(dst.getGuid())) {
            return;
        }
        if (!dontDo && !dontDelete) {
            this.copyMetadata(version, src, dst, remote);
        }
        SortedMap<String, AVMNodeDescriptor> srcList = this.fAVMService.getDirectoryListing(src);
        SortedMap<String, AVMNodeDescriptor> dstList = remote.getDirectoryListing(dst);
        for (Map.Entry<String, AVMNodeDescriptor> entry : srcList.entrySet()) {
            name = entry.getKey();
            srcNode = entry.getValue();
            if (!this.isStale(srcNode)) continue;
            if (fgLogger.isDebugEnabled()) {
                fgLogger.debug((Object)("Stale child found: " + srcNode));
            }
            srcList.remove(name);
        }
        for (Map.Entry<String, AVMNodeDescriptor> entry : srcList.entrySet()) {
            name = entry.getKey();
            srcNode = entry.getValue();
            AVMNodeDescriptor dstNode = (AVMNodeDescriptor)dstList.get(name);
            if (this.excluded(matcher, srcNode.getPath(), dstNode != null ? dstNode.getPath() : null)) continue;
            if (this.isStale(srcNode)) {
                fgLogger.debug((Object)("stale file not added" + srcNode));
                continue;
            }
            this.deploySinglePush(version, srcNode, dst, dstNode, remote, matcher, dontDelete, dontDo, callbacks);
        }
        if (dontDelete) {
            return;
        }
        for (String name2 : dstList.keySet()) {
            if (srcList.containsKey(name2)) continue;
            Pair source = new Pair((Object)version, (Object)AVMNodeConverter.ExtendAVMPath(src.getPath(), name2));
            String destination = AVMNodeConverter.ExtendAVMPath(dst.getPath(), name2);
            if (this.excluded(matcher, null, destination)) continue;
            DeploymentEvent event = new DeploymentEvent(DeploymentEvent.Type.DELETED, (Pair<Integer, String>)source, destination);
            this.processEvent(event, callbacks);
            if (dontDo) continue;
            remote.removeNode(dst.getPath(), name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deploySinglePush(int version, AVMNodeDescriptor src, AVMNodeDescriptor dstParent, AVMNodeDescriptor dst, AVMRemote remote, NameMatcher matcher, boolean dontDelete, boolean dontDo, List<DeploymentCallback> callbacks) {
        if (dst == null) {
            if (src.isDirectory()) {
                Pair source = new Pair((Object)version, (Object)src.getPath());
                String destination = AVMNodeConverter.ExtendAVMPath(dstParent.getPath(), src.getName());
                DeploymentEvent event = new DeploymentEvent(DeploymentEvent.Type.CREATED, (Pair<Integer, String>)source, destination);
                this.processEvent(event, callbacks);
                if (dontDo) {
                    return;
                }
                this.copyDirectory(version, src, dstParent, remote, matcher, callbacks);
                return;
            }
            Pair source = new Pair((Object)version, (Object)src.getPath());
            String destination = AVMNodeConverter.ExtendAVMPath(dstParent.getPath(), src.getName());
            DeploymentEvent event = new DeploymentEvent(DeploymentEvent.Type.CREATED, (Pair<Integer, String>)source, destination);
            this.processEvent(event, callbacks);
            if (dontDo) {
                return;
            }
            OutputStream out = remote.createFile(dstParent.getPath(), src.getName());
            try {
                InputStream in = this.fAVMService.getFileInputStream(src);
                this.copyStream(in, out);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        throw new AVMException("I/O Exception", e);
                    }
                }
            }
            this.copyMetadata(version, src, remote.lookup(-1, dstParent.getPath() + '/' + src.getName()), remote);
            return;
        }
        if (src.isDirectory()) {
            if (dst.isDirectory()) {
                this.deployDirectoryPush(version, src, dst, remote, matcher, dontDelete, dontDo, callbacks);
                return;
            }
            Pair source = new Pair((Object)version, (Object)src.getPath());
            String destination = dst.getPath();
            DeploymentEvent event = new DeploymentEvent(DeploymentEvent.Type.CREATED, (Pair<Integer, String>)source, destination);
            this.processEvent(event, callbacks);
            if (dontDo) {
                return;
            }
            fgLogger.debug((Object)("Remove and recopy node :" + dstParent.getPath() + '/' + src.getName()));
            remote.removeNode(dstParent.getPath(), src.getName());
            this.copyDirectory(version, src, dstParent, remote, matcher, callbacks);
            return;
        }
        if (dst.isFile()) {
            if (src.getGuid().equals(dst.getGuid())) {
                return;
            }
            Pair source = new Pair((Object)version, (Object)src.getPath());
            String destination = dst.getPath();
            DeploymentEvent event = new DeploymentEvent(DeploymentEvent.Type.UPDATED, (Pair<Integer, String>)source, destination);
            this.processEvent(event, callbacks);
            if (dontDo) {
                return;
            }
            OutputStream out = remote.getFileOutputStream(dst.getPath());
            try {
                InputStream in = this.fAVMService.getFileInputStream(src);
                this.copyStream(in, out);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        throw new AVMException("I/O Exception", e);
                    }
                }
            }
            this.copyMetadata(version, src, dst, remote);
            return;
        }
        Pair source = new Pair((Object)version, (Object)src.getPath());
        String destination = AVMNodeConverter.ExtendAVMPath(dstParent.getPath(), src.getName());
        DeploymentEvent event = new DeploymentEvent(DeploymentEvent.Type.UPDATED, (Pair<Integer, String>)source, destination);
        this.processEvent(event, callbacks);
        if (dontDo) {
            return;
        }
        remote.removeNode(dstParent.getPath(), dst.getName());
        OutputStream out = remote.createFile(dstParent.getPath(), src.getName());
        try {
            InputStream in = this.fAVMService.getFileInputStream(src);
            this.copyStream(in, out);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new AVMException("I/O Exception", e);
                }
            }
        }
        this.copyMetadata(version, src, remote.lookup(-1, dstParent.getPath() + '/' + dst.getName()), remote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyDirectory(int version, AVMNodeDescriptor src, AVMNodeDescriptor parent, AVMRemote remote, NameMatcher matcher, List<DeploymentCallback> callbacks) {
        remote.createDirectory(parent.getPath(), src.getName());
        AVMNodeDescriptor newParent = remote.lookup(-1, parent.getPath() + '/' + src.getName());
        this.copyMetadata(version, src, newParent, remote);
        SortedMap<String, AVMNodeDescriptor> list = this.fAVMService.getDirectoryListing(src);
        for (AVMNodeDescriptor child : list.values()) {
            DeploymentEvent event;
            if (this.excluded(matcher, child.getPath(), null)) continue;
            if (this.isStale(child)) {
                if (!fgLogger.isDebugEnabled()) continue;
                fgLogger.debug((Object)("Stale child found: " + child));
                continue;
            }
            if (child.isFile()) {
                event = new DeploymentEvent(DeploymentEvent.Type.CREATED, (Pair<Integer, String>)new Pair((Object)version, (Object)(src.getPath() + '/' + child.getName())), newParent.getPath() + '/' + child.getName());
                this.processEvent(event, callbacks);
                OutputStream out = remote.createFile(newParent.getPath(), child.getName());
                try {
                    InputStream in = this.fAVMService.getFileInputStream(child);
                    this.copyStream(in, out);
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            throw new AVMException("I/O Exception", e);
                        }
                    }
                }
                this.copyMetadata(version, child, remote.lookup(-1, newParent.getPath() + '/' + child.getName()), remote);
                continue;
            }
            event = new DeploymentEvent(DeploymentEvent.Type.CREATED, (Pair<Integer, String>)new Pair((Object)version, (Object)(src.getPath() + '/' + child.getName())), newParent.getPath() + '/' + child.getName());
            this.processEvent(event, callbacks);
            this.copyDirectory(version, child, newParent, remote, matcher, callbacks);
        }
    }

    private void copyStream(InputStream in, OutputStream out) {
        byte[] buff = new byte[8192];
        int read = 0;
        try {
            while ((read = in.read(buff)) != -1) {
                out.write(buff, 0, read);
            }
            in.close();
        }
        catch (IOException e) {
            throw new AVMException("I/O Exception", e);
        }
    }

    private void copyMetadata(int version, AVMNodeDescriptor src, AVMNodeDescriptor dst, AVMRemote remote) {
        Map<QName, PropertyValue> props = this.fAVMService.getNodeProperties(version, src.getPath());
        remote.setNodeProperties(dst.getPath(), props);
        Set<QName> aspects = this.fAVMService.getAspects(version, src.getPath());
        for (QName aspect : aspects) {
            if (remote.hasAspect(-1, dst.getPath(), aspect)) continue;
            remote.addAspect(dst.getPath(), aspect);
        }
        remote.setGuid(dst.getPath(), src.getGuid());
        if (src.isFile()) {
            ContentData contData = this.fAVMService.getContentDataForRead(version, src.getPath());
            remote.setEncoding(dst.getPath(), contData.getEncoding());
            remote.setMimeType(dst.getPath(), contData.getMimetype());
        }
    }

    private AVMRemote getRemote(String hostName, int port, String userName, String password) {
        try {
            RmiProxyFactoryBean authFactory = new RmiProxyFactoryBean();
            authFactory.setRefreshStubOnConnectFailure(true);
            authFactory.setServiceInterface(AuthenticationService.class);
            authFactory.setServiceUrl("rmi://" + hostName + ":" + port + "/authentication");
            authFactory.afterPropertiesSet();
            AuthenticationService authService = (AuthenticationService)authFactory.getObject();
            authService.authenticate(userName, password.toCharArray());
            String ticket = authService.getCurrentTicket();
            this.fTicketHolder.setTicket(ticket);
            RmiProxyFactoryBean remoteFactory = new RmiProxyFactoryBean();
            remoteFactory.setRefreshStubOnConnectFailure(true);
            remoteFactory.setServiceInterface(AVMRemoteTransport.class);
            remoteFactory.setServiceUrl("rmi://" + hostName + ":" + port + "/avm");
            remoteFactory.afterPropertiesSet();
            AVMRemoteTransport transport = (AVMRemoteTransport)remoteFactory.getObject();
            AVMRemoteImpl remote = new AVMRemoteImpl();
            remote.setAvmRemoteTransport(transport);
            remote.setClientTicketHolder(this.fTicketHolder);
            return remote;
        }
        catch (Exception e) {
            throw new AVMException("Could not Initialize Remote Connection to " + hostName, e);
        }
    }

    @Override
    public ActionService getRemoteActionService(String hostName, int port, String userName, String password) {
        try {
            RmiProxyFactoryBean authFactory = new RmiProxyFactoryBean();
            authFactory.setRefreshStubOnConnectFailure(true);
            authFactory.setServiceInterface(AuthenticationService.class);
            authFactory.setServiceUrl("rmi://" + hostName + ":" + port + "/authentication");
            authFactory.afterPropertiesSet();
            AuthenticationService authService = (AuthenticationService)authFactory.getObject();
            authService.authenticate(userName, password.toCharArray());
            String ticket = authService.getCurrentTicket();
            this.fTicketHolder.setTicket(ticket);
            RmiProxyFactoryBean remoteFactory = new RmiProxyFactoryBean();
            remoteFactory.setRefreshStubOnConnectFailure(true);
            remoteFactory.setServiceInterface(ActionServiceTransport.class);
            remoteFactory.setServiceUrl("rmi://" + hostName + ":" + port + "/action");
            remoteFactory.afterPropertiesSet();
            ActionServiceTransport transport = (ActionServiceTransport)remoteFactory.getObject();
            ActionServiceRemote remote = new ActionServiceRemote();
            remote.setActionServiceTransport(transport);
            remote.setClientTicketHolder(this.fTicketHolder);
            return remote;
        }
        catch (Exception e) {
            throw new AVMException("Could not Initialize Remote Connection to " + hostName, e);
        }
    }

    private List<DeploymentTransportOutputFilter> getTransformers(String transportName) {
        DeploymentReceiverTransportAdapter adapter = this.deploymentReceiverTransportAdapters.get(transportName);
        if (adapter == null) {
            fgLogger.error((Object)("Deployment Receiver Transport adapter does not exist for transport. Name: " + transportName));
            throw new AVMException("Deployment Receiver Transport adapter does not exist for transport. Name: " + transportName);
        }
        List<DeploymentTransportOutputFilter> transformers = adapter.getTransformers();
        return transformers;
    }

    private DeploymentReceiverService getDeploymentReceiverService(String transportName, String hostName, int port, int version, String srcPath) {
        DeploymentReceiverTransportAdapter adapter = this.deploymentReceiverTransportAdapters.get(transportName);
        if (adapter == null) {
            fgLogger.error((Object)("Deployment Receiver Transport adapter does not exist for transport. Name: " + transportName));
            throw new AVMException("Deployment Receiver Transport adapter does not exist for transport. Name: " + transportName);
        }
        try {
            DeploymentReceiverTransport transport = adapter.getTransport(hostName, port, version, srcPath);
            DeploymentReceiverServiceClient service = new DeploymentReceiverServiceClient();
            service.setDeploymentReceiverTransport(transport);
            return service;
        }
        catch (Exception e) {
            throw new AVMException("Could not connect to remote deployment receiver, transportName:" + transportName + ", hostName:" + hostName + ", port: " + port, e);
        }
    }

    private AVMSyncService getSyncService(String hostName, int port) {
        try {
            RmiProxyFactoryBean syncFactory = new RmiProxyFactoryBean();
            syncFactory.setRefreshStubOnConnectFailure(true);
            syncFactory.setServiceInterface(AVMSyncServiceTransport.class);
            syncFactory.setServiceUrl("rmi://" + hostName + ":" + port + "/avmsync");
            syncFactory.afterPropertiesSet();
            AVMSyncServiceTransport syncServiceTransport = (AVMSyncServiceTransport)syncFactory.getObject();
            AVMSyncServiceRemote remote = new AVMSyncServiceRemote();
            remote.setAvmSyncServiceTransport(syncServiceTransport);
            remote.setClientTicketHolder(this.fTicketHolder);
            return remote;
        }
        catch (Exception e) {
            throw new AVMException("Could not roll back failed deployment to " + hostName, e);
        }
    }

    private void createDestination(AVMRemote remote, String dstPath) {
        SimplePath simpPath;
        String[] storePath = dstPath.split(":");
        String storeName = storePath[0];
        String path = storePath[1];
        AVMStoreDescriptor storeDesc = remote.getStore(storeName);
        if (storeDesc == null) {
            remote.createStore(storeName);
        }
        if ((simpPath = new SimplePath(path)).size() == 0) {
            return;
        }
        String prevPath = storeName + ":/";
        for (int i = 0; i < simpPath.size(); ++i) {
            String currPath = AVMNodeConverter.ExtendAVMPath(prevPath, simpPath.get(i));
            AVMNodeDescriptor desc = remote.lookup(-1, currPath);
            if (desc == null) {
                remote.createDirectory(prevPath, simpPath.get(i));
            }
            prevPath = currPath;
        }
    }

    private Set<String> getAspects(AVMService avmService, AVMNodeDescriptor src) {
        Set<QName> aspects = avmService.getAspects(src);
        HashSet<String> stringAspects = new HashSet<String>();
        for (QName aspect : aspects) {
            stringAspects.add(aspect.toString());
        }
        return stringAspects;
    }

    private Map<String, Serializable> getProperties(AVMNodeDescriptor src, int version) {
        Map<QName, PropertyValue> properties = this.fAVMService.getNodeProperties(src);
        NodeRef nodeRef = AVMNodeConverter.ToNodeRef(version, src.getPath());
        Map<QName, Serializable> nodeProps = this.fAVMNodeService.getProperties(nodeRef);
        HashMap<String, Serializable> retVal = new HashMap<String, Serializable>();
        for (QName key : properties.keySet()) {
            Serializable value = nodeProps.get(key);
            retVal.put(key.toString(), value);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void deployDifferenceFS(int version, final String srcPath, String adapterName, String hostName, int port, String userName, String password, String target, final NameMatcher matcher, boolean createDst, boolean dontDelete, boolean dontDo, List<DeploymentCallback> callbacks) {
        fgLogger.debug((Object)"deployDifferenceFS start");
        String lockStr = "deploy." + hostName + "." + port + "." + target;
        QName lockQName = QName.createQName((String)("{http://www.alfresco.org/deploymentService/1.0}" + lockStr));
        final Lock lock = new Lock(lockQName);
        lock.makeLock();
        try {
            if (fgLogger.isDebugEnabled()) {
                Object[] objs = new Object[]{version, srcPath, adapterName, hostName, port, target};
                MessageFormat f = new MessageFormat("Deployment Lock Held: version {0}, srcPath {1}, adapterName {2}, hostName {3}, port {4}, target {5}");
                fgLogger.debug((Object)f.format(objs));
            }
            DeploymentReceiverService service = null;
            List<DeploymentTransportOutputFilter> transformers = null;
            String ticket = null;
            String currentEffectiveUser = AuthenticationUtil.getRunAsUser();
            try {
                final LinkedBlockingQueue<DeploymentEvent> eventQueue = new LinkedBlockingQueue<DeploymentEvent>();
                EventQueueWorker eventQueueWorker = new EventQueueWorker(currentEffectiveUser, eventQueue, callbacks);
                eventQueueWorker.setName(eventQueueWorker.getClass().getName());
                eventQueueWorker.setPriority(Thread.currentThread().getPriority());
                eventQueueWorker.start();
                try {
                    block54: {
                        final String storeName = srcPath.substring(0, srcPath.indexOf(58));
                        try {
                            if (version < 0) {
                                RetryingTransactionHelper trn = this.trxService.getRetryingTransactionHelper();
                                RetryingTransactionHelper.RetryingTransactionCallback<Integer> localSnapshot = new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){

                                    @Override
                                    public Integer execute() throws Throwable {
                                        int newVersion = DeploymentServiceImpl.this.fAVMService.createSnapshot(storeName, null, null).get(storeName);
                                        return new Integer(newVersion);
                                    }
                                };
                                version = trn.doInTransaction(localSnapshot, false, true);
                                fgLogger.debug((Object)("snapshot local created " + storeName + ", " + version));
                            }
                            transformers = this.getTransformers(adapterName);
                            service = this.getDeploymentReceiverService(adapterName, hostName, port, version, srcPath);
                        }
                        catch (Exception e) {
                            eventQueue.add(new DeploymentEvent(DeploymentEvent.Type.FAILED, (Pair<Integer, String>)new Pair((Object)version, (Object)srcPath), target, e.getMessage()));
                            throw e;
                        }
                        eventQueue.add(new DeploymentEvent(DeploymentEvent.Type.START, (Pair<Integer, String>)new Pair((Object)version, (Object)srcPath), target));
                        final LinkedBlockingQueue<DeploymentWork> sendQueue = new LinkedBlockingQueue<DeploymentWork>();
                        final List<Exception> errors = Collections.synchronizedList(new ArrayList());
                        SendQueueWorker[] workers = new SendQueueWorker[this.numberOfSendingThreads];
                        for (int i = 0; i < this.numberOfSendingThreads; ++i) {
                            workers[i] = new SendQueueWorker(currentEffectiveUser, service, this.fAVMService, this.trxService, errors, eventQueue, sendQueue, transformers);
                            workers[i].setName(workers[i].getClass().getName());
                            workers[i].setPriority(Thread.currentThread().getPriority());
                        }
                        for (SendQueueWorker sender : workers) {
                            sender.start();
                        }
                        try {
                            fgLogger.debug((Object)"calling begin");
                            DeploymentToken token = service.begin(target, storeName, version, userName, password.toCharArray());
                            ticket = token.getTicket();
                            lock.checkLock();
                            final DeploymentReceiverService fservice = service;
                            final String fTicket = ticket;
                            final int fVersion = version;
                            RetryingTransactionHelper.RetryingTransactionCallback<Integer> pushFSR = new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){

                                @Override
                                public Integer execute() throws Throwable {
                                    DeploymentServiceImpl.this.deployDirectoryPushFSR(fservice, fTicket, fVersion, srcPath, "/", matcher, eventQueue, sendQueue, errors, lock);
                                    return 0;
                                }
                            };
                            RetryingTransactionHelper trn = this.trxService.getRetryingTransactionHelper();
                            trn.doInTransaction(pushFSR, false, true);
                        }
                        catch (Exception e) {
                            errors.add(e);
                            fgLogger.debug((Object)"closing deployment workers");
                            for (SendQueueWorker sender : workers) {
                                sender.stopMeWhenIdle();
                            }
                            for (SendQueueWorker sender : workers) {
                                sender.join();
                            }
                            fgLogger.debug((Object)"deployment workers closed");
                            if (errors.size() <= 0 && ticket != null) {
                                try {
                                    fgLogger.debug((Object)"no errors - prepare and commit");
                                    lock.checkLock();
                                    service.prepare(ticket);
                                    lock.checkLock();
                                    service.commit(ticket);
                                }
                                catch (Exception e2) {
                                    errors.add(e2);
                                }
                            }
                            if (errors.size() <= 0) break block54;
                            fgLogger.debug((Object)"errors on deployment workers");
                            Exception firstError = errors.get(0);
                            eventQueue.add(new DeploymentEvent(DeploymentEvent.Type.FAILED, (Pair<Integer, String>)new Pair((Object)version, (Object)srcPath), target, firstError.getMessage()));
                            if (ticket != null) {
                                try {
                                    service.abort(ticket);
                                }
                                catch (Exception ae) {
                                    fgLogger.error((Object)"Unable to abort deployment.  Error in exception handler", (Throwable)ae);
                                }
                            }
                            MessageFormat f = new MessageFormat("Error during deployment srcPath: {0}, version:{1}, adapterName:{2}, hostName:{3}, port:{4}, error:{5}");
                            Object[] objs = new Object[]{srcPath, version, adapterName, hostName, port, firstError};
                            throw new AVMException(f.format(objs), firstError);
                        }
                        catch (Throwable t) {
                            errors.add((Exception)((Object)new AVMException("Unexpected Throwable", t)));
                            fgLogger.debug((Object)"closing deployment workers");
                            for (SendQueueWorker sender : workers) {
                                sender.stopMeWhenIdle();
                            }
                            for (SendQueueWorker sender : workers) {
                                sender.join();
                            }
                            fgLogger.debug((Object)"deployment workers closed");
                            if (errors.size() <= 0 && ticket != null) {
                                try {
                                    fgLogger.debug((Object)"no errors - prepare and commit");
                                    lock.checkLock();
                                    service.prepare(ticket);
                                    lock.checkLock();
                                    service.commit(ticket);
                                }
                                catch (Exception e3) {
                                    errors.add(e3);
                                }
                            }
                            if (errors.size() <= 0) break block54;
                            fgLogger.debug((Object)"errors on deployment workers");
                            Exception firstError = errors.get(0);
                            eventQueue.add(new DeploymentEvent(DeploymentEvent.Type.FAILED, (Pair<Integer, String>)new Pair((Object)version, (Object)srcPath), target, firstError.getMessage()));
                            if (ticket != null) {
                                try {
                                    service.abort(ticket);
                                }
                                catch (Exception ae) {
                                    fgLogger.error((Object)"Unable to abort deployment.  Error in exception handler", (Throwable)ae);
                                }
                            }
                            MessageFormat f = new MessageFormat("Error during deployment srcPath: {0}, version:{1}, adapterName:{2}, hostName:{3}, port:{4}, error:{5}");
                            Object[] objs = new Object[]{srcPath, version, adapterName, hostName, port, firstError};
                            throw new AVMException(f.format(objs), firstError);
                            {
                                catch (Throwable throwable) {
                                    fgLogger.debug((Object)"closing deployment workers");
                                    for (SendQueueWorker sender : workers) {
                                        sender.stopMeWhenIdle();
                                    }
                                    for (SendQueueWorker sender : workers) {
                                        sender.join();
                                    }
                                    fgLogger.debug((Object)"deployment workers closed");
                                    if (errors.size() <= 0 && ticket != null) {
                                        try {
                                            fgLogger.debug((Object)"no errors - prepare and commit");
                                            lock.checkLock();
                                            service.prepare(ticket);
                                            lock.checkLock();
                                            service.commit(ticket);
                                        }
                                        catch (Exception e2) {
                                            errors.add(e2);
                                        }
                                    }
                                    if (errors.size() > 0) {
                                        fgLogger.debug((Object)"errors on deployment workers");
                                        Exception firstError2 = errors.get(0);
                                        eventQueue.add(new DeploymentEvent(DeploymentEvent.Type.FAILED, (Pair<Integer, String>)new Pair((Object)version, (Object)srcPath), target, firstError2.getMessage()));
                                        if (ticket != null) {
                                            try {
                                                service.abort(ticket);
                                            }
                                            catch (Exception ae) {
                                                fgLogger.error((Object)"Unable to abort deployment.  Error in exception handler", (Throwable)ae);
                                            }
                                        }
                                        MessageFormat f2 = new MessageFormat("Error during deployment srcPath: {0}, version:{1}, adapterName:{2}, hostName:{3}, port:{4}, error:{5}");
                                        Object[] objs2 = new Object[]{srcPath, version, adapterName, hostName, port, firstError2};
                                        throw new AVMException(f2.format(objs2), firstError2);
                                    }
                                    throw throwable;
                                }
                            }
                        }
                        fgLogger.debug((Object)"closing deployment workers");
                        for (SendQueueWorker sender : workers) {
                            sender.stopMeWhenIdle();
                        }
                        for (SendQueueWorker sender : workers) {
                            sender.join();
                        }
                        fgLogger.debug((Object)"deployment workers closed");
                        if (errors.size() <= 0 && ticket != null) {
                            try {
                                fgLogger.debug((Object)"no errors - prepare and commit");
                                lock.checkLock();
                                service.prepare(ticket);
                                lock.checkLock();
                                service.commit(ticket);
                            }
                            catch (Exception e) {
                                errors.add(e);
                            }
                        }
                        if (errors.size() > 0) {
                            fgLogger.debug((Object)"errors on deployment workers");
                            Exception firstError = errors.get(0);
                            eventQueue.add(new DeploymentEvent(DeploymentEvent.Type.FAILED, (Pair<Integer, String>)new Pair((Object)version, (Object)srcPath), target, firstError.getMessage()));
                            if (ticket != null) {
                                try {
                                    service.abort(ticket);
                                }
                                catch (Exception ae) {
                                    fgLogger.error((Object)"Unable to abort deployment.  Error in exception handler", (Throwable)ae);
                                }
                            }
                            MessageFormat f = new MessageFormat("Error during deployment srcPath: {0}, version:{1}, adapterName:{2}, hostName:{3}, port:{4}, error:{5}");
                            Object[] objs = new Object[]{srcPath, version, adapterName, hostName, port, firstError};
                            throw new AVMException(f.format(objs), firstError);
                        }
                    }
                    eventQueue.add(new DeploymentEvent(DeploymentEvent.Type.END, (Pair<Integer, String>)new Pair((Object)version, (Object)srcPath), target));
                    fgLogger.debug((Object)"deployment completed successfully");
                }
                finally {
                    fgLogger.debug((Object)"closing event queue");
                    eventQueueWorker.stopMeWhenIdle();
                    eventQueueWorker.join();
                    fgLogger.debug((Object)"event queue closed");
                }
            }
            catch (Exception e) {
                MessageFormat f = new MessageFormat("Deployment exception, unable to deploy : srcPath:{0}, target:{1}, version:{2}, adapterName:{3}, hostName:{4}, port:{5}, error:{6}");
                Object[] objs = new Object[]{srcPath, target, version, adapterName, hostName, port, e};
                throw new AVMException(f.format(objs), e);
            }
        }
        finally {
            fgLogger.debug((Object)"At end of method - about to release lock");
            lock.releaseLock();
        }
    }

    private void deployDirectoryPushFSR(DeploymentReceiverService service, String ticket, int version, String srcPath, String dstPath, NameMatcher matcher, BlockingQueue<DeploymentEvent> eventQueue, BlockingQueue<DeploymentWork> sendQueue, List<Exception> errors, Lock lock) {
        SortedMap<String, AVMNodeDescriptor> rawSrcListing = this.fAVMService.getDirectoryListing(version, srcPath);
        List rawDstListing = service.getListing(ticket, dstPath);
        TreeSet<FileDescriptor> dstListing = new TreeSet<FileDescriptor>(this.FILE_DESCRIPTOR_CASE_SENSITIVE);
        dstListing.addAll(rawDstListing);
        TreeSet<AVMNodeDescriptor> srcListing = new TreeSet<AVMNodeDescriptor>(this.AVM_DESCRIPTOR_CASE_SENSITIVE);
        srcListing.addAll(rawSrcListing.values());
        Iterator<FileDescriptor> dstIter = dstListing.iterator();
        Iterator<AVMNodeDescriptor> srcIter = srcListing.iterator();
        lock.checkLock();
        AVMNodeDescriptor src = null;
        FileDescriptor dst = null;
        while ((srcIter.hasNext() || dstIter.hasNext() || src != null || dst != null) && errors.size() <= 0) {
            if (src == null && srcIter.hasNext() && this.isStale(src = srcIter.next())) {
                if (fgLogger.isDebugEnabled()) {
                    fgLogger.debug((Object)("Stale child found: " + src));
                }
                src = null;
                continue;
            }
            if (dst == null && dstIter.hasNext()) {
                dst = dstIter.next();
            }
            if (fgLogger.isDebugEnabled()) {
                fgLogger.debug((Object)("comparing src:" + src + " dst:" + dst));
            }
            lock.checkLock();
            if (src == null) {
                String newDstPath = this.extendPath(dstPath, dst.getName());
                if (!this.excluded(matcher, null, newDstPath)) {
                    sendQueue.add(new DeploymentWork(new DeploymentEvent(DeploymentEvent.Type.DELETED, (Pair<Integer, String>)new Pair((Object)version, (Object)this.extendPath(srcPath, dst.getName())), newDstPath), ticket));
                }
                dst = null;
                continue;
            }
            if (dst == null) {
                if (!this.excluded(matcher, src.getPath(), null)) {
                    this.createOnFSR(service, ticket, version, src, dstPath, matcher, sendQueue);
                }
                src = null;
                continue;
            }
            int diff = src.getName().compareTo(dst.getName());
            if (diff < 0) {
                if (!this.excluded(matcher, src.getPath(), null)) {
                    this.createOnFSR(service, ticket, version, src, dstPath, matcher, sendQueue);
                }
                src = null;
                continue;
            }
            if (diff == 0) {
                String extendedPath;
                if (src.getGuid().equals(dst.getGUID())) {
                    src = null;
                    dst = null;
                    continue;
                }
                if (src.isFile()) {
                    extendedPath = this.extendPath(dstPath, dst.getName());
                    if (!this.excluded(matcher, src.getPath(), extendedPath)) {
                        sendQueue.add(new DeploymentWork(new DeploymentEvent(DeploymentEvent.Type.UPDATED, (Pair<Integer, String>)new Pair((Object)version, (Object)src.getPath()), extendedPath), ticket, src, version));
                    }
                    src = null;
                    dst = null;
                    continue;
                }
                if (dst.getType() == FileType.DIR) {
                    extendedPath = this.extendPath(dstPath, dst.getName());
                    Set<String> stringAspects = this.getAspects(this.fAVMService, src);
                    Map<String, Serializable> stringProperties = this.getProperties(src, version);
                    service.updateDirectory(ticket, extendedPath, src.getGuid(), stringAspects, stringProperties);
                    if (!this.excluded(matcher, src.getPath(), extendedPath)) {
                        this.deployDirectoryPushFSR(service, ticket, version, src.getPath(), extendedPath, matcher, eventQueue, sendQueue, errors, lock);
                    }
                    src = null;
                    dst = null;
                    continue;
                }
                if (!this.excluded(matcher, src.getPath(), null)) {
                    this.createOnFSR(service, ticket, version, src, dstPath, matcher, sendQueue);
                }
                src = null;
                dst = null;
                continue;
            }
            String newDstPath = this.extendPath(dstPath, dst.getName());
            sendQueue.add(new DeploymentWork(new DeploymentEvent(DeploymentEvent.Type.DELETED, (Pair<Integer, String>)new Pair((Object)version, (Object)this.extendPath(srcPath, dst.getName())), newDstPath), ticket));
            dst = null;
        }
    }

    private void createOnFSR(DeploymentReceiverService service, String ticket, int version, AVMNodeDescriptor src, String parentPath, NameMatcher matcher, BlockingQueue<DeploymentWork> sendQueue) {
        String dstPath = this.extendPath(parentPath, src.getName());
        sendQueue.add(new DeploymentWork(new DeploymentEvent(DeploymentEvent.Type.CREATED, (Pair<Integer, String>)new Pair((Object)version, (Object)src.getPath()), dstPath), ticket, src, version));
        if (src.isFile()) {
            return;
        }
        Set<String> stringAspects = this.getAspects(this.fAVMService, src);
        Map<String, Serializable> stringProperties = this.getProperties(src, version);
        service.createDirectory(ticket, dstPath, src.getGuid(), stringAspects, stringProperties);
        SortedMap<String, AVMNodeDescriptor> listing = this.fAVMService.getDirectoryListing(src);
        for (AVMNodeDescriptor child : listing.values()) {
            if (this.excluded(matcher, child.getPath(), null)) continue;
            if (this.isStale(child)) {
                if (!fgLogger.isDebugEnabled()) continue;
                fgLogger.debug((Object)("Stale child found: " + child));
                continue;
            }
            this.createOnFSR(service, ticket, version, child, dstPath, matcher, sendQueue);
        }
    }

    private void processEvent(DeploymentEvent event, List<DeploymentCallback> callbacks) {
        if (fgLogger.isDebugEnabled()) {
            fgLogger.debug((Object)event);
        }
        if (callbacks != null) {
            for (DeploymentCallback callback : callbacks) {
                callback.eventOccurred(event);
            }
        }
    }

    private String extendPath(String path, String name) {
        if (path.endsWith("/")) {
            return path + name;
        }
        return path + '/' + name;
    }

    private boolean excluded(NameMatcher matcher, String srcPath, String dstPath) {
        return matcher != null && (srcPath != null && matcher.matches(srcPath) || dstPath != null && matcher.matches(dstPath));
    }

    public void setDeploymentReceiverTransportAdapters(Map<String, DeploymentReceiverTransportAdapter> adapters) {
        this.deploymentReceiverTransportAdapters = adapters;
    }

    public Map<String, DeploymentReceiverTransportAdapter> getDeploymentReceiverTransportAdapters() {
        return this.deploymentReceiverTransportAdapters;
    }

    @Override
    public Set<String> getAdapterNames() {
        if (this.deploymentReceiverTransportAdapters != null) {
            return this.deploymentReceiverTransportAdapters.keySet();
        }
        HashSet<String> ret = new HashSet<String>(1);
        ret.add("default");
        return ret;
    }

    @Override
    public List<NodeRef> findLiveDeploymentServers(NodeRef webProjectRef) {
        return this.findDeploymentServers(webProjectRef, true, false);
    }

    @Override
    public List<NodeRef> findTestDeploymentServers(NodeRef webProjectRef, boolean availableOnly) {
        return this.findDeploymentServers(webProjectRef, false, availableOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<NodeRef> findDeploymentServers(NodeRef webProjectRef, boolean live, boolean availableOnly) {
        Path projectPath = this.nodeService.getPath(webProjectRef);
        String stringPath = projectPath.toPrefixString(this.namespacePrefixResolver);
        String serverType = live ? "live" : "test";
        StringBuilder query = new StringBuilder("PATH:\"");
        query.append(stringPath);
        query.append("/*\" ");
        query.append(" AND @");
        query.append("wca");
        query.append("\\:");
        query.append(WCMAppModel.PROP_DEPLOYSERVERTYPE.getLocalName());
        query.append(":\"");
        query.append(serverType);
        query.append("\"");
        if (!live && availableOnly) {
            query.append(" AND ISNULL:\"");
            query.append(WCMAppModel.PROP_DEPLOYSERVERALLOCATEDTO.toString());
            query.append("\"");
        }
        if (fgLogger.isDebugEnabled()) {
            fgLogger.debug((Object)("Finding deployment servers using query: " + query.toString()));
        }
        ResultSet results = null;
        ArrayList<NodeRef> servers = new ArrayList<NodeRef>();
        try {
            results = this.searchService.query(webProjectRef.getStoreRef(), "lucene", query.toString());
            if (fgLogger.isDebugEnabled()) {
                fgLogger.debug((Object)("Found " + results.length() + " deployment servers"));
            }
            for (NodeRef server : results.getNodeRefs()) {
                servers.add(server);
            }
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
        return servers;
    }

    public void setNumberOfSendingThreads(int numberOfSendingThreads) {
        this.numberOfSendingThreads = numberOfSendingThreads;
    }

    public int getNumberOfSendingThreads() {
        return this.numberOfSendingThreads;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public JobLockService getJobLockService() {
        return this.jobLockService;
    }

    public void setTargetLockTimeToLive(long targetLockTimeToLive) {
        this.targetLockTimeToLive = targetLockTimeToLive;
    }

    public long getTargetLockTimeToLive() {
        return this.targetLockTimeToLive;
    }

    public void setTargetLockRetryWait(long targetLockRetryWait) {
        this.targetLockRetryWait = targetLockRetryWait;
    }

    public long getTargetLockRetryWait() {
        return this.targetLockRetryWait;
    }

    public void setTargetLockRetryCount(int targetLockRetryCount) {
        this.targetLockRetryCount = targetLockRetryCount;
    }

    public int getTargetLockRetryCount() {
        return this.targetLockRetryCount;
    }

    public void setAvmNodeService(AVMNodeService fAVMNodeService) {
        this.fAVMNodeService = fAVMNodeService;
    }

    public AVMNodeService getAvmNodeService() {
        return this.fAVMNodeService;
    }

    public void setOutputBufferSize(int outputBufferSize) {
        this.outputBufferSize = outputBufferSize;
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    private boolean isStale(AVMNodeDescriptor avmRef) {
        if (avmRef.isLayeredDirectory() && avmRef.isPrimary() || avmRef.isLayeredFile()) {
            AVMNodeDescriptor srcNode = avmRef;
            while (srcNode.isLayeredDirectory() && srcNode.isPrimary() || srcNode.isLayeredFile()) {
                AVMNodeDescriptor targetNode = this.fAVMService.lookup(srcNode.getIndirectionVersion(), srcNode.getIndirection());
                if (targetNode == null) {
                    return srcNode.isLayeredFile() || srcNode.isLayeredDirectory() && !srcNode.getOpacity() && this.fAVMService.getDirectoryListingDirect(srcNode, false).isEmpty();
                }
                srcNode = targetNode;
            }
        }
        return false;
    }

    public void setTargetLockRefreshTime(long targetLockRefreshTime) {
        this.targetLockRefreshTime = targetLockRefreshTime;
    }

    public long getTargetLockRefreshTime() {
        return this.targetLockRefreshTime;
    }

    private class SendQueueWorker
    extends Thread {
        private BlockingQueue<DeploymentEvent> eventQueue;
        private BlockingQueue<DeploymentWork> sendQueue;
        private DeploymentReceiverService service;
        private String userName;
        private AVMService avmService;
        private TransactionService trxService;
        List<Exception> errors;
        List<DeploymentTransportOutputFilter> transformers;
        private boolean stopMe = false;

        SendQueueWorker(String userName, DeploymentReceiverService service, AVMService avmService, TransactionService trxService, List<Exception> errors, BlockingQueue<DeploymentEvent> eventQueue, BlockingQueue<DeploymentWork> sendQueue, List<DeploymentTransportOutputFilter> transformers) {
            this.eventQueue = eventQueue;
            this.sendQueue = sendQueue;
            this.service = service;
            this.avmService = avmService;
            this.trxService = trxService;
            this.errors = errors;
            this.transformers = transformers;
            this.userName = userName;
        }

        @Override
        public void run() {
            AuthenticationUtil.setFullyAuthenticatedUser((String)this.userName);
            while (this.errors.size() <= 0) {
                DeploymentWork work = null;
                try {
                    work = this.sendQueue.poll(3L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e1) {
                    fgLogger.debug((Object)"Interrupted ", (Throwable)e1);
                    continue;
                }
                if (work == null && this.stopMe) {
                    fgLogger.debug((Object)"Send Queue Worker Closing Normally");
                    this.eventQueue = null;
                    this.sendQueue = null;
                    this.service = null;
                    this.errors = null;
                    break;
                }
                if (work == null) continue;
                DeploymentEvent event = work.getEvent();
                String ticket = work.getTicket();
                try {
                    if (event.getType().equals(DeploymentEvent.Type.DELETED)) {
                        this.service.delete(ticket, event.getDestination());
                    } else if (event.getType().equals(DeploymentEvent.Type.CREATED)) {
                        AVMNodeDescriptor src = work.getSrc();
                        if (src.isFile()) {
                            this.copyFileToFSR(src, true, work.getVersion(), event.getDestination(), ticket);
                        }
                    } else if (event.getType().equals(DeploymentEvent.Type.UPDATED)) {
                        this.copyFileToFSR(work.getSrc(), false, work.getVersion(), event.getDestination(), ticket);
                    }
                    this.eventQueue.add(event);
                }
                catch (Exception e) {
                    this.errors.add(e);
                }
            }
            fgLogger.debug((Object)"Send Queue Worker finished");
        }

        public void stopMeWhenIdle() {
            this.stopMe = true;
        }

        private void copyFileToFSR(final AVMNodeDescriptor src, final boolean create, final int version, final String dstPath, final String ticket) {
            try {
                RetryingTransactionHelper trx = this.trxService.getRetryingTransactionHelper();
                trx.setMaxRetries(1);
                trx.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Boolean execute() throws Exception {
                        ContentData data = SendQueueWorker.this.avmService.getContentDataForRead(src);
                        InputStream in = SendQueueWorker.this.avmService.getFileInputStream(src);
                        String encoding = data.getEncoding();
                        String mimeType = data.getMimetype();
                        Set stringAspects = DeploymentServiceImpl.this.getAspects(SendQueueWorker.this.avmService, src);
                        Map stringProperties = DeploymentServiceImpl.this.getProperties(src, version);
                        OutputStream out = SendQueueWorker.this.service.send(ticket, create, dstPath, src.getGuid(), encoding, mimeType, stringAspects, stringProperties);
                        try {
                            out = new BufferedOutputStream(out, DeploymentServiceImpl.this.outputBufferSize);
                            if (SendQueueWorker.this.transformers != null && SendQueueWorker.this.transformers.size() > 0) {
                                for (DeploymentTransportOutputFilter transformer : SendQueueWorker.this.transformers) {
                                    out = transformer.addFilter(out, src.getPath(), encoding, mimeType);
                                }
                            }
                            DeploymentServiceImpl.this.copyStream(in, out);
                        }
                        finally {
                            if (out != null) {
                                out.close();
                                out = null;
                            }
                        }
                        return true;
                    }
                }, true);
            }
            catch (Exception e) {
                fgLogger.debug((Object)("Failed to copy dstPath:" + dstPath), (Throwable)e);
                throw new AVMException("Failed to copy filename:" + dstPath, e);
            }
        }
    }

    private class Lock
    implements JobLockService.JobLockRefreshCallback {
        QName lockQName;
        String lockToken;
        boolean active = false;
        Date lastActive = new Date();

        public Lock(QName lockQName) {
            this.lockQName = lockQName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void makeLock() {
            if (fgLogger.isDebugEnabled()) {
                fgLogger.debug((Object)("target lock refresh time :" + DeploymentServiceImpl.this.getTargetLockRefreshTime() + "targetLockRetryWait:" + DeploymentServiceImpl.this.targetLockRetryWait + "targetLockRetryCount:" + DeploymentServiceImpl.this.targetLockRetryCount));
            }
            this.lockToken = DeploymentServiceImpl.this.jobLockService.getLock(this.lockQName, DeploymentServiceImpl.this.targetLockRefreshTime, DeploymentServiceImpl.this.targetLockRetryWait, DeploymentServiceImpl.this.targetLockRetryCount);
            Lock lock = this;
            synchronized (lock) {
                this.active = true;
            }
            if (fgLogger.isDebugEnabled()) {
                fgLogger.debug((Object)("lock taken:" + this.lockQName));
            }
            this.checkLock();
            fgLogger.debug((Object)("register lock callback, target lock refresh time :" + DeploymentServiceImpl.this.getTargetLockRefreshTime()));
            DeploymentServiceImpl.this.jobLockService.refreshLock(this.lockToken, this.lockQName, DeploymentServiceImpl.this.getTargetLockRefreshTime(), this);
            fgLogger.debug((Object)"callback registered");
        }

        public void checkLock() {
            if (this.active) {
                Date now = new Date();
                if (now.getTime() > this.lastActive.getTime() + DeploymentServiceImpl.this.targetLockTimeToLive) {
                    MessageFormat f = new MessageFormat("Deployment Lock timeout, lock time to live exceeded, timeout:{0}mS time since last activity:{1}mS");
                    Object[] objs = new Object[]{new Long(DeploymentServiceImpl.this.targetLockTimeToLive), new Long(now.getTime() - this.lastActive.getTime())};
                    throw new AVMException(f.format(objs));
                }
                if (now.getTime() > this.lastActive.getTime() + 1000L) {
                    this.lastActive = new Date();
                    fgLogger.debug((Object)("lastActive:" + this.lastActive));
                }
            } else {
                MessageFormat f = new MessageFormat("Lock timeout, lock not active");
                Object[] objs = new Object[]{};
                throw new AVMException(f.format(objs));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseLock() {
            if (fgLogger.isDebugEnabled()) {
                fgLogger.debug((Object)("deployment service about to releaseLock : " + this.lockQName));
            }
            if (this.active) {
                DeploymentServiceImpl.this.jobLockService.releaseLock(this.lockToken, this.lockQName);
            }
            fgLogger.debug((Object)("setting active = false" + this.lockQName));
            Lock lock = this;
            synchronized (lock) {
                this.active = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isActive() {
            Date now = new Date();
            Lock lock = this;
            synchronized (lock) {
                if (now.getTime() > this.lastActive.getTime() + DeploymentServiceImpl.this.targetLockTimeToLive) {
                    this.active = false;
                }
                if (fgLogger.isDebugEnabled()) {
                    fgLogger.debug((Object)("deployment service callback active: " + this.active));
                }
                return this.active;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void lockReleased() {
            fgLogger.debug((Object)"deployment service: lock released callback");
            Lock lock = this;
            synchronized (lock) {
                this.active = false;
            }
        }
    }

    private class EventQueueWorker
    extends Thread {
        private BlockingQueue<DeploymentEvent> eventQueue;
        private List<DeploymentCallback> callbacks;
        private String userName;
        private boolean stopMe = false;

        EventQueueWorker(String userName, BlockingQueue<DeploymentEvent> eventQueue, List<DeploymentCallback> callbacks) {
            this.eventQueue = eventQueue;
            this.callbacks = callbacks;
            this.userName = userName;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            AuthenticationUtil.setFullyAuthenticatedUser((String)this.userName);
            while (true) {
                event = null;
                try {
                    event = this.eventQueue.poll(3L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e1) {
                    DeploymentServiceImpl.access$500().debug((Object)"Interrupted ", (Throwable)e1);
                }
                if (event == null) {
                    if (!this.stopMe) continue;
                    break;
                }
                if (DeploymentServiceImpl.access$500().isDebugEnabled()) {
                    DeploymentServiceImpl.access$500().debug((Object)event);
                }
                if (this.callbacks == null) continue;
                i$ = this.callbacks.iterator();
                while (true) {
                    if (!i$.hasNext()) ** break;
                    callback = i$.next();
                    callback.eventOccurred(event);
                }
                break;
            }
            DeploymentServiceImpl.access$500().debug((Object)"Event Queue Closing Normally");
        }

        public void stopMeWhenIdle() {
            this.stopMe = true;
        }
    }

    private class ComparatorAVMNodeDescriptorCaseSensitive
    implements Comparator<AVMNodeDescriptor> {
        private ComparatorAVMNodeDescriptorCaseSensitive() {
        }

        @Override
        public int compare(AVMNodeDescriptor o1, AVMNodeDescriptor o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private class ComparatorFileDescriptorCaseSensitive
    implements Comparator<FileDescriptor> {
        private ComparatorFileDescriptorCaseSensitive() {
        }

        @Override
        public int compare(FileDescriptor o1, FileDescriptor o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

