/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary.types.period;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import junit.framework.TestCase;
import org.alfresco.repo.dictionary.types.period.AbstractEndOfCalendarPeriodProvider;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.Period;
import org.alfresco.service.cmr.repository.PeriodProvider;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.CachingDateFormat;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class PeriodTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        ApplicationContextHelper.getApplicationContext();
    }

    public void test01NoPeriod() {
        PeriodTest.assertTrue((boolean)Period.getProviderNames().contains("none"));
        Period period = new Period("none");
        PeriodTest.assertNull((Object)period.getNextDate(new Date()));
        PeriodProvider provider = Period.getProvider((String)"none");
        PeriodTest.assertNull((Object)provider.getDefaultExpression());
        PeriodTest.assertEquals((Object)provider.getExpressionMutiplicity(), (Object)PeriodProvider.ExpressionMutiplicity.NONE);
        PeriodTest.assertNull((Object)provider.getNextDate(new Date(), null));
        PeriodTest.assertNull((Object)provider.getNextDate(new Date(), ""));
        PeriodTest.assertNull((Object)provider.getNextDate(new Date(), "meep"));
        PeriodTest.assertEquals((String)provider.getPeriodType(), (String)"none");
        PeriodTest.assertNull((Object)provider.getExpressionDataType());
        PeriodTest.assertEquals((String)"None", (String)provider.getDisplayLabel());
    }

    public void test02Days() {
        PeriodTest.assertTrue((boolean)Period.getProviderNames().contains("day"));
        Period period = new Period("day");
        Date now = new Date();
        PeriodTest.assertNotNull((Object)period.getNextDate(now));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(6, 1);
        PeriodTest.assertEquals((Object)period.getNextDate(now), (Object)calendar.getTime());
        period = new Period("day|0");
        PeriodTest.assertNotNull((Object)period.getNextDate(now));
        calendar.setTime(now);
        calendar.add(6, 0);
        PeriodTest.assertEquals((Object)period.getNextDate(now), (Object)calendar.getTime());
        period = new Period("day|1");
        PeriodTest.assertNotNull((Object)period.getNextDate(now));
        calendar.setTime(now);
        calendar.add(6, 1);
        PeriodTest.assertEquals((Object)period.getNextDate(now), (Object)calendar.getTime());
        period = new Period("day|2");
        PeriodTest.assertNotNull((Object)period.getNextDate(now));
        calendar.setTime(now);
        calendar.add(6, 2);
        PeriodTest.assertEquals((Object)period.getNextDate(now), (Object)calendar.getTime());
        PeriodProvider provider = Period.getProvider((String)"day");
        PeriodTest.assertEquals((String)provider.getDefaultExpression(), (String)"1");
        PeriodTest.assertEquals((Object)provider.getExpressionMutiplicity(), (Object)PeriodProvider.ExpressionMutiplicity.OPTIONAL);
        PeriodTest.assertNotNull((Object)provider.getNextDate(now, "0"));
        PeriodTest.assertNotNull((Object)provider.getNextDate(now, "1"));
        PeriodTest.assertNotNull((Object)provider.getNextDate(now, "2"));
        PeriodTest.assertEquals((String)provider.getPeriodType(), (String)"day");
        PeriodTest.assertEquals((Object)DataTypeDefinition.INT, (Object)provider.getExpressionDataType());
        PeriodTest.assertEquals((String)"Day", (String)provider.getDisplayLabel());
    }

    public void test03Weeks() {
        PeriodTest.assertTrue((boolean)Period.getProviderNames().contains("week"));
        Period period = new Period("week");
        Date now = new Date();
        PeriodTest.assertNotNull((Object)period.getNextDate(now));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(3, 1);
        PeriodTest.assertEquals((Object)period.getNextDate(now), (Object)calendar.getTime());
        period = new Period("week|0");
        PeriodTest.assertNotNull((Object)period.getNextDate(now));
        calendar.setTime(now);
        calendar.add(3, 0);
        PeriodTest.assertEquals((Object)period.getNextDate(now), (Object)calendar.getTime());
        period = new Period("week|1");
        PeriodTest.assertNotNull((Object)period.getNextDate(now));
        calendar.setTime(now);
        calendar.add(3, 1);
        PeriodTest.assertEquals((Object)period.getNextDate(now), (Object)calendar.getTime());
        period = new Period("week|2");
        PeriodTest.assertNotNull((Object)period.getNextDate(now));
        calendar.setTime(now);
        calendar.add(3, 2);
        PeriodTest.assertEquals((Object)period.getNextDate(now), (Object)calendar.getTime());
        PeriodProvider provider = Period.getProvider((String)"week");
        PeriodTest.assertEquals((String)provider.getDefaultExpression(), (String)"1");
        PeriodTest.assertEquals((Object)provider.getExpressionMutiplicity(), (Object)PeriodProvider.ExpressionMutiplicity.OPTIONAL);
        PeriodTest.assertNotNull((Object)provider.getNextDate(now, "0"));
        PeriodTest.assertNotNull((Object)provider.getNextDate(now, "1"));
        PeriodTest.assertNotNull((Object)provider.getNextDate(now, "2"));
        PeriodTest.assertEquals((String)provider.getPeriodType(), (String)"week");
        PeriodTest.assertEquals((Object)DataTypeDefinition.INT, (Object)provider.getExpressionDataType());
        PeriodTest.assertEquals((String)"Week", (String)provider.getDisplayLabel());
    }

    public void test04Months() {
        PeriodTest.assertTrue((boolean)Period.getProviderNames().contains("month"));
        Period period = new Period("month");
        Date now = new Date();
        PeriodTest.assertNotNull((Object)period.getNextDate(now));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(2, 1);
        PeriodTest.assertEquals((Object)period.getNextDate(now), (Object)calendar.getTime());
        period = new Period("month|0");
        PeriodTest.assertNotNull((Object)period.getNextDate(now));
        calendar.setTime(now);
        calendar.add(2, 0);
        PeriodTest.assertEquals((Object)period.getNextDate(now), (Object)calendar.getTime());
        period = new Period("month|1");
        PeriodTest.assertNotNull((Object)period.getNextDate(now));
        calendar.setTime(now);
        calendar.add(2, 1);
        PeriodTest.assertEquals((Object)period.getNextDate(now), (Object)calendar.getTime());
        period = new Period("month|2");
        PeriodTest.assertNotNull((Object)period.getNextDate(now));
        calendar.setTime(now);
        calendar.add(2, 2);
        PeriodTest.assertEquals((Object)period.getNextDate(now), (Object)calendar.getTime());
        PeriodProvider provider = Period.getProvider((String)"month");
        PeriodTest.assertEquals((String)provider.getDefaultExpression(), (String)"1");
        PeriodTest.assertEquals((Object)provider.getExpressionMutiplicity(), (Object)PeriodProvider.ExpressionMutiplicity.OPTIONAL);
        PeriodTest.assertNotNull((Object)provider.getNextDate(now, "0"));
        PeriodTest.assertNotNull((Object)provider.getNextDate(now, "1"));
        PeriodTest.assertNotNull((Object)provider.getNextDate(now, "2"));
        PeriodTest.assertEquals((String)provider.getPeriodType(), (String)"month");
        PeriodTest.assertEquals((Object)DataTypeDefinition.INT, (Object)provider.getExpressionDataType());
        PeriodTest.assertEquals((String)"Month", (String)provider.getDisplayLabel());
    }

    public void test05Quarters() {
        PeriodTest.assertTrue((boolean)Period.getProviderNames().contains("quarter"));
        Period period = new Period("quarter");
        Date now = new Date();
        PeriodTest.assertNotNull((Object)period.getNextDate(now));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(2, 3);
        PeriodTest.assertEquals((Object)period.getNextDate(now), (Object)calendar.getTime());
        period = new Period("quarter|0");
        PeriodTest.assertNotNull((Object)period.getNextDate(now));
        calendar.setTime(now);
        calendar.add(2, 0);
        PeriodTest.assertEquals((Object)period.getNextDate(now), (Object)calendar.getTime());
        period = new Period("quarter|1");
        PeriodTest.assertNotNull((Object)period.getNextDate(now));
        calendar.setTime(now);
        calendar.add(2, 3);
        PeriodTest.assertEquals((Object)period.getNextDate(now), (Object)calendar.getTime());
        period = new Period("quarter|2");
        PeriodTest.assertNotNull((Object)period.getNextDate(now));
        calendar.setTime(now);
        calendar.add(2, 6);
        PeriodTest.assertEquals((Object)period.getNextDate(now), (Object)calendar.getTime());
        PeriodProvider provider = Period.getProvider((String)"quarter");
        PeriodTest.assertEquals((String)provider.getDefaultExpression(), (String)"1");
        PeriodTest.assertEquals((Object)provider.getExpressionMutiplicity(), (Object)PeriodProvider.ExpressionMutiplicity.OPTIONAL);
        PeriodTest.assertNotNull((Object)provider.getNextDate(now, "0"));
        PeriodTest.assertNotNull((Object)provider.getNextDate(now, "1"));
        PeriodTest.assertNotNull((Object)provider.getNextDate(now, "2"));
        PeriodTest.assertEquals((String)provider.getPeriodType(), (String)"quarter");
        PeriodTest.assertEquals((Object)DataTypeDefinition.INT, (Object)provider.getExpressionDataType());
        PeriodTest.assertEquals((String)"Quarter", (String)provider.getDisplayLabel());
    }

    public void test06Years() {
        PeriodTest.assertTrue((boolean)Period.getProviderNames().contains("year"));
        Period period = new Period("year");
        Date now = new Date();
        PeriodTest.assertNotNull((Object)period.getNextDate(now));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(1, 1);
        PeriodTest.assertEquals((Object)period.getNextDate(now), (Object)calendar.getTime());
        period = new Period("year|0");
        PeriodTest.assertNotNull((Object)period.getNextDate(now));
        calendar.setTime(now);
        calendar.add(1, 0);
        PeriodTest.assertEquals((Object)period.getNextDate(now), (Object)calendar.getTime());
        period = new Period("year|1");
        PeriodTest.assertNotNull((Object)period.getNextDate(now));
        calendar.setTime(now);
        calendar.add(1, 1);
        PeriodTest.assertEquals((Object)period.getNextDate(now), (Object)calendar.getTime());
        period = new Period("year|2");
        PeriodTest.assertNotNull((Object)period.getNextDate(now));
        calendar.setTime(now);
        calendar.add(1, 2);
        PeriodTest.assertEquals((Object)period.getNextDate(now), (Object)calendar.getTime());
        PeriodProvider provider = Period.getProvider((String)"year");
        PeriodTest.assertEquals((String)provider.getDefaultExpression(), (String)"1");
        PeriodTest.assertEquals((Object)provider.getExpressionMutiplicity(), (Object)PeriodProvider.ExpressionMutiplicity.OPTIONAL);
        PeriodTest.assertNotNull((Object)provider.getNextDate(now, "0"));
        PeriodTest.assertNotNull((Object)provider.getNextDate(now, "1"));
        PeriodTest.assertNotNull((Object)provider.getNextDate(now, "2"));
        PeriodTest.assertEquals((String)provider.getPeriodType(), (String)"year");
        PeriodTest.assertEquals((Object)DataTypeDefinition.INT, (Object)provider.getExpressionDataType());
        PeriodTest.assertEquals((String)"Year", (String)provider.getDisplayLabel());
    }

    public void test07EndOfMonth() {
        PeriodTest.assertTrue((boolean)Period.getProviderNames().contains("monthend"));
        Period period = new Period("monthend");
        Date now = new Date();
        PeriodTest.assertNotNull((Object)period.getNextDate(now));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        PeriodTest.assertEquals((Object)period.getNextDate(now), (Object)calendar.getTime());
        for (int i = -100; i < 100; ++i) {
            period = new Period("monthend|" + i);
            PeriodTest.assertNotNull((Object)period.getNextDate(now));
            calendar.setTime(now);
            calendar.add(2, i);
            calendar.set(5, 1);
            calendar.add(5, -1);
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 999);
            PeriodTest.assertEquals((Object)period.getNextDate(now), (Object)calendar.getTime());
        }
        PeriodProvider provider = Period.getProvider((String)"monthend");
        PeriodTest.assertEquals((String)provider.getDefaultExpression(), (String)"1");
        PeriodTest.assertEquals((Object)provider.getExpressionMutiplicity(), (Object)PeriodProvider.ExpressionMutiplicity.OPTIONAL);
        PeriodTest.assertNotNull((Object)provider.getNextDate(now, "0"));
        PeriodTest.assertNotNull((Object)provider.getNextDate(now, "1"));
        PeriodTest.assertNotNull((Object)provider.getNextDate(now, "2"));
        PeriodTest.assertEquals((String)provider.getPeriodType(), (String)"monthend");
        PeriodTest.assertEquals((Object)DataTypeDefinition.INT, (Object)provider.getExpressionDataType());
        PeriodTest.assertEquals((String)"End Of Month", (String)provider.getDisplayLabel());
    }

    public void test08EndOfYear() {
        PeriodTest.assertTrue((boolean)Period.getProviderNames().contains("yearend"));
        Period period = new Period("yearend");
        Date now = new Date();
        PeriodTest.assertNotNull((Object)period.getNextDate(now));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(1, 1);
        calendar.set(6, 1);
        calendar.add(6, -1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        PeriodTest.assertEquals((Object)period.getNextDate(now), (Object)calendar.getTime());
        for (int i = -100; i < 100; ++i) {
            period = new Period("yearend|" + i);
            PeriodTest.assertNotNull((Object)period.getNextDate(now));
            calendar.setTime(now);
            calendar.add(1, i);
            calendar.set(6, 1);
            calendar.add(6, -1);
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 999);
            PeriodTest.assertEquals((Object)period.getNextDate(now), (Object)calendar.getTime());
        }
        PeriodProvider provider = Period.getProvider((String)"yearend");
        PeriodTest.assertEquals((String)provider.getDefaultExpression(), (String)"1");
        PeriodTest.assertEquals((Object)provider.getExpressionMutiplicity(), (Object)PeriodProvider.ExpressionMutiplicity.OPTIONAL);
        PeriodTest.assertNotNull((Object)provider.getNextDate(now, "0"));
        PeriodTest.assertNotNull((Object)provider.getNextDate(now, "1"));
        PeriodTest.assertNotNull((Object)provider.getNextDate(now, "2"));
        PeriodTest.assertEquals((String)provider.getPeriodType(), (String)"yearend");
        PeriodTest.assertEquals((Object)DataTypeDefinition.INT, (Object)provider.getExpressionDataType());
        PeriodTest.assertEquals((String)"End Of Year", (String)provider.getDisplayLabel());
    }

    public void test09EndOfQuarter() throws ParseException {
        PeriodProvider provider = Period.getProvider((String)"quarterend");
        PeriodTest.assertEquals((String)provider.getDefaultExpression(), (String)"1");
        PeriodTest.assertEquals((Object)provider.getExpressionMutiplicity(), (Object)PeriodProvider.ExpressionMutiplicity.OPTIONAL);
        PeriodTest.assertEquals((String)provider.getPeriodType(), (String)"quarterend");
        PeriodTest.assertEquals((Object)DataTypeDefinition.INT, (Object)provider.getExpressionDataType());
        PeriodTest.assertEquals((String)"End Of Quarter", (String)provider.getDisplayLabel());
        SimpleDateFormat df = CachingDateFormat.getDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss.SSS", (boolean)true);
        Period period = new Period("quarterend");
        Date date = df.parse("2009-01-01T00:00:00.000");
        PeriodTest.assertEquals((String)"2009-03-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-03-31T00:00:00.000");
        PeriodTest.assertEquals((String)"2009-03-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-04-01T00:00:00.000");
        PeriodTest.assertEquals((String)"2009-06-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-06-01T00:00:00.000");
        PeriodTest.assertEquals((String)"2009-06-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-06-30T23:59:59.999");
        PeriodTest.assertEquals((String)"2009-09-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-07-01T23:59:59.999");
        PeriodTest.assertEquals((String)"2009-09-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-09-30T23:59:59.998");
        PeriodTest.assertEquals((String)"2009-09-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-09-30T23:59:59.999");
        PeriodTest.assertEquals((String)"2009-12-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-10-01T23:59:00.000");
        PeriodTest.assertEquals((String)"2009-12-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-12-31T23:59:00.000");
        PeriodTest.assertEquals((String)"2009-12-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        period = new Period("quarterend|2");
        date = df.parse("2009-01-01T00:00:00.000");
        PeriodTest.assertEquals((String)"2009-06-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-03-31T00:00:00.000");
        PeriodTest.assertEquals((String)"2009-06-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-04-01T00:00:00.000");
        PeriodTest.assertEquals((String)"2009-09-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-06-01T00:00:00.000");
        PeriodTest.assertEquals((String)"2009-09-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-06-30T23:59:59.999");
        PeriodTest.assertEquals((String)"2009-12-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-07-01T23:59:59.999");
        PeriodTest.assertEquals((String)"2009-12-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-09-30T23:59:59.999");
        PeriodTest.assertEquals((String)"2010-03-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-10-01T23:59:00.000");
        PeriodTest.assertEquals((String)"2010-03-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-12-31T23:59:00.000");
        PeriodTest.assertEquals((String)"2010-03-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        period = new Period("quarterend|3");
        date = df.parse("2009-01-01T00:00:00.000");
        PeriodTest.assertEquals((String)"2009-09-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-03-31T00:00:00.000");
        PeriodTest.assertEquals((String)"2009-09-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-04-01T00:00:00.000");
        PeriodTest.assertEquals((String)"2009-12-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-06-01T00:00:00.000");
        PeriodTest.assertEquals((String)"2009-12-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-06-30T23:59:59.999");
        PeriodTest.assertEquals((String)"2010-03-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-07-01T23:59:59.999");
        PeriodTest.assertEquals((String)"2010-03-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-09-30T23:59:59.999");
        PeriodTest.assertEquals((String)"2010-06-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-10-01T23:59:00.000");
        PeriodTest.assertEquals((String)"2010-06-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-12-31T23:59:00.000");
        PeriodTest.assertEquals((String)"2010-06-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        period = new Period("quarterend|4");
        date = df.parse("2009-01-01T00:00:00.000");
        PeriodTest.assertEquals((String)"2009-12-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-03-31T00:00:00.000");
        PeriodTest.assertEquals((String)"2009-12-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-04-01T00:00:00.000");
        PeriodTest.assertEquals((String)"2010-03-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-06-01T00:00:00.000");
        PeriodTest.assertEquals((String)"2010-03-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-06-30T23:59:59.999");
        PeriodTest.assertEquals((String)"2010-06-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-07-01T23:59:59.999");
        PeriodTest.assertEquals((String)"2010-06-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-09-30T23:59:59.999");
        PeriodTest.assertEquals((String)"2010-09-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-10-01T23:59:00.000");
        PeriodTest.assertEquals((String)"2010-09-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-12-31T23:59:00.000");
        PeriodTest.assertEquals((String)"2010-09-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        period = new Period("quarterend|5");
        date = df.parse("2009-01-01T00:00:00.000");
        PeriodTest.assertEquals((String)"2010-03-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-03-31T00:00:00.000");
        PeriodTest.assertEquals((String)"2010-03-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-04-01T00:00:00.000");
        PeriodTest.assertEquals((String)"2010-06-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-06-01T00:00:00.000");
        PeriodTest.assertEquals((String)"2010-06-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-06-30T23:59:59.999");
        PeriodTest.assertEquals((String)"2010-09-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-07-01T23:59:59.999");
        PeriodTest.assertEquals((String)"2010-09-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-09-30T23:59:59.999");
        PeriodTest.assertEquals((String)"2010-12-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-10-01T23:59:00.000");
        PeriodTest.assertEquals((String)"2010-12-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-12-31T23:59:00.000");
        PeriodTest.assertEquals((String)"2010-12-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
    }

    public void test10EndOfDefaultFinancialMonth() {
        PeriodTest.assertTrue((boolean)Period.getProviderNames().contains("fmend"));
        Period period = new Period("fmend");
        PeriodProvider provider = Period.getProvider((String)"fmend");
        AbstractEndOfCalendarPeriodProvider instance = (AbstractEndOfCalendarPeriodProvider)provider;
        instance.setStartDayOfMonth(1);
        instance.setStartMonth(0);
        Date now = new Date();
        PeriodTest.assertNotNull((Object)period.getNextDate(now));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        PeriodTest.assertEquals((Object)period.getNextDate(now), (Object)calendar.getTime());
        for (int i = -100; i < 100; ++i) {
            period = new Period("fmend|" + i);
            PeriodTest.assertNotNull((Object)period.getNextDate(now));
            calendar.setTime(now);
            calendar.add(2, i);
            calendar.set(5, 1);
            calendar.add(5, -1);
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 999);
            PeriodTest.assertEquals((Object)period.getNextDate(now), (Object)calendar.getTime());
        }
        PeriodTest.assertEquals((String)provider.getDefaultExpression(), (String)"1");
        PeriodTest.assertEquals((Object)provider.getExpressionMutiplicity(), (Object)PeriodProvider.ExpressionMutiplicity.OPTIONAL);
        PeriodTest.assertNotNull((Object)provider.getNextDate(now, "0"));
        PeriodTest.assertNotNull((Object)provider.getNextDate(now, "1"));
        PeriodTest.assertNotNull((Object)provider.getNextDate(now, "2"));
        PeriodTest.assertEquals((String)provider.getPeriodType(), (String)"fmend");
        PeriodTest.assertEquals((Object)DataTypeDefinition.INT, (Object)provider.getExpressionDataType());
        PeriodTest.assertEquals((String)"End Of Financial Month", (String)provider.getDisplayLabel());
    }

    public void test11EndOfDefaultFinancialYear() throws ParseException {
        PeriodProvider provider = Period.getProvider((String)"fyend");
        PeriodTest.assertEquals((String)provider.getDefaultExpression(), (String)"1");
        PeriodTest.assertEquals((Object)provider.getExpressionMutiplicity(), (Object)PeriodProvider.ExpressionMutiplicity.OPTIONAL);
        PeriodTest.assertEquals((String)provider.getPeriodType(), (String)"fyend");
        PeriodTest.assertEquals((Object)DataTypeDefinition.INT, (Object)provider.getExpressionDataType());
        PeriodTest.assertEquals((String)"End Of Financial Year", (String)provider.getDisplayLabel());
        SimpleDateFormat df = CachingDateFormat.getDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss.SSS", (boolean)true);
        Period period = new Period("fyend");
        Date date = df.parse("2008-10-01T00:00:00.000");
        PeriodTest.assertEquals((String)"2009-09-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-09-30T23:59:59.998");
        PeriodTest.assertEquals((String)"2009-09-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-09-30T23:59:59.999");
        PeriodTest.assertEquals((String)"2010-09-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        period = new Period("fyend|10");
        date = df.parse("2008-10-01T00:00:00.000");
        PeriodTest.assertEquals((String)"2018-09-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-09-30T23:59:59.998");
        PeriodTest.assertEquals((String)"2018-09-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-09-30T23:59:59.999");
        PeriodTest.assertEquals((String)"2019-09-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
    }

    public void test12EndOfDefaultFinancialQuarter() throws ParseException {
        PeriodProvider provider = Period.getProvider((String)"fqend");
        PeriodTest.assertEquals((String)provider.getDefaultExpression(), (String)"1");
        PeriodTest.assertEquals((Object)provider.getExpressionMutiplicity(), (Object)PeriodProvider.ExpressionMutiplicity.OPTIONAL);
        PeriodTest.assertEquals((String)provider.getPeriodType(), (String)"fqend");
        PeriodTest.assertEquals((Object)DataTypeDefinition.INT, (Object)provider.getExpressionDataType());
        PeriodTest.assertEquals((String)"End Of Financial Quarter", (String)provider.getDisplayLabel());
        AbstractEndOfCalendarPeriodProvider instance = (AbstractEndOfCalendarPeriodProvider)provider;
        instance.setStartDayOfMonth(1);
        instance.setStartMonth(0);
        SimpleDateFormat df = CachingDateFormat.getDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss.SSS", (boolean)true);
        Period period = new Period("fqend");
        Date date = df.parse("2008-10-01T00:00:00.000");
        PeriodTest.assertEquals((String)"2008-12-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-12-31T23:59:59.998");
        PeriodTest.assertEquals((String)"2008-12-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-12-31T23:59:59.999");
        PeriodTest.assertEquals((String)"2009-03-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-01-01T00:00:00.000");
        PeriodTest.assertEquals((String)"2009-03-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-03-31T23:59:59.998");
        PeriodTest.assertEquals((String)"2009-03-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-03-31T23:59:59.999");
        PeriodTest.assertEquals((String)"2009-06-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-04-01T00:00:00.000");
        PeriodTest.assertEquals((String)"2009-06-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-06-30T23:59:59.998");
        PeriodTest.assertEquals((String)"2009-06-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-06-30T23:59:59.999");
        PeriodTest.assertEquals((String)"2009-09-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-07-01T00:00:00.000");
        PeriodTest.assertEquals((String)"2009-09-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-09-30T23:59:59.998");
        PeriodTest.assertEquals((String)"2009-09-30T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-09-30T23:59:59.999");
        PeriodTest.assertEquals((String)"2009-12-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-10-01T00:00:00.000");
        PeriodTest.assertEquals((String)"2009-12-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-12-31T23:59:59.998");
        PeriodTest.assertEquals((String)"2009-12-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-12-31T23:59:59.999");
        PeriodTest.assertEquals((String)"2010-03-31T23:59:59.999", (String)df.format(period.getNextDate(date)));
    }

    public void test13EndOfUKTaxYear() throws ParseException {
        PeriodProvider provider = Period.getProvider((String)"fyend");
        PeriodTest.assertEquals((String)provider.getDefaultExpression(), (String)"1");
        PeriodTest.assertEquals((Object)provider.getExpressionMutiplicity(), (Object)PeriodProvider.ExpressionMutiplicity.OPTIONAL);
        PeriodTest.assertEquals((String)provider.getPeriodType(), (String)"fyend");
        PeriodTest.assertEquals((Object)DataTypeDefinition.INT, (Object)provider.getExpressionDataType());
        AbstractEndOfCalendarPeriodProvider instance = (AbstractEndOfCalendarPeriodProvider)provider;
        instance.setStartDayOfMonth(6);
        instance.setStartMonth(3);
        SimpleDateFormat df = CachingDateFormat.getDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss.SSS", (boolean)true);
        Period period = new Period("fyend");
        Date date = df.parse("2008-4-06T00:00:00.000");
        PeriodTest.assertEquals((String)"2009-04-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-04-05T23:59:59.998");
        PeriodTest.assertEquals((String)"2009-04-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-04-05T23:59:59.999");
        PeriodTest.assertEquals((String)"2010-04-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        period = new Period("fyend|10");
        date = df.parse("2008-4-06T00:00:00.000");
        PeriodTest.assertEquals((String)"2018-04-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-04-05T23:59:59.998");
        PeriodTest.assertEquals((String)"2018-04-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-04-05T23:59:59.999");
        PeriodTest.assertEquals((String)"2019-04-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
    }

    public void test14EndOfUKTaxQuarter() throws ParseException {
        PeriodProvider provider = Period.getProvider((String)"fqend");
        PeriodTest.assertEquals((String)provider.getDefaultExpression(), (String)"1");
        PeriodTest.assertEquals((Object)provider.getExpressionMutiplicity(), (Object)PeriodProvider.ExpressionMutiplicity.OPTIONAL);
        PeriodTest.assertEquals((String)provider.getPeriodType(), (String)"fqend");
        PeriodTest.assertEquals((Object)DataTypeDefinition.INT, (Object)provider.getExpressionDataType());
        AbstractEndOfCalendarPeriodProvider instance = (AbstractEndOfCalendarPeriodProvider)provider;
        instance.setStartDayOfMonth(6);
        instance.setStartMonth(3);
        SimpleDateFormat df = CachingDateFormat.getDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss.SSS", (boolean)true);
        Period period = new Period("fqend");
        Date date = df.parse("2008-04-06T00:00:00.000");
        PeriodTest.assertEquals((String)"2008-07-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-07-05T23:59:59.998");
        PeriodTest.assertEquals((String)"2008-07-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-07-05T23:59:59.999");
        PeriodTest.assertEquals((String)"2008-10-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-07-06T00:00:00.000");
        PeriodTest.assertEquals((String)"2008-10-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-10-05T23:59:59.998");
        PeriodTest.assertEquals((String)"2008-10-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-10-05T23:59:59.999");
        PeriodTest.assertEquals((String)"2009-01-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-10-06T00:00:00.000");
        PeriodTest.assertEquals((String)"2009-01-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-01-05T23:59:59.998");
        PeriodTest.assertEquals((String)"2009-01-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-01-05T23:59:59.999");
        PeriodTest.assertEquals((String)"2009-04-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-01-06T00:00:00.000");
        PeriodTest.assertEquals((String)"2009-04-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-04-05T23:59:59.998");
        PeriodTest.assertEquals((String)"2009-04-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-04-05T23:59:59.999");
        PeriodTest.assertEquals((String)"2009-07-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-04-06T00:00:00.000");
        PeriodTest.assertEquals((String)"2009-07-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-07-05T23:59:59.998");
        PeriodTest.assertEquals((String)"2009-07-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-07-05T23:59:59.999");
        PeriodTest.assertEquals((String)"2009-10-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
    }

    public void test15EndOfUKTaxMonth() throws ParseException {
        PeriodProvider provider = Period.getProvider((String)"fmend");
        PeriodTest.assertEquals((String)provider.getDefaultExpression(), (String)"1");
        PeriodTest.assertEquals((Object)provider.getExpressionMutiplicity(), (Object)PeriodProvider.ExpressionMutiplicity.OPTIONAL);
        PeriodTest.assertEquals((String)provider.getPeriodType(), (String)"fmend");
        PeriodTest.assertEquals((Object)DataTypeDefinition.INT, (Object)provider.getExpressionDataType());
        AbstractEndOfCalendarPeriodProvider instance = (AbstractEndOfCalendarPeriodProvider)provider;
        instance.setStartDayOfMonth(6);
        instance.setStartMonth(3);
        SimpleDateFormat df = CachingDateFormat.getDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss.SSS", (boolean)true);
        Period period = new Period("fmend");
        Date date = df.parse("2008-04-06T00:00:00.000");
        PeriodTest.assertEquals((String)"2008-05-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-05-05T23:59:59.998");
        PeriodTest.assertEquals((String)"2008-05-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-05-05T23:59:59.999");
        PeriodTest.assertEquals((String)"2008-06-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-05-06T00:00:00.000");
        PeriodTest.assertEquals((String)"2008-06-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-06-05T23:59:59.998");
        PeriodTest.assertEquals((String)"2008-06-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-06-05T23:59:59.999");
        PeriodTest.assertEquals((String)"2008-07-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-06-06T00:00:00.000");
        PeriodTest.assertEquals((String)"2008-07-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-07-05T23:59:59.998");
        PeriodTest.assertEquals((String)"2008-07-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-07-05T23:59:59.999");
        PeriodTest.assertEquals((String)"2008-08-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-07-06T00:00:00.000");
        PeriodTest.assertEquals((String)"2008-08-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-08-05T23:59:59.998");
        PeriodTest.assertEquals((String)"2008-08-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-08-05T23:59:59.999");
        PeriodTest.assertEquals((String)"2008-09-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-08-06T00:00:00.000");
        PeriodTest.assertEquals((String)"2008-09-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-09-05T23:59:59.998");
        PeriodTest.assertEquals((String)"2008-09-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-09-05T23:59:59.999");
        PeriodTest.assertEquals((String)"2008-10-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-09-06T00:00:00.000");
        PeriodTest.assertEquals((String)"2008-10-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-10-05T23:59:59.998");
        PeriodTest.assertEquals((String)"2008-10-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-10-05T23:59:59.999");
        PeriodTest.assertEquals((String)"2008-11-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-10-06T00:00:00.000");
        PeriodTest.assertEquals((String)"2008-11-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-11-05T23:59:59.998");
        PeriodTest.assertEquals((String)"2008-11-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-11-05T23:59:59.999");
        PeriodTest.assertEquals((String)"2008-12-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-11-06T00:00:00.000");
        PeriodTest.assertEquals((String)"2008-12-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-12-05T23:59:59.998");
        PeriodTest.assertEquals((String)"2008-12-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-12-05T23:59:59.999");
        PeriodTest.assertEquals((String)"2009-01-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2008-12-06T00:00:00.000");
        PeriodTest.assertEquals((String)"2009-01-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-01-05T23:59:59.998");
        PeriodTest.assertEquals((String)"2009-01-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-01-05T23:59:59.999");
        PeriodTest.assertEquals((String)"2009-02-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-01-06T00:00:00.000");
        PeriodTest.assertEquals((String)"2009-02-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-02-05T23:59:59.998");
        PeriodTest.assertEquals((String)"2009-02-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-02-05T23:59:59.999");
        PeriodTest.assertEquals((String)"2009-03-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-02-06T00:00:00.000");
        PeriodTest.assertEquals((String)"2009-03-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-03-05T23:59:59.998");
        PeriodTest.assertEquals((String)"2009-03-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-03-05T23:59:59.999");
        PeriodTest.assertEquals((String)"2009-04-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-03-06T00:00:00.000");
        PeriodTest.assertEquals((String)"2009-04-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-04-05T23:59:59.998");
        PeriodTest.assertEquals((String)"2009-04-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-04-05T23:59:59.999");
        PeriodTest.assertEquals((String)"2009-05-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-04-06T00:00:00.000");
        PeriodTest.assertEquals((String)"2009-05-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-05-05T23:59:59.998");
        PeriodTest.assertEquals((String)"2009-05-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
        date = df.parse("2009-05-05T23:59:59.999");
        PeriodTest.assertEquals((String)"2009-06-05T23:59:59.999", (String)df.format(period.getNextDate(date)));
    }

    public void test16Cron() throws ParseException {
        PeriodProvider provider = Period.getProvider((String)"cron");
        PeriodTest.assertEquals((String)provider.getDefaultExpression(), (String)"59 59 23 * * ?");
        PeriodTest.assertEquals((Object)provider.getExpressionMutiplicity(), (Object)PeriodProvider.ExpressionMutiplicity.MANDATORY);
        PeriodTest.assertEquals((String)provider.getPeriodType(), (String)"cron");
        PeriodTest.assertEquals((Object)DataTypeDefinition.TEXT, (Object)provider.getExpressionDataType());
        PeriodTest.assertEquals((String)"Cron Expression", (String)provider.getDisplayLabel());
        SimpleDateFormat df = CachingDateFormat.getDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss.SSS", (boolean)true);
        Period period = new Period("cron");
        Date date = df.parse("2009-06-02T00:00:00.000");
        PeriodTest.assertEquals((String)"2009-06-02T23:59:59.000", (String)df.format(period.getNextDate(date)));
        period = new Period("cron|0 0 2 ? * 6#1");
        PeriodTest.assertEquals((String)"2009-06-05T02:00:00.000", (String)df.format(period.getNextDate(date)));
    }

    public void test17XMLDuration() throws ParseException {
        PeriodProvider provider = Period.getProvider((String)"duration");
        PeriodTest.assertEquals((String)provider.getDefaultExpression(), (String)"P1D");
        PeriodTest.assertEquals((Object)provider.getExpressionMutiplicity(), (Object)PeriodProvider.ExpressionMutiplicity.MANDATORY);
        PeriodTest.assertEquals((String)provider.getPeriodType(), (String)"duration");
        PeriodTest.assertEquals((Object)DataTypeDefinition.TEXT, (Object)provider.getExpressionDataType());
        PeriodTest.assertEquals((String)"XML Duration", (String)provider.getDisplayLabel());
        SimpleDateFormat df = CachingDateFormat.getDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss.SSS", (boolean)true);
        Period period = new Period("duration");
        Date date = df.parse("2009-06-02T01:02:03.004");
        PeriodTest.assertEquals((String)"2009-06-03T01:02:03.004", (String)df.format(period.getNextDate(date)));
        period = new Period("duration|P2Y6M5DT12H35M30.100S");
        PeriodTest.assertEquals((String)"2011-12-07T13:37:33.104", (String)df.format(period.getNextDate(date)));
    }

    public void test18MissingExpression() {
        PeriodTest.assertTrue((boolean)Period.getProviderNames().contains("day"));
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        Period period = new Period("day|");
        PeriodTest.assertNotNull((Object)period.getNextDate(now));
        calendar.setTime(now);
        calendar.add(6, 1);
        PeriodTest.assertEquals((Object)period.getNextDate(now), (Object)calendar.getTime());
    }
}

