/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.contentdata;

import java.io.Serializable;
import java.sql.Savepoint;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.cache.lookup.EntityLookupCache;
import org.alfresco.repo.content.cleanup.EagerContentStoreCleaner;
import org.alfresco.repo.domain.contentdata.ContentDataDAO;
import org.alfresco.repo.domain.contentdata.ContentDataEntity;
import org.alfresco.repo.domain.contentdata.ContentUrlEntity;
import org.alfresco.repo.domain.control.ControlDAO;
import org.alfresco.repo.domain.encoding.EncodingDAO;
import org.alfresco.repo.domain.locale.LocaleDAO;
import org.alfresco.repo.domain.mimetype.MimetypeDAO;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataIntegrityViolationException;

public abstract class AbstractContentDataDAOImpl
implements ContentDataDAO {
    private static final String CACHE_REGION_CONTENT_DATA = "ContentData";
    private static final String KEY_PRE_COMMIT_CONTENT_URL_DELETIONS = "AbstractContentDataDAOImpl.PreCommitContentUrlDeletions";
    private static Log logger = LogFactory.getLog(AbstractContentDataDAOImpl.class);
    private final ContentDataCallbackDAO contentDataCallbackDAO = new ContentDataCallbackDAO();
    private ControlDAO controlDAO;
    private MimetypeDAO mimetypeDAO;
    private EncodingDAO encodingDAO;
    private LocaleDAO localeDAO;
    private EagerContentStoreCleaner contentStoreCleaner;
    private EntityLookupCache<Long, ContentData, Serializable> contentDataCache = new EntityLookupCache<Long, ContentData, Serializable>(this.contentDataCallbackDAO);

    public void setControlDAO(ControlDAO controlDAO) {
        this.controlDAO = controlDAO;
    }

    public void setMimetypeDAO(MimetypeDAO mimetypeDAO) {
        this.mimetypeDAO = mimetypeDAO;
    }

    public void setEncodingDAO(EncodingDAO encodingDAO) {
        this.encodingDAO = encodingDAO;
    }

    public void setLocaleDAO(LocaleDAO localeDAO) {
        this.localeDAO = localeDAO;
    }

    public void setContentStoreCleaner(EagerContentStoreCleaner contentStoreCleaner) {
        this.contentStoreCleaner = contentStoreCleaner;
    }

    public void setContentDataCache(SimpleCache<Long, ContentData> contentDataCache) {
        this.contentDataCache = new EntityLookupCache<Long, ContentData, Serializable>(contentDataCache, CACHE_REGION_CONTENT_DATA, this.contentDataCallbackDAO);
    }

    protected void registerDereferencedContentUrl(String contentUrl) {
        Set contentUrls = TransactionalResourceHelper.getSet(KEY_PRE_COMMIT_CONTENT_URL_DELETIONS);
        if (contentUrls.size() == 0) {
            ContentUrlDeleteTransactionListener listener = new ContentUrlDeleteTransactionListener();
            AlfrescoTransactionSupport.bindListener(listener);
        }
        contentUrls.add(contentUrl);
    }

    @Override
    public Pair<Long, ContentData> createContentData(ContentData contentData) {
        if (contentData == null) {
            throw new IllegalArgumentException("ContentData values cannot be null");
        }
        Pair<Long, ContentData> entityPair = this.contentDataCache.getOrCreateByValue(contentData);
        return entityPair;
    }

    @Override
    public Pair<Long, ContentData> getContentData(Long id) {
        if (id == null) {
            throw new IllegalArgumentException("Cannot look up ContentData by null ID.");
        }
        Pair<Long, ContentData> entityPair = this.contentDataCache.getByKey(id);
        if (entityPair == null) {
            throw new DataIntegrityViolationException("No ContentData value exists for ID " + id);
        }
        return entityPair;
    }

    @Override
    public void cacheContentDataForNodes(Set<Long> nodeIds) {
        for (ContentDataEntity entity : this.getContentDataEntitiesForNodes(nodeIds)) {
            this.contentDataCache.setValue(entity.getId(), this.makeContentData(entity));
        }
    }

    @Override
    public void updateContentData(Long id, ContentData contentData) {
        if (id == null) {
            throw new IllegalArgumentException("Cannot look up ContentData by null ID.");
        }
        if (contentData == null) {
            throw new IllegalArgumentException("Cannot update ContentData with a null.");
        }
        int updated = this.contentDataCache.updateValue(id, contentData);
        if (updated < 1) {
            throw new ConcurrencyFailureException("ContentData with ID " + id + " not updated");
        }
    }

    @Override
    public void deleteContentData(Long id) {
        if (id == null) {
            throw new IllegalArgumentException("Cannot delete ContentData by null ID.");
        }
        int deleted = this.contentDataCache.deleteByKey(id);
        if (deleted < 1) {
            throw new ConcurrencyFailureException("ContentData with ID " + id + " no longer exists");
        }
    }

    private ContentData makeContentData(ContentDataEntity contentDataEntity) {
        String contentUrl = contentDataEntity.getContentUrl();
        long size = contentDataEntity.getSize() == null ? 0L : contentDataEntity.getSize();
        Long mimetypeId = contentDataEntity.getMimetypeId();
        String mimetype = null;
        if (mimetypeId != null) {
            mimetype = (String)this.mimetypeDAO.getMimetype(mimetypeId).getSecond();
        }
        Long encodingId = contentDataEntity.getEncodingId();
        String encoding = null;
        if (encodingId != null) {
            encoding = (String)this.encodingDAO.getEncoding(encodingId).getSecond();
        }
        Long localeId = contentDataEntity.getLocaleId();
        Locale locale = null;
        if (localeId != null) {
            locale = (Locale)this.localeDAO.getLocalePair(localeId).getSecond();
        }
        ContentData contentData = new ContentData(contentUrl, mimetype, size, encoding, locale);
        return contentData;
    }

    private ContentDataEntity createContentDataEntity(ContentData contentData) {
        Long contentUrlId = null;
        String contentUrl = contentData.getContentUrl();
        long size = contentData.getSize();
        if (contentUrl != null) {
            contentUrlId = this.getOrCreateContentUrlEntity(contentUrl, size).getId();
        }
        Long mimetypeId = null;
        String mimetype = contentData.getMimetype();
        if (mimetype != null) {
            mimetypeId = (Long)this.mimetypeDAO.getOrCreateMimetype(mimetype).getFirst();
        }
        Long encodingId = null;
        String encoding = contentData.getEncoding();
        if (encoding != null) {
            encodingId = (Long)this.encodingDAO.getOrCreateEncoding(encoding).getFirst();
        }
        Long localeId = null;
        Locale locale = contentData.getLocale();
        if (locale != null) {
            localeId = (Long)this.localeDAO.getOrCreateLocalePair(locale).getFirst();
        }
        ContentDataEntity contentDataEntity = this.createContentDataEntity(contentUrlId, mimetypeId, encodingId, localeId);
        return contentDataEntity;
    }

    private int updateContentDataEntity(ContentDataEntity contentDataEntity, ContentData contentData) {
        String newContentUrl;
        String oldContentUrl = contentDataEntity.getContentUrl();
        if (!EqualsHelper.nullSafeEquals((Object)oldContentUrl, (Object)(newContentUrl = contentData.getContentUrl()))) {
            if (oldContentUrl != null) {
                this.registerDereferencedContentUrl(oldContentUrl);
            }
            if (newContentUrl != null) {
                Long contentUrlId = this.getOrCreateContentUrlEntity(newContentUrl, contentData.getSize()).getId();
                contentDataEntity.setContentUrlId(contentUrlId);
                contentDataEntity.setContentUrl(newContentUrl);
            } else {
                contentDataEntity.setContentUrlId(null);
                contentDataEntity.setContentUrl(null);
            }
        }
        Long mimetypeId = null;
        String mimetype = contentData.getMimetype();
        if (mimetype != null) {
            mimetypeId = (Long)this.mimetypeDAO.getOrCreateMimetype(mimetype).getFirst();
        }
        Long encodingId = null;
        String encoding = contentData.getEncoding();
        if (encoding != null) {
            encodingId = (Long)this.encodingDAO.getOrCreateEncoding(encoding).getFirst();
        }
        Long localeId = null;
        Locale locale = contentData.getLocale();
        if (locale != null) {
            localeId = (Long)this.localeDAO.getOrCreateLocalePair(locale).getFirst();
        }
        contentDataEntity.setMimetypeId(mimetypeId);
        contentDataEntity.setEncodingId(encodingId);
        contentDataEntity.setLocaleId(localeId);
        return this.updateContentDataEntity(contentDataEntity);
    }

    private ContentUrlEntity getOrCreateContentUrlEntity(String contentUrl, long size) {
        ContentUrlEntity contentUrlEntity;
        block4: {
            contentUrlEntity = null;
            Savepoint savepoint = this.controlDAO.createSavepoint("getOrCreateContentUrlEntity");
            try {
                contentUrlEntity = this.createContentUrlEntity(contentUrl, size);
                this.controlDAO.releaseSavepoint(savepoint);
            }
            catch (RuntimeException e) {
                Long id;
                int updated;
                Long oldOrphanTime;
                this.controlDAO.rollbackToSavepoint(savepoint);
                contentUrlEntity = this.getContentUrlEntity(contentUrl);
                if (contentUrlEntity == null) {
                    throw e;
                }
                long existingSize = contentUrlEntity.getSize();
                if (size != existingSize) {
                    logger.warn((Object)("Re-using Content URL, but size is mismatched: \n   Inbound: " + contentUrl + "\n" + "   Existing: " + contentUrlEntity));
                }
                if ((oldOrphanTime = contentUrlEntity.getOrphanTime()) == null || (updated = this.updateContentUrlOrphanTime(id = contentUrlEntity.getId(), null, oldOrphanTime)) != 0) break block4;
                throw new ConcurrencyFailureException("Failed to remove orphan time: " + contentUrlEntity);
            }
        }
        return contentUrlEntity;
    }

    protected abstract ContentUrlEntity createContentUrlEntity(String var1, long var2);

    protected abstract ContentUrlEntity getContentUrlEntity(Long var1);

    protected abstract ContentUrlEntity getContentUrlEntity(String var1);

    protected abstract ContentUrlEntity getContentUrlEntityUnreferenced(String var1);

    protected abstract int updateContentUrlOrphanTime(Long var1, Long var2, Long var3);

    protected abstract ContentDataEntity createContentDataEntity(Long var1, Long var2, Long var3, Long var4);

    protected abstract ContentDataEntity getContentDataEntity(Long var1);

    protected abstract List<ContentDataEntity> getContentDataEntitiesForNodes(Set<Long> var1);

    protected abstract int updateContentDataEntity(ContentDataEntity var1);

    protected abstract int deleteContentDataEntity(Long var1);

    public class ContentUrlDeleteTransactionListener
    extends TransactionListenerAdapter {
        @Override
        public void beforeCommit(boolean readOnly) {
            if (readOnly) {
                return;
            }
            Set<String> contentUrls = TransactionalResourceHelper.getSet(AbstractContentDataDAOImpl.KEY_PRE_COMMIT_CONTENT_URL_DELETIONS);
            long orphanTime = System.currentTimeMillis();
            for (String contentUrl : contentUrls) {
                List<Long> contentUrlId;
                ContentUrlEntity contentUrlEntity = AbstractContentDataDAOImpl.this.getContentUrlEntityUnreferenced(contentUrl);
                if (contentUrlEntity == null) continue;
                boolean isEagerCleanup = AbstractContentDataDAOImpl.this.contentStoreCleaner.registerOrphanedContentUrl(contentUrl);
                if (!isEagerCleanup) {
                    contentUrlId = contentUrlEntity.getId();
                    Long oldOrphanTime = contentUrlEntity.getOrphanTime();
                    int updated = AbstractContentDataDAOImpl.this.updateContentUrlOrphanTime((Long)((Object)contentUrlId), orphanTime, oldOrphanTime);
                    if (updated == 1) continue;
                    throw new ConcurrencyFailureException("Failed to update content URL orphan time: " + contentUrlEntity);
                }
                contentUrlId = Collections.singletonList(contentUrlEntity.getId());
                int deleted = AbstractContentDataDAOImpl.this.deleteContentUrls(contentUrlId);
                if (deleted == 1) continue;
                throw new ConcurrencyFailureException("Failed to delete eagerly-reaped content URL: " + contentUrlEntity);
            }
            contentUrls.clear();
        }
    }

    private class ContentDataCallbackDAO
    extends EntityLookupCache.EntityLookupCallbackDAOAdaptor<Long, ContentData, Serializable> {
        private ContentDataCallbackDAO() {
        }

        @Override
        public Pair<Long, ContentData> createValue(ContentData value) {
            ContentDataEntity contentDataEntity = AbstractContentDataDAOImpl.this.createContentDataEntity(value);
            return new Pair((Object)contentDataEntity.getId(), (Object)value);
        }

        @Override
        public Pair<Long, ContentData> findByKey(Long key) {
            ContentDataEntity contentDataEntity = AbstractContentDataDAOImpl.this.getContentDataEntity(key);
            if (contentDataEntity == null) {
                return null;
            }
            ContentData contentData = AbstractContentDataDAOImpl.this.makeContentData(contentDataEntity);
            return new Pair((Object)key, (Object)contentData);
        }

        @Override
        public int updateValue(Long key, ContentData value) {
            ContentDataEntity contentDataEntity = AbstractContentDataDAOImpl.this.getContentDataEntity(key);
            if (contentDataEntity == null) {
                return 0;
            }
            return AbstractContentDataDAOImpl.this.updateContentDataEntity(contentDataEntity, value);
        }

        @Override
        public int deleteByKey(Long key) {
            return AbstractContentDataDAOImpl.this.deleteContentDataEntity(key);
        }
    }
}

