/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.mimetype;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.repo.domain.mimetype.MimetypeDAO;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.springframework.context.ApplicationContext;

public class MimetypeDAOTest
extends TestCase {
    private ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private RetryingTransactionHelper txnHelper;
    private MimetypeDAO mimetypeDAO;

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.mimetypeDAO = (MimetypeDAO)this.ctx.getBean("mimetypeDAO");
    }

    private Pair<Long, String> get(final String mimetype, final boolean autoCreate, boolean expectSuccess) {
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>>(){

            @Override
            public Pair<Long, String> execute() throws Throwable {
                Pair<Long, String> mimetypePair = null;
                mimetypePair = autoCreate ? MimetypeDAOTest.this.mimetypeDAO.getOrCreateMimetype(mimetype) : MimetypeDAOTest.this.mimetypeDAO.getMimetype(mimetype);
                return mimetypePair;
            }
        };
        try {
            return this.txnHelper.doInTransaction(callback, !autoCreate, false);
        }
        catch (Throwable e) {
            if (expectSuccess) {
                throw new RuntimeException("Expected to get mimetype '" + mimetype + "'.", e);
            }
            return null;
        }
    }

    public void testCreateWithCommit() throws Exception {
        String mimetype = GUID.generate();
        Pair<Long, String> mimetypePair = this.get(mimetype, true, true);
        Pair<Long, String> mimetypePairCheck = this.get((String)mimetypePair.getSecond(), false, true);
        MimetypeDAOTest.assertEquals((String)"Mimetype ID changed", (Object)mimetypePair.getFirst(), (Object)mimetypePairCheck.getFirst());
    }

    public void testCreateWithRollback() throws Exception {
        final String mimetype = GUID.generate();
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>>(){

            @Override
            public Pair<Long, String> execute() throws Throwable {
                MimetypeDAOTest.this.get(mimetype, true, true);
                throw new RuntimeException("Forced");
            }
        };
        try {
            this.txnHelper.doInTransaction(callback);
            MimetypeDAOTest.fail((String)"Transaction didn't roll back");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.get(mimetype, false, false);
    }

    public void testCaseInsensitivity() throws Exception {
        String mimetype = "AAA-" + GUID.generate();
        Pair<Long, String> lowercasePair = this.get(mimetype.toLowerCase(), true, true);
        Pair<Long, String> uppercasePair = this.get(mimetype.toUpperCase(), true, true);
        MimetypeDAOTest.assertNotNull(uppercasePair);
        MimetypeDAOTest.assertEquals((String)"Upper and lowercase mimetype instance IDs were not the same", (Object)lowercasePair.getFirst(), (Object)uppercasePair.getFirst());
    }

    public void testUpdate() throws Exception {
        final String oldMimetype = GUID.generate();
        final String newMimetype = GUID.generate();
        Pair<Long, String> oldMimetypePair = this.get(oldMimetype, true, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>>(){

            @Override
            public Pair<Long, String> execute() throws Throwable {
                int count = MimetypeDAOTest.this.mimetypeDAO.updateMimetype(oldMimetype, newMimetype);
                Assert.assertEquals((String)"Incorrect number updated", (int)1, (int)count);
                return MimetypeDAOTest.this.mimetypeDAO.getMimetype(newMimetype);
            }
        };
        Pair<Long, String> newMimetypePair = this.txnHelper.doInTransaction(callback, false, false);
        MimetypeDAOTest.assertEquals((String)"ID should remain the same if the old mimetype existed", (Object)oldMimetypePair.getFirst(), (Object)newMimetypePair.getFirst());
        this.get(oldMimetype, false, false);
        this.get(newMimetype, false, true);
    }
}

