/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.propval;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.naming.CompositeName;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.repo.domain.propval.AbstractPropertyValueDAOImpl;
import org.alfresco.repo.domain.propval.PropertyUniqueConstraintViolation;
import org.alfresco.repo.domain.propval.PropertyValueDAO;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.surf.util.ISO8601DateFormat;

public class PropertyValueDAOTest
extends TestCase {
    private ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private RetryingTransactionHelper txnHelper;
    private PropertyValueDAO propertyValueDAO;

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.txnHelper.setMaxRetries(0);
        this.propertyValueDAO = (PropertyValueDAO)this.ctx.getBean("propertyValueDAO");
        this.removeCaches();
    }

    private void removeCaches() {
        ((AbstractPropertyValueDAOImpl)this.propertyValueDAO).setPropertyClassCache(null);
        ((AbstractPropertyValueDAOImpl)this.propertyValueDAO).setPropertyDateValueCache(null);
        ((AbstractPropertyValueDAOImpl)this.propertyValueDAO).setPropertyDoubleValueCache(null);
        ((AbstractPropertyValueDAOImpl)this.propertyValueDAO).setPropertyStringValueCache(null);
        ((AbstractPropertyValueDAOImpl)this.propertyValueDAO).setPropertyValueCache(null);
    }

    public void testPropertyClass() throws Exception {
        final Class<?> clazz = ((Object)((Object)this)).getClass();
        RetryingTransactionHelper.RetryingTransactionCallback createClassCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Class<?>>>(){

            @Override
            public Pair<Long, Class<?>> execute() throws Throwable {
                return PropertyValueDAOTest.this.propertyValueDAO.getOrCreatePropertyClass(clazz);
            }
        };
        final Pair clazzEntityPair = (Pair)this.txnHelper.doInTransaction(createClassCallback, false);
        PropertyValueDAOTest.assertNotNull((Object)clazzEntityPair);
        PropertyValueDAOTest.assertNotNull((Object)clazzEntityPair.getFirst());
        PropertyValueDAOTest.assertEquals(clazz, (Object)clazzEntityPair.getSecond());
        RetryingTransactionHelper.RetryingTransactionCallback<Void> getClassCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                Pair<Long, Class<?>> checkPair1 = PropertyValueDAOTest.this.propertyValueDAO.getPropertyClassById((Long)clazzEntityPair.getFirst());
                Assert.assertEquals((Object)clazzEntityPair, checkPair1);
                Pair<Long, Class<?>> checkPair2 = PropertyValueDAOTest.this.propertyValueDAO.getPropertyClass((Class)clazzEntityPair.getSecond());
                Assert.assertEquals((Object)clazzEntityPair, checkPair2);
                return null;
            }
        };
        this.txnHelper.doInTransaction(getClassCallback, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> badGetCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                PropertyValueDAOTest.this.propertyValueDAO.getPropertyClassById(Long.MIN_VALUE);
                return null;
            }
        };
        try {
            this.txnHelper.doInTransaction(badGetCallback, false);
            PropertyValueDAOTest.fail((String)"Expected exception when using invalid ID.");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        RetryingTransactionHelper.RetryingTransactionCallback<Void> noHitCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                PropertyValueDAOTest.this.propertyValueDAO.getPropertyClass(this.getClass());
                PropertyValueDAOTest.this.propertyValueDAO.getPropertyClass(this.getClass());
                return null;
            }
        };
        this.txnHelper.doInTransaction(noHitCallback, false);
    }

    public void testPropertyDateValue() throws Exception {
        final Date dateValue = ISO8601DateFormat.parse((String)"1936-08-04T23:37:25.793Z");
        Date dateValueBack = ISO8601DateFormat.parse((String)"1936-08-04T00:00:00.000Z");
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Date>> createValueCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Date>>(){

            @Override
            public Pair<Long, Date> execute() throws Throwable {
                return PropertyValueDAOTest.this.propertyValueDAO.getOrCreatePropertyDateValue(dateValue);
            }
        };
        Pair<Long, Date> entityPair = this.txnHelper.doInTransaction(createValueCallback, false);
        PropertyValueDAOTest.assertNotNull(entityPair);
        PropertyValueDAOTest.assertEquals((Object)dateValueBack, (Object)entityPair.getSecond());
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Date>> getValueCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Date>>(){

            @Override
            public Pair<Long, Date> execute() throws Throwable {
                return PropertyValueDAOTest.this.propertyValueDAO.getPropertyDateValue(dateValue);
            }
        };
        Pair<Long, Date> entityPairCheck = this.txnHelper.doInTransaction(getValueCallback, false);
        PropertyValueDAOTest.assertNotNull(entityPairCheck);
        PropertyValueDAOTest.assertEquals(entityPair, entityPairCheck);
    }

    public void testPropertyStringValue() throws Exception {
        final String stringValue = "One Two Three - \u00e0\u00e2\u00e6\u00e7\u00e9\u00e8\u00ea\u00eb\u00ee\u00ef\u00f4\u0153\u00f9\u00fb\u00fc\u00ff\u00f1 - " + System.currentTimeMillis();
        final String stringValueUpper = stringValue.toUpperCase();
        final String stringValueLower = stringValue.toLowerCase();
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>> createStringCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>>(){

            @Override
            public Pair<Long, String> execute() throws Throwable {
                return PropertyValueDAOTest.this.propertyValueDAO.getOrCreatePropertyStringValue(stringValue);
            }
        };
        Pair<Long, String> stringEntityPair = this.txnHelper.doInTransaction(createStringCallback, false);
        PropertyValueDAOTest.assertNotNull(stringEntityPair);
        PropertyValueDAOTest.assertNotNull((Object)stringEntityPair.getFirst());
        PropertyValueDAOTest.assertEquals((String)stringValue, (String)((String)stringEntityPair.getSecond()));
        RetryingTransactionHelper.RetryingTransactionCallback<Void> getStringCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                Pair<Long, String> checkPair1 = PropertyValueDAOTest.this.propertyValueDAO.getPropertyStringValue(stringValue);
                Assert.assertNotNull(checkPair1);
                Assert.assertEquals((String)stringValue, (String)((String)checkPair1.getSecond()));
                Pair<Long, String> checkPair2 = PropertyValueDAOTest.this.propertyValueDAO.getPropertyStringValue(stringValueUpper);
                Assert.assertNull(checkPair2);
                Pair<Long, String> checkPair3 = PropertyValueDAOTest.this.propertyValueDAO.getPropertyStringValue(stringValueLower);
                Assert.assertNull(checkPair3);
                return null;
            }
        };
        this.txnHelper.doInTransaction(getStringCallback, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>> createStringUpperCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>>(){

            @Override
            public Pair<Long, String> execute() throws Throwable {
                return PropertyValueDAOTest.this.propertyValueDAO.getOrCreatePropertyStringValue(stringValueUpper);
            }
        };
        Pair<Long, String> stringUpperEntityPair = this.txnHelper.doInTransaction(createStringUpperCallback, false);
        PropertyValueDAOTest.assertNotNull(stringUpperEntityPair);
        PropertyValueDAOTest.assertNotNull((Object)stringUpperEntityPair.getFirst());
        PropertyValueDAOTest.assertEquals((String)stringValueUpper, (String)((String)stringUpperEntityPair.getSecond()));
        PropertyValueDAOTest.assertNotSame((String)"String IDs were not different", (Object)stringEntityPair.getFirst(), (Object)stringUpperEntityPair.getFirst());
    }

    public void testPropertyStringValue_EmptyAndNull() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> emptyStringCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                Pair<Long, String> emptyStringPair1 = PropertyValueDAOTest.this.propertyValueDAO.getOrCreatePropertyStringValue("");
                Assert.assertNotNull(emptyStringPair1);
                Assert.assertEquals((String)"", (String)((String)emptyStringPair1.getSecond()));
                Pair<Long, String> emptyStringPair2 = PropertyValueDAOTest.this.propertyValueDAO.getOrCreatePropertyStringValue("");
                Assert.assertNotNull(emptyStringPair2);
                Assert.assertEquals(emptyStringPair1, emptyStringPair2);
                return null;
            }
        };
        this.txnHelper.doInTransaction(emptyStringCallback, false);
    }

    public void testPropertyDoubleValue() throws Exception {
        final Double doubleValue = 1.7976931348623E125;
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Double>> createValueCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Double>>(){

            @Override
            public Pair<Long, Double> execute() throws Throwable {
                return PropertyValueDAOTest.this.propertyValueDAO.getOrCreatePropertyDoubleValue(doubleValue);
            }
        };
        Pair<Long, Double> entityPair = this.txnHelper.doInTransaction(createValueCallback, false);
        PropertyValueDAOTest.assertNotNull(entityPair);
        PropertyValueDAOTest.assertEquals((Object)doubleValue, (Object)entityPair.getSecond());
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Double>> getValueCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Double>>(){

            @Override
            public Pair<Long, Double> execute() throws Throwable {
                return PropertyValueDAOTest.this.propertyValueDAO.getPropertyDoubleValue(doubleValue);
            }
        };
        Pair<Long, Double> entityPairCheck = this.txnHelper.doInTransaction(getValueCallback, false);
        PropertyValueDAOTest.assertNotNull(entityPairCheck);
        PropertyValueDAOTest.assertEquals(entityPair, entityPairCheck);
    }

    public void testPropertySerializableValue() throws Exception {
        final CompositeName serializableValue = new CompositeName("123");
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Serializable>> createValueCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Serializable>>(){

            @Override
            public Pair<Long, Serializable> execute() throws Throwable {
                return PropertyValueDAOTest.this.propertyValueDAO.createPropertySerializableValue(serializableValue);
            }
        };
        final Pair<Long, Serializable> entityPair = this.txnHelper.doInTransaction(createValueCallback, false);
        PropertyValueDAOTest.assertNotNull(entityPair);
        PropertyValueDAOTest.assertEquals((Object)serializableValue, (Object)entityPair.getSecond());
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Serializable>> getValueCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Serializable>>(){

            @Override
            public Pair<Long, Serializable> execute() throws Throwable {
                return PropertyValueDAOTest.this.propertyValueDAO.getPropertySerializableValueById((Long)entityPair.getFirst());
            }
        };
        Pair<Long, Serializable> entityPairCheck = this.txnHelper.doInTransaction(getValueCallback, false);
        PropertyValueDAOTest.assertNotNull(entityPairCheck);
        PropertyValueDAOTest.assertEquals((Object)entityPair.getFirst(), (Object)entityPairCheck.getFirst());
        PropertyValueDAOTest.assertEquals(entityPair, entityPairCheck);
        byte[] bytes = new byte[]{1, 2, 3};
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Void>> testBytesCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Void>>((Serializable)bytes){
            final /* synthetic */ Serializable val$bytes;
            {
                this.val$bytes = serializable;
            }

            @Override
            public Pair<Long, Void> execute() throws Throwable {
                Long id = (Long)PropertyValueDAOTest.this.propertyValueDAO.createPropertySerializableValue(this.val$bytes).getFirst();
                Serializable check = (Serializable)PropertyValueDAOTest.this.propertyValueDAO.getPropertySerializableValueById(id).getSecond();
                Assert.assertNotNull((Object)check);
                Assert.assertTrue((boolean)(check instanceof byte[]));
                Arrays.equals((byte[])this.val$bytes, (byte[])check);
                return null;
            }
        };
        this.txnHelper.doInTransaction(testBytesCallback, false);
    }

    private void runPropertyValueTest(Serializable value) throws Exception {
        this.runPropertyValueTest(value, true);
    }

    private void runPropertyValueTest(final Serializable value, boolean runValueRetrieval) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Serializable>> createValueCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Serializable>>(){

            @Override
            public Pair<Long, Serializable> execute() throws Throwable {
                return PropertyValueDAOTest.this.propertyValueDAO.getOrCreatePropertyValue(value);
            }
        };
        final Pair<Long, Serializable> entityPair = this.txnHelper.doInTransaction(createValueCallback, false);
        PropertyValueDAOTest.assertNotNull(entityPair);
        PropertyValueDAOTest.assertEquals((Object)value, (Object)entityPair.getSecond());
        if (runValueRetrieval) {
            RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Serializable>> getValueCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Serializable>>(){

                @Override
                public Pair<Long, Serializable> execute() throws Throwable {
                    return PropertyValueDAOTest.this.propertyValueDAO.getPropertyValue(value);
                }
            };
            Pair<Long, Serializable> entityPairCheck = this.txnHelper.doInTransaction(getValueCallback, false);
            PropertyValueDAOTest.assertNotNull(entityPairCheck);
            PropertyValueDAOTest.assertEquals(entityPair, entityPairCheck);
        }
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Serializable>> getByIdCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Serializable>>(){

            @Override
            public Pair<Long, Serializable> execute() throws Throwable {
                return PropertyValueDAOTest.this.propertyValueDAO.getPropertyValueById((Long)entityPair.getFirst());
            }
        };
        Pair<Long, Serializable> entityPairCheck2 = this.txnHelper.doInTransaction(getByIdCallback, false);
        PropertyValueDAOTest.assertNotNull(entityPairCheck2);
        PropertyValueDAOTest.assertEquals(entityPair, entityPairCheck2);
    }

    public void testPropertyValue_Null() throws Exception {
        this.runPropertyValueTest(null);
    }

    public void testPropertyValue_Boolean() throws Exception {
        this.runPropertyValueTest(Boolean.TRUE);
        this.runPropertyValueTest(Boolean.FALSE);
    }

    public void testPropertyValue_Short() throws Exception {
        for (short i = 0; i < 100; i = (short)(i + 1)) {
            this.runPropertyValueTest(new Short(i));
        }
    }

    public void testPropertyValue_Integer() throws Exception {
        for (int i = 0; i < 100; ++i) {
            this.runPropertyValueTest(new Integer(i));
        }
    }

    public void testPropertyValue_Long() throws Exception {
        for (long i = 0L; i < 100L; ++i) {
            this.runPropertyValueTest(new Long(i));
        }
    }

    public void testPropertyValue_Float() throws Exception {
        for (long i = 0L; i < 100L; ++i) {
            this.runPropertyValueTest(new Float((float)i + 0.01f));
        }
    }

    public void testPropertyValue_Double() throws Exception {
        for (long i = 0L; i < 100L; ++i) {
            this.runPropertyValueTest(new Double((double)i + 0.01));
        }
    }

    public void testPropertyValue_Date() throws Exception {
        Random rand = new Random();
        for (long i = 0L; i < 100L; ++i) {
            this.runPropertyValueTest(new Date(rand.nextLong()));
        }
    }

    public void testPropertyValue_String() throws Exception {
        for (long i = 0L; i < 100L; ++i) {
            this.runPropertyValueTest((Serializable)((Object)new String("Value-" + i + ".xyz")));
        }
    }

    public void testPropertyValue_Serializable() throws Exception {
        for (int i = 0; i < 100; ++i) {
            this.runPropertyValueTest(new CompositeName("Name-" + i), false);
        }
    }

    public void testPropertyValue_Enum() throws Exception {
        for (int i = 0; i < 3; ++i) {
            TEST_NUMBERS n = TEST_NUMBERS.values()[i];
            this.runPropertyValueTest((Serializable)((Object)n));
        }
    }

    public void testPropertyValue_EmptyHashMap() throws Exception {
        HashMap map = new HashMap(15);
        this.runPropertyValueTest(map, true);
    }

    public void testPropertyValue_EmptyArrayList() throws Exception {
        ArrayList list = new ArrayList(20);
        this.runPropertyValueTest(list, true);
    }

    public void testPropertyValue_EmptyHashSet() throws Exception {
        HashSet set = new HashSet(20);
        this.runPropertyValueTest(set, true);
    }

    public void testPropertyValue_MapOfStrings() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>(15);
        for (int i = 0; i < 20; ++i) {
            String key = "MAP-KEY-" + i;
            String value = "MAP-VALUE-" + i;
            map.put(key, value);
        }
        this.runPropertyValueTest(map, false);
    }

    private Long runPropertyTest(final Serializable value) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Long> createValueCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            @Override
            public Long execute() throws Throwable {
                return PropertyValueDAOTest.this.propertyValueDAO.createProperty(value);
            }
        };
        final Long entityId = this.txnHelper.doInTransaction(createValueCallback, false);
        PropertyValueDAOTest.assertNotNull((Object)entityId);
        RetryingTransactionHelper.RetryingTransactionCallback<Serializable> getByIdCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Serializable>(){

            @Override
            public Serializable execute() throws Throwable {
                return PropertyValueDAOTest.this.propertyValueDAO.getPropertyById(entityId);
            }
        };
        Serializable entityValueCheck = this.txnHelper.doInTransaction(getByIdCallback, false);
        PropertyValueDAOTest.assertNotNull((Object)entityValueCheck);
        PropertyValueDAOTest.assertEquals((Object)value, (Object)entityValueCheck);
        final HashMap propsById = new HashMap();
        PropertyValueDAO.PropertyFinderCallback finderCallback = new PropertyValueDAO.PropertyFinderCallback(){

            @Override
            public void handleProperty(Long id, Serializable value) {
                propsById.put(id, value);
            }
        };
        List<Long> entityIds = Collections.singletonList(entityId);
        this.propertyValueDAO.getPropertiesByIds(entityIds, finderCallback);
        PropertyValueDAOTest.assertEquals((String)"Should be exactly one value in map", (int)1, (int)propsById.size());
        PropertyValueDAOTest.assertTrue((String)"Expected ID to be in map", (boolean)propsById.containsKey(entityId));
        PropertyValueDAOTest.assertEquals((String)"Value was not retrieved correctly", (Object)value, propsById.get(entityId));
        return entityId;
    }

    public void testProperty_MapOfStrings() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>(15);
        for (int i = 0; i < 20; ++i) {
            String key = "MAP-KEY-" + i;
            String value = "MAP-VALUE-" + i;
            map.put(key, value);
        }
        this.runPropertyTest(map);
    }

    public void testProperty_MapOfMapOfSerializables() throws Exception {
        HashMap<String, CompositeName> mapInner = new HashMap<String, CompositeName>(15);
        for (int i = 0; i < 20; ++i) {
            String key = "INNERMAP-KEY-" + i;
            CompositeName value = new CompositeName("INNERMAP-VALUE-" + i);
            mapInner.put(key, value);
        }
        HashMap<String, HashMap<String, CompositeName>> mapOuter = new HashMap<String, HashMap<String, CompositeName>>(37);
        for (int i = 0; i < 2; ++i) {
            String key = "OUTERMAP-KEY-" + i;
            mapOuter.put(key, mapInner);
        }
        this.runPropertyTest(mapOuter);
    }

    public void testProperty_MapOfMapOfStrings() throws Exception {
        HashMap<String, String> mapInner = new HashMap<String, String>(15);
        for (int i = 0; i < 20; ++i) {
            String key = "INNERMAP-KEY-" + i;
            String value = "INNERMAP-VALUE-" + i;
            mapInner.put(key, value);
        }
        HashMap<String, HashMap<String, String>> mapOuter = new HashMap<String, HashMap<String, String>>(37);
        for (int i = 0; i < 2; ++i) {
            String key = "OUTERMAP-KEY-" + i;
            mapOuter.put(key, mapInner);
        }
        this.runPropertyTest(mapOuter);
    }

    public void testProperty_CollectionOfStrings() throws Exception {
        ArrayList<String> list = new ArrayList<String>(20);
        for (int i = 0; i < 20; ++i) {
            String value = "COLL-VALUE-" + i;
            list.add(value);
        }
        this.runPropertyTest(list);
    }

    public void testProperty_UpdateCollection() throws Exception {
        final ArrayList<String> list = new ArrayList<String>(20);
        for (int i = 0; i < 20; ++i) {
            String value = "COLL-VALUE-" + i;
            list.add(value);
        }
        final Long propId = this.runPropertyTest(list);
        list.add("Additional value");
        RetryingTransactionHelper.RetryingTransactionCallback<Serializable> updateAndGetCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Serializable>(){

            @Override
            public Serializable execute() throws Throwable {
                PropertyValueDAOTest.this.propertyValueDAO.updateProperty(propId, list);
                return PropertyValueDAOTest.this.propertyValueDAO.getPropertyById(propId);
            }
        };
        Serializable entityValueCheck = this.txnHelper.doInTransaction(updateAndGetCallback, false);
        PropertyValueDAOTest.assertNotNull((Object)entityValueCheck);
        PropertyValueDAOTest.assertEquals(list, (Object)entityValueCheck);
    }

    public void testProperty_Delete() throws Exception {
        ArrayList list = new ArrayList(20);
        final Long propId = this.runPropertyTest(list);
        RetryingTransactionHelper.RetryingTransactionCallback<Serializable> deleteCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Serializable>(){

            @Override
            public Serializable execute() throws Throwable {
                PropertyValueDAOTest.this.propertyValueDAO.deleteProperty(propId);
                return null;
            }
        };
        this.txnHelper.doInTransaction(deleteCallback, false);
        RetryingTransactionHelper.RetryingTransactionCallback<Serializable> failedGetCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Serializable>(){

            @Override
            public Serializable execute() throws Throwable {
                return PropertyValueDAOTest.this.propertyValueDAO.getPropertyById(propId);
            }
        };
        try {
            Serializable entityValueCheck = this.txnHelper.doInTransaction(failedGetCallback, false);
            PropertyValueDAOTest.fail((String)("Deleted property should not be gettable.  Got: " + entityValueCheck));
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    public void testPropertyClass_NoCache() throws Exception {
        this.removeCaches();
        this.testPropertyClass();
    }

    public void testPropertyDateValue_NoCache() throws Exception {
        this.removeCaches();
        this.testPropertyDateValue();
    }

    public void testPropertyStringValue_NoCache() throws Exception {
        this.removeCaches();
        this.testPropertyStringValue();
    }

    public void testPropertyDoubleValue_NoCache() throws Exception {
        this.removeCaches();
        this.testPropertyDoubleValue();
    }

    public void testPropertySerializableValue_NoCache() throws Exception {
        this.removeCaches();
        this.testPropertySerializableValue();
    }

    public void testPropertyUniqueContext() throws Exception {
        final String aaa = GUID.generate();
        final String bbb = GUID.generate();
        this.txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                Pair<Long, Long> nullPair = PropertyValueDAOTest.this.propertyValueDAO.getPropertyUniqueContext((Serializable)null, (Serializable)null, (Serializable)null);
                if (nullPair != null) {
                    PropertyValueDAOTest.this.propertyValueDAO.deletePropertyUniqueContext((Long)nullPair.getFirst());
                }
                PropertyValueDAOTest.this.propertyValueDAO.createPropertyUniqueContext(null, null, null, (Serializable)((Object)"A VALUE"));
                try {
                    PropertyValueDAOTest.this.propertyValueDAO.createPropertyUniqueContext(null, null, null, (Serializable)((Object)"A VALUE"));
                    Assert.fail((String)"Failed to throw exception creating duplicate property unique context");
                }
                catch (PropertyUniqueConstraintViolation propertyUniqueConstraintViolation) {
                    // empty catch block
                }
                return null;
            }
        }, false);
        final Long id = this.txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            @Override
            public Long execute() throws Throwable {
                return (Long)PropertyValueDAOTest.this.propertyValueDAO.createPropertyUniqueContext((Serializable)((Object)"A"), (Serializable)((Object)"AA"), (Serializable)((Object)aaa), null).getFirst();
            }
        }, false);
        try {
            this.txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() throws Throwable {
                    PropertyValueDAOTest.this.propertyValueDAO.createPropertyUniqueContext((Serializable)((Object)"A"), (Serializable)((Object)"AA"), (Serializable)((Object)aaa), null);
                    return null;
                }
            }, false);
            PropertyValueDAOTest.fail((String)"Failed to throw exception creating duplicate property unique context");
        }
        catch (PropertyUniqueConstraintViolation e) {
            // empty catch block
        }
        try {
            this.txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() throws Throwable {
                    PropertyValueDAOTest.this.propertyValueDAO.updatePropertyUniqueContext(id, (Serializable)((Object)"A"), (Serializable)((Object)"AA"), (Serializable)((Object)bbb));
                    PropertyValueDAOTest.this.propertyValueDAO.createPropertyUniqueContext((Serializable)((Object)"A"), (Serializable)((Object)"AA"), (Serializable)((Object)aaa), null);
                    PropertyValueDAOTest.this.propertyValueDAO.createPropertyUniqueContext((Serializable)((Object)"A"), (Serializable)((Object)"AA"), (Serializable)((Object)bbb), null);
                    return null;
                }
            }, false);
            PropertyValueDAOTest.fail((String)"Failed to throw exception creating duplicate property unique context");
        }
        catch (PropertyUniqueConstraintViolation e) {
            // empty catch block
        }
        this.txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                PropertyValueDAOTest.this.propertyValueDAO.deletePropertyUniqueContext(id);
                PropertyValueDAOTest.this.propertyValueDAO.createPropertyUniqueContext((Serializable)((Object)"A"), (Serializable)((Object)"AA"), (Serializable)((Object)bbb), null);
                return null;
            }
        }, false);
    }

    public void testPropertyUniqueContextValue() throws Exception {
        final String aaa = GUID.generate();
        final String bbb = GUID.generate();
        final String ccc = GUID.generate();
        final String v1 = GUID.generate();
        final String v2 = GUID.generate();
        final Long id = this.txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            @Override
            public Long execute() throws Throwable {
                return (Long)PropertyValueDAOTest.this.propertyValueDAO.createPropertyUniqueContext((Serializable)((Object)aaa), (Serializable)((Object)bbb), (Serializable)((Object)ccc), null).getFirst();
            }
        }, false);
        Pair v0Pair = new Pair((Object)id, null);
        Pair v1Pair = new Pair((Object)id, (Object)v1);
        Pair v2Pair = new Pair((Object)id, (Object)v2);
        Pair<Long, Serializable> pair = null;
        pair = this.txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Serializable>>(){

            @Override
            public Pair<Long, Serializable> execute() throws Throwable {
                Pair<Long, Long> pair = PropertyValueDAOTest.this.propertyValueDAO.getPropertyUniqueContext((Serializable)((Object)aaa), (Serializable)((Object)bbb), (Serializable)((Object)ccc));
                if (pair.getSecond() == null) {
                    return new Pair(pair.getFirst(), null);
                }
                Serializable value = PropertyValueDAOTest.this.propertyValueDAO.getPropertyById((Long)pair.getSecond());
                return new Pair(pair.getFirst(), (Object)value);
            }
        }, true);
        PropertyValueDAOTest.assertEquals((String)"ID-value pair incorrect", (Object)v0Pair, pair);
        pair = this.txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Serializable>>(){

            @Override
            public Pair<Long, Serializable> execute() throws Throwable {
                PropertyValueDAOTest.this.propertyValueDAO.updatePropertyUniqueContext(id, (Serializable)((Object)v1));
                Pair<Long, Long> pair = PropertyValueDAOTest.this.propertyValueDAO.getPropertyUniqueContext((Serializable)((Object)aaa), (Serializable)((Object)bbb), (Serializable)((Object)ccc));
                Serializable value = PropertyValueDAOTest.this.propertyValueDAO.getPropertyById((Long)pair.getSecond());
                return new Pair(pair.getFirst(), (Object)value);
            }
        }, false);
        PropertyValueDAOTest.assertEquals((String)"ID-value pair incorrect", (Object)v1Pair, pair);
        pair = this.txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Serializable>>(){

            @Override
            public Pair<Long, Serializable> execute() throws Throwable {
                PropertyValueDAOTest.this.propertyValueDAO.updatePropertyUniqueContext(id, (Serializable)((Object)v2));
                Pair<Long, Long> pair = PropertyValueDAOTest.this.propertyValueDAO.getPropertyUniqueContext((Serializable)((Object)aaa), (Serializable)((Object)bbb), (Serializable)((Object)ccc));
                Serializable value = PropertyValueDAOTest.this.propertyValueDAO.getPropertyById((Long)pair.getSecond());
                return new Pair(pair.getFirst(), (Object)value);
            }
        }, false);
        PropertyValueDAOTest.assertEquals((String)"ID-value pair incorrect", (Object)v2Pair, pair);
    }

    private static enum TEST_NUMBERS {
        ONE,
        TWO,
        THREE;

    }
}

