/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.schema;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.sql.DataSource;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngineConfiguration;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.ibatis.SerializableTypeHandler;
import org.alfresco.repo.admin.patch.Patch;
import org.alfresco.repo.admin.patch.impl.SchemaUpgradeScriptPatch;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.domain.hibernate.dialect.AlfrescoOracle9Dialect;
import org.alfresco.repo.domain.hibernate.dialect.AlfrescoSQLServerDialect;
import org.alfresco.repo.domain.hibernate.dialect.AlfrescoSybaseAnywhereDialect;
import org.alfresco.repo.domain.schema.SchemaAvailableEvent;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.util.DatabaseMetaDataHelper;
import org.alfresco.util.LogUtil;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.schemacomp.ExportDb;
import org.alfresco.util.schemacomp.MultiFileDumper;
import org.alfresco.util.schemacomp.Result;
import org.alfresco.util.schemacomp.Results;
import org.alfresco.util.schemacomp.SchemaComparator;
import org.alfresco.util.schemacomp.XMLToSchema;
import org.alfresco.util.schemacomp.model.Schema;
import org.alfresco.util.schemadump.Main;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.connection.UserSuppliedConnectionProvider;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.DerbyDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.MySQL5Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.MySQLInnoDBDialect;
import org.hibernate.dialect.Oracle10gDialect;
import org.hibernate.dialect.Oracle9Dialect;
import org.hibernate.dialect.Oracle9iDialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.engine.ActionQueue;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;

public class SchemaBootstrap
extends AbstractLifecycleBean {
    private static final String PLACEHOLDER_DIALECT = "\\$\\{db\\.script\\.dialect\\}";
    private static final String PROPERTY_DEFAULT_BATCH_SIZE = "system.upgrade.default.batchsize";
    private static final String MSG_DIALECT_USED = "schema.update.msg.dialect_used";
    private static final String MSG_DATABASE_USED = "schema.update.msg.database_used";
    private static final String MSG_BYPASSING_SCHEMA_UPDATE = "schema.update.msg.bypassing";
    private static final String MSG_NORMALIZED_SCHEMA = "schema.update.msg.normalized_schema";
    private static final String MSG_NORMALIZED_SCHEMA_PRE = "schema.update.msg.normalized_schema_pre";
    private static final String MSG_NORMALIZED_SCHEMA_POST = "schema.update.msg.normalized_schema_post";
    private static final String MSG_NO_CHANGES = "schema.update.msg.no_changes";
    private static final String MSG_ALL_STATEMENTS = "schema.update.msg.all_statements";
    private static final String MSG_EXECUTING_GENERATED_SCRIPT = "schema.update.msg.executing_generated_script";
    private static final String MSG_EXECUTING_COPIED_SCRIPT = "schema.update.msg.executing_copied_script";
    private static final String MSG_EXECUTING_STATEMENT = "schema.update.msg.executing_statement";
    private static final String MSG_OPTIONAL_STATEMENT_FAILED = "schema.update.msg.optional_statement_failed";
    private static final String WARN_DIALECT_UNSUPPORTED = "schema.update.warn.dialect_unsupported";
    private static final String WARN_DIALECT_SUBSTITUTING = "schema.update.warn.dialect_substituting";
    private static final String WARN_DIALECT_HSQL = "schema.update.warn.dialect_hsql";
    private static final String WARN_DIALECT_DERBY = "schema.update.warn.dialect_derby";
    private static final String ERR_FORCED_STOP = "schema.update.err.forced_stop";
    private static final String ERR_DIALECT_SHOULD_USE = "schema.update.err.dialect_should_use";
    private static final String ERR_MULTIPLE_SCHEMAS = "schema.update.err.found_multiple";
    private static final String ERR_PREVIOUS_FAILED_BOOTSTRAP = "schema.update.err.previous_failed";
    private static final String ERR_STATEMENT_FAILED = "schema.update.err.statement_failed";
    private static final String ERR_UPDATE_FAILED = "schema.update.err.update_failed";
    private static final String ERR_VALIDATION_FAILED = "schema.update.err.validation_failed";
    private static final String ERR_SCRIPT_NOT_RUN = "schema.update.err.update_script_not_run";
    private static final String ERR_SCRIPT_NOT_FOUND = "schema.update.err.script_not_found";
    private static final String ERR_STATEMENT_INCLUDE_BEFORE_SQL = "schema.update.err.statement_include_before_sql";
    private static final String ERR_STATEMENT_VAR_ASSIGNMENT_BEFORE_SQL = "schema.update.err.statement_var_assignment_before_sql";
    private static final String ERR_STATEMENT_VAR_ASSIGNMENT_FORMAT = "schema.update.err.statement_var_assignment_format";
    private static final String ERR_STATEMENT_TERMINATOR = "schema.update.err.statement_terminator";
    private static final String DEBUG_SCHEMA_COMP_NO_REF_FILE = "system.schema_comp.debug.no_ref_file";
    private static final String INFO_SCHEMA_COMP_ALL_OK = "system.schema_comp.info.all_ok";
    private static final String WARN_SCHEMA_COMP_PROBLEMS_FOUND = "system.schema_comp.warn.problems_found";
    private static final String DEBUG_SCHEMA_COMP_TIME_TAKEN = "system.schema_comp.debug.time_taken";
    public static final int DEFAULT_LOCK_RETRY_COUNT = 24;
    public static final int DEFAULT_LOCK_RETRY_WAIT_SECONDS = 5;
    public static final int DEFAULT_MAX_STRING_LENGTH = 1024;
    private static volatile int maxStringLength = 1024;
    private Dialect dialect;
    private ResourcePatternResolver rpr = new PathMatchingResourcePatternResolver(((Object)((Object)this)).getClass().getClassLoader());
    private static Log logger = LogFactory.getLog(SchemaBootstrap.class);
    private DescriptorService descriptorService;
    private DataSource dataSource;
    private LocalSessionFactoryBean localSessionFactory;
    private String schemaOuputFilename;
    private boolean updateSchema;
    private boolean stopAfterSchemaBootstrap;
    private List<String> preCreateScriptUrls;
    private List<String> postCreateScriptUrls;
    private List<String> schemaReferenceUrls;
    private List<SchemaUpgradeScriptPatch> validateUpdateScriptPatches;
    private List<SchemaUpgradeScriptPatch> preUpdateScriptPatches;
    private List<SchemaUpgradeScriptPatch> postUpdateScriptPatches;
    private int schemaUpdateLockRetryCount = 24;
    private int schemaUpdateLockRetryWaitSeconds = 5;
    private int maximumStringLength = -1;
    private Properties globalProperties;
    private ThreadLocal<StringBuilder> executedStatementsThreadLocal = new ThreadLocal();
    private File xmlPreSchemaOutputFile34;

    private static final void setMaxStringLength(int length) {
        if (length < 1024) {
            throw new AlfrescoRuntimeException("The maximum string length must >= 1024 characters.");
        }
        maxStringLength = length;
    }

    public static final int getMaxStringLength() {
        return maxStringLength;
    }

    public static final String trimStringForTextFields(String value) {
        if (value != null && value.length() > maxStringLength) {
            return value.substring(0, maxStringLength);
        }
        return value;
    }

    public void setDescriptorService(DescriptorService descriptorService) {
        this.descriptorService = descriptorService;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public SchemaBootstrap() {
        this.preCreateScriptUrls = new ArrayList<String>(1);
        this.postCreateScriptUrls = new ArrayList<String>(1);
        this.validateUpdateScriptPatches = new ArrayList<SchemaUpgradeScriptPatch>(4);
        this.preUpdateScriptPatches = new ArrayList<SchemaUpgradeScriptPatch>(4);
        this.postUpdateScriptPatches = new ArrayList<SchemaUpgradeScriptPatch>(4);
        this.globalProperties = new Properties();
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setLocalSessionFactory(LocalSessionFactoryBean localSessionFactory) {
        this.localSessionFactory = localSessionFactory;
    }

    public LocalSessionFactoryBean getLocalSessionFactory() {
        return this.localSessionFactory;
    }

    public void setSchemaOuputFilename(String schemaOuputFilename) {
        this.schemaOuputFilename = schemaOuputFilename;
    }

    public void setUpdateSchema(boolean updateSchema) {
        this.updateSchema = updateSchema;
    }

    public void setStopAfterSchemaBootstrap(boolean stopAfterSchemaBootstrap) {
        this.stopAfterSchemaBootstrap = stopAfterSchemaBootstrap;
    }

    public void setPreCreateScriptUrls(List<String> preUpdateScriptUrls) {
        this.preCreateScriptUrls = preUpdateScriptUrls;
    }

    public void setPostCreateScriptUrls(List<String> postUpdateScriptUrls) {
        this.postCreateScriptUrls = postUpdateScriptUrls;
    }

    public void setSchemaReferenceUrls(List<String> schemaReferenceUrls) {
        this.schemaReferenceUrls = schemaReferenceUrls;
    }

    public void setValidateUpdateScriptPatches(List<SchemaUpgradeScriptPatch> scriptPatches) {
        this.validateUpdateScriptPatches = scriptPatches;
    }

    public void setPreUpdateScriptPatches(List<SchemaUpgradeScriptPatch> scriptPatches) {
        this.preUpdateScriptPatches = scriptPatches;
    }

    public void setPostUpdateScriptPatches(List<SchemaUpgradeScriptPatch> scriptPatches) {
        this.postUpdateScriptPatches = scriptPatches;
    }

    public void setSchemaUpdateLockRetryCount(int schemaUpdateLockRetryCount) {
        this.schemaUpdateLockRetryCount = schemaUpdateLockRetryCount;
    }

    public void setSchemaUpdateLockRetryWaitSeconds(int schemaUpdateLockRetryWaitSeconds) {
        this.schemaUpdateLockRetryWaitSeconds = schemaUpdateLockRetryWaitSeconds;
    }

    public void setMaximumStringLength(int maximumStringLength) {
        if (maximumStringLength > 0) {
            this.maximumStringLength = maximumStringLength;
        }
    }

    public int getHibernateMaxExecutions() {
        return ActionQueue.getMAX_EXECUTIONS_SIZE();
    }

    public void setHibernateMaxExecutions(int hibernateMaxExecutions) {
        ActionQueue.setMAX_EXECUTIONS_SIZE((int)hibernateMaxExecutions);
    }

    public void setGlobalProperties(Properties globalProperties) {
        this.globalProperties = globalProperties;
    }

    private SessionFactory getSessionFactory() {
        return this.localSessionFactory.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countAppliedPatches(Configuration cfg, Connection connection) throws Exception {
        ResultSet rs;
        String defaultCatalog;
        String defaultSchema = DatabaseMetaDataHelper.getSchema(connection);
        if (defaultSchema != null && defaultSchema.length() == 0) {
            defaultSchema = null;
        }
        if ((defaultCatalog = cfg.getProperty("hibernate.default_catalog")) != null && defaultCatalog.length() == 0) {
            defaultCatalog = null;
        }
        DatabaseMetaData dbMetadata = connection.getMetaData();
        ResultSet tableRs = dbMetadata.getTables(defaultCatalog, defaultSchema, "%", null);
        boolean newPatchTable = false;
        boolean oldPatchTable = false;
        try {
            boolean multipleSchemas = false;
            while (tableRs.next()) {
                String tableName = tableRs.getString("TABLE_NAME");
                if (tableName.equalsIgnoreCase("applied_patch")) {
                    if (oldPatchTable || newPatchTable) {
                        multipleSchemas = true;
                    }
                    oldPatchTable = true;
                    continue;
                }
                if (!tableName.equalsIgnoreCase("alf_applied_patch")) continue;
                if (oldPatchTable || newPatchTable) {
                    multipleSchemas = true;
                }
                newPatchTable = true;
            }
            if (multipleSchemas) {
                throw new AlfrescoRuntimeException(ERR_MULTIPLE_SCHEMAS);
            }
        }
        finally {
            try {
                tableRs.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (newPatchTable) {
            Statement stmt = connection.createStatement();
            try {
                int count;
                rs = stmt.executeQuery("select count(id) from alf_applied_patch");
                rs.next();
                int n = count = rs.getInt(1);
                return n;
            }
            catch (SQLException e) {
                throw new AlfrescoRuntimeException(ERR_MULTIPLE_SCHEMAS);
            }
            finally {
                try {
                    stmt.close();
                }
                catch (Throwable e) {}
            }
        }
        if (oldPatchTable) {
            Statement stmt = connection.createStatement();
            try {
                int count;
                rs = stmt.executeQuery("select count(id) from applied_patch");
                rs.next();
                int n = count = rs.getInt(1);
                return n;
            }
            finally {
                try {
                    stmt.close();
                }
                catch (Throwable e) {}
            }
        }
        throw new NoSchemaException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getAppliedPatchTableName(Connection connection) throws Exception {
        String e;
        Statement stmt = connection.createStatement();
        try {
            stmt.executeQuery("select * from alf_applied_patch");
            String string = "alf_applied_patch";
            return string;
        }
        catch (Throwable e2) {
        }
        finally {
            try {
                stmt.close();
            }
            catch (Throwable e3) {}
        }
        stmt = connection.createStatement();
        try {
            stmt.executeQuery("select * from applied_patch");
            e = "applied_patch";
        }
        catch (Throwable e2) {
            try {
                String string = null;
                return string;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    stmt.close();
                }
                catch (Throwable e3) {}
            }
        }
        try {
            stmt.close();
            return e;
        }
        catch (Throwable e2) {
            // empty catch block
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean didPatchSucceed(Connection connection, String patchId, boolean alternative) throws Exception {
        String patchTableName = this.getAppliedPatchTableName(connection);
        if (patchTableName == null) {
            return false;
        }
        Statement stmt = connection.createStatement();
        try {
            ResultSet rs = stmt.executeQuery("select succeeded, was_executed from " + patchTableName + " where id = '" + patchId + "'");
            if (!rs.next()) {
                boolean bl = false;
                return bl;
            }
            boolean succeeded = rs.getBoolean(1);
            boolean wasExecuted = rs.getBoolean(2);
            if (alternative) {
                boolean bl = succeeded && wasExecuted;
                return bl;
            }
            boolean bl = succeeded;
            return bl;
        }
        finally {
            try {
                stmt.close();
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getInstalledSchemaNumber(Connection connection) throws Exception {
        Statement stmt = connection.createStatement();
        try {
            int installedSchema;
            ResultSet rs = stmt.executeQuery("select min(applied_to_schema) from alf_applied_patch where applied_to_schema > -1");
            if (!rs.next()) {
                int n = -1;
                return n;
            }
            if (rs.getObject(1) == null) {
                int n = -1;
                return n;
            }
            int n = installedSchema = rs.getInt(1);
            return n;
        }
        finally {
            try {
                stmt.close();
            }
            catch (Throwable e) {}
        }
    }

    private synchronized void setBootstrapStarted(Connection connection) throws Exception {
        Statement stmt = connection.createStatement();
        try {
            stmt.executeUpdate("create table alf_bootstrap_lock (charval CHAR(1) NOT NULL)");
            return;
        }
        catch (Throwable e) {
            throw new LockFailedException();
        }
        finally {
            try {
                stmt.close();
            }
            catch (Throwable e) {}
        }
    }

    private void setBootstrapCompleted(Connection connection) throws Exception {
        Statement stmt = connection.createStatement();
        try {
            stmt.executeUpdate("drop table alf_bootstrap_lock");
        }
        catch (Throwable e) {
            throw AlfrescoRuntimeException.create((String)ERR_PREVIOUS_FAILED_BOOTSTRAP, (Object[])new Object[0]);
        }
        finally {
            try {
                stmt.close();
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateSchema(Configuration cfg, org.hibernate.Session session, Connection connection) throws Exception {
        boolean create = false;
        try {
            this.countAppliedPatches(cfg, connection);
        }
        catch (NoSchemaException e) {
            create = true;
        }
        Dialect dialect = Dialect.getDialect((Properties)cfg.getProperties());
        String dialectStr = dialect.getClass().getSimpleName();
        if (create) {
            this.initialiseActivitiDBSchema(new UnclosableConnection(connection));
        }
        if (create) {
            block29: {
                for (String scriptUrl : this.preCreateScriptUrls) {
                    this.executeScriptUrl(cfg, connection, scriptUrl);
                }
                File tempFile = null;
                Writer writer = null;
                try {
                    DatabaseMetadata metadata = new DatabaseMetadata(connection, dialect);
                    String[] sqls = cfg.generateSchemaUpdateScript(dialect, metadata);
                    if (sqls.length <= 0) break block29;
                    tempFile = TempFileProvider.createTempFile((String)("AlfrescoSchema-" + dialectStr + "-Update-"), (String)".sql");
                    writer = new BufferedWriter(new FileWriter(tempFile));
                    for (String sql : sqls) {
                        writer.append(sql);
                        writer.append(";\n");
                    }
                    try {
                        writer.close();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    this.executeScriptFile(cfg, connection, tempFile, null);
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable e) {}
                    }
                }
            }
            for (String scriptUrl : this.postCreateScriptUrls) {
                this.executeScriptUrl(cfg, connection, scriptUrl);
            }
        } else {
            this.checkSchemaPatchScripts(cfg, connection, this.validateUpdateScriptPatches, false);
            this.checkSchemaPatchScripts(cfg, connection, this.preUpdateScriptPatches, true);
            File tempFile = null;
            Writer writer = null;
            try {
                DatabaseMetadata metadata = new DatabaseMetadata(connection, dialect);
                String[] sqls = cfg.generateSchemaUpdateScript(dialect, metadata);
                if (sqls.length > 0) {
                    tempFile = TempFileProvider.createTempFile((String)("AlfrescoSchema-" + dialectStr + "-Update-"), (String)".sql");
                    writer = new BufferedWriter(new FileWriter(tempFile));
                    for (String sql : sqls) {
                        writer.append(sql);
                        writer.append(";\n");
                    }
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable e) {}
                }
            }
            if (tempFile != null) {
                this.executeScriptFile(cfg, connection, tempFile, null);
            }
            this.checkSchemaPatchScripts(cfg, connection, this.postUpdateScriptPatches, true);
        }
        return create;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialiseActivitiDBSchema(Connection connection) {
        ProcessEngine engine = null;
        ProcessEngineConfiguration engineConfig = ProcessEngineConfiguration.createStandaloneProcessEngineConfiguration();
        try {
            engine = engineConfig.setDataSource(this.dataSource).setDatabaseSchemaUpdate("none").setProcessEngineName("activitiBootstrapEngine").setHistory("full").setJobExecutorActivate(false).buildProcessEngine();
            engine.getManagementService().databaseSchemaUpgrade(connection, null, DatabaseMetaDataHelper.getSchema(connection));
        }
        finally {
            if (engine != null) {
                engine.close();
            }
        }
    }

    private void checkSchemaPatchScripts(Configuration cfg, Connection connection, List<SchemaUpgradeScriptPatch> scriptPatches, boolean apply) throws Exception {
        int appliedPatchCount = this.countAppliedPatches(cfg, connection);
        if (appliedPatchCount == 0) {
            return;
        }
        int installedSchema = this.getInstalledSchemaNumber(connection);
        block0: for (SchemaUpgradeScriptPatch patch : scriptPatches) {
            String patchId = patch.getId();
            String scriptUrl = patch.getScriptUrl();
            List<Patch> alternatives = patch.getAlternatives();
            for (Patch alternativePatch : alternatives) {
                String alternativePatchId = alternativePatch.getId();
                boolean alternativeSucceeded = this.didPatchSucceed(connection, alternativePatchId, true);
                if (!alternativeSucceeded) continue;
                continue block0;
            }
            boolean wasSuccessfullyApplied = this.didPatchSucceed(connection, patchId, false);
            if (wasSuccessfullyApplied || !patch.applies(installedSchema)) continue;
            if (!apply) {
                throw AlfrescoRuntimeException.create((String)ERR_SCRIPT_NOT_RUN, (Object[])new Object[]{scriptUrl});
            }
            this.executeScriptUrl(cfg, connection, scriptUrl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeScriptUrl(Configuration cfg, Connection connection, String scriptUrl) throws Exception {
        Dialect dialect = Dialect.getDialect((Properties)cfg.getProperties());
        String dialectStr = dialect.getClass().getSimpleName();
        InputStream scriptInputStream = this.getScriptInputStream(dialect.getClass(), scriptUrl);
        if (scriptInputStream == null) {
            throw AlfrescoRuntimeException.create((String)ERR_SCRIPT_NOT_FOUND, (Object[])new Object[]{scriptUrl});
        }
        File tempFile = null;
        try {
            tempFile = TempFileProvider.createTempFile((String)("AlfrescoSchema-" + dialectStr + "-Update-"), (String)".sql");
            FileContentWriter writer = new FileContentWriter(tempFile);
            writer.putContent(scriptInputStream);
        }
        finally {
            try {
                scriptInputStream.close();
            }
            catch (Throwable e) {}
        }
        String dialectScriptUrl = scriptUrl.replaceAll(PLACEHOLDER_DIALECT, dialect.getClass().getName());
        this.executeScriptFile(cfg, connection, tempFile, dialectScriptUrl);
    }

    private Resource getDialectResource(Class dialectClass, String resourceUrl) {
        String dialectResourceUrl = this.resolveDialectUrl(dialectClass, resourceUrl);
        Resource resource = this.rpr.getResource(dialectResourceUrl);
        if (!resource.exists()) {
            Class superClass = dialectClass.getSuperclass();
            if (Dialect.class.isAssignableFrom(superClass)) {
                return this.getDialectResource(superClass, resourceUrl);
            }
            return null;
        }
        return resource;
    }

    private String resolveDialectUrl(Class dialectClass, String resourceUrl) {
        return resourceUrl.replaceAll(PLACEHOLDER_DIALECT, dialectClass.getName());
    }

    private InputStream getScriptInputStream(Class dialectClazz, String scriptUrl) throws Exception {
        return this.getDialectResource(dialectClazz, scriptUrl).getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeScriptFile(Configuration cfg, Connection connection, File scriptFile, String scriptUrl) throws Exception {
        Dialect dialect = Dialect.getDialect((Properties)cfg.getProperties());
        StringBuilder executedStatements = this.executedStatementsThreadLocal.get();
        if (executedStatements == null) {
            this.validateSchema("Alfresco-{0}-Validation-Pre-Upgrade-{1}-");
            this.xmlPreSchemaOutputFile34 = this.dumpSchema34(this.dialect, TempFileProvider.createTempFile((String)("AlfrescoSchema-" + this.dialect.getClass().getSimpleName() + "-"), (String)"-Startup.xml").getPath(), "Failed to dump normalized, pre-upgrade schema to file.");
            this.dumpSchema("pre-upgrade");
            this.setBootstrapStarted(connection);
            executedStatements = new StringBuilder(8094);
            this.executedStatementsThreadLocal.set(executedStatements);
        }
        if (scriptUrl == null) {
            LogUtil.info((Log)logger, (String)MSG_EXECUTING_GENERATED_SCRIPT, (Object[])new Object[]{scriptFile});
        } else {
            LogUtil.info((Log)logger, (String)MSG_EXECUTING_COPIED_SCRIPT, (Object[])new Object[]{scriptFile, scriptUrl});
        }
        FileInputStream scriptInputStream = new FileInputStream(scriptFile);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)scriptInputStream, "UTF-8"));
        try {
            int line = 0;
            StringBuilder sb = new StringBuilder(1024);
            String fetchVarName = null;
            String fetchColumnName = null;
            boolean doBatch = false;
            int batchUpperLimit = 0;
            int batchSize = 1;
            HashMap<String, Object> varAssignments = new HashMap<String, Object>(13);
            if (dialect instanceof PostgreSQLDialect) {
                varAssignments.put("true", "true");
                varAssignments.put("false", "false");
                varAssignments.put("TRUE", "TRUE");
                varAssignments.put("FALSE", "FALSE");
            } else {
                varAssignments.put("true", "1");
                varAssignments.put("false", "0");
                varAssignments.put("TRUE", "1");
                varAssignments.put("FALSE", "0");
            }
            long now = System.currentTimeMillis();
            varAssignments.put("now", new Long(now).toString());
            varAssignments.put("NOW", new Long(now).toString());
            while (true) {
                int endIndex;
                String sqlOriginal = reader.readLine();
                ++line;
                if (sqlOriginal == null) {
                    break;
                }
                String sql = sqlOriginal.trim();
                if (sql.startsWith("--INCLUDE:")) {
                    if (sb.length() > 0) {
                        throw AlfrescoRuntimeException.create((String)ERR_STATEMENT_INCLUDE_BEFORE_SQL, (Object[])new Object[]{line - 1, scriptUrl});
                    }
                    String includedScriptUrl = sql.substring(10, sql.length());
                    this.executeScriptUrl(cfg, connection, includedScriptUrl);
                } else {
                    if (sql.startsWith("--ASSIGN:")) {
                        if (sb.length() > 0) {
                            throw AlfrescoRuntimeException.create((String)ERR_STATEMENT_VAR_ASSIGNMENT_BEFORE_SQL, (Object[])new Object[]{line - 1, scriptUrl});
                        }
                        String assignStr = sql.substring(9, sql.length());
                        String[] assigns = assignStr.split("=");
                        if (assigns.length != 2 || assigns[0].length() == 0 || assigns[1].length() == 0) {
                            throw AlfrescoRuntimeException.create((String)ERR_STATEMENT_VAR_ASSIGNMENT_FORMAT, (Object[])new Object[]{line - 1, scriptUrl});
                        }
                        fetchVarName = assigns[0];
                        fetchColumnName = assigns[1];
                        continue;
                    }
                    if (sql.startsWith("--FOREACH")) {
                        int sepIndex;
                        String[] args = sql.split("[ \\t]+");
                        if (args.length != 3 || (sepIndex = args[1].indexOf(46)) == -1) continue;
                        doBatch = true;
                        String stmt = "SELECT MAX(" + args[1].substring(sepIndex + 1) + ") AS upper_limit FROM " + args[1].substring(0, sepIndex);
                        Object fetchedVal = this.executeStatement(connection, stmt, "upper_limit", false, line, scriptFile);
                        if (!(fetchedVal instanceof Number)) continue;
                        batchUpperLimit = ((Number)fetchedVal).intValue();
                        String batchSizeString = this.globalProperties.getProperty(args[2]);
                        if (batchSizeString == null) {
                            batchSizeString = this.globalProperties.getProperty(PROPERTY_DEFAULT_BATCH_SIZE);
                        }
                        batchSize = batchSizeString == null ? 10000 : Integer.parseInt(batchSizeString);
                        continue;
                    }
                    if (sql.startsWith("--BEGIN TXN")) {
                        connection.setAutoCommit(false);
                        continue;
                    }
                    if (sql.startsWith("--END TXN")) {
                        connection.commit();
                        connection.setAutoCommit(true);
                        continue;
                    }
                }
                if (sql.length() == 0 || sql.startsWith("--") || sql.startsWith("//") || sql.startsWith("/*")) {
                    if (sb.length() <= 0) continue;
                    throw AlfrescoRuntimeException.create((String)ERR_STATEMENT_TERMINATOR, (Object[])new Object[]{line - 1, scriptUrl});
                }
                boolean execute = false;
                boolean optional = false;
                if (sql.endsWith(";")) {
                    sql = sql.substring(0, sql.length() - 1);
                    execute = true;
                    optional = false;
                } else if ((sql.endsWith("(optional)") || sql.endsWith("(OPTIONAL)")) && (endIndex = sql.lastIndexOf(59)) > -1) {
                    sql = sql.substring(0, endIndex);
                    execute = true;
                    optional = true;
                }
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                int whitespaceCount = sqlOriginal.indexOf(sql);
                for (int i = 0; i < whitespaceCount; ++i) {
                    sb.append(" ");
                }
                sb.append(sql);
                if (!execute) continue;
                String unsubstituted = sb.toString();
                for (int lowerBound = 0; lowerBound <= batchUpperLimit; lowerBound += batchSize) {
                    sql = unsubstituted;
                    if (doBatch) {
                        varAssignments.put("LOWERBOUND", String.valueOf(lowerBound));
                        varAssignments.put("UPPERBOUND", String.valueOf(lowerBound + batchSize - 1));
                    }
                    for (Map.Entry entry : varAssignments.entrySet()) {
                        String var = (String)entry.getKey();
                        Object val = entry.getValue();
                        sql = sql.replaceAll("\\$\\{" + var + "\\}", val.toString());
                    }
                    sql = this.dialect != null && this.dialect instanceof PostgreSQLDialect ? sql.replaceAll("\\$\\{TRUE\\}", "TRUE") : sql.replaceAll("\\$\\{TRUE\\}", "1");
                    if (this.dialect != null && this.dialect instanceof MySQLInnoDBDialect) {
                        sql = sql.replaceAll("(?i)TYPE=InnoDB", "ENGINE=InnoDB");
                    }
                    Object fetchedVal = this.executeStatement(connection, sql, fetchColumnName, optional, line, scriptFile);
                    if (fetchVarName == null || fetchColumnName == null) continue;
                    varAssignments.put(fetchVarName, fetchedVal);
                }
                sb.setLength(0);
                fetchVarName = null;
                fetchColumnName = null;
                doBatch = false;
                batchUpperLimit = 0;
                batchSize = 1;
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (Throwable e) {}
            try {
                ((InputStream)scriptInputStream).close();
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeStatement(Connection connection, String sql, String fetchColumnName, boolean optional, int line, File file) throws Exception {
        Object ret;
        block15: {
            StringBuilder executedStatements = this.executedStatementsThreadLocal.get();
            if (executedStatements == null) {
                throw new IllegalArgumentException("The executedStatementsThreadLocal must be populated");
            }
            Statement stmt = connection.createStatement();
            ret = null;
            try {
                ResultSet rs;
                if (logger.isDebugEnabled()) {
                    LogUtil.debug((Log)logger, (String)MSG_EXECUTING_STATEMENT, (Object[])new Object[]{sql});
                }
                boolean haveResults = stmt.execute(sql);
                executedStatements.append(sql).append(";\n\n");
                if (haveResults && fetchColumnName != null && (rs = stmt.getResultSet()).next()) {
                    ret = rs.getObject(fetchColumnName);
                }
            }
            catch (SQLException e) {
                if (optional) {
                    LogUtil.debug((Log)logger, (String)MSG_OPTIONAL_STATEMENT_FAILED, (Object[])new Object[]{sql, e.getMessage(), file.getAbsolutePath(), line});
                    break block15;
                }
                LogUtil.error((Log)logger, (String)ERR_STATEMENT_FAILED, (Object[])new Object[]{sql, e.getMessage(), file.getAbsolutePath(), line});
                throw e;
            }
            finally {
                try {
                    stmt.close();
                }
                catch (Throwable e) {}
            }
        }
        return ret;
    }

    private void checkDialect(Dialect dialect) {
        Class<?> dialectClazz = dialect.getClass();
        LogUtil.info((Log)logger, (String)MSG_DIALECT_USED, (Object[])new Object[]{dialectClazz.getName()});
        if (dialectClazz.equals(MySQLDialect.class) || dialectClazz.equals(MySQL5Dialect.class)) {
            LogUtil.error((Log)logger, (String)ERR_DIALECT_SHOULD_USE, (Object[])new Object[]{dialectClazz.getName(), MySQLInnoDBDialect.class.getName()});
            throw AlfrescoRuntimeException.create((String)WARN_DIALECT_UNSUPPORTED, (Object[])new Object[]{dialectClazz.getName()});
        }
        if (dialectClazz.equals(HSQLDialect.class)) {
            LogUtil.info((Log)logger, (String)WARN_DIALECT_HSQL, (Object[])new Object[0]);
        } else if (dialectClazz.equals(DerbyDialect.class)) {
            LogUtil.info((Log)logger, (String)WARN_DIALECT_DERBY, (Object[])new Object[0]);
        } else {
            if (dialectClazz.equals(Oracle9iDialect.class) || dialectClazz.equals(Oracle10gDialect.class)) {
                LogUtil.error((Log)logger, (String)ERR_DIALECT_SHOULD_USE, (Object[])new Object[]{dialectClazz.getName(), AlfrescoOracle9Dialect.class.getName()});
                throw AlfrescoRuntimeException.create((String)WARN_DIALECT_UNSUPPORTED, (Object[])new Object[]{dialectClazz.getName()});
            }
            if (dialectClazz.equals(OracleDialect.class) || dialectClazz.equals(Oracle9Dialect.class)) {
                LogUtil.error((Log)logger, (String)ERR_DIALECT_SHOULD_USE, (Object[])new Object[]{dialectClazz.getName(), AlfrescoOracle9Dialect.class.getName()});
                throw AlfrescoRuntimeException.create((String)WARN_DIALECT_UNSUPPORTED, (Object[])new Object[]{dialectClazz.getName()});
            }
        }
        int maxStringLength = 1024;
        int serializableType = SerializableTypeHandler.getSerializableType();
        if (dialect instanceof AlfrescoSQLServerDialect) {
            maxStringLength = 1024;
        } else if (dialect instanceof AlfrescoSybaseAnywhereDialect) {
            maxStringLength = Integer.MAX_VALUE;
        } else if (dialect instanceof DB2Dialect) {
            maxStringLength = 1024;
            serializableType = 2004;
        } else if (dialect instanceof HSQLDialect) {
            maxStringLength = 1024;
        } else if (dialect instanceof MySQLInnoDBDialect) {
            maxStringLength = Integer.MAX_VALUE;
        } else if (dialect instanceof AlfrescoOracle9Dialect) {
            maxStringLength = 1024;
        } else if (dialect instanceof PostgreSQLDialect) {
            maxStringLength = 1024;
        }
        SchemaBootstrap.setMaxStringLength(maxStringLength);
        SerializableTypeHandler.setSerializableType((int)serializableType);
        if (this.maximumStringLength > 0) {
            SchemaBootstrap.setMaxStringLength(this.maximumStringLength);
        }
    }

    protected synchronized void onBootstrap(ApplicationEvent event) {
        this.rpr = (ApplicationContext)event.getSource();
        Session session = this.getSessionFactory().openSession();
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(true);
            LogUtil.info((Log)logger, (String)MSG_DATABASE_USED, (Object[])new Object[]{connection});
            Configuration cfg = this.localSessionFactory.getConfiguration();
            this.checkDialect(this.dialect);
            String defaultConnectionProviderFactoryClass = cfg.getProperty("hibernate.connection.provider_class");
            cfg.setProperty("hibernate.connection.provider_class", SchemaBootstrapConnectionProvider.class.getName());
            SchemaBootstrapConnectionProvider.setBootstrapConnection(connection);
            if (this.updateSchema) {
                boolean updatedSchema = false;
                boolean createdSchema = false;
                for (int i = 0; i < this.schemaUpdateLockRetryCount; ++i) {
                    try {
                        createdSchema = this.updateSchema(cfg, (org.hibernate.Session)session, connection);
                        updatedSchema = true;
                        break;
                    }
                    catch (LockFailedException e) {
                        try {
                            ((Object)((Object)this)).wait((long)this.schemaUpdateLockRetryWaitSeconds * 1000L);
                        }
                        catch (InterruptedException ee) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                if (!updatedSchema) {
                    throw new AlfrescoRuntimeException(ERR_PREVIOUS_FAILED_BOOTSTRAP);
                }
                File schemaOutputFile = null;
                schemaOutputFile = this.schemaOuputFilename != null ? new File(this.schemaOuputFilename) : TempFileProvider.createTempFile((String)("AlfrescoSchema-" + this.dialect.getClass().getSimpleName() + "-All_Statements-"), (String)".sql");
                StringBuilder executedStatements = this.executedStatementsThreadLocal.get();
                if (executedStatements == null) {
                    LogUtil.info((Log)logger, (String)MSG_NO_CHANGES, (Object[])new Object[0]);
                } else {
                    FileContentWriter writer = new FileContentWriter(schemaOutputFile);
                    writer.setEncoding("UTF-8");
                    String executedStatementsStr = executedStatements.toString();
                    writer.putContent(executedStatementsStr);
                    LogUtil.info((Log)logger, (String)MSG_ALL_STATEMENTS, (Object[])new Object[]{schemaOutputFile.getPath()});
                }
                if (!createdSchema) {
                    this.checkSchemaPatchScripts(cfg, connection, this.validateUpdateScriptPatches, false);
                    this.checkSchemaPatchScripts(cfg, connection, this.preUpdateScriptPatches, false);
                    this.checkSchemaPatchScripts(cfg, connection, this.postUpdateScriptPatches, false);
                }
                if (executedStatements != null) {
                    this.setBootstrapCompleted(connection);
                }
                if (executedStatements != null) {
                    this.validateSchema("Alfresco-{0}-Validation-Post-Upgrade-{1}-");
                    File xmlPostSchemaOutputFile34 = this.dumpSchema34(this.dialect, TempFileProvider.createTempFile((String)("AlfrescoSchema-" + this.dialect.getClass().getSimpleName() + "-"), (String)".xml").getPath(), "Failed to dump normalized, post-upgrade schema to file.");
                    this.dumpSchema("post-upgrade");
                    if (createdSchema) {
                        if (xmlPostSchemaOutputFile34 != null) {
                            LogUtil.info((Log)logger, (String)MSG_NORMALIZED_SCHEMA, (Object[])new Object[]{xmlPostSchemaOutputFile34.getPath()});
                        }
                    } else {
                        if (this.xmlPreSchemaOutputFile34 != null) {
                            LogUtil.info((Log)logger, (String)MSG_NORMALIZED_SCHEMA_PRE, (Object[])new Object[]{this.xmlPreSchemaOutputFile34.getPath()});
                        }
                        if (xmlPostSchemaOutputFile34 != null) {
                            LogUtil.info((Log)logger, (String)MSG_NORMALIZED_SCHEMA_POST, (Object[])new Object[]{xmlPostSchemaOutputFile34.getPath()});
                        }
                    }
                }
            } else {
                LogUtil.info((Log)logger, (String)MSG_BYPASSING_SCHEMA_UPDATE, (Object[])new Object[0]);
            }
            if (this.stopAfterSchemaBootstrap) {
                File xmlStopSchemaOutputFile = this.dumpSchema34(this.dialect, TempFileProvider.createTempFile((String)("AlfrescoSchema-" + this.dialect.getClass().getSimpleName() + "-"), (String)"-ForcedExit.xml").getPath(), "Failed to dump normalized, post-upgrade, forced-exit schema to file.");
                this.dumpSchema("forced-exit");
                if (xmlStopSchemaOutputFile != null) {
                    LogUtil.info((Log)logger, (String)MSG_NORMALIZED_SCHEMA, (Object[])new Object[]{xmlStopSchemaOutputFile});
                }
                LogUtil.error((Log)logger, (String)ERR_FORCED_STOP, (Object[])new Object[0]);
                throw new BootstrapStopException();
            }
            cfg.setProperty("hibernate.connection.provider_class", defaultConnectionProviderFactoryClass);
            ((ApplicationContext)event.getSource()).publishEvent((ApplicationEvent)new SchemaAvailableEvent((Object)this));
        }
        catch (BootstrapStopException e) {
            throw e;
        }
        catch (Throwable e) {
            LogUtil.error((Log)logger, (Throwable)e, (String)ERR_UPDATE_FAILED, (Object[])new Object[0]);
            if (this.updateSchema) {
                throw new AlfrescoRuntimeException(ERR_UPDATE_FAILED, e);
            }
            throw new AlfrescoRuntimeException(ERR_VALIDATION_FAILED, e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Throwable e) {
                logger.warn((Object)("Error closing DB connection: " + e.getMessage()));
            }
            SchemaBootstrapConnectionProvider.setBootstrapConnection(null);
        }
    }

    public synchronized int validateSchema(String outputFileNameTemplate) {
        int totalProblems = 0;
        for (String schemaReferenceUrl : this.schemaReferenceUrls) {
            Resource referenceResource = this.getDialectResource(this.dialect.getClass(), schemaReferenceUrl);
            if (referenceResource == null || !referenceResource.exists()) {
                String resourceUrl = this.resolveDialectUrl(this.dialect.getClass(), schemaReferenceUrl);
                LogUtil.debug((Log)logger, (String)DEBUG_SCHEMA_COMP_NO_REF_FILE, (Object[])new Object[]{resourceUrl});
                continue;
            }
            int problems = this.validateSchema(referenceResource, outputFileNameTemplate);
            totalProblems += problems;
        }
        return totalProblems;
    }

    private int validateSchema(Resource referenceResource, String outputFileNameTemplate) {
        try {
            return this.attemptValidateSchema(referenceResource, outputFileNameTemplate);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)"Unable to validate database schema.", e);
            }
            return 0;
        }
    }

    private int attemptValidateSchema(Resource referenceResource, String outputFileNameTemplate) {
        Date startTime = new Date();
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(referenceResource.getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to open schema reference file: " + referenceResource);
        }
        XMLToSchema xmlToSchema = new XMLToSchema(is);
        xmlToSchema.parse();
        Schema reference = xmlToSchema.getSchema();
        ExportDb exporter = new ExportDb(this.dataSource, this.dialect, this.descriptorService);
        exporter.setNamePrefix(reference.getDbPrefix());
        exporter.execute();
        Schema target = exporter.getSchema();
        SchemaComparator schemaComparator = new SchemaComparator(reference, target, this.dialect);
        schemaComparator.validateAndCompare();
        Results results = schemaComparator.getComparisonResults();
        Object[] outputFileNameParams = new Object[]{this.dialect.getClass().getSimpleName(), reference.getDbPrefix()};
        String outputFileName = MessageFormat.format(outputFileNameTemplate, outputFileNameParams);
        File outputFile = TempFileProvider.createTempFile((String)outputFileName, (String)".txt");
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(outputFile, "UTF-8");
        }
        catch (FileNotFoundException error) {
            throw new RuntimeException("Unable to open file for writing: " + outputFile);
        }
        catch (UnsupportedEncodingException error) {
            throw new RuntimeException("Unsupported char set: UTF-8", error);
        }
        for (Result result : results) {
            pw.print(result.describe());
            pw.print("\r\n");
        }
        pw.close();
        if (results.size() == 0) {
            LogUtil.info((Log)logger, (String)INFO_SCHEMA_COMP_ALL_OK, (Object[])new Object[]{referenceResource});
        } else {
            int numProblems = results.size();
            LogUtil.warn((Log)logger, (String)WARN_SCHEMA_COMP_PROBLEMS_FOUND, (Object[])new Object[]{numProblems, outputFile});
        }
        Date endTime = new Date();
        long durationMillis = endTime.getTime() - startTime.getTime();
        LogUtil.debug((Log)logger, (String)DEBUG_SCHEMA_COMP_TIME_TAKEN, (Object[])new Object[]{durationMillis});
        return results.size();
    }

    private File dumpSchema34(Dialect dialect, String fileName, String err) {
        File xmlSchemaOutputFile = new File(fileName);
        try {
            Main xmlSchemaOutputMain = new Main(this.dataSource, dialect);
            xmlSchemaOutputMain.execute(xmlSchemaOutputFile);
        }
        catch (Throwable e) {
            xmlSchemaOutputFile = null;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)err, e);
            }
            logger.error((Object)(err + "  Error: " + e.getMessage()));
        }
        return xmlSchemaOutputFile;
    }

    public List<File> dumpSchema() {
        return this.dumpSchema("", null);
    }

    public List<File> dumpSchema(String[] dbPrefixes) {
        return this.dumpSchema("", dbPrefixes);
    }

    private List<File> dumpSchema(String whenDumped, String[] dbPrefixes) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Alfresco-schema-").append(this.dialect.getClass().getSimpleName());
        if (whenDumped != null && whenDumped.length() > 0) {
            sb.append("-");
            sb.append(whenDumped);
        }
        sb.append("-{0}-");
        File outputDir = TempFileProvider.getTempDir();
        String fileNameTemplate = sb.toString();
        return this.dumpSchema(outputDir, fileNameTemplate, dbPrefixes);
    }

    private List<File> dumpSchema(String whenDumped) {
        return this.dumpSchema(whenDumped, null);
    }

    private List<File> dumpSchema(File outputDir, String fileNameTemplate, String[] dbPrefixes) {
        try {
            return this.attemptDumpSchema(outputDir, fileNameTemplate, dbPrefixes);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)("Unable to dump schema to directory " + outputDir), e);
            }
            return null;
        }
    }

    private List<File> attemptDumpSchema(File outputDir, String fileNameTemplate, String[] dbPrefixes) {
        MultiFileDumper.DbToXMLFactoryImpl dbToXMLFactory = new MultiFileDumper.DbToXMLFactoryImpl(this.getApplicationContext());
        MultiFileDumper dumper = dbPrefixes == null ? new MultiFileDumper(outputDir, fileNameTemplate, dbToXMLFactory) : new MultiFileDumper(dbPrefixes, outputDir, fileNameTemplate, dbToXMLFactory);
        List<File> files = dumper.dumpFiles();
        for (File file : files) {
            if (!logger.isInfoEnabled()) continue;
            LogUtil.info((Log)logger, (String)MSG_NORMALIZED_SCHEMA, (Object[])new Object[]{file.getAbsolutePath()});
        }
        return files;
    }

    protected void onShutdown(ApplicationEvent event) {
        Class<?> dialectClazz = this.dialect.getClass();
        if (dialectClazz.equals(DerbyDialect.class)) {
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public class UnclosableConnection
    implements Connection {
        private Connection wrapped;

        public UnclosableConnection(Connection wrappedConnection) {
            this.wrapped = wrappedConnection;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.wrapped.isWrapperFor(iface);
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.wrapped.unwrap(iface);
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.wrapped.clearWarnings();
        }

        @Override
        public void close() throws SQLException {
        }

        @Override
        public void commit() throws SQLException {
            this.wrapped.commit();
        }

        @Override
        public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
            return this.wrapped.createArrayOf(typeName, elements);
        }

        @Override
        public Blob createBlob() throws SQLException {
            return this.wrapped.createBlob();
        }

        @Override
        public Clob createClob() throws SQLException {
            return this.wrapped.createClob();
        }

        @Override
        public NClob createNClob() throws SQLException {
            return this.wrapped.createNClob();
        }

        @Override
        public SQLXML createSQLXML() throws SQLException {
            return this.wrapped.createSQLXML();
        }

        @Override
        public Statement createStatement() throws SQLException {
            return this.wrapped.createStatement();
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.wrapped.createStatement(resultSetType, resultSetConcurrency);
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.wrapped.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
            return this.wrapped.createStruct(typeName, attributes);
        }

        @Override
        public boolean getAutoCommit() throws SQLException {
            return this.wrapped.getAutoCommit();
        }

        @Override
        public String getCatalog() throws SQLException {
            return this.wrapped.getCatalog();
        }

        @Override
        public Properties getClientInfo() throws SQLException {
            return this.wrapped.getClientInfo();
        }

        @Override
        public String getClientInfo(String name) throws SQLException {
            return this.wrapped.getClientInfo(name);
        }

        @Override
        public int getHoldability() throws SQLException {
            return this.wrapped.getHoldability();
        }

        @Override
        public DatabaseMetaData getMetaData() throws SQLException {
            return this.wrapped.getMetaData();
        }

        @Override
        public int getTransactionIsolation() throws SQLException {
            return this.wrapped.getTransactionIsolation();
        }

        @Override
        public Map<String, Class<?>> getTypeMap() throws SQLException {
            return this.wrapped.getTypeMap();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return this.wrapped.getWarnings();
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.wrapped.isClosed();
        }

        @Override
        public boolean isReadOnly() throws SQLException {
            return this.wrapped.isReadOnly();
        }

        @Override
        public boolean isValid(int timeout) throws SQLException {
            return this.wrapped.isValid(timeout);
        }

        @Override
        public String nativeSQL(String sql) throws SQLException {
            return this.wrapped.nativeSQL(sql);
        }

        @Override
        public CallableStatement prepareCall(String sql) throws SQLException {
            return this.wrapped.prepareCall(sql);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.wrapped.prepareCall(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.wrapped.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public PreparedStatement prepareStatement(String sql) throws SQLException {
            return this.wrapped.prepareStatement(sql);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
            return this.wrapped.prepareStatement(sql, autoGeneratedKeys);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
            return this.wrapped.prepareStatement(sql, columnIndexes);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
            return this.wrapped.prepareStatement(sql, columnNames);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.wrapped.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.wrapped.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.wrapped.releaseSavepoint(savepoint);
        }

        @Override
        public void rollback() throws SQLException {
            this.wrapped.rollback();
        }

        @Override
        public void rollback(Savepoint savepoint) throws SQLException {
            this.wrapped.rollback(savepoint);
        }

        @Override
        public void setAutoCommit(boolean autoCommit) throws SQLException {
            this.wrapped.setAutoCommit(autoCommit);
        }

        @Override
        public void setCatalog(String catalog) throws SQLException {
            this.wrapped.setCatalog(catalog);
        }

        @Override
        public void setClientInfo(Properties properties) throws SQLClientInfoException {
            this.wrapped.setClientInfo(properties);
        }

        @Override
        public void setClientInfo(String name, String value) throws SQLClientInfoException {
            this.wrapped.setClientInfo(name, value);
        }

        @Override
        public void setHoldability(int holdability) throws SQLException {
            this.wrapped.setHoldability(holdability);
        }

        @Override
        public void setReadOnly(boolean readOnly) throws SQLException {
            this.wrapped.setReadOnly(readOnly);
        }

        @Override
        public Savepoint setSavepoint() throws SQLException {
            return this.wrapped.setSavepoint();
        }

        @Override
        public Savepoint setSavepoint(String name) throws SQLException {
            return this.wrapped.setSavepoint(name);
        }

        @Override
        public void setTransactionIsolation(int level) throws SQLException {
            this.wrapped.setTransactionIsolation(level);
        }

        @Override
        public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
            this.wrapped.setTypeMap(map);
        }

        @Override
        public void setSchema(String schema) throws SQLException {
            this.wrapped.setSchema(schema);
        }

        @Override
        public String getSchema() throws SQLException {
            return this.wrapped.getSchema();
        }

        @Override
        public void abort(Executor executor) throws SQLException {
            this.wrapped.abort(executor);
        }

        @Override
        public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
            this.wrapped.setNetworkTimeout(executor, milliseconds);
        }

        @Override
        public int getNetworkTimeout() throws SQLException {
            return this.wrapped.getNetworkTimeout();
        }
    }

    public static class SchemaBootstrapConnectionProvider
    extends UserSuppliedConnectionProvider {
        private static ThreadLocal<Connection> threadLocalConnection = new ThreadLocal();

        public static void setBootstrapConnection(Connection connection) {
            threadLocalConnection.set(connection);
        }

        public void close() {
            threadLocalConnection.set(null);
        }

        public void closeConnection(Connection conn) {
        }

        public void configure(Properties props) throws HibernateException {
        }

        public Connection getConnection() {
            return threadLocalConnection.get();
        }

        public boolean supportsAggressiveRelease() {
            return false;
        }
    }

    private static class LockFailedException
    extends Exception {
        private static final long serialVersionUID = -6676398230191205456L;

        private LockFailedException() {
        }
    }

    private static class BootstrapStopException
    extends RuntimeException {
        private static final long serialVersionUID = 4250016675538442181L;

        private BootstrapStopException() {
            super(I18NUtil.getMessage((String)SchemaBootstrap.ERR_FORCED_STOP));
        }
    }

    private static class NoSchemaException
    extends Exception {
        private static final long serialVersionUID = 5574280159910824660L;

        private NoSchemaException() {
        }
    }
}

