/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.usage;

import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.node.ChildAssocEntity;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.usage.UsageDAO;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.surf.util.I18NUtil;

public class UsageDAOTest
extends TestCase {
    private ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private RetryingTransactionHelper txnHelper;
    private UsageDAO usageDAO;
    private NodeDAO nodeDAO;
    private static final StoreRef storeRef = new StoreRef("workspace", "SpacesStore");

    public void setUp() throws Exception {
        this.transactionService = (TransactionService)this.ctx.getBean("transactionService");
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.usageDAO = (UsageDAO)this.ctx.getBean("usageDAO");
        this.nodeDAO = (NodeDAO)this.ctx.getBean("nodeDAO");
    }

    private NodeRef getRootNodeRef() {
        return (NodeRef)this.nodeDAO.getRootNode(storeRef).getSecond();
    }

    private long getNodeId(NodeRef nodeRef) {
        return (Long)this.nodeDAO.getNodePair(nodeRef).getFirst();
    }

    private NodeRef createNode(long parentNodeId) {
        ChildAssocEntity assoc = this.nodeDAO.newNode(parentNodeId, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, storeRef, null, ContentModel.TYPE_CONTENT, I18NUtil.getLocale(), null, null);
        return assoc.getChildNode().getNodeRef();
    }

    public void testCreateAndDeleteUsageDeltas() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeRef rootNodeRef = UsageDAOTest.this.getRootNodeRef();
                long rootNodeId = UsageDAOTest.this.getNodeId(rootNodeRef);
                UsageDAOTest.this.usageDAO.deleteDeltas(rootNodeId);
                Set<NodeRef> usageDeltaNodes = UsageDAOTest.this.usageDAO.getUsageDeltaNodes();
                for (NodeRef nodeRef : usageDeltaNodes) {
                    long nodeId = UsageDAOTest.this.getNodeId(nodeRef);
                    UsageDAOTest.this.usageDAO.deleteDeltas(nodeId);
                }
                Assert.assertEquals((int)0, (int)UsageDAOTest.this.usageDAO.getUsageDeltaNodes().size());
                UsageDAOTest.this.usageDAO.insertDelta(rootNodeRef, 100L);
                Assert.assertEquals((long)100L, (long)UsageDAOTest.this.usageDAO.getTotalDeltaSize(rootNodeRef, false));
                Assert.assertEquals((int)1, (int)UsageDAOTest.this.usageDAO.getUsageDeltaNodes().size());
                UsageDAOTest.this.usageDAO.insertDelta(rootNodeRef, 1000L);
                Assert.assertEquals((long)1100L, (long)UsageDAOTest.this.usageDAO.getTotalDeltaSize(rootNodeRef, false));
                Assert.assertEquals((int)1, (int)UsageDAOTest.this.usageDAO.getUsageDeltaNodes().size());
                UsageDAOTest.this.usageDAO.insertDelta(rootNodeRef, -500L);
                Assert.assertEquals((long)600L, (long)UsageDAOTest.this.usageDAO.getTotalDeltaSize(rootNodeRef, false));
                Assert.assertEquals((int)1, (int)UsageDAOTest.this.usageDAO.getUsageDeltaNodes().size());
                NodeRef nodeRef1 = UsageDAOTest.this.createNode(rootNodeId);
                long nodeId1 = UsageDAOTest.this.getNodeId(nodeRef1);
                Assert.assertEquals((long)0L, (long)UsageDAOTest.this.usageDAO.getTotalDeltaSize(nodeRef1, false));
                NodeRef nodeRef2 = UsageDAOTest.this.createNode(rootNodeId);
                long nodeId2 = UsageDAOTest.this.getNodeId(nodeRef2);
                Assert.assertEquals((long)0L, (long)UsageDAOTest.this.usageDAO.getTotalDeltaSize(nodeRef2, false));
                Assert.assertEquals((int)1, (int)UsageDAOTest.this.usageDAO.getUsageDeltaNodes().size());
                UsageDAOTest.this.usageDAO.insertDelta(nodeRef1, 200L);
                Assert.assertEquals((long)200L, (long)UsageDAOTest.this.usageDAO.getTotalDeltaSize(nodeRef1, false));
                Assert.assertEquals((int)2, (int)UsageDAOTest.this.usageDAO.getUsageDeltaNodes().size());
                UsageDAOTest.this.usageDAO.insertDelta(nodeRef2, -400L);
                Assert.assertEquals((long)-400L, (long)UsageDAOTest.this.usageDAO.getTotalDeltaSize(nodeRef2, false));
                Assert.assertEquals((int)3, (int)UsageDAOTest.this.usageDAO.getUsageDeltaNodes().size());
                UsageDAOTest.this.usageDAO.deleteDeltas(rootNodeId);
                Assert.assertEquals((long)0L, (long)UsageDAOTest.this.usageDAO.getTotalDeltaSize(rootNodeRef, false));
                Assert.assertEquals((int)2, (int)UsageDAOTest.this.usageDAO.getUsageDeltaNodes().size());
                UsageDAOTest.this.usageDAO.deleteDeltas(nodeId1);
                Assert.assertEquals((long)0L, (long)UsageDAOTest.this.usageDAO.getTotalDeltaSize(nodeRef1, false));
                Assert.assertEquals((int)1, (int)UsageDAOTest.this.usageDAO.getUsageDeltaNodes().size());
                UsageDAOTest.this.usageDAO.deleteDeltas(nodeId2);
                Assert.assertEquals((long)0L, (long)UsageDAOTest.this.usageDAO.getTotalDeltaSize(nodeRef2, false));
                Assert.assertEquals((int)0, (int)UsageDAOTest.this.usageDAO.getUsageDeltaNodes().size());
                return null;
            }
        };
        this.txnHelper.doInTransaction(callback);
    }

    public void testCreateUsageDeltasWithRollback() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> voidCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeRef rootNodeRef = UsageDAOTest.this.getRootNodeRef();
                long rootNodeId = UsageDAOTest.this.getNodeId(rootNodeRef);
                UsageDAOTest.this.usageDAO.deleteDeltas(rootNodeId);
                Assert.assertEquals((long)0L, (long)UsageDAOTest.this.usageDAO.getTotalDeltaSize(rootNodeRef, false));
                Set<NodeRef> usageDeltaNodes = UsageDAOTest.this.usageDAO.getUsageDeltaNodes();
                for (NodeRef nodeRef : usageDeltaNodes) {
                    long nodeId = UsageDAOTest.this.getNodeId(nodeRef);
                    UsageDAOTest.this.usageDAO.deleteDeltas(nodeId);
                }
                Assert.assertEquals((int)0, (int)UsageDAOTest.this.usageDAO.getUsageDeltaNodes().size());
                return null;
            }
        };
        this.txnHelper.doInTransaction(voidCallback);
        voidCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeRef usageNodeRef = UsageDAOTest.this.getRootNodeRef();
                UsageDAOTest.this.usageDAO.insertDelta(usageNodeRef, 100L);
                throw new RuntimeException("Forced");
            }
        };
        try {
            this.txnHelper.doInTransaction(voidCallback);
            UsageDAOTest.fail((String)"Transaction didn't roll back");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        voidCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeRef usageNodeRef = UsageDAOTest.this.getRootNodeRef();
                Assert.assertEquals((long)0L, (long)UsageDAOTest.this.usageDAO.getTotalDeltaSize(usageNodeRef, false));
                Assert.assertEquals((int)0, (int)UsageDAOTest.this.usageDAO.getUsageDeltaNodes().size());
                return null;
            }
        };
        this.txnHelper.doInTransaction(voidCallback);
    }
}

