/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.exporter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.exporter.ACPExportPackageHandler;
import org.alfresco.repo.importer.ACPImportPackageHandler;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.view.Exporter;
import org.alfresco.service.cmr.view.ExporterContext;
import org.alfresco.service.cmr.view.ExporterCrawlerParameters;
import org.alfresco.service.cmr.view.ExporterService;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.debug.NodeStoreInspector;
import org.springframework.extensions.surf.util.I18NUtil;

public class ExporterComponentTest
extends BaseSpringTest {
    private NodeService nodeService;
    private ExporterService exporterService;
    private ImporterService importerService;
    private FileFolderService fileFolderService;
    private CategoryService categoryService;
    private StoreRef storeRef;
    private AuthenticationComponent authenticationComponent;

    protected void onSetUpInTransaction() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean(ServiceRegistry.NODE_SERVICE.getLocalName());
        this.exporterService = (ExporterService)this.applicationContext.getBean("exporterComponent");
        this.importerService = (ImporterService)this.applicationContext.getBean("importerComponent");
        this.fileFolderService = (FileFolderService)this.applicationContext.getBean("fileFolderService");
        this.categoryService = (CategoryService)this.applicationContext.getBean("categoryService");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
    }

    protected void onTearDownInTransaction() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
        super.onTearDownInTransaction();
    }

    public void testExport() throws Exception {
        TestProgress testProgress = new TestProgress();
        Location location = new Location(this.storeRef);
        InputStream test = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/alfresco/repo/importer/importercomponent_test.xml");
        InputStreamReader testReader = new InputStreamReader(test, "UTF-8");
        this.importerService.importView(testReader, location, null, null);
        this.dumpNodeStore(Locale.ENGLISH);
        this.dumpNodeStore(Locale.FRENCH);
        this.dumpNodeStore(Locale.GERMAN);
        location.setPath("/system");
        File tempFile = TempFileProvider.createTempFile((String)"xmlexporttest", (String)".xml");
        FileOutputStream output = new FileOutputStream(tempFile);
        ExporterCrawlerParameters parameters = new ExporterCrawlerParameters();
        parameters.setExportFrom(location);
        File acpFile = TempFileProvider.createTempFile((String)"alf", (String)"acp");
        File dataFile = new File("test");
        File contentDir = new File("test");
        ACPExportPackageHandler acpHandler = new ACPExportPackageHandler(new FileOutputStream(acpFile), dataFile, contentDir, null);
        acpHandler.setNodeService(this.nodeService);
        acpHandler.setExportAsFolders(true);
        this.exporterService.exportView(acpHandler, parameters, (Exporter)testProgress);
        ((OutputStream)output).close();
    }

    public void testRoundTripKeepsCategoriesWhenWithinSameStore() throws Exception {
        StoreRef storeRef = StoreRef.STORE_REF_WORKSPACE_SPACESSTORE;
        NodeRef rootNode = this.nodeService.getRootNode(storeRef);
        ChildAssociationRef contentChildAssocRef = this.createContentWithCategories(storeRef, rootNode);
        File acpFile = this.exportContent(contentChildAssocRef);
        FileInfo importFolderFileInfo = this.importContent(acpFile, rootNode);
        NodeRef importedFileNode = this.fileFolderService.searchSimple(importFolderFileInfo.getNodeRef(), "test.txt");
        ExporterComponentTest.assertNotNull((String)"Couldn't find imported file: test.txt", (Object)importedFileNode);
        ExporterComponentTest.assertTrue((boolean)this.nodeService.hasAspect(importedFileNode, ContentModel.ASPECT_GEN_CLASSIFIABLE));
        List importedFileCategories = (List)((Object)this.nodeService.getProperty(importedFileNode, ContentModel.PROP_CATEGORIES));
        this.assertCategoriesEqual(importedFileCategories, "Regions", "Software Document Classification");
    }

    public void testRoundTripLosesCategoriesImportingToDifferentStore() throws Exception {
        StoreRef storeRef = StoreRef.STORE_REF_WORKSPACE_SPACESSTORE;
        NodeRef rootNode = this.nodeService.getRootNode(storeRef);
        ChildAssociationRef contentChildAssocRef = this.createContentWithCategories(storeRef, rootNode);
        File acpFile = this.exportContent(contentChildAssocRef);
        NodeRef destRootNode = this.nodeService.getRootNode(this.storeRef);
        FileInfo importFolderFileInfo = this.importContent(acpFile, destRootNode);
        NodeRef importedFileNode = this.fileFolderService.searchSimple(importFolderFileInfo.getNodeRef(), "test.txt");
        ExporterComponentTest.assertNotNull((String)"Couldn't find imported file: test.txt", (Object)importedFileNode);
        ExporterComponentTest.assertTrue((boolean)this.nodeService.hasAspect(importedFileNode, ContentModel.ASPECT_GEN_CLASSIFIABLE));
        List importedFileCategories = (List)((Object)this.nodeService.getProperty(importedFileNode, ContentModel.PROP_CATEGORIES));
        ExporterComponentTest.assertEquals((String)"No categories should have been imported for the content", (int)0, (int)importedFileCategories.size());
    }

    private File exportContent(ChildAssociationRef contentChildAssocRef) throws FileNotFoundException, IOException {
        TestProgress testProgress = new TestProgress();
        Location location = new Location(contentChildAssocRef.getParentRef());
        ExporterCrawlerParameters parameters = new ExporterCrawlerParameters();
        parameters.setExportFrom(location);
        File acpFile = TempFileProvider.createTempFile((String)"category-export-test", (String)"acp");
        System.out.println("Exporting to file: " + acpFile.getAbsolutePath());
        File dataFile = new File("test-data-file");
        File contentDir = new File("test-content-dir");
        FileOutputStream fos = new FileOutputStream(acpFile);
        ACPExportPackageHandler acpHandler = new ACPExportPackageHandler(fos, dataFile, contentDir, null);
        acpHandler.setNodeService(this.nodeService);
        acpHandler.setExportAsFolders(true);
        this.exporterService.exportView(acpHandler, parameters, (Exporter)testProgress);
        ((OutputStream)fos).close();
        return acpFile;
    }

    private ChildAssociationRef createContentWithCategories(StoreRef storeRef, NodeRef rootNode) {
        Collection<ChildAssociationRef> assocRefs = this.categoryService.getRootCategories(storeRef, ContentModel.ASPECT_GEN_CLASSIFIABLE);
        ExporterComponentTest.assertTrue((String)"Pre-condition failure: not enough categories", (assocRefs.size() >= 2 ? 1 : 0) != 0);
        Iterator<ChildAssociationRef> it = assocRefs.iterator();
        NodeRef softwareDocCategoryNode = it.next().getChildRef();
        it.next();
        NodeRef regionsCategoryNode = it.next().getChildRef();
        FileInfo exportFileInfo = this.fileFolderService.create(rootNode, "Export Folder", ContentModel.TYPE_FOLDER);
        Map<QName, String> properties = Collections.singletonMap(ContentModel.PROP_NAME, "test.txt");
        ChildAssociationRef contentChildAssocRef = this.nodeService.createNode(exportFileInfo.getNodeRef(), ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT, properties);
        NodeRef contentNodeRef = contentChildAssocRef.getChildRef();
        ArrayList<NodeRef> categories = new ArrayList<NodeRef>(2);
        categories.add(softwareDocCategoryNode);
        categories.add(regionsCategoryNode);
        if (!this.nodeService.hasAspect(contentNodeRef, ContentModel.ASPECT_GEN_CLASSIFIABLE)) {
            HashMap<QName, ArrayList<NodeRef>> props = new HashMap<QName, ArrayList<NodeRef>>();
            props.put(ContentModel.PROP_CATEGORIES, categories);
            this.nodeService.addAspect(contentNodeRef, ContentModel.ASPECT_GEN_CLASSIFIABLE, props);
        } else {
            this.nodeService.setProperty(contentNodeRef, ContentModel.PROP_CATEGORIES, categories);
        }
        return contentChildAssocRef;
    }

    private FileInfo importContent(File acpFile, NodeRef destRootNode) {
        FileInfo importFolderFileInfo = this.fileFolderService.create(destRootNode, "Import Folder", ContentModel.TYPE_FOLDER);
        ACPImportPackageHandler importHandler = new ACPImportPackageHandler(acpFile, "UTF-8");
        this.importerService.importView(importHandler, new Location(importFolderFileInfo.getNodeRef()), null, null);
        return importFolderFileInfo;
    }

    private void assertCategoriesEqual(List<NodeRef> categories, String ... expectedCategoryNames) {
        ExporterComponentTest.assertEquals((String)"Number of categories is not as expected.", (int)expectedCategoryNames.length, (int)categories.size());
        ArrayList<String> categoryNames = new ArrayList<String>(10);
        for (NodeRef nodeRef : categories) {
            String name = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
            categoryNames.add(name);
        }
        Collections.sort(categoryNames);
        for (int i = 0; i < expectedCategoryNames.length; ++i) {
            ExporterComponentTest.assertEquals((String)expectedCategoryNames[i], (String)((String)categoryNames.get(i)));
        }
    }

    private void dumpNodeStore(Locale locale) {
        System.out.println(locale.getDisplayLanguage() + " LOCALE: ");
        I18NUtil.setLocale((Locale)locale);
        System.out.println(NodeStoreInspector.dumpNodeStore((NodeService)this.applicationContext.getBean("NodeService"), this.storeRef));
    }

    private static class TestProgress
    implements Exporter {
        private TestProgress() {
        }

        @Override
        public void start(ExporterContext exportNodeRef) {
            System.out.println("TestProgress: start");
        }

        @Override
        public void startNamespace(String prefix, String uri) {
        }

        @Override
        public void endNamespace(String prefix) {
        }

        @Override
        public void startNode(NodeRef nodeRef) {
            System.out.println("TestProgress: start node " + nodeRef);
        }

        @Override
        public void endNode(NodeRef nodeRef) {
        }

        @Override
        public void startAspect(NodeRef nodeRef, QName aspect) {
        }

        @Override
        public void endAspect(NodeRef nodeRef, QName aspect) {
        }

        @Override
        public void startProperty(NodeRef nodeRef, QName property) {
        }

        @Override
        public void endProperty(NodeRef nodeRef, QName property) {
        }

        @Override
        public void startValueCollection(NodeRef nodeRef, QName property) {
        }

        @Override
        public void endValueCollection(NodeRef nodeRef, QName property) {
        }

        @Override
        public void value(NodeRef nodeRef, QName property, Object value, int index) {
        }

        @Override
        public void content(NodeRef nodeRef, QName property, InputStream content, ContentData contentData, int index) {
        }

        @Override
        public void startAssoc(NodeRef nodeRef, QName assoc) {
        }

        @Override
        public void endAssoc(NodeRef nodeRef, QName assoc) {
        }

        @Override
        public void warning(String warning) {
            System.out.println("TestProgress: warning " + warning);
        }

        @Override
        public void end() {
            System.out.println("TestProgress: end");
        }

        @Override
        public void startProperties(NodeRef nodeRef) {
        }

        @Override
        public void endProperties(NodeRef nodeRef) {
        }

        @Override
        public void startAspects(NodeRef nodeRef) {
        }

        @Override
        public void endAspects(NodeRef nodeRef) {
        }

        @Override
        public void startAssocs(NodeRef nodeRef) {
        }

        @Override
        public void endAssocs(NodeRef nodeRef) {
        }

        @Override
        public void startACL(NodeRef nodeRef) {
        }

        @Override
        public void permission(NodeRef nodeRef, AccessPermission permission) {
        }

        @Override
        public void endACL(NodeRef nodeRef) {
        }

        @Override
        public void startReference(NodeRef nodeRef, QName childName) {
        }

        @Override
        public void endReference(NodeRef nodeRef) {
        }

        @Override
        public void endValueMLText(NodeRef nodeRef) {
        }

        @Override
        public void startValueMLText(NodeRef nodeRef, Locale locale) {
        }
    }
}

