/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.exporter;

import java.io.InputStream;
import java.util.Locale;
import org.alfresco.repo.exporter.NodeContentData;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.view.ExportPackageHandler;
import org.alfresco.service.cmr.view.Exporter;
import org.alfresco.service.cmr.view.ExporterContext;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.surf.util.ParameterCheck;

class URLExporter
implements Exporter {
    private Exporter exporter;
    private ExportPackageHandler streamHandler;

    public URLExporter(Exporter exporter, ExportPackageHandler streamHandler) {
        ParameterCheck.mandatory((String)"Exporter", (Object)exporter);
        ParameterCheck.mandatory((String)"Stream Handler", (Object)streamHandler);
        this.exporter = exporter;
        this.streamHandler = streamHandler;
    }

    @Override
    public void start(ExporterContext context) {
        this.exporter.start(context);
    }

    @Override
    public void startNamespace(String prefix, String uri) {
        this.exporter.startNamespace(prefix, uri);
    }

    @Override
    public void endNamespace(String prefix) {
        this.exporter.endNamespace(prefix);
    }

    @Override
    public void startNode(NodeRef nodeRef) {
        this.exporter.startNode(nodeRef);
    }

    @Override
    public void endNode(NodeRef nodeRef) {
        this.exporter.endNode(nodeRef);
    }

    @Override
    public void startAspects(NodeRef nodeRef) {
        this.exporter.startAspects(nodeRef);
    }

    @Override
    public void endAspects(NodeRef nodeRef) {
        this.exporter.endAspects(nodeRef);
    }

    @Override
    public void startAspect(NodeRef nodeRef, QName aspect) {
        this.exporter.startAspect(nodeRef, aspect);
    }

    @Override
    public void endAspect(NodeRef nodeRef, QName aspect) {
        this.exporter.endAspect(nodeRef, aspect);
    }

    @Override
    public void startACL(NodeRef nodeRef) {
        this.exporter.startACL(nodeRef);
    }

    @Override
    public void permission(NodeRef nodeRef, AccessPermission permission) {
        this.exporter.permission(nodeRef, permission);
    }

    @Override
    public void endACL(NodeRef nodeRef) {
        this.exporter.endACL(nodeRef);
    }

    @Override
    public void startProperties(NodeRef nodeRef) {
        this.exporter.startProperties(nodeRef);
    }

    @Override
    public void endProperties(NodeRef nodeRef) {
        this.exporter.endProperties(nodeRef);
    }

    @Override
    public void startProperty(NodeRef nodeRef, QName property) {
        this.exporter.startProperty(nodeRef, property);
    }

    @Override
    public void endProperty(NodeRef nodeRef, QName property) {
        this.exporter.endProperty(nodeRef, property);
    }

    @Override
    public void startValueCollection(NodeRef nodeRef, QName property) {
        this.exporter.startValueCollection(nodeRef, property);
    }

    @Override
    public void endValueCollection(NodeRef nodeRef, QName property) {
        this.exporter.endValueCollection(nodeRef, property);
    }

    @Override
    public void value(NodeRef nodeRef, QName property, Object value, int index) {
        this.exporter.value(nodeRef, property, value, index);
    }

    @Override
    public void content(NodeRef nodeRef, QName property, InputStream content, ContentData contentData, int index) {
        ContentData exportedContentData = this.streamHandler.exportContent(content, new NodeContentData(nodeRef, contentData));
        this.value(nodeRef, property, exportedContentData, index);
    }

    @Override
    public void startAssoc(NodeRef nodeRef, QName assoc) {
        this.exporter.startAssoc(nodeRef, assoc);
    }

    @Override
    public void endAssoc(NodeRef nodeRef, QName assoc) {
        this.exporter.endAssoc(nodeRef, assoc);
    }

    @Override
    public void startAssocs(NodeRef nodeRef) {
        this.exporter.startAssocs(nodeRef);
    }

    @Override
    public void endAssocs(NodeRef nodeRef) {
        this.exporter.endAssocs(nodeRef);
    }

    @Override
    public void startReference(NodeRef nodeRef, QName childName) {
        this.exporter.startReference(nodeRef, childName);
    }

    @Override
    public void endReference(NodeRef nodeRef) {
        this.exporter.endReference(nodeRef);
    }

    @Override
    public void startValueMLText(NodeRef nodeRef, Locale locale) {
        this.exporter.startValueMLText(nodeRef, locale);
    }

    @Override
    public void endValueMLText(NodeRef nodeRef) {
        this.exporter.endValueMLText(nodeRef);
    }

    @Override
    public void warning(String warning) {
        this.exporter.warning(warning);
    }

    @Override
    public void end() {
        this.exporter.end();
    }
}

